/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securityposture.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PostureTemplateName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_POSTURE_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/postureTemplates/{posture_template}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;
    private final String postureTemplate;

    @Deprecated
    protected PostureTemplateName() {
        this.organization = null;
        this.location = null;
        this.postureTemplate = null;
    }

    private PostureTemplateName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.postureTemplate = (String)Preconditions.checkNotNull((Object)builder.getPostureTemplate());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPostureTemplate() {
        return this.postureTemplate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PostureTemplateName of(String organization, String location, String postureTemplate) {
        return PostureTemplateName.newBuilder().setOrganization(organization).setLocation(location).setPostureTemplate(postureTemplate).build();
    }

    public static String format(String organization, String location, String postureTemplate) {
        return PostureTemplateName.newBuilder().setOrganization(organization).setLocation(location).setPostureTemplate(postureTemplate).build().toString();
    }

    public static PostureTemplateName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_LOCATION_POSTURE_TEMPLATE.validatedMatch(formattedString, "PostureTemplateName.parse: formattedString not in valid format");
        return PostureTemplateName.of((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("posture_template"));
    }

    public static List<PostureTemplateName> parseList(List<String> formattedStrings) {
        ArrayList<PostureTemplateName> list = new ArrayList<PostureTemplateName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PostureTemplateName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PostureTemplateName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PostureTemplateName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_POSTURE_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PostureTemplateName postureTemplateName = this;
            synchronized (postureTemplateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.postureTemplate != null) {
                        fieldMapBuilder.put((Object)"posture_template", (Object)this.postureTemplate);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION_POSTURE_TEMPLATE.instantiate(new String[]{"organization", this.organization, "location", this.location, "posture_template", this.postureTemplate});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PostureTemplateName that = (PostureTemplateName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.postureTemplate, that.postureTemplate);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.postureTemplate);
    }

    public static class Builder {
        private String organization;
        private String location;
        private String postureTemplate;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPostureTemplate() {
            return this.postureTemplate;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPostureTemplate(String postureTemplate) {
            this.postureTemplate = postureTemplate;
            return this;
        }

        private Builder(PostureTemplateName postureTemplateName) {
            this.organization = postureTemplateName.organization;
            this.location = postureTemplateName.location;
            this.postureTemplate = postureTemplateName.postureTemplate;
        }

        public PostureTemplateName build() {
            return new PostureTemplateName(this);
        }
    }
}

