/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v2;

import com.google.cloud.securitycenter.v2.MitreAttackOrBuilder;
import com.google.cloud.securitycenter.v2.MitreAttackProto;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MitreAttack
extends GeneratedMessageV3
implements MitreAttackOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int PRIMARY_TACTIC_FIELD_NUMBER = 1;
    private int primaryTactic_ = 0;
    public static final int PRIMARY_TECHNIQUES_FIELD_NUMBER = 2;
    private List<Integer> primaryTechniques_;
    private static final Internal.ListAdapter.Converter<Integer, Technique> primaryTechniques_converter_ = new Internal.ListAdapter.Converter<Integer, Technique>(){

        public Technique convert(Integer from) {
            Technique result = Technique.forNumber(from);
            return result == null ? Technique.UNRECOGNIZED : result;
        }
    };
    private int primaryTechniquesMemoizedSerializedSize;
    public static final int ADDITIONAL_TACTICS_FIELD_NUMBER = 3;
    private List<Integer> additionalTactics_;
    private static final Internal.ListAdapter.Converter<Integer, Tactic> additionalTactics_converter_ = new Internal.ListAdapter.Converter<Integer, Tactic>(){

        public Tactic convert(Integer from) {
            Tactic result = Tactic.forNumber(from);
            return result == null ? Tactic.UNRECOGNIZED : result;
        }
    };
    private int additionalTacticsMemoizedSerializedSize;
    public static final int ADDITIONAL_TECHNIQUES_FIELD_NUMBER = 4;
    private List<Integer> additionalTechniques_;
    private static final Internal.ListAdapter.Converter<Integer, Technique> additionalTechniques_converter_ = new Internal.ListAdapter.Converter<Integer, Technique>(){

        public Technique convert(Integer from) {
            Technique result = Technique.forNumber(from);
            return result == null ? Technique.UNRECOGNIZED : result;
        }
    };
    private int additionalTechniquesMemoizedSerializedSize;
    public static final int VERSION_FIELD_NUMBER = 5;
    private volatile Object version_ = "";
    private byte memoizedIsInitialized = (byte)-1;
    private static final MitreAttack DEFAULT_INSTANCE = new MitreAttack();
    private static final Parser<MitreAttack> PARSER = new AbstractParser<MitreAttack>(){

        public MitreAttack parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = MitreAttack.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private MitreAttack(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private MitreAttack() {
        this.primaryTactic_ = 0;
        this.primaryTechniques_ = Collections.emptyList();
        this.additionalTactics_ = Collections.emptyList();
        this.additionalTechniques_ = Collections.emptyList();
        this.version_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new MitreAttack();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return MitreAttackProto.internal_static_google_cloud_securitycenter_v2_MitreAttack_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return MitreAttackProto.internal_static_google_cloud_securitycenter_v2_MitreAttack_fieldAccessorTable.ensureFieldAccessorsInitialized(MitreAttack.class, Builder.class);
    }

    @Override
    public int getPrimaryTacticValue() {
        return this.primaryTactic_;
    }

    @Override
    public Tactic getPrimaryTactic() {
        Tactic result = Tactic.forNumber(this.primaryTactic_);
        return result == null ? Tactic.UNRECOGNIZED : result;
    }

    @Override
    public List<Technique> getPrimaryTechniquesList() {
        return new Internal.ListAdapter(this.primaryTechniques_, primaryTechniques_converter_);
    }

    @Override
    public int getPrimaryTechniquesCount() {
        return this.primaryTechniques_.size();
    }

    @Override
    public Technique getPrimaryTechniques(int index) {
        return (Technique)((Object)primaryTechniques_converter_.convert((Object)this.primaryTechniques_.get(index)));
    }

    @Override
    public List<Integer> getPrimaryTechniquesValueList() {
        return this.primaryTechniques_;
    }

    @Override
    public int getPrimaryTechniquesValue(int index) {
        return this.primaryTechniques_.get(index);
    }

    @Override
    public List<Tactic> getAdditionalTacticsList() {
        return new Internal.ListAdapter(this.additionalTactics_, additionalTactics_converter_);
    }

    @Override
    public int getAdditionalTacticsCount() {
        return this.additionalTactics_.size();
    }

    @Override
    public Tactic getAdditionalTactics(int index) {
        return (Tactic)((Object)additionalTactics_converter_.convert((Object)this.additionalTactics_.get(index)));
    }

    @Override
    public List<Integer> getAdditionalTacticsValueList() {
        return this.additionalTactics_;
    }

    @Override
    public int getAdditionalTacticsValue(int index) {
        return this.additionalTactics_.get(index);
    }

    @Override
    public List<Technique> getAdditionalTechniquesList() {
        return new Internal.ListAdapter(this.additionalTechniques_, additionalTechniques_converter_);
    }

    @Override
    public int getAdditionalTechniquesCount() {
        return this.additionalTechniques_.size();
    }

    @Override
    public Technique getAdditionalTechniques(int index) {
        return (Technique)((Object)additionalTechniques_converter_.convert((Object)this.additionalTechniques_.get(index)));
    }

    @Override
    public List<Integer> getAdditionalTechniquesValueList() {
        return this.additionalTechniques_;
    }

    @Override
    public int getAdditionalTechniquesValue(int index) {
        return this.additionalTechniques_.get(index);
    }

    @Override
    public String getVersion() {
        Object ref = this.version_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.version_ = s;
        return s;
    }

    @Override
    public ByteString getVersionBytes() {
        Object ref = this.version_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.version_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (this.primaryTactic_ != Tactic.TACTIC_UNSPECIFIED.getNumber()) {
            output.writeEnum(1, this.primaryTactic_);
        }
        if (this.getPrimaryTechniquesList().size() > 0) {
            output.writeUInt32NoTag(18);
            output.writeUInt32NoTag(this.primaryTechniquesMemoizedSerializedSize);
        }
        for (i = 0; i < this.primaryTechniques_.size(); ++i) {
            output.writeEnumNoTag(this.primaryTechniques_.get(i).intValue());
        }
        if (this.getAdditionalTacticsList().size() > 0) {
            output.writeUInt32NoTag(26);
            output.writeUInt32NoTag(this.additionalTacticsMemoizedSerializedSize);
        }
        for (i = 0; i < this.additionalTactics_.size(); ++i) {
            output.writeEnumNoTag(this.additionalTactics_.get(i).intValue());
        }
        if (this.getAdditionalTechniquesList().size() > 0) {
            output.writeUInt32NoTag(34);
            output.writeUInt32NoTag(this.additionalTechniquesMemoizedSerializedSize);
        }
        for (i = 0; i < this.additionalTechniques_.size(); ++i) {
            output.writeEnumNoTag(this.additionalTechniques_.get(i).intValue());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.version_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.version_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.primaryTactic_ != Tactic.TACTIC_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)1, (int)this.primaryTactic_);
        }
        int dataSize = 0;
        for (i = 0; i < this.primaryTechniques_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.primaryTechniques_.get(i));
        }
        size += dataSize;
        if (!this.getPrimaryTechniquesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.primaryTechniquesMemoizedSerializedSize = dataSize;
        dataSize = 0;
        for (i = 0; i < this.additionalTactics_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.additionalTactics_.get(i));
        }
        size += dataSize;
        if (!this.getAdditionalTacticsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.additionalTacticsMemoizedSerializedSize = dataSize;
        dataSize = 0;
        for (i = 0; i < this.additionalTechniques_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.additionalTechniques_.get(i));
        }
        size += dataSize;
        if (!this.getAdditionalTechniquesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.additionalTechniquesMemoizedSerializedSize = dataSize;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.version_)) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.version_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MitreAttack)) {
            return super.equals(obj);
        }
        MitreAttack other = (MitreAttack)obj;
        if (this.primaryTactic_ != other.primaryTactic_) {
            return false;
        }
        if (!this.primaryTechniques_.equals(other.primaryTechniques_)) {
            return false;
        }
        if (!this.additionalTactics_.equals(other.additionalTactics_)) {
            return false;
        }
        if (!this.additionalTechniques_.equals(other.additionalTechniques_)) {
            return false;
        }
        if (!this.getVersion().equals(other.getVersion())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + MitreAttack.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.primaryTactic_;
        if (this.getPrimaryTechniquesCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.primaryTechniques_.hashCode();
        }
        if (this.getAdditionalTacticsCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.additionalTactics_.hashCode();
        }
        if (this.getAdditionalTechniquesCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.additionalTechniques_.hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getVersion().hashCode();
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static MitreAttack parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (MitreAttack)PARSER.parseFrom(data);
    }

    public static MitreAttack parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (MitreAttack)PARSER.parseFrom(data, extensionRegistry);
    }

    public static MitreAttack parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (MitreAttack)PARSER.parseFrom(data);
    }

    public static MitreAttack parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (MitreAttack)PARSER.parseFrom(data, extensionRegistry);
    }

    public static MitreAttack parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (MitreAttack)PARSER.parseFrom(data);
    }

    public static MitreAttack parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (MitreAttack)PARSER.parseFrom(data, extensionRegistry);
    }

    public static MitreAttack parseFrom(InputStream input) throws IOException {
        return (MitreAttack)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static MitreAttack parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (MitreAttack)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static MitreAttack parseDelimitedFrom(InputStream input) throws IOException {
        return (MitreAttack)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static MitreAttack parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (MitreAttack)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static MitreAttack parseFrom(CodedInputStream input) throws IOException {
        return (MitreAttack)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static MitreAttack parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (MitreAttack)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return MitreAttack.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(MitreAttack prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static MitreAttack getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<MitreAttack> parser() {
        return PARSER;
    }

    public Parser<MitreAttack> getParserForType() {
        return PARSER;
    }

    public MitreAttack getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements MitreAttackOrBuilder {
        private int bitField0_;
        private int primaryTactic_ = 0;
        private List<Integer> primaryTechniques_ = Collections.emptyList();
        private List<Integer> additionalTactics_ = Collections.emptyList();
        private List<Integer> additionalTechniques_ = Collections.emptyList();
        private Object version_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return MitreAttackProto.internal_static_google_cloud_securitycenter_v2_MitreAttack_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return MitreAttackProto.internal_static_google_cloud_securitycenter_v2_MitreAttack_fieldAccessorTable.ensureFieldAccessorsInitialized(MitreAttack.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.primaryTactic_ = 0;
            this.primaryTechniques_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.additionalTactics_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFB;
            this.additionalTechniques_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFF7;
            this.version_ = "";
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return MitreAttackProto.internal_static_google_cloud_securitycenter_v2_MitreAttack_descriptor;
        }

        public MitreAttack getDefaultInstanceForType() {
            return MitreAttack.getDefaultInstance();
        }

        public MitreAttack build() {
            MitreAttack result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public MitreAttack buildPartial() {
            MitreAttack result = new MitreAttack(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(MitreAttack result) {
            if ((this.bitField0_ & 2) != 0) {
                this.primaryTechniques_ = Collections.unmodifiableList(this.primaryTechniques_);
                this.bitField0_ &= 0xFFFFFFFD;
            }
            result.primaryTechniques_ = this.primaryTechniques_;
            if ((this.bitField0_ & 4) != 0) {
                this.additionalTactics_ = Collections.unmodifiableList(this.additionalTactics_);
                this.bitField0_ &= 0xFFFFFFFB;
            }
            result.additionalTactics_ = this.additionalTactics_;
            if ((this.bitField0_ & 8) != 0) {
                this.additionalTechniques_ = Collections.unmodifiableList(this.additionalTechniques_);
                this.bitField0_ &= 0xFFFFFFF7;
            }
            result.additionalTechniques_ = this.additionalTechniques_;
        }

        private void buildPartial0(MitreAttack result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.primaryTactic_ = this.primaryTactic_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.version_ = this.version_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof MitreAttack) {
                return this.mergeFrom((MitreAttack)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(MitreAttack other) {
            if (other == MitreAttack.getDefaultInstance()) {
                return this;
            }
            if (other.primaryTactic_ != 0) {
                this.setPrimaryTacticValue(other.getPrimaryTacticValue());
            }
            if (!other.primaryTechniques_.isEmpty()) {
                if (this.primaryTechniques_.isEmpty()) {
                    this.primaryTechniques_ = other.primaryTechniques_;
                    this.bitField0_ &= 0xFFFFFFFD;
                } else {
                    this.ensurePrimaryTechniquesIsMutable();
                    this.primaryTechniques_.addAll(other.primaryTechniques_);
                }
                this.onChanged();
            }
            if (!other.additionalTactics_.isEmpty()) {
                if (this.additionalTactics_.isEmpty()) {
                    this.additionalTactics_ = other.additionalTactics_;
                    this.bitField0_ &= 0xFFFFFFFB;
                } else {
                    this.ensureAdditionalTacticsIsMutable();
                    this.additionalTactics_.addAll(other.additionalTactics_);
                }
                this.onChanged();
            }
            if (!other.additionalTechniques_.isEmpty()) {
                if (this.additionalTechniques_.isEmpty()) {
                    this.additionalTechniques_ = other.additionalTechniques_;
                    this.bitField0_ &= 0xFFFFFFF7;
                } else {
                    this.ensureAdditionalTechniquesIsMutable();
                    this.additionalTechniques_.addAll(other.additionalTechniques_);
                }
                this.onChanged();
            }
            if (!other.getVersion().isEmpty()) {
                this.version_ = other.version_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block16: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block16;
                        }
                        case 8: {
                            this.primaryTactic_ = input.readEnum();
                            this.bitField0_ |= 1;
                            continue block16;
                        }
                        case 16: {
                            int tmpRaw = input.readEnum();
                            this.ensurePrimaryTechniquesIsMutable();
                            this.primaryTechniques_.add(tmpRaw);
                            continue block16;
                        }
                        case 18: {
                            int tmpRaw;
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                tmpRaw = input.readEnum();
                                this.ensurePrimaryTechniquesIsMutable();
                                this.primaryTechniques_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block16;
                        }
                        case 24: {
                            int tmpRaw = input.readEnum();
                            this.ensureAdditionalTacticsIsMutable();
                            this.additionalTactics_.add(tmpRaw);
                            continue block16;
                        }
                        case 26: {
                            int tmpRaw;
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                tmpRaw = input.readEnum();
                                this.ensureAdditionalTacticsIsMutable();
                                this.additionalTactics_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block16;
                        }
                        case 32: {
                            int tmpRaw = input.readEnum();
                            this.ensureAdditionalTechniquesIsMutable();
                            this.additionalTechniques_.add(tmpRaw);
                            continue block16;
                        }
                        case 34: {
                            int tmpRaw;
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                tmpRaw = input.readEnum();
                                this.ensureAdditionalTechniquesIsMutable();
                                this.additionalTechniques_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block16;
                        }
                        case 42: {
                            this.version_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block16;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public int getPrimaryTacticValue() {
            return this.primaryTactic_;
        }

        public Builder setPrimaryTacticValue(int value) {
            this.primaryTactic_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public Tactic getPrimaryTactic() {
            Tactic result = Tactic.forNumber(this.primaryTactic_);
            return result == null ? Tactic.UNRECOGNIZED : result;
        }

        public Builder setPrimaryTactic(Tactic value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 1;
            this.primaryTactic_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearPrimaryTactic() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.primaryTactic_ = 0;
            this.onChanged();
            return this;
        }

        private void ensurePrimaryTechniquesIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.primaryTechniques_ = new ArrayList<Integer>(this.primaryTechniques_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<Technique> getPrimaryTechniquesList() {
            return new Internal.ListAdapter(this.primaryTechniques_, primaryTechniques_converter_);
        }

        @Override
        public int getPrimaryTechniquesCount() {
            return this.primaryTechniques_.size();
        }

        @Override
        public Technique getPrimaryTechniques(int index) {
            return (Technique)((Object)primaryTechniques_converter_.convert((Object)this.primaryTechniques_.get(index)));
        }

        public Builder setPrimaryTechniques(int index, Technique value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePrimaryTechniquesIsMutable();
            this.primaryTechniques_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addPrimaryTechniques(Technique value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePrimaryTechniquesIsMutable();
            this.primaryTechniques_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllPrimaryTechniques(Iterable<? extends Technique> values) {
            this.ensurePrimaryTechniquesIsMutable();
            for (Technique technique : values) {
                this.primaryTechniques_.add(technique.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearPrimaryTechniques() {
            this.primaryTechniques_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getPrimaryTechniquesValueList() {
            return Collections.unmodifiableList(this.primaryTechniques_);
        }

        @Override
        public int getPrimaryTechniquesValue(int index) {
            return this.primaryTechniques_.get(index);
        }

        public Builder setPrimaryTechniquesValue(int index, int value) {
            this.ensurePrimaryTechniquesIsMutable();
            this.primaryTechniques_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addPrimaryTechniquesValue(int value) {
            this.ensurePrimaryTechniquesIsMutable();
            this.primaryTechniques_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllPrimaryTechniquesValue(Iterable<Integer> values) {
            this.ensurePrimaryTechniquesIsMutable();
            for (int value : values) {
                this.primaryTechniques_.add(value);
            }
            this.onChanged();
            return this;
        }

        private void ensureAdditionalTacticsIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.additionalTactics_ = new ArrayList<Integer>(this.additionalTactics_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<Tactic> getAdditionalTacticsList() {
            return new Internal.ListAdapter(this.additionalTactics_, additionalTactics_converter_);
        }

        @Override
        public int getAdditionalTacticsCount() {
            return this.additionalTactics_.size();
        }

        @Override
        public Tactic getAdditionalTactics(int index) {
            return (Tactic)((Object)additionalTactics_converter_.convert((Object)this.additionalTactics_.get(index)));
        }

        public Builder setAdditionalTactics(int index, Tactic value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAdditionalTacticsIsMutable();
            this.additionalTactics_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAdditionalTactics(Tactic value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAdditionalTacticsIsMutable();
            this.additionalTactics_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllAdditionalTactics(Iterable<? extends Tactic> values) {
            this.ensureAdditionalTacticsIsMutable();
            for (Tactic tactic : values) {
                this.additionalTactics_.add(tactic.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearAdditionalTactics() {
            this.additionalTactics_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getAdditionalTacticsValueList() {
            return Collections.unmodifiableList(this.additionalTactics_);
        }

        @Override
        public int getAdditionalTacticsValue(int index) {
            return this.additionalTactics_.get(index);
        }

        public Builder setAdditionalTacticsValue(int index, int value) {
            this.ensureAdditionalTacticsIsMutable();
            this.additionalTactics_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addAdditionalTacticsValue(int value) {
            this.ensureAdditionalTacticsIsMutable();
            this.additionalTactics_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllAdditionalTacticsValue(Iterable<Integer> values) {
            this.ensureAdditionalTacticsIsMutable();
            for (int value : values) {
                this.additionalTactics_.add(value);
            }
            this.onChanged();
            return this;
        }

        private void ensureAdditionalTechniquesIsMutable() {
            if ((this.bitField0_ & 8) == 0) {
                this.additionalTechniques_ = new ArrayList<Integer>(this.additionalTechniques_);
                this.bitField0_ |= 8;
            }
        }

        @Override
        public List<Technique> getAdditionalTechniquesList() {
            return new Internal.ListAdapter(this.additionalTechniques_, additionalTechniques_converter_);
        }

        @Override
        public int getAdditionalTechniquesCount() {
            return this.additionalTechniques_.size();
        }

        @Override
        public Technique getAdditionalTechniques(int index) {
            return (Technique)((Object)additionalTechniques_converter_.convert((Object)this.additionalTechniques_.get(index)));
        }

        public Builder setAdditionalTechniques(int index, Technique value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAdditionalTechniquesIsMutable();
            this.additionalTechniques_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAdditionalTechniques(Technique value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAdditionalTechniquesIsMutable();
            this.additionalTechniques_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllAdditionalTechniques(Iterable<? extends Technique> values) {
            this.ensureAdditionalTechniquesIsMutable();
            for (Technique technique : values) {
                this.additionalTechniques_.add(technique.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearAdditionalTechniques() {
            this.additionalTechniques_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getAdditionalTechniquesValueList() {
            return Collections.unmodifiableList(this.additionalTechniques_);
        }

        @Override
        public int getAdditionalTechniquesValue(int index) {
            return this.additionalTechniques_.get(index);
        }

        public Builder setAdditionalTechniquesValue(int index, int value) {
            this.ensureAdditionalTechniquesIsMutable();
            this.additionalTechniques_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addAdditionalTechniquesValue(int value) {
            this.ensureAdditionalTechniquesIsMutable();
            this.additionalTechniques_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllAdditionalTechniquesValue(Iterable<Integer> values) {
            this.ensureAdditionalTechniquesIsMutable();
            for (int value : values) {
                this.additionalTechniques_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public String getVersion() {
            Object ref = this.version_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.version_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getVersionBytes() {
            Object ref = this.version_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.version_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setVersion(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.version_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearVersion() {
            this.version_ = MitreAttack.getDefaultInstance().getVersion();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setVersionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            MitreAttack.checkByteStringIsUtf8((ByteString)value);
            this.version_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum Technique implements ProtocolMessageEnum
    {
        TECHNIQUE_UNSPECIFIED(0),
        MASQUERADING(49),
        MATCH_LEGITIMATE_NAME_OR_LOCATION(50),
        BOOT_OR_LOGON_INITIALIZATION_SCRIPTS(37),
        STARTUP_ITEMS(38),
        NETWORK_SERVICE_DISCOVERY(32),
        PROCESS_DISCOVERY(56),
        COMMAND_AND_SCRIPTING_INTERPRETER(6),
        UNIX_SHELL(7),
        PYTHON(59),
        EXPLOITATION_FOR_PRIVILEGE_ESCALATION(63),
        PERMISSION_GROUPS_DISCOVERY(18),
        CLOUD_GROUPS(19),
        INDICATOR_REMOVAL_FILE_DELETION(64),
        APPLICATION_LAYER_PROTOCOL(45),
        DNS(46),
        SOFTWARE_DEPLOYMENT_TOOLS(47),
        VALID_ACCOUNTS(14),
        DEFAULT_ACCOUNTS(35),
        LOCAL_ACCOUNTS(15),
        CLOUD_ACCOUNTS(16),
        PROXY(9),
        EXTERNAL_PROXY(10),
        MULTI_HOP_PROXY(11),
        ACCOUNT_MANIPULATION(22),
        ADDITIONAL_CLOUD_CREDENTIALS(40),
        SSH_AUTHORIZED_KEYS(23),
        ADDITIONAL_CONTAINER_CLUSTER_ROLES(58),
        INGRESS_TOOL_TRANSFER(3),
        NATIVE_API(4),
        BRUTE_FORCE(44),
        SHARED_MODULES(5),
        ACCESS_TOKEN_MANIPULATION(33),
        TOKEN_IMPERSONATION_OR_THEFT(39),
        EXPLOIT_PUBLIC_FACING_APPLICATION(27),
        DOMAIN_POLICY_MODIFICATION(30),
        DATA_DESTRUCTION(29),
        SERVICE_STOP(52),
        INHIBIT_SYSTEM_RECOVERY(36),
        RESOURCE_HIJACKING(8),
        NETWORK_DENIAL_OF_SERVICE(17),
        CLOUD_SERVICE_DISCOVERY(48),
        STEAL_APPLICATION_ACCESS_TOKEN(42),
        ACCOUNT_ACCESS_REMOVAL(51),
        STEAL_WEB_SESSION_COOKIE(25),
        CREATE_OR_MODIFY_SYSTEM_PROCESS(24),
        ABUSE_ELEVATION_CONTROL_MECHANISM(34),
        UNSECURED_CREDENTIALS(13),
        MODIFY_AUTHENTICATION_PROCESS(28),
        IMPAIR_DEFENSES(31),
        DISABLE_OR_MODIFY_TOOLS(55),
        EXFILTRATION_OVER_WEB_SERVICE(20),
        EXFILTRATION_TO_CLOUD_STORAGE(21),
        DYNAMIC_RESOLUTION(12),
        LATERAL_TOOL_TRANSFER(41),
        MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE(26),
        CREATE_SNAPSHOT(54),
        CLOUD_INFRASTRUCTURE_DISCOVERY(53),
        OBTAIN_CAPABILITIES(43),
        ACTIVE_SCANNING(1),
        SCANNING_IP_BLOCKS(2),
        CONTAINER_ADMINISTRATION_COMMAND(60),
        ESCAPE_TO_HOST(61),
        CONTAINER_AND_RESOURCE_DISCOVERY(57),
        STEAL_OR_FORGE_AUTHENTICATION_CERTIFICATES(62),
        UNRECOGNIZED(-1);

        public static final int TECHNIQUE_UNSPECIFIED_VALUE = 0;
        public static final int MASQUERADING_VALUE = 49;
        public static final int MATCH_LEGITIMATE_NAME_OR_LOCATION_VALUE = 50;
        public static final int BOOT_OR_LOGON_INITIALIZATION_SCRIPTS_VALUE = 37;
        public static final int STARTUP_ITEMS_VALUE = 38;
        public static final int NETWORK_SERVICE_DISCOVERY_VALUE = 32;
        public static final int PROCESS_DISCOVERY_VALUE = 56;
        public static final int COMMAND_AND_SCRIPTING_INTERPRETER_VALUE = 6;
        public static final int UNIX_SHELL_VALUE = 7;
        public static final int PYTHON_VALUE = 59;
        public static final int EXPLOITATION_FOR_PRIVILEGE_ESCALATION_VALUE = 63;
        public static final int PERMISSION_GROUPS_DISCOVERY_VALUE = 18;
        public static final int CLOUD_GROUPS_VALUE = 19;
        public static final int INDICATOR_REMOVAL_FILE_DELETION_VALUE = 64;
        public static final int APPLICATION_LAYER_PROTOCOL_VALUE = 45;
        public static final int DNS_VALUE = 46;
        public static final int SOFTWARE_DEPLOYMENT_TOOLS_VALUE = 47;
        public static final int VALID_ACCOUNTS_VALUE = 14;
        public static final int DEFAULT_ACCOUNTS_VALUE = 35;
        public static final int LOCAL_ACCOUNTS_VALUE = 15;
        public static final int CLOUD_ACCOUNTS_VALUE = 16;
        public static final int PROXY_VALUE = 9;
        public static final int EXTERNAL_PROXY_VALUE = 10;
        public static final int MULTI_HOP_PROXY_VALUE = 11;
        public static final int ACCOUNT_MANIPULATION_VALUE = 22;
        public static final int ADDITIONAL_CLOUD_CREDENTIALS_VALUE = 40;
        public static final int SSH_AUTHORIZED_KEYS_VALUE = 23;
        public static final int ADDITIONAL_CONTAINER_CLUSTER_ROLES_VALUE = 58;
        public static final int INGRESS_TOOL_TRANSFER_VALUE = 3;
        public static final int NATIVE_API_VALUE = 4;
        public static final int BRUTE_FORCE_VALUE = 44;
        public static final int SHARED_MODULES_VALUE = 5;
        public static final int ACCESS_TOKEN_MANIPULATION_VALUE = 33;
        public static final int TOKEN_IMPERSONATION_OR_THEFT_VALUE = 39;
        public static final int EXPLOIT_PUBLIC_FACING_APPLICATION_VALUE = 27;
        public static final int DOMAIN_POLICY_MODIFICATION_VALUE = 30;
        public static final int DATA_DESTRUCTION_VALUE = 29;
        public static final int SERVICE_STOP_VALUE = 52;
        public static final int INHIBIT_SYSTEM_RECOVERY_VALUE = 36;
        public static final int RESOURCE_HIJACKING_VALUE = 8;
        public static final int NETWORK_DENIAL_OF_SERVICE_VALUE = 17;
        public static final int CLOUD_SERVICE_DISCOVERY_VALUE = 48;
        public static final int STEAL_APPLICATION_ACCESS_TOKEN_VALUE = 42;
        public static final int ACCOUNT_ACCESS_REMOVAL_VALUE = 51;
        public static final int STEAL_WEB_SESSION_COOKIE_VALUE = 25;
        public static final int CREATE_OR_MODIFY_SYSTEM_PROCESS_VALUE = 24;
        public static final int ABUSE_ELEVATION_CONTROL_MECHANISM_VALUE = 34;
        public static final int UNSECURED_CREDENTIALS_VALUE = 13;
        public static final int MODIFY_AUTHENTICATION_PROCESS_VALUE = 28;
        public static final int IMPAIR_DEFENSES_VALUE = 31;
        public static final int DISABLE_OR_MODIFY_TOOLS_VALUE = 55;
        public static final int EXFILTRATION_OVER_WEB_SERVICE_VALUE = 20;
        public static final int EXFILTRATION_TO_CLOUD_STORAGE_VALUE = 21;
        public static final int DYNAMIC_RESOLUTION_VALUE = 12;
        public static final int LATERAL_TOOL_TRANSFER_VALUE = 41;
        public static final int MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE_VALUE = 26;
        public static final int CREATE_SNAPSHOT_VALUE = 54;
        public static final int CLOUD_INFRASTRUCTURE_DISCOVERY_VALUE = 53;
        public static final int OBTAIN_CAPABILITIES_VALUE = 43;
        public static final int ACTIVE_SCANNING_VALUE = 1;
        public static final int SCANNING_IP_BLOCKS_VALUE = 2;
        public static final int CONTAINER_ADMINISTRATION_COMMAND_VALUE = 60;
        public static final int ESCAPE_TO_HOST_VALUE = 61;
        public static final int CONTAINER_AND_RESOURCE_DISCOVERY_VALUE = 57;
        public static final int STEAL_OR_FORGE_AUTHENTICATION_CERTIFICATES_VALUE = 62;
        private static final Internal.EnumLiteMap<Technique> internalValueMap;
        private static final Technique[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static Technique valueOf(int value) {
            return Technique.forNumber(value);
        }

        public static Technique forNumber(int value) {
            switch (value) {
                case 0: {
                    return TECHNIQUE_UNSPECIFIED;
                }
                case 49: {
                    return MASQUERADING;
                }
                case 50: {
                    return MATCH_LEGITIMATE_NAME_OR_LOCATION;
                }
                case 37: {
                    return BOOT_OR_LOGON_INITIALIZATION_SCRIPTS;
                }
                case 38: {
                    return STARTUP_ITEMS;
                }
                case 32: {
                    return NETWORK_SERVICE_DISCOVERY;
                }
                case 56: {
                    return PROCESS_DISCOVERY;
                }
                case 6: {
                    return COMMAND_AND_SCRIPTING_INTERPRETER;
                }
                case 7: {
                    return UNIX_SHELL;
                }
                case 59: {
                    return PYTHON;
                }
                case 63: {
                    return EXPLOITATION_FOR_PRIVILEGE_ESCALATION;
                }
                case 18: {
                    return PERMISSION_GROUPS_DISCOVERY;
                }
                case 19: {
                    return CLOUD_GROUPS;
                }
                case 64: {
                    return INDICATOR_REMOVAL_FILE_DELETION;
                }
                case 45: {
                    return APPLICATION_LAYER_PROTOCOL;
                }
                case 46: {
                    return DNS;
                }
                case 47: {
                    return SOFTWARE_DEPLOYMENT_TOOLS;
                }
                case 14: {
                    return VALID_ACCOUNTS;
                }
                case 35: {
                    return DEFAULT_ACCOUNTS;
                }
                case 15: {
                    return LOCAL_ACCOUNTS;
                }
                case 16: {
                    return CLOUD_ACCOUNTS;
                }
                case 9: {
                    return PROXY;
                }
                case 10: {
                    return EXTERNAL_PROXY;
                }
                case 11: {
                    return MULTI_HOP_PROXY;
                }
                case 22: {
                    return ACCOUNT_MANIPULATION;
                }
                case 40: {
                    return ADDITIONAL_CLOUD_CREDENTIALS;
                }
                case 23: {
                    return SSH_AUTHORIZED_KEYS;
                }
                case 58: {
                    return ADDITIONAL_CONTAINER_CLUSTER_ROLES;
                }
                case 3: {
                    return INGRESS_TOOL_TRANSFER;
                }
                case 4: {
                    return NATIVE_API;
                }
                case 44: {
                    return BRUTE_FORCE;
                }
                case 5: {
                    return SHARED_MODULES;
                }
                case 33: {
                    return ACCESS_TOKEN_MANIPULATION;
                }
                case 39: {
                    return TOKEN_IMPERSONATION_OR_THEFT;
                }
                case 27: {
                    return EXPLOIT_PUBLIC_FACING_APPLICATION;
                }
                case 30: {
                    return DOMAIN_POLICY_MODIFICATION;
                }
                case 29: {
                    return DATA_DESTRUCTION;
                }
                case 52: {
                    return SERVICE_STOP;
                }
                case 36: {
                    return INHIBIT_SYSTEM_RECOVERY;
                }
                case 8: {
                    return RESOURCE_HIJACKING;
                }
                case 17: {
                    return NETWORK_DENIAL_OF_SERVICE;
                }
                case 48: {
                    return CLOUD_SERVICE_DISCOVERY;
                }
                case 42: {
                    return STEAL_APPLICATION_ACCESS_TOKEN;
                }
                case 51: {
                    return ACCOUNT_ACCESS_REMOVAL;
                }
                case 25: {
                    return STEAL_WEB_SESSION_COOKIE;
                }
                case 24: {
                    return CREATE_OR_MODIFY_SYSTEM_PROCESS;
                }
                case 34: {
                    return ABUSE_ELEVATION_CONTROL_MECHANISM;
                }
                case 13: {
                    return UNSECURED_CREDENTIALS;
                }
                case 28: {
                    return MODIFY_AUTHENTICATION_PROCESS;
                }
                case 31: {
                    return IMPAIR_DEFENSES;
                }
                case 55: {
                    return DISABLE_OR_MODIFY_TOOLS;
                }
                case 20: {
                    return EXFILTRATION_OVER_WEB_SERVICE;
                }
                case 21: {
                    return EXFILTRATION_TO_CLOUD_STORAGE;
                }
                case 12: {
                    return DYNAMIC_RESOLUTION;
                }
                case 41: {
                    return LATERAL_TOOL_TRANSFER;
                }
                case 26: {
                    return MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE;
                }
                case 54: {
                    return CREATE_SNAPSHOT;
                }
                case 53: {
                    return CLOUD_INFRASTRUCTURE_DISCOVERY;
                }
                case 43: {
                    return OBTAIN_CAPABILITIES;
                }
                case 1: {
                    return ACTIVE_SCANNING;
                }
                case 2: {
                    return SCANNING_IP_BLOCKS;
                }
                case 60: {
                    return CONTAINER_ADMINISTRATION_COMMAND;
                }
                case 61: {
                    return ESCAPE_TO_HOST;
                }
                case 57: {
                    return CONTAINER_AND_RESOURCE_DISCOVERY;
                }
                case 62: {
                    return STEAL_OR_FORGE_AUTHENTICATION_CERTIFICATES;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<Technique> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)Technique.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return Technique.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)MitreAttack.getDescriptor().getEnumTypes().get(1);
        }

        public static Technique valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != Technique.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private Technique(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<Technique>(){

                public Technique findValueByNumber(int number) {
                    return Technique.forNumber(number);
                }
            };
            VALUES = Technique.values();
        }
    }

    public static enum Tactic implements ProtocolMessageEnum
    {
        TACTIC_UNSPECIFIED(0),
        RECONNAISSANCE(1),
        RESOURCE_DEVELOPMENT(2),
        INITIAL_ACCESS(5),
        EXECUTION(3),
        PERSISTENCE(6),
        PRIVILEGE_ESCALATION(8),
        DEFENSE_EVASION(7),
        CREDENTIAL_ACCESS(9),
        DISCOVERY(10),
        LATERAL_MOVEMENT(11),
        COLLECTION(12),
        COMMAND_AND_CONTROL(4),
        EXFILTRATION(13),
        IMPACT(14),
        UNRECOGNIZED(-1);

        public static final int TACTIC_UNSPECIFIED_VALUE = 0;
        public static final int RECONNAISSANCE_VALUE = 1;
        public static final int RESOURCE_DEVELOPMENT_VALUE = 2;
        public static final int INITIAL_ACCESS_VALUE = 5;
        public static final int EXECUTION_VALUE = 3;
        public static final int PERSISTENCE_VALUE = 6;
        public static final int PRIVILEGE_ESCALATION_VALUE = 8;
        public static final int DEFENSE_EVASION_VALUE = 7;
        public static final int CREDENTIAL_ACCESS_VALUE = 9;
        public static final int DISCOVERY_VALUE = 10;
        public static final int LATERAL_MOVEMENT_VALUE = 11;
        public static final int COLLECTION_VALUE = 12;
        public static final int COMMAND_AND_CONTROL_VALUE = 4;
        public static final int EXFILTRATION_VALUE = 13;
        public static final int IMPACT_VALUE = 14;
        private static final Internal.EnumLiteMap<Tactic> internalValueMap;
        private static final Tactic[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static Tactic valueOf(int value) {
            return Tactic.forNumber(value);
        }

        public static Tactic forNumber(int value) {
            switch (value) {
                case 0: {
                    return TACTIC_UNSPECIFIED;
                }
                case 1: {
                    return RECONNAISSANCE;
                }
                case 2: {
                    return RESOURCE_DEVELOPMENT;
                }
                case 5: {
                    return INITIAL_ACCESS;
                }
                case 3: {
                    return EXECUTION;
                }
                case 6: {
                    return PERSISTENCE;
                }
                case 8: {
                    return PRIVILEGE_ESCALATION;
                }
                case 7: {
                    return DEFENSE_EVASION;
                }
                case 9: {
                    return CREDENTIAL_ACCESS;
                }
                case 10: {
                    return DISCOVERY;
                }
                case 11: {
                    return LATERAL_MOVEMENT;
                }
                case 12: {
                    return COLLECTION;
                }
                case 4: {
                    return COMMAND_AND_CONTROL;
                }
                case 13: {
                    return EXFILTRATION;
                }
                case 14: {
                    return IMPACT;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<Tactic> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)Tactic.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return Tactic.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)MitreAttack.getDescriptor().getEnumTypes().get(0);
        }

        public static Tactic valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != Tactic.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private Tactic(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<Tactic>(){

                public Tactic findValueByNumber(int number) {
                    return Tactic.forNumber(number);
                }
            };
            VALUES = Tactic.values();
        }
    }
}

