/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MuteConfigName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_MUTE_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/muteConfigs/{mute_config}");
    private static final PathTemplate FOLDER_MUTE_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/muteConfigs/{mute_config}");
    private static final PathTemplate PROJECT_MUTE_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/muteConfigs/{mute_config}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String muteConfig;
    private final String folder;
    private final String project;

    @Deprecated
    protected MuteConfigName() {
        this.organization = null;
        this.muteConfig = null;
        this.folder = null;
        this.project = null;
    }

    private MuteConfigName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.muteConfig = (String)Preconditions.checkNotNull((Object)builder.getMuteConfig());
        this.folder = null;
        this.project = null;
        this.pathTemplate = ORGANIZATION_MUTE_CONFIG;
    }

    private MuteConfigName(FolderMuteConfigBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.muteConfig = (String)Preconditions.checkNotNull((Object)builder.getMuteConfig());
        this.organization = null;
        this.project = null;
        this.pathTemplate = FOLDER_MUTE_CONFIG;
    }

    private MuteConfigName(ProjectMuteConfigBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.muteConfig = (String)Preconditions.checkNotNull((Object)builder.getMuteConfig());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_MUTE_CONFIG;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getMuteConfig() {
        return this.muteConfig;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationMuteConfigBuilder() {
        return new Builder();
    }

    public static FolderMuteConfigBuilder newFolderMuteConfigBuilder() {
        return new FolderMuteConfigBuilder();
    }

    public static ProjectMuteConfigBuilder newProjectMuteConfigBuilder() {
        return new ProjectMuteConfigBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MuteConfigName of(String organization, String muteConfig) {
        return MuteConfigName.newBuilder().setOrganization(organization).setMuteConfig(muteConfig).build();
    }

    public static MuteConfigName ofOrganizationMuteConfigName(String organization, String muteConfig) {
        return MuteConfigName.newBuilder().setOrganization(organization).setMuteConfig(muteConfig).build();
    }

    public static MuteConfigName ofFolderMuteConfigName(String folder, String muteConfig) {
        return MuteConfigName.newFolderMuteConfigBuilder().setFolder(folder).setMuteConfig(muteConfig).build();
    }

    public static MuteConfigName ofProjectMuteConfigName(String project, String muteConfig) {
        return MuteConfigName.newProjectMuteConfigBuilder().setProject(project).setMuteConfig(muteConfig).build();
    }

    public static String format(String organization, String muteConfig) {
        return MuteConfigName.newBuilder().setOrganization(organization).setMuteConfig(muteConfig).build().toString();
    }

    public static String formatOrganizationMuteConfigName(String organization, String muteConfig) {
        return MuteConfigName.newBuilder().setOrganization(organization).setMuteConfig(muteConfig).build().toString();
    }

    public static String formatFolderMuteConfigName(String folder, String muteConfig) {
        return MuteConfigName.newFolderMuteConfigBuilder().setFolder(folder).setMuteConfig(muteConfig).build().toString();
    }

    public static String formatProjectMuteConfigName(String project, String muteConfig) {
        return MuteConfigName.newProjectMuteConfigBuilder().setProject(project).setMuteConfig(muteConfig).build().toString();
    }

    public static MuteConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_MUTE_CONFIG.matches(formattedString)) {
            Map matchMap = ORGANIZATION_MUTE_CONFIG.match(formattedString);
            return MuteConfigName.ofOrganizationMuteConfigName((String)matchMap.get("organization"), (String)matchMap.get("mute_config"));
        }
        if (FOLDER_MUTE_CONFIG.matches(formattedString)) {
            Map matchMap = FOLDER_MUTE_CONFIG.match(formattedString);
            return MuteConfigName.ofFolderMuteConfigName((String)matchMap.get("folder"), (String)matchMap.get("mute_config"));
        }
        if (PROJECT_MUTE_CONFIG.matches(formattedString)) {
            Map matchMap = PROJECT_MUTE_CONFIG.match(formattedString);
            return MuteConfigName.ofProjectMuteConfigName((String)matchMap.get("project"), (String)matchMap.get("mute_config"));
        }
        throw new ValidationException("MuteConfigName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<MuteConfigName> parseList(List<String> formattedStrings) {
        ArrayList<MuteConfigName> list = new ArrayList<MuteConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MuteConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MuteConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MuteConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_MUTE_CONFIG.matches(formattedString) || FOLDER_MUTE_CONFIG.matches(formattedString) || PROJECT_MUTE_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MuteConfigName muteConfigName = this;
            synchronized (muteConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.muteConfig != null) {
                        fieldMapBuilder.put((Object)"mute_config", (Object)this.muteConfig);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MuteConfigName that = (MuteConfigName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.muteConfig, that.muteConfig) && Objects.equals(this.folder, that.folder) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.muteConfig);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class ProjectMuteConfigBuilder {
        private String project;
        private String muteConfig;

        protected ProjectMuteConfigBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getMuteConfig() {
            return this.muteConfig;
        }

        public ProjectMuteConfigBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectMuteConfigBuilder setMuteConfig(String muteConfig) {
            this.muteConfig = muteConfig;
            return this;
        }

        public MuteConfigName build() {
            return new MuteConfigName(this);
        }
    }

    public static class FolderMuteConfigBuilder {
        private String folder;
        private String muteConfig;

        protected FolderMuteConfigBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getMuteConfig() {
            return this.muteConfig;
        }

        public FolderMuteConfigBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderMuteConfigBuilder setMuteConfig(String muteConfig) {
            this.muteConfig = muteConfig;
            return this;
        }

        public MuteConfigName build() {
            return new MuteConfigName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String muteConfig;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getMuteConfig() {
            return this.muteConfig;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setMuteConfig(String muteConfig) {
            this.muteConfig = muteConfig;
            return this;
        }

        private Builder(MuteConfigName muteConfigName) {
            Preconditions.checkArgument((boolean)Objects.equals(muteConfigName.pathTemplate, ORGANIZATION_MUTE_CONFIG), (Object)"toBuilder is only supported when MuteConfigName has the pattern of organizations/{organization}/muteConfigs/{mute_config}");
            this.organization = muteConfigName.organization;
            this.muteConfig = muteConfigName.muteConfig;
        }

        public MuteConfigName build() {
            return new MuteConfigName(this);
        }
    }
}

