/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EffectiveSecurityHealthAnalyticsCustomModuleName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_EFFECTIVE_CUSTOM_MODULE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{effective_custom_module}");
    private static final PathTemplate FOLDER_EFFECTIVE_CUSTOM_MODULE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/securityHealthAnalyticsSettings/effectiveCustomModules/{effective_custom_module}");
    private static final PathTemplate PROJECT_EFFECTIVE_CUSTOM_MODULE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/securityHealthAnalyticsSettings/effectiveCustomModules/{effective_custom_module}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String effectiveCustomModule;
    private final String folder;
    private final String project;

    @Deprecated
    protected EffectiveSecurityHealthAnalyticsCustomModuleName() {
        this.organization = null;
        this.effectiveCustomModule = null;
        this.folder = null;
        this.project = null;
    }

    private EffectiveSecurityHealthAnalyticsCustomModuleName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.effectiveCustomModule = (String)Preconditions.checkNotNull((Object)builder.getEffectiveCustomModule());
        this.folder = null;
        this.project = null;
        this.pathTemplate = ORGANIZATION_EFFECTIVE_CUSTOM_MODULE;
    }

    private EffectiveSecurityHealthAnalyticsCustomModuleName(FolderEffectiveCustomModuleBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.effectiveCustomModule = (String)Preconditions.checkNotNull((Object)builder.getEffectiveCustomModule());
        this.organization = null;
        this.project = null;
        this.pathTemplate = FOLDER_EFFECTIVE_CUSTOM_MODULE;
    }

    private EffectiveSecurityHealthAnalyticsCustomModuleName(ProjectEffectiveCustomModuleBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.effectiveCustomModule = (String)Preconditions.checkNotNull((Object)builder.getEffectiveCustomModule());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_EFFECTIVE_CUSTOM_MODULE;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getEffectiveCustomModule() {
        return this.effectiveCustomModule;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newOrganizationEffectiveCustomModuleBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderEffectiveCustomModuleBuilder newFolderEffectiveCustomModuleBuilder() {
        return new FolderEffectiveCustomModuleBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectEffectiveCustomModuleBuilder newProjectEffectiveCustomModuleBuilder() {
        return new ProjectEffectiveCustomModuleBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EffectiveSecurityHealthAnalyticsCustomModuleName of(String organization, String effectiveCustomModule) {
        return EffectiveSecurityHealthAnalyticsCustomModuleName.newBuilder().setOrganization(organization).setEffectiveCustomModule(effectiveCustomModule).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static EffectiveSecurityHealthAnalyticsCustomModuleName ofOrganizationEffectiveCustomModuleName(String organization, String effectiveCustomModule) {
        return EffectiveSecurityHealthAnalyticsCustomModuleName.newBuilder().setOrganization(organization).setEffectiveCustomModule(effectiveCustomModule).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static EffectiveSecurityHealthAnalyticsCustomModuleName ofFolderEffectiveCustomModuleName(String folder, String effectiveCustomModule) {
        return EffectiveSecurityHealthAnalyticsCustomModuleName.newFolderEffectiveCustomModuleBuilder().setFolder(folder).setEffectiveCustomModule(effectiveCustomModule).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static EffectiveSecurityHealthAnalyticsCustomModuleName ofProjectEffectiveCustomModuleName(String project, String effectiveCustomModule) {
        return EffectiveSecurityHealthAnalyticsCustomModuleName.newProjectEffectiveCustomModuleBuilder().setProject(project).setEffectiveCustomModule(effectiveCustomModule).build();
    }

    public static String format(String organization, String effectiveCustomModule) {
        return EffectiveSecurityHealthAnalyticsCustomModuleName.newBuilder().setOrganization(organization).setEffectiveCustomModule(effectiveCustomModule).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationEffectiveCustomModuleName(String organization, String effectiveCustomModule) {
        return EffectiveSecurityHealthAnalyticsCustomModuleName.newBuilder().setOrganization(organization).setEffectiveCustomModule(effectiveCustomModule).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderEffectiveCustomModuleName(String folder, String effectiveCustomModule) {
        return EffectiveSecurityHealthAnalyticsCustomModuleName.newFolderEffectiveCustomModuleBuilder().setFolder(folder).setEffectiveCustomModule(effectiveCustomModule).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectEffectiveCustomModuleName(String project, String effectiveCustomModule) {
        return EffectiveSecurityHealthAnalyticsCustomModuleName.newProjectEffectiveCustomModuleBuilder().setProject(project).setEffectiveCustomModule(effectiveCustomModule).build().toString();
    }

    public static EffectiveSecurityHealthAnalyticsCustomModuleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_EFFECTIVE_CUSTOM_MODULE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_EFFECTIVE_CUSTOM_MODULE.match(formattedString);
            return EffectiveSecurityHealthAnalyticsCustomModuleName.ofOrganizationEffectiveCustomModuleName((String)matchMap.get("organization"), (String)matchMap.get("effective_custom_module"));
        }
        if (FOLDER_EFFECTIVE_CUSTOM_MODULE.matches(formattedString)) {
            Map matchMap = FOLDER_EFFECTIVE_CUSTOM_MODULE.match(formattedString);
            return EffectiveSecurityHealthAnalyticsCustomModuleName.ofFolderEffectiveCustomModuleName((String)matchMap.get("folder"), (String)matchMap.get("effective_custom_module"));
        }
        if (PROJECT_EFFECTIVE_CUSTOM_MODULE.matches(formattedString)) {
            Map matchMap = PROJECT_EFFECTIVE_CUSTOM_MODULE.match(formattedString);
            return EffectiveSecurityHealthAnalyticsCustomModuleName.ofProjectEffectiveCustomModuleName((String)matchMap.get("project"), (String)matchMap.get("effective_custom_module"));
        }
        throw new ValidationException("EffectiveSecurityHealthAnalyticsCustomModuleName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<EffectiveSecurityHealthAnalyticsCustomModuleName> parseList(List<String> formattedStrings) {
        ArrayList<EffectiveSecurityHealthAnalyticsCustomModuleName> list = new ArrayList<EffectiveSecurityHealthAnalyticsCustomModuleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EffectiveSecurityHealthAnalyticsCustomModuleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EffectiveSecurityHealthAnalyticsCustomModuleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EffectiveSecurityHealthAnalyticsCustomModuleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_EFFECTIVE_CUSTOM_MODULE.matches(formattedString) || FOLDER_EFFECTIVE_CUSTOM_MODULE.matches(formattedString) || PROJECT_EFFECTIVE_CUSTOM_MODULE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EffectiveSecurityHealthAnalyticsCustomModuleName effectiveSecurityHealthAnalyticsCustomModuleName = this;
            synchronized (effectiveSecurityHealthAnalyticsCustomModuleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.effectiveCustomModule != null) {
                        fieldMapBuilder.put((Object)"effective_custom_module", (Object)this.effectiveCustomModule);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            EffectiveSecurityHealthAnalyticsCustomModuleName that = (EffectiveSecurityHealthAnalyticsCustomModuleName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.effectiveCustomModule, that.effectiveCustomModule) && Objects.equals(this.folder, that.folder) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.effectiveCustomModule);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectEffectiveCustomModuleBuilder {
        private String project;
        private String effectiveCustomModule;

        protected ProjectEffectiveCustomModuleBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getEffectiveCustomModule() {
            return this.effectiveCustomModule;
        }

        public ProjectEffectiveCustomModuleBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectEffectiveCustomModuleBuilder setEffectiveCustomModule(String effectiveCustomModule) {
            this.effectiveCustomModule = effectiveCustomModule;
            return this;
        }

        public EffectiveSecurityHealthAnalyticsCustomModuleName build() {
            return new EffectiveSecurityHealthAnalyticsCustomModuleName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderEffectiveCustomModuleBuilder {
        private String folder;
        private String effectiveCustomModule;

        protected FolderEffectiveCustomModuleBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getEffectiveCustomModule() {
            return this.effectiveCustomModule;
        }

        public FolderEffectiveCustomModuleBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderEffectiveCustomModuleBuilder setEffectiveCustomModule(String effectiveCustomModule) {
            this.effectiveCustomModule = effectiveCustomModule;
            return this;
        }

        public EffectiveSecurityHealthAnalyticsCustomModuleName build() {
            return new EffectiveSecurityHealthAnalyticsCustomModuleName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String effectiveCustomModule;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getEffectiveCustomModule() {
            return this.effectiveCustomModule;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setEffectiveCustomModule(String effectiveCustomModule) {
            this.effectiveCustomModule = effectiveCustomModule;
            return this;
        }

        private Builder(EffectiveSecurityHealthAnalyticsCustomModuleName effectiveSecurityHealthAnalyticsCustomModuleName) {
            Preconditions.checkArgument((boolean)Objects.equals(effectiveSecurityHealthAnalyticsCustomModuleName.pathTemplate, ORGANIZATION_EFFECTIVE_CUSTOM_MODULE), (Object)"toBuilder is only supported when EffectiveSecurityHealthAnalyticsCustomModuleName has the pattern of organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{effective_custom_module}");
            this.organization = effectiveSecurityHealthAnalyticsCustomModuleName.organization;
            this.effectiveCustomModule = effectiveSecurityHealthAnalyticsCustomModuleName.effectiveCustomModule;
        }

        public EffectiveSecurityHealthAnalyticsCustomModuleName build() {
            return new EffectiveSecurityHealthAnalyticsCustomModuleName(this);
        }
    }
}

