/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SecurityHealthAnalyticsCustomModuleName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_CUSTOM_MODULE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/securityHealthAnalyticsSettings/customModules/{custom_module}");
    private static final PathTemplate FOLDER_CUSTOM_MODULE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/securityHealthAnalyticsSettings/customModules/{custom_module}");
    private static final PathTemplate PROJECT_CUSTOM_MODULE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/securityHealthAnalyticsSettings/customModules/{custom_module}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String customModule;
    private final String folder;
    private final String project;

    @Deprecated
    protected SecurityHealthAnalyticsCustomModuleName() {
        this.organization = null;
        this.customModule = null;
        this.folder = null;
        this.project = null;
    }

    private SecurityHealthAnalyticsCustomModuleName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.customModule = (String)Preconditions.checkNotNull((Object)builder.getCustomModule());
        this.folder = null;
        this.project = null;
        this.pathTemplate = ORGANIZATION_CUSTOM_MODULE;
    }

    private SecurityHealthAnalyticsCustomModuleName(FolderCustomModuleBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.customModule = (String)Preconditions.checkNotNull((Object)builder.getCustomModule());
        this.organization = null;
        this.project = null;
        this.pathTemplate = FOLDER_CUSTOM_MODULE;
    }

    private SecurityHealthAnalyticsCustomModuleName(ProjectCustomModuleBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.customModule = (String)Preconditions.checkNotNull((Object)builder.getCustomModule());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_CUSTOM_MODULE;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getCustomModule() {
        return this.customModule;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newOrganizationCustomModuleBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderCustomModuleBuilder newFolderCustomModuleBuilder() {
        return new FolderCustomModuleBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectCustomModuleBuilder newProjectCustomModuleBuilder() {
        return new ProjectCustomModuleBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SecurityHealthAnalyticsCustomModuleName of(String organization, String customModule) {
        return SecurityHealthAnalyticsCustomModuleName.newBuilder().setOrganization(organization).setCustomModule(customModule).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SecurityHealthAnalyticsCustomModuleName ofOrganizationCustomModuleName(String organization, String customModule) {
        return SecurityHealthAnalyticsCustomModuleName.newBuilder().setOrganization(organization).setCustomModule(customModule).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SecurityHealthAnalyticsCustomModuleName ofFolderCustomModuleName(String folder, String customModule) {
        return SecurityHealthAnalyticsCustomModuleName.newFolderCustomModuleBuilder().setFolder(folder).setCustomModule(customModule).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SecurityHealthAnalyticsCustomModuleName ofProjectCustomModuleName(String project, String customModule) {
        return SecurityHealthAnalyticsCustomModuleName.newProjectCustomModuleBuilder().setProject(project).setCustomModule(customModule).build();
    }

    public static String format(String organization, String customModule) {
        return SecurityHealthAnalyticsCustomModuleName.newBuilder().setOrganization(organization).setCustomModule(customModule).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationCustomModuleName(String organization, String customModule) {
        return SecurityHealthAnalyticsCustomModuleName.newBuilder().setOrganization(organization).setCustomModule(customModule).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderCustomModuleName(String folder, String customModule) {
        return SecurityHealthAnalyticsCustomModuleName.newFolderCustomModuleBuilder().setFolder(folder).setCustomModule(customModule).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectCustomModuleName(String project, String customModule) {
        return SecurityHealthAnalyticsCustomModuleName.newProjectCustomModuleBuilder().setProject(project).setCustomModule(customModule).build().toString();
    }

    public static SecurityHealthAnalyticsCustomModuleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_CUSTOM_MODULE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_CUSTOM_MODULE.match(formattedString);
            return SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)matchMap.get("organization"), (String)matchMap.get("custom_module"));
        }
        if (FOLDER_CUSTOM_MODULE.matches(formattedString)) {
            Map matchMap = FOLDER_CUSTOM_MODULE.match(formattedString);
            return SecurityHealthAnalyticsCustomModuleName.ofFolderCustomModuleName((String)matchMap.get("folder"), (String)matchMap.get("custom_module"));
        }
        if (PROJECT_CUSTOM_MODULE.matches(formattedString)) {
            Map matchMap = PROJECT_CUSTOM_MODULE.match(formattedString);
            return SecurityHealthAnalyticsCustomModuleName.ofProjectCustomModuleName((String)matchMap.get("project"), (String)matchMap.get("custom_module"));
        }
        throw new ValidationException("SecurityHealthAnalyticsCustomModuleName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SecurityHealthAnalyticsCustomModuleName> parseList(List<String> formattedStrings) {
        ArrayList<SecurityHealthAnalyticsCustomModuleName> list = new ArrayList<SecurityHealthAnalyticsCustomModuleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SecurityHealthAnalyticsCustomModuleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SecurityHealthAnalyticsCustomModuleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SecurityHealthAnalyticsCustomModuleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_CUSTOM_MODULE.matches(formattedString) || FOLDER_CUSTOM_MODULE.matches(formattedString) || PROJECT_CUSTOM_MODULE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SecurityHealthAnalyticsCustomModuleName securityHealthAnalyticsCustomModuleName = this;
            synchronized (securityHealthAnalyticsCustomModuleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.customModule != null) {
                        fieldMapBuilder.put((Object)"custom_module", (Object)this.customModule);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SecurityHealthAnalyticsCustomModuleName that = (SecurityHealthAnalyticsCustomModuleName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.customModule, that.customModule) && Objects.equals(this.folder, that.folder) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.customModule);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectCustomModuleBuilder {
        private String project;
        private String customModule;

        protected ProjectCustomModuleBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getCustomModule() {
            return this.customModule;
        }

        public ProjectCustomModuleBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectCustomModuleBuilder setCustomModule(String customModule) {
            this.customModule = customModule;
            return this;
        }

        public SecurityHealthAnalyticsCustomModuleName build() {
            return new SecurityHealthAnalyticsCustomModuleName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderCustomModuleBuilder {
        private String folder;
        private String customModule;

        protected FolderCustomModuleBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getCustomModule() {
            return this.customModule;
        }

        public FolderCustomModuleBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderCustomModuleBuilder setCustomModule(String customModule) {
            this.customModule = customModule;
            return this;
        }

        public SecurityHealthAnalyticsCustomModuleName build() {
            return new SecurityHealthAnalyticsCustomModuleName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String customModule;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getCustomModule() {
            return this.customModule;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setCustomModule(String customModule) {
            this.customModule = customModule;
            return this;
        }

        private Builder(SecurityHealthAnalyticsCustomModuleName securityHealthAnalyticsCustomModuleName) {
            Preconditions.checkArgument((boolean)Objects.equals(securityHealthAnalyticsCustomModuleName.pathTemplate, ORGANIZATION_CUSTOM_MODULE), (Object)"toBuilder is only supported when SecurityHealthAnalyticsCustomModuleName has the pattern of organizations/{organization}/securityHealthAnalyticsSettings/customModules/{custom_module}");
            this.organization = securityHealthAnalyticsCustomModuleName.organization;
            this.customModule = securityHealthAnalyticsCustomModuleName.customModule;
        }

        public SecurityHealthAnalyticsCustomModuleName build() {
            return new SecurityHealthAnalyticsCustomModuleName(this);
        }
    }
}

