/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NotificationConfigName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/notificationConfigs/{notification_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String notificationConfig;

    public String getOrganization() {
        return this.organization;
    }

    public String getNotificationConfig() {
        return this.notificationConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private NotificationConfigName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.notificationConfig = (String)Preconditions.checkNotNull((Object)builder.getNotificationConfig());
    }

    public static NotificationConfigName of(String organization, String notificationConfig) {
        return NotificationConfigName.newBuilder().setOrganization(organization).setNotificationConfig(notificationConfig).build();
    }

    public static String format(String organization, String notificationConfig) {
        return NotificationConfigName.newBuilder().setOrganization(organization).setNotificationConfig(notificationConfig).build().toString();
    }

    public static NotificationConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "NotificationConfigName.parse: formattedString not in valid format");
        return NotificationConfigName.of((String)matchMap.get("organization"), (String)matchMap.get("notification_config"));
    }

    public static List<NotificationConfigName> parseList(List<String> formattedStrings) {
        ArrayList<NotificationConfigName> list = new ArrayList<NotificationConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NotificationConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NotificationConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NotificationConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NotificationConfigName notificationConfigName = this;
            synchronized (notificationConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    fieldMapBuilder.put((Object)"notificationConfig", (Object)this.notificationConfig);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"organization", this.organization, "notification_config", this.notificationConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NotificationConfigName) {
            NotificationConfigName that = (NotificationConfigName)o;
            return this.organization.equals(that.organization) && this.notificationConfig.equals(that.notificationConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.organization.hashCode();
        h *= 1000003;
        return h ^= this.notificationConfig.hashCode();
    }

    public static class Builder {
        private String organization;
        private String notificationConfig;

        public String getOrganization() {
            return this.organization;
        }

        public String getNotificationConfig() {
            return this.notificationConfig;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setNotificationConfig(String notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        private Builder() {
        }

        private Builder(NotificationConfigName notificationConfigName) {
            this.organization = notificationConfigName.organization;
            this.notificationConfig = notificationConfigName.notificationConfig;
        }

        public NotificationConfigName build() {
            return new NotificationConfigName(this);
        }
    }
}

