/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.settings.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SettingsName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_SETTINGS_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/settings");
    private static final PathTemplate FOLDER_SETTINGS_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/settings");
    private static final PathTemplate PROJECT_SETTINGS_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/settings");
    private static final PathTemplate PROJECT_LOCATION_CLUSTER_SETTINGS_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/clusters/{cluster}/settings");
    private static final PathTemplate PROJECT_REGION_CLUSTER_SETTINGS_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/regions/{region}/clusters/{cluster}/settings");
    private static final PathTemplate PROJECT_ZONE_CLUSTER_SETTINGS_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/zones/{zone}/clusters/{cluster}/settings");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private String organization;
    private String folder;
    private String project;
    private String location;
    private String cluster;
    private String region;
    private String zone;

    @Deprecated
    protected SettingsName() {
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getRegion() {
        return this.region;
    }

    public String getZone() {
        return this.zone;
    }

    private SettingsName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.pathTemplate = ORGANIZATION_SETTINGS_PATH_TEMPLATE;
    }

    private SettingsName(FolderSettingsBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.pathTemplate = FOLDER_SETTINGS_PATH_TEMPLATE;
    }

    private SettingsName(ProjectSettingsBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.pathTemplate = PROJECT_SETTINGS_PATH_TEMPLATE;
    }

    private SettingsName(ProjectLocationClusterSettingsBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
        this.pathTemplate = PROJECT_LOCATION_CLUSTER_SETTINGS_PATH_TEMPLATE;
    }

    private SettingsName(ProjectRegionClusterSettingsBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
        this.pathTemplate = PROJECT_REGION_CLUSTER_SETTINGS_PATH_TEMPLATE;
    }

    private SettingsName(ProjectZoneClusterSettingsBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
        this.pathTemplate = PROJECT_ZONE_CLUSTER_SETTINGS_PATH_TEMPLATE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newOrganizationSettingsBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderSettingsBuilder newFolderSettingsBuilder() {
        return new FolderSettingsBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectSettingsBuilder newProjectSettingsBuilder() {
        return new ProjectSettingsBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationClusterSettingsBuilder newProjectLocationClusterSettingsBuilder() {
        return new ProjectLocationClusterSettingsBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectRegionClusterSettingsBuilder newProjectRegionClusterSettingsBuilder() {
        return new ProjectRegionClusterSettingsBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectZoneClusterSettingsBuilder newProjectZoneClusterSettingsBuilder() {
        return new ProjectZoneClusterSettingsBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SettingsName of(String organization) {
        return SettingsName.newOrganizationSettingsBuilder().setOrganization(organization).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SettingsName ofOrganizationSettingsName(String organization) {
        return SettingsName.newOrganizationSettingsBuilder().setOrganization(organization).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SettingsName ofFolderSettingsName(String folder) {
        return SettingsName.newFolderSettingsBuilder().setFolder(folder).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SettingsName ofProjectSettingsName(String project) {
        return SettingsName.newProjectSettingsBuilder().setProject(project).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SettingsName ofProjectLocationClusterSettingsName(String project, String location, String cluster) {
        return SettingsName.newProjectLocationClusterSettingsBuilder().setProject(project).setLocation(location).setCluster(cluster).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SettingsName ofProjectRegionClusterSettingsName(String project, String region, String cluster) {
        return SettingsName.newProjectRegionClusterSettingsBuilder().setProject(project).setRegion(region).setCluster(cluster).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SettingsName ofProjectZoneClusterSettingsName(String project, String zone, String cluster) {
        return SettingsName.newProjectZoneClusterSettingsBuilder().setProject(project).setZone(zone).setCluster(cluster).build();
    }

    public static String format(String organization) {
        return SettingsName.newBuilder().setOrganization(organization).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationSettingsName(String organization) {
        return SettingsName.newBuilder().setOrganization(organization).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderSettingsName(String folder) {
        return SettingsName.newFolderSettingsBuilder().setFolder(folder).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectSettingsName(String project) {
        return SettingsName.newProjectSettingsBuilder().setProject(project).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationClusterSettingsName(String project, String location, String cluster) {
        return SettingsName.newProjectLocationClusterSettingsBuilder().setProject(project).setLocation(location).setCluster(cluster).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectRegionClusterSettingsName(String project, String region, String cluster) {
        return SettingsName.newProjectRegionClusterSettingsBuilder().setProject(project).setRegion(region).setCluster(cluster).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectZoneClusterSettingsName(String project, String zone, String cluster) {
        return SettingsName.newProjectZoneClusterSettingsBuilder().setProject(project).setZone(zone).setCluster(cluster).build().toString();
    }

    public static SettingsName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_SETTINGS_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_SETTINGS_PATH_TEMPLATE.match(formattedString);
            return SettingsName.ofOrganizationSettingsName((String)matchMap.get("organization"));
        }
        if (FOLDER_SETTINGS_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = FOLDER_SETTINGS_PATH_TEMPLATE.match(formattedString);
            return SettingsName.ofFolderSettingsName((String)matchMap.get("folder"));
        }
        if (PROJECT_SETTINGS_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_SETTINGS_PATH_TEMPLATE.match(formattedString);
            return SettingsName.ofProjectSettingsName((String)matchMap.get("project"));
        }
        if (PROJECT_LOCATION_CLUSTER_SETTINGS_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_CLUSTER_SETTINGS_PATH_TEMPLATE.match(formattedString);
            return SettingsName.ofProjectLocationClusterSettingsName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cluster"));
        }
        if (PROJECT_REGION_CLUSTER_SETTINGS_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_REGION_CLUSTER_SETTINGS_PATH_TEMPLATE.match(formattedString);
            return SettingsName.ofProjectRegionClusterSettingsName((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("cluster"));
        }
        if (PROJECT_ZONE_CLUSTER_SETTINGS_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_ZONE_CLUSTER_SETTINGS_PATH_TEMPLATE.match(formattedString);
            return SettingsName.ofProjectZoneClusterSettingsName((String)matchMap.get("project"), (String)matchMap.get("zone"), (String)matchMap.get("cluster"));
        }
        throw new ValidationException("JobName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SettingsName> parseList(List<String> formattedStrings) {
        ArrayList<SettingsName> list = new ArrayList<SettingsName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SettingsName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SettingsName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SettingsName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_SETTINGS_PATH_TEMPLATE.matches(formattedString) || FOLDER_SETTINGS_PATH_TEMPLATE.matches(formattedString) || PROJECT_SETTINGS_PATH_TEMPLATE.matches(formattedString) || PROJECT_LOCATION_CLUSTER_SETTINGS_PATH_TEMPLATE.matches(formattedString) || PROJECT_REGION_CLUSTER_SETTINGS_PATH_TEMPLATE.matches(formattedString) || PROJECT_ZONE_CLUSTER_SETTINGS_PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SettingsName settingsName = this;
            synchronized (settingsName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cluster != null) {
                        fieldMapBuilder.put((Object)"cluster", (Object)this.cluster);
                    }
                    if (this.region != null) {
                        fieldMapBuilder.put((Object)"region", (Object)this.region);
                    }
                    if (this.zone != null) {
                        fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SettingsName that = (SettingsName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder) && Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cluster, that.cluster) && Objects.equals(this.region, that.region) && Objects.equals(this.zone, that.zone);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.cluster);
        h *= 1000003;
        h ^= Objects.hashCode(this.region);
        h *= 1000003;
        return h ^= Objects.hashCode(this.zone);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectZoneClusterSettingsBuilder {
        private String project;
        private String zone;
        private String cluster;

        private ProjectZoneClusterSettingsBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getZone() {
            return this.zone;
        }

        public String getCluster() {
            return this.cluster;
        }

        public ProjectZoneClusterSettingsBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectZoneClusterSettingsBuilder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public ProjectZoneClusterSettingsBuilder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectRegionClusterSettingsBuilder {
        private String project;
        private String region;
        private String cluster;

        private ProjectRegionClusterSettingsBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getCluster() {
            return this.cluster;
        }

        public ProjectRegionClusterSettingsBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectRegionClusterSettingsBuilder setRegion(String region) {
            this.region = region;
            return this;
        }

        public ProjectRegionClusterSettingsBuilder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationClusterSettingsBuilder {
        private String project;
        private String location;
        private String cluster;

        private ProjectLocationClusterSettingsBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCluster() {
            return this.cluster;
        }

        public ProjectLocationClusterSettingsBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationClusterSettingsBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationClusterSettingsBuilder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectSettingsBuilder {
        private String project;

        private ProjectSettingsBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public ProjectSettingsBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderSettingsBuilder {
        private String folder;

        private FolderSettingsBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public FolderSettingsBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }

    public static class Builder {
        private String organization;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        private Builder(SettingsName settingsName) {
            Preconditions.checkArgument((settingsName.pathTemplate == ORGANIZATION_SETTINGS_PATH_TEMPLATE ? 1 : 0) != 0, (Object)"toBuilder is only supported when SettingsName has the pattern of organizations/{organization}/settings.");
            this.organization = settingsName.organization;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }
}

