/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.security.privateca.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CertificateRevocationListName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/certificateAuthorities/{certificate_authority}/certificateRevocationLists/{certificate_revocation_list}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String certificateAuthority;
    private final String certificateRevocationList;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCertificateAuthority() {
        return this.certificateAuthority;
    }

    public String getCertificateRevocationList() {
        return this.certificateRevocationList;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CertificateRevocationListName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.certificateAuthority = (String)Preconditions.checkNotNull((Object)builder.getCertificateAuthority());
        this.certificateRevocationList = (String)Preconditions.checkNotNull((Object)builder.getCertificateRevocationList());
    }

    public static CertificateRevocationListName of(String project, String location, String certificateAuthority, String certificateRevocationList) {
        return CertificateRevocationListName.newBuilder().setProject(project).setLocation(location).setCertificateAuthority(certificateAuthority).setCertificateRevocationList(certificateRevocationList).build();
    }

    public static String format(String project, String location, String certificateAuthority, String certificateRevocationList) {
        return CertificateRevocationListName.newBuilder().setProject(project).setLocation(location).setCertificateAuthority(certificateAuthority).setCertificateRevocationList(certificateRevocationList).build().toString();
    }

    public static CertificateRevocationListName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CertificateRevocationListName.parse: formattedString not in valid format");
        return CertificateRevocationListName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("certificate_authority"), (String)matchMap.get("certificate_revocation_list"));
    }

    public static List<CertificateRevocationListName> parseList(List<String> formattedStrings) {
        ArrayList<CertificateRevocationListName> list = new ArrayList<CertificateRevocationListName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CertificateRevocationListName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CertificateRevocationListName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CertificateRevocationListName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CertificateRevocationListName certificateRevocationListName = this;
            synchronized (certificateRevocationListName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"certificateAuthority", (Object)this.certificateAuthority);
                    fieldMapBuilder.put((Object)"certificateRevocationList", (Object)this.certificateRevocationList);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "certificate_authority", this.certificateAuthority, "certificate_revocation_list", this.certificateRevocationList});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CertificateRevocationListName) {
            CertificateRevocationListName that = (CertificateRevocationListName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.certificateAuthority.equals(that.certificateAuthority) && this.certificateRevocationList.equals(that.certificateRevocationList);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.certificateAuthority.hashCode();
        h *= 1000003;
        return h ^= this.certificateRevocationList.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String certificateAuthority;
        private String certificateRevocationList;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCertificateAuthority() {
            return this.certificateAuthority;
        }

        public String getCertificateRevocationList() {
            return this.certificateRevocationList;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCertificateAuthority(String certificateAuthority) {
            this.certificateAuthority = certificateAuthority;
            return this;
        }

        public Builder setCertificateRevocationList(String certificateRevocationList) {
            this.certificateRevocationList = certificateRevocationList;
            return this;
        }

        private Builder() {
        }

        private Builder(CertificateRevocationListName certificateRevocationListName) {
            this.project = certificateRevocationListName.project;
            this.location = certificateRevocationListName.location;
            this.certificateAuthority = certificateRevocationListName.certificateAuthority;
            this.certificateRevocationList = certificateRevocationListName.certificateRevocationList;
        }

        public CertificateRevocationListName build() {
            return new CertificateRevocationListName(this);
        }
    }
}

