/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.security.privateca.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CaPoolName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CA_POOL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/caPools/{ca_pool}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String caPool;

    @Deprecated
    protected CaPoolName() {
        this.project = null;
        this.location = null;
        this.caPool = null;
    }

    private CaPoolName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.caPool = (String)Preconditions.checkNotNull((Object)builder.getCaPool());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCaPool() {
        return this.caPool;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CaPoolName of(String project, String location, String caPool) {
        return CaPoolName.newBuilder().setProject(project).setLocation(location).setCaPool(caPool).build();
    }

    public static String format(String project, String location, String caPool) {
        return CaPoolName.newBuilder().setProject(project).setLocation(location).setCaPool(caPool).build().toString();
    }

    public static CaPoolName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CA_POOL.validatedMatch(formattedString, "CaPoolName.parse: formattedString not in valid format");
        return CaPoolName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("ca_pool"));
    }

    public static List<CaPoolName> parseList(List<String> formattedStrings) {
        ArrayList<CaPoolName> list = new ArrayList<CaPoolName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CaPoolName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CaPoolName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CaPoolName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CA_POOL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CaPoolName caPoolName = this;
            synchronized (caPoolName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.caPool != null) {
                        fieldMapBuilder.put((Object)"ca_pool", (Object)this.caPool);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CA_POOL.instantiate(new String[]{"project", this.project, "location", this.location, "ca_pool", this.caPool});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CaPoolName that = (CaPoolName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.caPool, that.caPool);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.caPool);
    }

    public static class Builder {
        private String project;
        private String location;
        private String caPool;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCaPool() {
            return this.caPool;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCaPool(String caPool) {
            this.caPool = caPool;
            return this;
        }

        private Builder(CaPoolName caPoolName) {
            this.project = caPoolName.project;
            this.location = caPoolName.location;
            this.caPool = caPoolName.caPool;
        }

        public CaPoolName build() {
            return new CaPoolName(this);
        }
    }
}

