/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.security.privateca.v1;

import com.google.cloud.security.privateca.v1.KeyUsage;
import com.google.cloud.security.privateca.v1.KeyUsageOrBuilder;
import com.google.cloud.security.privateca.v1.ObjectId;
import com.google.cloud.security.privateca.v1.ObjectIdOrBuilder;
import com.google.cloud.security.privateca.v1.PrivateCaResourcesProto;
import com.google.cloud.security.privateca.v1.X509Extension;
import com.google.cloud.security.privateca.v1.X509ExtensionOrBuilder;
import com.google.cloud.security.privateca.v1.X509ParametersOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class X509Parameters
extends GeneratedMessageV3
implements X509ParametersOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int KEY_USAGE_FIELD_NUMBER = 1;
    private KeyUsage keyUsage_;
    public static final int CA_OPTIONS_FIELD_NUMBER = 2;
    private CaOptions caOptions_;
    public static final int POLICY_IDS_FIELD_NUMBER = 3;
    private List<ObjectId> policyIds_;
    public static final int AIA_OCSP_SERVERS_FIELD_NUMBER = 4;
    private LazyStringArrayList aiaOcspServers_ = LazyStringArrayList.emptyList();
    public static final int NAME_CONSTRAINTS_FIELD_NUMBER = 6;
    private NameConstraints nameConstraints_;
    public static final int ADDITIONAL_EXTENSIONS_FIELD_NUMBER = 5;
    private List<X509Extension> additionalExtensions_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final X509Parameters DEFAULT_INSTANCE = new X509Parameters();
    private static final Parser<X509Parameters> PARSER = new AbstractParser<X509Parameters>(){

        public X509Parameters parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = X509Parameters.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private X509Parameters(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private X509Parameters() {
        this.policyIds_ = Collections.emptyList();
        this.aiaOcspServers_ = LazyStringArrayList.emptyList();
        this.additionalExtensions_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new X509Parameters();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return PrivateCaResourcesProto.internal_static_google_cloud_security_privateca_v1_X509Parameters_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return PrivateCaResourcesProto.internal_static_google_cloud_security_privateca_v1_X509Parameters_fieldAccessorTable.ensureFieldAccessorsInitialized(X509Parameters.class, Builder.class);
    }

    @Override
    public boolean hasKeyUsage() {
        return this.keyUsage_ != null;
    }

    @Override
    public KeyUsage getKeyUsage() {
        return this.keyUsage_ == null ? KeyUsage.getDefaultInstance() : this.keyUsage_;
    }

    @Override
    public KeyUsageOrBuilder getKeyUsageOrBuilder() {
        return this.keyUsage_ == null ? KeyUsage.getDefaultInstance() : this.keyUsage_;
    }

    @Override
    public boolean hasCaOptions() {
        return this.caOptions_ != null;
    }

    @Override
    public CaOptions getCaOptions() {
        return this.caOptions_ == null ? CaOptions.getDefaultInstance() : this.caOptions_;
    }

    @Override
    public CaOptionsOrBuilder getCaOptionsOrBuilder() {
        return this.caOptions_ == null ? CaOptions.getDefaultInstance() : this.caOptions_;
    }

    @Override
    public List<ObjectId> getPolicyIdsList() {
        return this.policyIds_;
    }

    @Override
    public List<? extends ObjectIdOrBuilder> getPolicyIdsOrBuilderList() {
        return this.policyIds_;
    }

    @Override
    public int getPolicyIdsCount() {
        return this.policyIds_.size();
    }

    @Override
    public ObjectId getPolicyIds(int index) {
        return this.policyIds_.get(index);
    }

    @Override
    public ObjectIdOrBuilder getPolicyIdsOrBuilder(int index) {
        return this.policyIds_.get(index);
    }

    public ProtocolStringList getAiaOcspServersList() {
        return this.aiaOcspServers_;
    }

    @Override
    public int getAiaOcspServersCount() {
        return this.aiaOcspServers_.size();
    }

    @Override
    public String getAiaOcspServers(int index) {
        return this.aiaOcspServers_.get(index);
    }

    @Override
    public ByteString getAiaOcspServersBytes(int index) {
        return this.aiaOcspServers_.getByteString(index);
    }

    @Override
    public boolean hasNameConstraints() {
        return this.nameConstraints_ != null;
    }

    @Override
    public NameConstraints getNameConstraints() {
        return this.nameConstraints_ == null ? NameConstraints.getDefaultInstance() : this.nameConstraints_;
    }

    @Override
    public NameConstraintsOrBuilder getNameConstraintsOrBuilder() {
        return this.nameConstraints_ == null ? NameConstraints.getDefaultInstance() : this.nameConstraints_;
    }

    @Override
    public List<X509Extension> getAdditionalExtensionsList() {
        return this.additionalExtensions_;
    }

    @Override
    public List<? extends X509ExtensionOrBuilder> getAdditionalExtensionsOrBuilderList() {
        return this.additionalExtensions_;
    }

    @Override
    public int getAdditionalExtensionsCount() {
        return this.additionalExtensions_.size();
    }

    @Override
    public X509Extension getAdditionalExtensions(int index) {
        return this.additionalExtensions_.get(index);
    }

    @Override
    public X509ExtensionOrBuilder getAdditionalExtensionsOrBuilder(int index) {
        return this.additionalExtensions_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (this.keyUsage_ != null) {
            output.writeMessage(1, (MessageLite)this.getKeyUsage());
        }
        if (this.caOptions_ != null) {
            output.writeMessage(2, (MessageLite)this.getCaOptions());
        }
        for (i = 0; i < this.policyIds_.size(); ++i) {
            output.writeMessage(3, (MessageLite)this.policyIds_.get(i));
        }
        for (i = 0; i < this.aiaOcspServers_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.aiaOcspServers_.getRaw(i));
        }
        for (i = 0; i < this.additionalExtensions_.size(); ++i) {
            output.writeMessage(5, (MessageLite)this.additionalExtensions_.get(i));
        }
        if (this.nameConstraints_ != null) {
            output.writeMessage(6, (MessageLite)this.getNameConstraints());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.keyUsage_ != null) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getKeyUsage());
        }
        if (this.caOptions_ != null) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getCaOptions());
        }
        for (i = 0; i < this.policyIds_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)((MessageLite)this.policyIds_.get(i)));
        }
        int dataSize = 0;
        for (int i2 = 0; i2 < this.aiaOcspServers_.size(); ++i2) {
            dataSize += X509Parameters.computeStringSizeNoTag((Object)this.aiaOcspServers_.getRaw(i2));
        }
        size += dataSize;
        size += 1 * this.getAiaOcspServersList().size();
        for (i = 0; i < this.additionalExtensions_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)((MessageLite)this.additionalExtensions_.get(i)));
        }
        if (this.nameConstraints_ != null) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getNameConstraints());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof X509Parameters)) {
            return super.equals(obj);
        }
        X509Parameters other = (X509Parameters)obj;
        if (this.hasKeyUsage() != other.hasKeyUsage()) {
            return false;
        }
        if (this.hasKeyUsage() && !this.getKeyUsage().equals(other.getKeyUsage())) {
            return false;
        }
        if (this.hasCaOptions() != other.hasCaOptions()) {
            return false;
        }
        if (this.hasCaOptions() && !this.getCaOptions().equals(other.getCaOptions())) {
            return false;
        }
        if (!this.getPolicyIdsList().equals(other.getPolicyIdsList())) {
            return false;
        }
        if (!this.getAiaOcspServersList().equals(other.getAiaOcspServersList())) {
            return false;
        }
        if (this.hasNameConstraints() != other.hasNameConstraints()) {
            return false;
        }
        if (this.hasNameConstraints() && !this.getNameConstraints().equals(other.getNameConstraints())) {
            return false;
        }
        if (!this.getAdditionalExtensionsList().equals(other.getAdditionalExtensionsList())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + X509Parameters.getDescriptor().hashCode();
        if (this.hasKeyUsage()) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getKeyUsage().hashCode();
        }
        if (this.hasCaOptions()) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getCaOptions().hashCode();
        }
        if (this.getPolicyIdsCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getPolicyIdsList().hashCode();
        }
        if (this.getAiaOcspServersCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getAiaOcspServersList().hashCode();
        }
        if (this.hasNameConstraints()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getNameConstraints().hashCode();
        }
        if (this.getAdditionalExtensionsCount() > 0) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getAdditionalExtensionsList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static X509Parameters parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (X509Parameters)PARSER.parseFrom(data);
    }

    public static X509Parameters parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (X509Parameters)PARSER.parseFrom(data, extensionRegistry);
    }

    public static X509Parameters parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (X509Parameters)PARSER.parseFrom(data);
    }

    public static X509Parameters parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (X509Parameters)PARSER.parseFrom(data, extensionRegistry);
    }

    public static X509Parameters parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (X509Parameters)PARSER.parseFrom(data);
    }

    public static X509Parameters parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (X509Parameters)PARSER.parseFrom(data, extensionRegistry);
    }

    public static X509Parameters parseFrom(InputStream input) throws IOException {
        return (X509Parameters)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static X509Parameters parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (X509Parameters)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static X509Parameters parseDelimitedFrom(InputStream input) throws IOException {
        return (X509Parameters)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static X509Parameters parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (X509Parameters)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static X509Parameters parseFrom(CodedInputStream input) throws IOException {
        return (X509Parameters)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static X509Parameters parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (X509Parameters)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return X509Parameters.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(X509Parameters prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static X509Parameters getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<X509Parameters> parser() {
        return PARSER;
    }

    public Parser<X509Parameters> getParserForType() {
        return PARSER;
    }

    public X509Parameters getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements X509ParametersOrBuilder {
        private int bitField0_;
        private KeyUsage keyUsage_;
        private SingleFieldBuilderV3<KeyUsage, KeyUsage.Builder, KeyUsageOrBuilder> keyUsageBuilder_;
        private CaOptions caOptions_;
        private SingleFieldBuilderV3<CaOptions, CaOptions.Builder, CaOptionsOrBuilder> caOptionsBuilder_;
        private List<ObjectId> policyIds_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<ObjectId, ObjectId.Builder, ObjectIdOrBuilder> policyIdsBuilder_;
        private LazyStringArrayList aiaOcspServers_ = LazyStringArrayList.emptyList();
        private NameConstraints nameConstraints_;
        private SingleFieldBuilderV3<NameConstraints, NameConstraints.Builder, NameConstraintsOrBuilder> nameConstraintsBuilder_;
        private List<X509Extension> additionalExtensions_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<X509Extension, X509Extension.Builder, X509ExtensionOrBuilder> additionalExtensionsBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return PrivateCaResourcesProto.internal_static_google_cloud_security_privateca_v1_X509Parameters_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return PrivateCaResourcesProto.internal_static_google_cloud_security_privateca_v1_X509Parameters_fieldAccessorTable.ensureFieldAccessorsInitialized(X509Parameters.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.keyUsage_ = null;
            if (this.keyUsageBuilder_ != null) {
                this.keyUsageBuilder_.dispose();
                this.keyUsageBuilder_ = null;
            }
            this.caOptions_ = null;
            if (this.caOptionsBuilder_ != null) {
                this.caOptionsBuilder_.dispose();
                this.caOptionsBuilder_ = null;
            }
            if (this.policyIdsBuilder_ == null) {
                this.policyIds_ = Collections.emptyList();
            } else {
                this.policyIds_ = null;
                this.policyIdsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFB;
            this.aiaOcspServers_ = LazyStringArrayList.emptyList();
            this.nameConstraints_ = null;
            if (this.nameConstraintsBuilder_ != null) {
                this.nameConstraintsBuilder_.dispose();
                this.nameConstraintsBuilder_ = null;
            }
            if (this.additionalExtensionsBuilder_ == null) {
                this.additionalExtensions_ = Collections.emptyList();
            } else {
                this.additionalExtensions_ = null;
                this.additionalExtensionsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFDF;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return PrivateCaResourcesProto.internal_static_google_cloud_security_privateca_v1_X509Parameters_descriptor;
        }

        public X509Parameters getDefaultInstanceForType() {
            return X509Parameters.getDefaultInstance();
        }

        public X509Parameters build() {
            X509Parameters result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public X509Parameters buildPartial() {
            X509Parameters result = new X509Parameters(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(X509Parameters result) {
            if (this.policyIdsBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0) {
                    this.policyIds_ = Collections.unmodifiableList(this.policyIds_);
                    this.bitField0_ &= 0xFFFFFFFB;
                }
                result.policyIds_ = this.policyIds_;
            } else {
                result.policyIds_ = this.policyIdsBuilder_.build();
            }
            if (this.additionalExtensionsBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0) {
                    this.additionalExtensions_ = Collections.unmodifiableList(this.additionalExtensions_);
                    this.bitField0_ &= 0xFFFFFFDF;
                }
                result.additionalExtensions_ = this.additionalExtensions_;
            } else {
                result.additionalExtensions_ = this.additionalExtensionsBuilder_.build();
            }
        }

        private void buildPartial0(X509Parameters result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.keyUsage_ = this.keyUsageBuilder_ == null ? this.keyUsage_ : (KeyUsage)this.keyUsageBuilder_.build();
            }
            if ((from_bitField0_ & 2) != 0) {
                result.caOptions_ = this.caOptionsBuilder_ == null ? this.caOptions_ : (CaOptions)this.caOptionsBuilder_.build();
            }
            if ((from_bitField0_ & 8) != 0) {
                this.aiaOcspServers_.makeImmutable();
                result.aiaOcspServers_ = this.aiaOcspServers_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.nameConstraints_ = this.nameConstraintsBuilder_ == null ? this.nameConstraints_ : (NameConstraints)this.nameConstraintsBuilder_.build();
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof X509Parameters) {
                return this.mergeFrom((X509Parameters)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(X509Parameters other) {
            if (other == X509Parameters.getDefaultInstance()) {
                return this;
            }
            if (other.hasKeyUsage()) {
                this.mergeKeyUsage(other.getKeyUsage());
            }
            if (other.hasCaOptions()) {
                this.mergeCaOptions(other.getCaOptions());
            }
            if (this.policyIdsBuilder_ == null) {
                if (!other.policyIds_.isEmpty()) {
                    if (this.policyIds_.isEmpty()) {
                        this.policyIds_ = other.policyIds_;
                        this.bitField0_ &= 0xFFFFFFFB;
                    } else {
                        this.ensurePolicyIdsIsMutable();
                        this.policyIds_.addAll(other.policyIds_);
                    }
                    this.onChanged();
                }
            } else if (!other.policyIds_.isEmpty()) {
                if (this.policyIdsBuilder_.isEmpty()) {
                    this.policyIdsBuilder_.dispose();
                    this.policyIdsBuilder_ = null;
                    this.policyIds_ = other.policyIds_;
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.policyIdsBuilder_ = alwaysUseFieldBuilders ? this.getPolicyIdsFieldBuilder() : null;
                } else {
                    this.policyIdsBuilder_.addAllMessages((Iterable)other.policyIds_);
                }
            }
            if (!other.aiaOcspServers_.isEmpty()) {
                if (this.aiaOcspServers_.isEmpty()) {
                    this.aiaOcspServers_ = other.aiaOcspServers_;
                    this.bitField0_ |= 8;
                } else {
                    this.ensureAiaOcspServersIsMutable();
                    this.aiaOcspServers_.addAll((Collection)other.aiaOcspServers_);
                }
                this.onChanged();
            }
            if (other.hasNameConstraints()) {
                this.mergeNameConstraints(other.getNameConstraints());
            }
            if (this.additionalExtensionsBuilder_ == null) {
                if (!other.additionalExtensions_.isEmpty()) {
                    if (this.additionalExtensions_.isEmpty()) {
                        this.additionalExtensions_ = other.additionalExtensions_;
                        this.bitField0_ &= 0xFFFFFFDF;
                    } else {
                        this.ensureAdditionalExtensionsIsMutable();
                        this.additionalExtensions_.addAll(other.additionalExtensions_);
                    }
                    this.onChanged();
                }
            } else if (!other.additionalExtensions_.isEmpty()) {
                if (this.additionalExtensionsBuilder_.isEmpty()) {
                    this.additionalExtensionsBuilder_.dispose();
                    this.additionalExtensionsBuilder_ = null;
                    this.additionalExtensions_ = other.additionalExtensions_;
                    this.bitField0_ &= 0xFFFFFFDF;
                    this.additionalExtensionsBuilder_ = alwaysUseFieldBuilders ? this.getAdditionalExtensionsFieldBuilder() : null;
                } else {
                    this.additionalExtensionsBuilder_.addAllMessages((Iterable)other.additionalExtensions_);
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block14: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block14;
                        }
                        case 10: {
                            input.readMessage((MessageLite.Builder)this.getKeyUsageFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 1;
                            continue block14;
                        }
                        case 18: {
                            input.readMessage((MessageLite.Builder)this.getCaOptionsFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 2;
                            continue block14;
                        }
                        case 26: {
                            GeneratedMessageV3 m = (ObjectId)input.readMessage(ObjectId.parser(), extensionRegistry);
                            if (this.policyIdsBuilder_ == null) {
                                this.ensurePolicyIdsIsMutable();
                                this.policyIds_.add((ObjectId)m);
                                continue block14;
                            }
                            this.policyIdsBuilder_.addMessage((AbstractMessage)m);
                            continue block14;
                        }
                        case 34: {
                            String s = input.readStringRequireUtf8();
                            this.ensureAiaOcspServersIsMutable();
                            this.aiaOcspServers_.add((Object)s);
                            continue block14;
                        }
                        case 42: {
                            GeneratedMessageV3 m = (X509Extension)input.readMessage(X509Extension.parser(), extensionRegistry);
                            if (this.additionalExtensionsBuilder_ == null) {
                                this.ensureAdditionalExtensionsIsMutable();
                                this.additionalExtensions_.add((X509Extension)m);
                                continue block14;
                            }
                            this.additionalExtensionsBuilder_.addMessage((AbstractMessage)m);
                            continue block14;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getNameConstraintsFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block14;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasKeyUsage() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public KeyUsage getKeyUsage() {
            if (this.keyUsageBuilder_ == null) {
                return this.keyUsage_ == null ? KeyUsage.getDefaultInstance() : this.keyUsage_;
            }
            return (KeyUsage)this.keyUsageBuilder_.getMessage();
        }

        public Builder setKeyUsage(KeyUsage value) {
            if (this.keyUsageBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.keyUsage_ = value;
            } else {
                this.keyUsageBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder setKeyUsage(KeyUsage.Builder builderForValue) {
            if (this.keyUsageBuilder_ == null) {
                this.keyUsage_ = builderForValue.build();
            } else {
                this.keyUsageBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder mergeKeyUsage(KeyUsage value) {
            if (this.keyUsageBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0 && this.keyUsage_ != null && this.keyUsage_ != KeyUsage.getDefaultInstance()) {
                    this.getKeyUsageBuilder().mergeFrom(value);
                } else {
                    this.keyUsage_ = value;
                }
            } else {
                this.keyUsageBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearKeyUsage() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.keyUsage_ = null;
            if (this.keyUsageBuilder_ != null) {
                this.keyUsageBuilder_.dispose();
                this.keyUsageBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public KeyUsage.Builder getKeyUsageBuilder() {
            this.bitField0_ |= 1;
            this.onChanged();
            return (KeyUsage.Builder)this.getKeyUsageFieldBuilder().getBuilder();
        }

        @Override
        public KeyUsageOrBuilder getKeyUsageOrBuilder() {
            if (this.keyUsageBuilder_ != null) {
                return (KeyUsageOrBuilder)this.keyUsageBuilder_.getMessageOrBuilder();
            }
            return this.keyUsage_ == null ? KeyUsage.getDefaultInstance() : this.keyUsage_;
        }

        private SingleFieldBuilderV3<KeyUsage, KeyUsage.Builder, KeyUsageOrBuilder> getKeyUsageFieldBuilder() {
            if (this.keyUsageBuilder_ == null) {
                this.keyUsageBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getKeyUsage(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.keyUsage_ = null;
            }
            return this.keyUsageBuilder_;
        }

        @Override
        public boolean hasCaOptions() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public CaOptions getCaOptions() {
            if (this.caOptionsBuilder_ == null) {
                return this.caOptions_ == null ? CaOptions.getDefaultInstance() : this.caOptions_;
            }
            return (CaOptions)this.caOptionsBuilder_.getMessage();
        }

        public Builder setCaOptions(CaOptions value) {
            if (this.caOptionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.caOptions_ = value;
            } else {
                this.caOptionsBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder setCaOptions(CaOptions.Builder builderForValue) {
            if (this.caOptionsBuilder_ == null) {
                this.caOptions_ = builderForValue.build();
            } else {
                this.caOptionsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder mergeCaOptions(CaOptions value) {
            if (this.caOptionsBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0 && this.caOptions_ != null && this.caOptions_ != CaOptions.getDefaultInstance()) {
                    this.getCaOptionsBuilder().mergeFrom(value);
                } else {
                    this.caOptions_ = value;
                }
            } else {
                this.caOptionsBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearCaOptions() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.caOptions_ = null;
            if (this.caOptionsBuilder_ != null) {
                this.caOptionsBuilder_.dispose();
                this.caOptionsBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public CaOptions.Builder getCaOptionsBuilder() {
            this.bitField0_ |= 2;
            this.onChanged();
            return (CaOptions.Builder)this.getCaOptionsFieldBuilder().getBuilder();
        }

        @Override
        public CaOptionsOrBuilder getCaOptionsOrBuilder() {
            if (this.caOptionsBuilder_ != null) {
                return (CaOptionsOrBuilder)this.caOptionsBuilder_.getMessageOrBuilder();
            }
            return this.caOptions_ == null ? CaOptions.getDefaultInstance() : this.caOptions_;
        }

        private SingleFieldBuilderV3<CaOptions, CaOptions.Builder, CaOptionsOrBuilder> getCaOptionsFieldBuilder() {
            if (this.caOptionsBuilder_ == null) {
                this.caOptionsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCaOptions(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.caOptions_ = null;
            }
            return this.caOptionsBuilder_;
        }

        private void ensurePolicyIdsIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.policyIds_ = new ArrayList<ObjectId>(this.policyIds_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<ObjectId> getPolicyIdsList() {
            if (this.policyIdsBuilder_ == null) {
                return Collections.unmodifiableList(this.policyIds_);
            }
            return this.policyIdsBuilder_.getMessageList();
        }

        @Override
        public int getPolicyIdsCount() {
            if (this.policyIdsBuilder_ == null) {
                return this.policyIds_.size();
            }
            return this.policyIdsBuilder_.getCount();
        }

        @Override
        public ObjectId getPolicyIds(int index) {
            if (this.policyIdsBuilder_ == null) {
                return this.policyIds_.get(index);
            }
            return (ObjectId)this.policyIdsBuilder_.getMessage(index);
        }

        public Builder setPolicyIds(int index, ObjectId value) {
            if (this.policyIdsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePolicyIdsIsMutable();
                this.policyIds_.set(index, value);
                this.onChanged();
            } else {
                this.policyIdsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setPolicyIds(int index, ObjectId.Builder builderForValue) {
            if (this.policyIdsBuilder_ == null) {
                this.ensurePolicyIdsIsMutable();
                this.policyIds_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.policyIdsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPolicyIds(ObjectId value) {
            if (this.policyIdsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePolicyIdsIsMutable();
                this.policyIds_.add(value);
                this.onChanged();
            } else {
                this.policyIdsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addPolicyIds(int index, ObjectId value) {
            if (this.policyIdsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePolicyIdsIsMutable();
                this.policyIds_.add(index, value);
                this.onChanged();
            } else {
                this.policyIdsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addPolicyIds(ObjectId.Builder builderForValue) {
            if (this.policyIdsBuilder_ == null) {
                this.ensurePolicyIdsIsMutable();
                this.policyIds_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.policyIdsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPolicyIds(int index, ObjectId.Builder builderForValue) {
            if (this.policyIdsBuilder_ == null) {
                this.ensurePolicyIdsIsMutable();
                this.policyIds_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.policyIdsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllPolicyIds(Iterable<? extends ObjectId> values) {
            if (this.policyIdsBuilder_ == null) {
                this.ensurePolicyIdsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.policyIds_);
                this.onChanged();
            } else {
                this.policyIdsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearPolicyIds() {
            if (this.policyIdsBuilder_ == null) {
                this.policyIds_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
            } else {
                this.policyIdsBuilder_.clear();
            }
            return this;
        }

        public Builder removePolicyIds(int index) {
            if (this.policyIdsBuilder_ == null) {
                this.ensurePolicyIdsIsMutable();
                this.policyIds_.remove(index);
                this.onChanged();
            } else {
                this.policyIdsBuilder_.remove(index);
            }
            return this;
        }

        public ObjectId.Builder getPolicyIdsBuilder(int index) {
            return (ObjectId.Builder)this.getPolicyIdsFieldBuilder().getBuilder(index);
        }

        @Override
        public ObjectIdOrBuilder getPolicyIdsOrBuilder(int index) {
            if (this.policyIdsBuilder_ == null) {
                return this.policyIds_.get(index);
            }
            return (ObjectIdOrBuilder)this.policyIdsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ObjectIdOrBuilder> getPolicyIdsOrBuilderList() {
            if (this.policyIdsBuilder_ != null) {
                return this.policyIdsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.policyIds_);
        }

        public ObjectId.Builder addPolicyIdsBuilder() {
            return (ObjectId.Builder)this.getPolicyIdsFieldBuilder().addBuilder((AbstractMessage)ObjectId.getDefaultInstance());
        }

        public ObjectId.Builder addPolicyIdsBuilder(int index) {
            return (ObjectId.Builder)this.getPolicyIdsFieldBuilder().addBuilder(index, (AbstractMessage)ObjectId.getDefaultInstance());
        }

        public List<ObjectId.Builder> getPolicyIdsBuilderList() {
            return this.getPolicyIdsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<ObjectId, ObjectId.Builder, ObjectIdOrBuilder> getPolicyIdsFieldBuilder() {
            if (this.policyIdsBuilder_ == null) {
                this.policyIdsBuilder_ = new RepeatedFieldBuilderV3(this.policyIds_, (this.bitField0_ & 4) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.policyIds_ = null;
            }
            return this.policyIdsBuilder_;
        }

        private void ensureAiaOcspServersIsMutable() {
            if (!this.aiaOcspServers_.isModifiable()) {
                this.aiaOcspServers_ = new LazyStringArrayList((LazyStringList)this.aiaOcspServers_);
            }
            this.bitField0_ |= 8;
        }

        public ProtocolStringList getAiaOcspServersList() {
            this.aiaOcspServers_.makeImmutable();
            return this.aiaOcspServers_;
        }

        @Override
        public int getAiaOcspServersCount() {
            return this.aiaOcspServers_.size();
        }

        @Override
        public String getAiaOcspServers(int index) {
            return this.aiaOcspServers_.get(index);
        }

        @Override
        public ByteString getAiaOcspServersBytes(int index) {
            return this.aiaOcspServers_.getByteString(index);
        }

        public Builder setAiaOcspServers(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAiaOcspServersIsMutable();
            this.aiaOcspServers_.set(index, value);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder addAiaOcspServers(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAiaOcspServersIsMutable();
            this.aiaOcspServers_.add((Object)value);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder addAllAiaOcspServers(Iterable<String> values) {
            this.ensureAiaOcspServersIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.aiaOcspServers_);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearAiaOcspServers() {
            this.aiaOcspServers_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder addAiaOcspServersBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            X509Parameters.checkByteStringIsUtf8((ByteString)value);
            this.ensureAiaOcspServersIsMutable();
            this.aiaOcspServers_.add(value);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasNameConstraints() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public NameConstraints getNameConstraints() {
            if (this.nameConstraintsBuilder_ == null) {
                return this.nameConstraints_ == null ? NameConstraints.getDefaultInstance() : this.nameConstraints_;
            }
            return (NameConstraints)this.nameConstraintsBuilder_.getMessage();
        }

        public Builder setNameConstraints(NameConstraints value) {
            if (this.nameConstraintsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.nameConstraints_ = value;
            } else {
                this.nameConstraintsBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setNameConstraints(NameConstraints.Builder builderForValue) {
            if (this.nameConstraintsBuilder_ == null) {
                this.nameConstraints_ = builderForValue.build();
            } else {
                this.nameConstraintsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergeNameConstraints(NameConstraints value) {
            if (this.nameConstraintsBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.nameConstraints_ != null && this.nameConstraints_ != NameConstraints.getDefaultInstance()) {
                    this.getNameConstraintsBuilder().mergeFrom(value);
                } else {
                    this.nameConstraints_ = value;
                }
            } else {
                this.nameConstraintsBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearNameConstraints() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.nameConstraints_ = null;
            if (this.nameConstraintsBuilder_ != null) {
                this.nameConstraintsBuilder_.dispose();
                this.nameConstraintsBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public NameConstraints.Builder getNameConstraintsBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (NameConstraints.Builder)this.getNameConstraintsFieldBuilder().getBuilder();
        }

        @Override
        public NameConstraintsOrBuilder getNameConstraintsOrBuilder() {
            if (this.nameConstraintsBuilder_ != null) {
                return (NameConstraintsOrBuilder)this.nameConstraintsBuilder_.getMessageOrBuilder();
            }
            return this.nameConstraints_ == null ? NameConstraints.getDefaultInstance() : this.nameConstraints_;
        }

        private SingleFieldBuilderV3<NameConstraints, NameConstraints.Builder, NameConstraintsOrBuilder> getNameConstraintsFieldBuilder() {
            if (this.nameConstraintsBuilder_ == null) {
                this.nameConstraintsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getNameConstraints(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.nameConstraints_ = null;
            }
            return this.nameConstraintsBuilder_;
        }

        private void ensureAdditionalExtensionsIsMutable() {
            if ((this.bitField0_ & 0x20) == 0) {
                this.additionalExtensions_ = new ArrayList<X509Extension>(this.additionalExtensions_);
                this.bitField0_ |= 0x20;
            }
        }

        @Override
        public List<X509Extension> getAdditionalExtensionsList() {
            if (this.additionalExtensionsBuilder_ == null) {
                return Collections.unmodifiableList(this.additionalExtensions_);
            }
            return this.additionalExtensionsBuilder_.getMessageList();
        }

        @Override
        public int getAdditionalExtensionsCount() {
            if (this.additionalExtensionsBuilder_ == null) {
                return this.additionalExtensions_.size();
            }
            return this.additionalExtensionsBuilder_.getCount();
        }

        @Override
        public X509Extension getAdditionalExtensions(int index) {
            if (this.additionalExtensionsBuilder_ == null) {
                return this.additionalExtensions_.get(index);
            }
            return (X509Extension)this.additionalExtensionsBuilder_.getMessage(index);
        }

        public Builder setAdditionalExtensions(int index, X509Extension value) {
            if (this.additionalExtensionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdditionalExtensionsIsMutable();
                this.additionalExtensions_.set(index, value);
                this.onChanged();
            } else {
                this.additionalExtensionsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAdditionalExtensions(int index, X509Extension.Builder builderForValue) {
            if (this.additionalExtensionsBuilder_ == null) {
                this.ensureAdditionalExtensionsIsMutable();
                this.additionalExtensions_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.additionalExtensionsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAdditionalExtensions(X509Extension value) {
            if (this.additionalExtensionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdditionalExtensionsIsMutable();
                this.additionalExtensions_.add(value);
                this.onChanged();
            } else {
                this.additionalExtensionsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAdditionalExtensions(int index, X509Extension value) {
            if (this.additionalExtensionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdditionalExtensionsIsMutable();
                this.additionalExtensions_.add(index, value);
                this.onChanged();
            } else {
                this.additionalExtensionsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAdditionalExtensions(X509Extension.Builder builderForValue) {
            if (this.additionalExtensionsBuilder_ == null) {
                this.ensureAdditionalExtensionsIsMutable();
                this.additionalExtensions_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.additionalExtensionsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAdditionalExtensions(int index, X509Extension.Builder builderForValue) {
            if (this.additionalExtensionsBuilder_ == null) {
                this.ensureAdditionalExtensionsIsMutable();
                this.additionalExtensions_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.additionalExtensionsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAdditionalExtensions(Iterable<? extends X509Extension> values) {
            if (this.additionalExtensionsBuilder_ == null) {
                this.ensureAdditionalExtensionsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.additionalExtensions_);
                this.onChanged();
            } else {
                this.additionalExtensionsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAdditionalExtensions() {
            if (this.additionalExtensionsBuilder_ == null) {
                this.additionalExtensions_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFDF;
                this.onChanged();
            } else {
                this.additionalExtensionsBuilder_.clear();
            }
            return this;
        }

        public Builder removeAdditionalExtensions(int index) {
            if (this.additionalExtensionsBuilder_ == null) {
                this.ensureAdditionalExtensionsIsMutable();
                this.additionalExtensions_.remove(index);
                this.onChanged();
            } else {
                this.additionalExtensionsBuilder_.remove(index);
            }
            return this;
        }

        public X509Extension.Builder getAdditionalExtensionsBuilder(int index) {
            return (X509Extension.Builder)this.getAdditionalExtensionsFieldBuilder().getBuilder(index);
        }

        @Override
        public X509ExtensionOrBuilder getAdditionalExtensionsOrBuilder(int index) {
            if (this.additionalExtensionsBuilder_ == null) {
                return this.additionalExtensions_.get(index);
            }
            return (X509ExtensionOrBuilder)this.additionalExtensionsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends X509ExtensionOrBuilder> getAdditionalExtensionsOrBuilderList() {
            if (this.additionalExtensionsBuilder_ != null) {
                return this.additionalExtensionsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.additionalExtensions_);
        }

        public X509Extension.Builder addAdditionalExtensionsBuilder() {
            return (X509Extension.Builder)this.getAdditionalExtensionsFieldBuilder().addBuilder((AbstractMessage)X509Extension.getDefaultInstance());
        }

        public X509Extension.Builder addAdditionalExtensionsBuilder(int index) {
            return (X509Extension.Builder)this.getAdditionalExtensionsFieldBuilder().addBuilder(index, (AbstractMessage)X509Extension.getDefaultInstance());
        }

        public List<X509Extension.Builder> getAdditionalExtensionsBuilderList() {
            return this.getAdditionalExtensionsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<X509Extension, X509Extension.Builder, X509ExtensionOrBuilder> getAdditionalExtensionsFieldBuilder() {
            if (this.additionalExtensionsBuilder_ == null) {
                this.additionalExtensionsBuilder_ = new RepeatedFieldBuilderV3(this.additionalExtensions_, (this.bitField0_ & 0x20) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.additionalExtensions_ = null;
            }
            return this.additionalExtensionsBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class NameConstraints
    extends GeneratedMessageV3
    implements NameConstraintsOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int CRITICAL_FIELD_NUMBER = 1;
        private boolean critical_ = false;
        public static final int PERMITTED_DNS_NAMES_FIELD_NUMBER = 2;
        private LazyStringArrayList permittedDnsNames_ = LazyStringArrayList.emptyList();
        public static final int EXCLUDED_DNS_NAMES_FIELD_NUMBER = 3;
        private LazyStringArrayList excludedDnsNames_ = LazyStringArrayList.emptyList();
        public static final int PERMITTED_IP_RANGES_FIELD_NUMBER = 4;
        private LazyStringArrayList permittedIpRanges_ = LazyStringArrayList.emptyList();
        public static final int EXCLUDED_IP_RANGES_FIELD_NUMBER = 5;
        private LazyStringArrayList excludedIpRanges_ = LazyStringArrayList.emptyList();
        public static final int PERMITTED_EMAIL_ADDRESSES_FIELD_NUMBER = 6;
        private LazyStringArrayList permittedEmailAddresses_ = LazyStringArrayList.emptyList();
        public static final int EXCLUDED_EMAIL_ADDRESSES_FIELD_NUMBER = 7;
        private LazyStringArrayList excludedEmailAddresses_ = LazyStringArrayList.emptyList();
        public static final int PERMITTED_URIS_FIELD_NUMBER = 8;
        private LazyStringArrayList permittedUris_ = LazyStringArrayList.emptyList();
        public static final int EXCLUDED_URIS_FIELD_NUMBER = 9;
        private LazyStringArrayList excludedUris_ = LazyStringArrayList.emptyList();
        private byte memoizedIsInitialized = (byte)-1;
        private static final NameConstraints DEFAULT_INSTANCE = new NameConstraints();
        private static final Parser<NameConstraints> PARSER = new AbstractParser<NameConstraints>(){

            public NameConstraints parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = NameConstraints.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private NameConstraints(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private NameConstraints() {
            this.permittedDnsNames_ = LazyStringArrayList.emptyList();
            this.excludedDnsNames_ = LazyStringArrayList.emptyList();
            this.permittedIpRanges_ = LazyStringArrayList.emptyList();
            this.excludedIpRanges_ = LazyStringArrayList.emptyList();
            this.permittedEmailAddresses_ = LazyStringArrayList.emptyList();
            this.excludedEmailAddresses_ = LazyStringArrayList.emptyList();
            this.permittedUris_ = LazyStringArrayList.emptyList();
            this.excludedUris_ = LazyStringArrayList.emptyList();
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new NameConstraints();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return PrivateCaResourcesProto.internal_static_google_cloud_security_privateca_v1_X509Parameters_NameConstraints_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return PrivateCaResourcesProto.internal_static_google_cloud_security_privateca_v1_X509Parameters_NameConstraints_fieldAccessorTable.ensureFieldAccessorsInitialized(NameConstraints.class, Builder.class);
        }

        @Override
        public boolean getCritical() {
            return this.critical_;
        }

        public ProtocolStringList getPermittedDnsNamesList() {
            return this.permittedDnsNames_;
        }

        @Override
        public int getPermittedDnsNamesCount() {
            return this.permittedDnsNames_.size();
        }

        @Override
        public String getPermittedDnsNames(int index) {
            return this.permittedDnsNames_.get(index);
        }

        @Override
        public ByteString getPermittedDnsNamesBytes(int index) {
            return this.permittedDnsNames_.getByteString(index);
        }

        public ProtocolStringList getExcludedDnsNamesList() {
            return this.excludedDnsNames_;
        }

        @Override
        public int getExcludedDnsNamesCount() {
            return this.excludedDnsNames_.size();
        }

        @Override
        public String getExcludedDnsNames(int index) {
            return this.excludedDnsNames_.get(index);
        }

        @Override
        public ByteString getExcludedDnsNamesBytes(int index) {
            return this.excludedDnsNames_.getByteString(index);
        }

        public ProtocolStringList getPermittedIpRangesList() {
            return this.permittedIpRanges_;
        }

        @Override
        public int getPermittedIpRangesCount() {
            return this.permittedIpRanges_.size();
        }

        @Override
        public String getPermittedIpRanges(int index) {
            return this.permittedIpRanges_.get(index);
        }

        @Override
        public ByteString getPermittedIpRangesBytes(int index) {
            return this.permittedIpRanges_.getByteString(index);
        }

        public ProtocolStringList getExcludedIpRangesList() {
            return this.excludedIpRanges_;
        }

        @Override
        public int getExcludedIpRangesCount() {
            return this.excludedIpRanges_.size();
        }

        @Override
        public String getExcludedIpRanges(int index) {
            return this.excludedIpRanges_.get(index);
        }

        @Override
        public ByteString getExcludedIpRangesBytes(int index) {
            return this.excludedIpRanges_.getByteString(index);
        }

        public ProtocolStringList getPermittedEmailAddressesList() {
            return this.permittedEmailAddresses_;
        }

        @Override
        public int getPermittedEmailAddressesCount() {
            return this.permittedEmailAddresses_.size();
        }

        @Override
        public String getPermittedEmailAddresses(int index) {
            return this.permittedEmailAddresses_.get(index);
        }

        @Override
        public ByteString getPermittedEmailAddressesBytes(int index) {
            return this.permittedEmailAddresses_.getByteString(index);
        }

        public ProtocolStringList getExcludedEmailAddressesList() {
            return this.excludedEmailAddresses_;
        }

        @Override
        public int getExcludedEmailAddressesCount() {
            return this.excludedEmailAddresses_.size();
        }

        @Override
        public String getExcludedEmailAddresses(int index) {
            return this.excludedEmailAddresses_.get(index);
        }

        @Override
        public ByteString getExcludedEmailAddressesBytes(int index) {
            return this.excludedEmailAddresses_.getByteString(index);
        }

        public ProtocolStringList getPermittedUrisList() {
            return this.permittedUris_;
        }

        @Override
        public int getPermittedUrisCount() {
            return this.permittedUris_.size();
        }

        @Override
        public String getPermittedUris(int index) {
            return this.permittedUris_.get(index);
        }

        @Override
        public ByteString getPermittedUrisBytes(int index) {
            return this.permittedUris_.getByteString(index);
        }

        public ProtocolStringList getExcludedUrisList() {
            return this.excludedUris_;
        }

        @Override
        public int getExcludedUrisCount() {
            return this.excludedUris_.size();
        }

        @Override
        public String getExcludedUris(int index) {
            return this.excludedUris_.get(index);
        }

        @Override
        public ByteString getExcludedUrisBytes(int index) {
            return this.excludedUris_.getByteString(index);
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            int i;
            if (this.critical_) {
                output.writeBool(1, this.critical_);
            }
            for (i = 0; i < this.permittedDnsNames_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.permittedDnsNames_.getRaw(i));
            }
            for (i = 0; i < this.excludedDnsNames_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.excludedDnsNames_.getRaw(i));
            }
            for (i = 0; i < this.permittedIpRanges_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.permittedIpRanges_.getRaw(i));
            }
            for (i = 0; i < this.excludedIpRanges_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.excludedIpRanges_.getRaw(i));
            }
            for (i = 0; i < this.permittedEmailAddresses_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.permittedEmailAddresses_.getRaw(i));
            }
            for (i = 0; i < this.excludedEmailAddresses_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.excludedEmailAddresses_.getRaw(i));
            }
            for (i = 0; i < this.permittedUris_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)8, (Object)this.permittedUris_.getRaw(i));
            }
            for (i = 0; i < this.excludedUris_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)9, (Object)this.excludedUris_.getRaw(i));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int i;
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.critical_) {
                size += CodedOutputStream.computeBoolSize((int)1, (boolean)this.critical_);
            }
            int dataSize = 0;
            for (i = 0; i < this.permittedDnsNames_.size(); ++i) {
                dataSize += NameConstraints.computeStringSizeNoTag((Object)this.permittedDnsNames_.getRaw(i));
            }
            size += dataSize;
            size += 1 * this.getPermittedDnsNamesList().size();
            dataSize = 0;
            for (i = 0; i < this.excludedDnsNames_.size(); ++i) {
                dataSize += NameConstraints.computeStringSizeNoTag((Object)this.excludedDnsNames_.getRaw(i));
            }
            size += dataSize;
            size += 1 * this.getExcludedDnsNamesList().size();
            dataSize = 0;
            for (i = 0; i < this.permittedIpRanges_.size(); ++i) {
                dataSize += NameConstraints.computeStringSizeNoTag((Object)this.permittedIpRanges_.getRaw(i));
            }
            size += dataSize;
            size += 1 * this.getPermittedIpRangesList().size();
            dataSize = 0;
            for (i = 0; i < this.excludedIpRanges_.size(); ++i) {
                dataSize += NameConstraints.computeStringSizeNoTag((Object)this.excludedIpRanges_.getRaw(i));
            }
            size += dataSize;
            size += 1 * this.getExcludedIpRangesList().size();
            dataSize = 0;
            for (i = 0; i < this.permittedEmailAddresses_.size(); ++i) {
                dataSize += NameConstraints.computeStringSizeNoTag((Object)this.permittedEmailAddresses_.getRaw(i));
            }
            size += dataSize;
            size += 1 * this.getPermittedEmailAddressesList().size();
            dataSize = 0;
            for (i = 0; i < this.excludedEmailAddresses_.size(); ++i) {
                dataSize += NameConstraints.computeStringSizeNoTag((Object)this.excludedEmailAddresses_.getRaw(i));
            }
            size += dataSize;
            size += 1 * this.getExcludedEmailAddressesList().size();
            dataSize = 0;
            for (i = 0; i < this.permittedUris_.size(); ++i) {
                dataSize += NameConstraints.computeStringSizeNoTag((Object)this.permittedUris_.getRaw(i));
            }
            size += dataSize;
            size += 1 * this.getPermittedUrisList().size();
            dataSize = 0;
            for (i = 0; i < this.excludedUris_.size(); ++i) {
                dataSize += NameConstraints.computeStringSizeNoTag((Object)this.excludedUris_.getRaw(i));
            }
            size += dataSize;
            size += 1 * this.getExcludedUrisList().size();
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof NameConstraints)) {
                return super.equals(obj);
            }
            NameConstraints other = (NameConstraints)obj;
            if (this.getCritical() != other.getCritical()) {
                return false;
            }
            if (!this.getPermittedDnsNamesList().equals(other.getPermittedDnsNamesList())) {
                return false;
            }
            if (!this.getExcludedDnsNamesList().equals(other.getExcludedDnsNamesList())) {
                return false;
            }
            if (!this.getPermittedIpRangesList().equals(other.getPermittedIpRangesList())) {
                return false;
            }
            if (!this.getExcludedIpRangesList().equals(other.getExcludedIpRangesList())) {
                return false;
            }
            if (!this.getPermittedEmailAddressesList().equals(other.getPermittedEmailAddressesList())) {
                return false;
            }
            if (!this.getExcludedEmailAddressesList().equals(other.getExcludedEmailAddressesList())) {
                return false;
            }
            if (!this.getPermittedUrisList().equals(other.getPermittedUrisList())) {
                return false;
            }
            if (!this.getExcludedUrisList().equals(other.getExcludedUrisList())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + NameConstraints.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + Internal.hashBoolean((boolean)this.getCritical());
            if (this.getPermittedDnsNamesCount() > 0) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getPermittedDnsNamesList().hashCode();
            }
            if (this.getExcludedDnsNamesCount() > 0) {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getExcludedDnsNamesList().hashCode();
            }
            if (this.getPermittedIpRangesCount() > 0) {
                hash = 37 * hash + 4;
                hash = 53 * hash + this.getPermittedIpRangesList().hashCode();
            }
            if (this.getExcludedIpRangesCount() > 0) {
                hash = 37 * hash + 5;
                hash = 53 * hash + this.getExcludedIpRangesList().hashCode();
            }
            if (this.getPermittedEmailAddressesCount() > 0) {
                hash = 37 * hash + 6;
                hash = 53 * hash + this.getPermittedEmailAddressesList().hashCode();
            }
            if (this.getExcludedEmailAddressesCount() > 0) {
                hash = 37 * hash + 7;
                hash = 53 * hash + this.getExcludedEmailAddressesList().hashCode();
            }
            if (this.getPermittedUrisCount() > 0) {
                hash = 37 * hash + 8;
                hash = 53 * hash + this.getPermittedUrisList().hashCode();
            }
            if (this.getExcludedUrisCount() > 0) {
                hash = 37 * hash + 9;
                hash = 53 * hash + this.getExcludedUrisList().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static NameConstraints parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (NameConstraints)PARSER.parseFrom(data);
        }

        public static NameConstraints parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (NameConstraints)PARSER.parseFrom(data, extensionRegistry);
        }

        public static NameConstraints parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (NameConstraints)PARSER.parseFrom(data);
        }

        public static NameConstraints parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (NameConstraints)PARSER.parseFrom(data, extensionRegistry);
        }

        public static NameConstraints parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (NameConstraints)PARSER.parseFrom(data);
        }

        public static NameConstraints parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (NameConstraints)PARSER.parseFrom(data, extensionRegistry);
        }

        public static NameConstraints parseFrom(InputStream input) throws IOException {
            return (NameConstraints)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static NameConstraints parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (NameConstraints)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static NameConstraints parseDelimitedFrom(InputStream input) throws IOException {
            return (NameConstraints)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static NameConstraints parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (NameConstraints)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static NameConstraints parseFrom(CodedInputStream input) throws IOException {
            return (NameConstraints)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static NameConstraints parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (NameConstraints)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return NameConstraints.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(NameConstraints prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static NameConstraints getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<NameConstraints> parser() {
            return PARSER;
        }

        public Parser<NameConstraints> getParserForType() {
            return PARSER;
        }

        public NameConstraints getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements NameConstraintsOrBuilder {
            private int bitField0_;
            private boolean critical_;
            private LazyStringArrayList permittedDnsNames_ = LazyStringArrayList.emptyList();
            private LazyStringArrayList excludedDnsNames_ = LazyStringArrayList.emptyList();
            private LazyStringArrayList permittedIpRanges_ = LazyStringArrayList.emptyList();
            private LazyStringArrayList excludedIpRanges_ = LazyStringArrayList.emptyList();
            private LazyStringArrayList permittedEmailAddresses_ = LazyStringArrayList.emptyList();
            private LazyStringArrayList excludedEmailAddresses_ = LazyStringArrayList.emptyList();
            private LazyStringArrayList permittedUris_ = LazyStringArrayList.emptyList();
            private LazyStringArrayList excludedUris_ = LazyStringArrayList.emptyList();

            public static final Descriptors.Descriptor getDescriptor() {
                return PrivateCaResourcesProto.internal_static_google_cloud_security_privateca_v1_X509Parameters_NameConstraints_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return PrivateCaResourcesProto.internal_static_google_cloud_security_privateca_v1_X509Parameters_NameConstraints_fieldAccessorTable.ensureFieldAccessorsInitialized(NameConstraints.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.critical_ = false;
                this.permittedDnsNames_ = LazyStringArrayList.emptyList();
                this.excludedDnsNames_ = LazyStringArrayList.emptyList();
                this.permittedIpRanges_ = LazyStringArrayList.emptyList();
                this.excludedIpRanges_ = LazyStringArrayList.emptyList();
                this.permittedEmailAddresses_ = LazyStringArrayList.emptyList();
                this.excludedEmailAddresses_ = LazyStringArrayList.emptyList();
                this.permittedUris_ = LazyStringArrayList.emptyList();
                this.excludedUris_ = LazyStringArrayList.emptyList();
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return PrivateCaResourcesProto.internal_static_google_cloud_security_privateca_v1_X509Parameters_NameConstraints_descriptor;
            }

            public NameConstraints getDefaultInstanceForType() {
                return NameConstraints.getDefaultInstance();
            }

            public NameConstraints build() {
                NameConstraints result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public NameConstraints buildPartial() {
                NameConstraints result = new NameConstraints(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(NameConstraints result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.critical_ = this.critical_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    this.permittedDnsNames_.makeImmutable();
                    result.permittedDnsNames_ = this.permittedDnsNames_;
                }
                if ((from_bitField0_ & 4) != 0) {
                    this.excludedDnsNames_.makeImmutable();
                    result.excludedDnsNames_ = this.excludedDnsNames_;
                }
                if ((from_bitField0_ & 8) != 0) {
                    this.permittedIpRanges_.makeImmutable();
                    result.permittedIpRanges_ = this.permittedIpRanges_;
                }
                if ((from_bitField0_ & 0x10) != 0) {
                    this.excludedIpRanges_.makeImmutable();
                    result.excludedIpRanges_ = this.excludedIpRanges_;
                }
                if ((from_bitField0_ & 0x20) != 0) {
                    this.permittedEmailAddresses_.makeImmutable();
                    result.permittedEmailAddresses_ = this.permittedEmailAddresses_;
                }
                if ((from_bitField0_ & 0x40) != 0) {
                    this.excludedEmailAddresses_.makeImmutable();
                    result.excludedEmailAddresses_ = this.excludedEmailAddresses_;
                }
                if ((from_bitField0_ & 0x80) != 0) {
                    this.permittedUris_.makeImmutable();
                    result.permittedUris_ = this.permittedUris_;
                }
                if ((from_bitField0_ & 0x100) != 0) {
                    this.excludedUris_.makeImmutable();
                    result.excludedUris_ = this.excludedUris_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof NameConstraints) {
                    return this.mergeFrom((NameConstraints)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(NameConstraints other) {
                if (other == NameConstraints.getDefaultInstance()) {
                    return this;
                }
                if (other.getCritical()) {
                    this.setCritical(other.getCritical());
                }
                if (!other.permittedDnsNames_.isEmpty()) {
                    if (this.permittedDnsNames_.isEmpty()) {
                        this.permittedDnsNames_ = other.permittedDnsNames_;
                        this.bitField0_ |= 2;
                    } else {
                        this.ensurePermittedDnsNamesIsMutable();
                        this.permittedDnsNames_.addAll((Collection)other.permittedDnsNames_);
                    }
                    this.onChanged();
                }
                if (!other.excludedDnsNames_.isEmpty()) {
                    if (this.excludedDnsNames_.isEmpty()) {
                        this.excludedDnsNames_ = other.excludedDnsNames_;
                        this.bitField0_ |= 4;
                    } else {
                        this.ensureExcludedDnsNamesIsMutable();
                        this.excludedDnsNames_.addAll((Collection)other.excludedDnsNames_);
                    }
                    this.onChanged();
                }
                if (!other.permittedIpRanges_.isEmpty()) {
                    if (this.permittedIpRanges_.isEmpty()) {
                        this.permittedIpRanges_ = other.permittedIpRanges_;
                        this.bitField0_ |= 8;
                    } else {
                        this.ensurePermittedIpRangesIsMutable();
                        this.permittedIpRanges_.addAll((Collection)other.permittedIpRanges_);
                    }
                    this.onChanged();
                }
                if (!other.excludedIpRanges_.isEmpty()) {
                    if (this.excludedIpRanges_.isEmpty()) {
                        this.excludedIpRanges_ = other.excludedIpRanges_;
                        this.bitField0_ |= 0x10;
                    } else {
                        this.ensureExcludedIpRangesIsMutable();
                        this.excludedIpRanges_.addAll((Collection)other.excludedIpRanges_);
                    }
                    this.onChanged();
                }
                if (!other.permittedEmailAddresses_.isEmpty()) {
                    if (this.permittedEmailAddresses_.isEmpty()) {
                        this.permittedEmailAddresses_ = other.permittedEmailAddresses_;
                        this.bitField0_ |= 0x20;
                    } else {
                        this.ensurePermittedEmailAddressesIsMutable();
                        this.permittedEmailAddresses_.addAll((Collection)other.permittedEmailAddresses_);
                    }
                    this.onChanged();
                }
                if (!other.excludedEmailAddresses_.isEmpty()) {
                    if (this.excludedEmailAddresses_.isEmpty()) {
                        this.excludedEmailAddresses_ = other.excludedEmailAddresses_;
                        this.bitField0_ |= 0x40;
                    } else {
                        this.ensureExcludedEmailAddressesIsMutable();
                        this.excludedEmailAddresses_.addAll((Collection)other.excludedEmailAddresses_);
                    }
                    this.onChanged();
                }
                if (!other.permittedUris_.isEmpty()) {
                    if (this.permittedUris_.isEmpty()) {
                        this.permittedUris_ = other.permittedUris_;
                        this.bitField0_ |= 0x80;
                    } else {
                        this.ensurePermittedUrisIsMutable();
                        this.permittedUris_.addAll((Collection)other.permittedUris_);
                    }
                    this.onChanged();
                }
                if (!other.excludedUris_.isEmpty()) {
                    if (this.excludedUris_.isEmpty()) {
                        this.excludedUris_ = other.excludedUris_;
                        this.bitField0_ |= 0x100;
                    } else {
                        this.ensureExcludedUrisIsMutable();
                        this.excludedUris_.addAll((Collection)other.excludedUris_);
                    }
                    this.onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block17: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block17;
                            }
                            case 8: {
                                this.critical_ = input.readBool();
                                this.bitField0_ |= 1;
                                continue block17;
                            }
                            case 18: {
                                String s = input.readStringRequireUtf8();
                                this.ensurePermittedDnsNamesIsMutable();
                                this.permittedDnsNames_.add((Object)s);
                                continue block17;
                            }
                            case 26: {
                                String s = input.readStringRequireUtf8();
                                this.ensureExcludedDnsNamesIsMutable();
                                this.excludedDnsNames_.add((Object)s);
                                continue block17;
                            }
                            case 34: {
                                String s = input.readStringRequireUtf8();
                                this.ensurePermittedIpRangesIsMutable();
                                this.permittedIpRanges_.add((Object)s);
                                continue block17;
                            }
                            case 42: {
                                String s = input.readStringRequireUtf8();
                                this.ensureExcludedIpRangesIsMutable();
                                this.excludedIpRanges_.add((Object)s);
                                continue block17;
                            }
                            case 50: {
                                String s = input.readStringRequireUtf8();
                                this.ensurePermittedEmailAddressesIsMutable();
                                this.permittedEmailAddresses_.add((Object)s);
                                continue block17;
                            }
                            case 58: {
                                String s = input.readStringRequireUtf8();
                                this.ensureExcludedEmailAddressesIsMutable();
                                this.excludedEmailAddresses_.add((Object)s);
                                continue block17;
                            }
                            case 66: {
                                String s = input.readStringRequireUtf8();
                                this.ensurePermittedUrisIsMutable();
                                this.permittedUris_.add((Object)s);
                                continue block17;
                            }
                            case 74: {
                                String s = input.readStringRequireUtf8();
                                this.ensureExcludedUrisIsMutable();
                                this.excludedUris_.add((Object)s);
                                continue block17;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean getCritical() {
                return this.critical_;
            }

            public Builder setCritical(boolean value) {
                this.critical_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearCritical() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.critical_ = false;
                this.onChanged();
                return this;
            }

            private void ensurePermittedDnsNamesIsMutable() {
                if (!this.permittedDnsNames_.isModifiable()) {
                    this.permittedDnsNames_ = new LazyStringArrayList((LazyStringList)this.permittedDnsNames_);
                }
                this.bitField0_ |= 2;
            }

            public ProtocolStringList getPermittedDnsNamesList() {
                this.permittedDnsNames_.makeImmutable();
                return this.permittedDnsNames_;
            }

            @Override
            public int getPermittedDnsNamesCount() {
                return this.permittedDnsNames_.size();
            }

            @Override
            public String getPermittedDnsNames(int index) {
                return this.permittedDnsNames_.get(index);
            }

            @Override
            public ByteString getPermittedDnsNamesBytes(int index) {
                return this.permittedDnsNames_.getByteString(index);
            }

            public Builder setPermittedDnsNames(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePermittedDnsNamesIsMutable();
                this.permittedDnsNames_.set(index, value);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder addPermittedDnsNames(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePermittedDnsNamesIsMutable();
                this.permittedDnsNames_.add((Object)value);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder addAllPermittedDnsNames(Iterable<String> values) {
                this.ensurePermittedDnsNamesIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.permittedDnsNames_);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearPermittedDnsNames() {
                this.permittedDnsNames_ = LazyStringArrayList.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
                return this;
            }

            public Builder addPermittedDnsNamesBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                NameConstraints.checkByteStringIsUtf8((ByteString)value);
                this.ensurePermittedDnsNamesIsMutable();
                this.permittedDnsNames_.add(value);
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            private void ensureExcludedDnsNamesIsMutable() {
                if (!this.excludedDnsNames_.isModifiable()) {
                    this.excludedDnsNames_ = new LazyStringArrayList((LazyStringList)this.excludedDnsNames_);
                }
                this.bitField0_ |= 4;
            }

            public ProtocolStringList getExcludedDnsNamesList() {
                this.excludedDnsNames_.makeImmutable();
                return this.excludedDnsNames_;
            }

            @Override
            public int getExcludedDnsNamesCount() {
                return this.excludedDnsNames_.size();
            }

            @Override
            public String getExcludedDnsNames(int index) {
                return this.excludedDnsNames_.get(index);
            }

            @Override
            public ByteString getExcludedDnsNamesBytes(int index) {
                return this.excludedDnsNames_.getByteString(index);
            }

            public Builder setExcludedDnsNames(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureExcludedDnsNamesIsMutable();
                this.excludedDnsNames_.set(index, value);
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder addExcludedDnsNames(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureExcludedDnsNamesIsMutable();
                this.excludedDnsNames_.add((Object)value);
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder addAllExcludedDnsNames(Iterable<String> values) {
                this.ensureExcludedDnsNamesIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.excludedDnsNames_);
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder clearExcludedDnsNames() {
                this.excludedDnsNames_ = LazyStringArrayList.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
                return this;
            }

            public Builder addExcludedDnsNamesBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                NameConstraints.checkByteStringIsUtf8((ByteString)value);
                this.ensureExcludedDnsNamesIsMutable();
                this.excludedDnsNames_.add(value);
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            private void ensurePermittedIpRangesIsMutable() {
                if (!this.permittedIpRanges_.isModifiable()) {
                    this.permittedIpRanges_ = new LazyStringArrayList((LazyStringList)this.permittedIpRanges_);
                }
                this.bitField0_ |= 8;
            }

            public ProtocolStringList getPermittedIpRangesList() {
                this.permittedIpRanges_.makeImmutable();
                return this.permittedIpRanges_;
            }

            @Override
            public int getPermittedIpRangesCount() {
                return this.permittedIpRanges_.size();
            }

            @Override
            public String getPermittedIpRanges(int index) {
                return this.permittedIpRanges_.get(index);
            }

            @Override
            public ByteString getPermittedIpRangesBytes(int index) {
                return this.permittedIpRanges_.getByteString(index);
            }

            public Builder setPermittedIpRanges(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePermittedIpRangesIsMutable();
                this.permittedIpRanges_.set(index, value);
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder addPermittedIpRanges(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePermittedIpRangesIsMutable();
                this.permittedIpRanges_.add((Object)value);
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder addAllPermittedIpRanges(Iterable<String> values) {
                this.ensurePermittedIpRangesIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.permittedIpRanges_);
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder clearPermittedIpRanges() {
                this.permittedIpRanges_ = LazyStringArrayList.emptyList();
                this.bitField0_ &= 0xFFFFFFF7;
                this.onChanged();
                return this;
            }

            public Builder addPermittedIpRangesBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                NameConstraints.checkByteStringIsUtf8((ByteString)value);
                this.ensurePermittedIpRangesIsMutable();
                this.permittedIpRanges_.add(value);
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            private void ensureExcludedIpRangesIsMutable() {
                if (!this.excludedIpRanges_.isModifiable()) {
                    this.excludedIpRanges_ = new LazyStringArrayList((LazyStringList)this.excludedIpRanges_);
                }
                this.bitField0_ |= 0x10;
            }

            public ProtocolStringList getExcludedIpRangesList() {
                this.excludedIpRanges_.makeImmutable();
                return this.excludedIpRanges_;
            }

            @Override
            public int getExcludedIpRangesCount() {
                return this.excludedIpRanges_.size();
            }

            @Override
            public String getExcludedIpRanges(int index) {
                return this.excludedIpRanges_.get(index);
            }

            @Override
            public ByteString getExcludedIpRangesBytes(int index) {
                return this.excludedIpRanges_.getByteString(index);
            }

            public Builder setExcludedIpRanges(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureExcludedIpRangesIsMutable();
                this.excludedIpRanges_.set(index, value);
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder addExcludedIpRanges(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureExcludedIpRangesIsMutable();
                this.excludedIpRanges_.add((Object)value);
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder addAllExcludedIpRanges(Iterable<String> values) {
                this.ensureExcludedIpRangesIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.excludedIpRanges_);
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder clearExcludedIpRanges() {
                this.excludedIpRanges_ = LazyStringArrayList.emptyList();
                this.bitField0_ &= 0xFFFFFFEF;
                this.onChanged();
                return this;
            }

            public Builder addExcludedIpRangesBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                NameConstraints.checkByteStringIsUtf8((ByteString)value);
                this.ensureExcludedIpRangesIsMutable();
                this.excludedIpRanges_.add(value);
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            private void ensurePermittedEmailAddressesIsMutable() {
                if (!this.permittedEmailAddresses_.isModifiable()) {
                    this.permittedEmailAddresses_ = new LazyStringArrayList((LazyStringList)this.permittedEmailAddresses_);
                }
                this.bitField0_ |= 0x20;
            }

            public ProtocolStringList getPermittedEmailAddressesList() {
                this.permittedEmailAddresses_.makeImmutable();
                return this.permittedEmailAddresses_;
            }

            @Override
            public int getPermittedEmailAddressesCount() {
                return this.permittedEmailAddresses_.size();
            }

            @Override
            public String getPermittedEmailAddresses(int index) {
                return this.permittedEmailAddresses_.get(index);
            }

            @Override
            public ByteString getPermittedEmailAddressesBytes(int index) {
                return this.permittedEmailAddresses_.getByteString(index);
            }

            public Builder setPermittedEmailAddresses(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePermittedEmailAddressesIsMutable();
                this.permittedEmailAddresses_.set(index, value);
                this.bitField0_ |= 0x20;
                this.onChanged();
                return this;
            }

            public Builder addPermittedEmailAddresses(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePermittedEmailAddressesIsMutable();
                this.permittedEmailAddresses_.add((Object)value);
                this.bitField0_ |= 0x20;
                this.onChanged();
                return this;
            }

            public Builder addAllPermittedEmailAddresses(Iterable<String> values) {
                this.ensurePermittedEmailAddressesIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.permittedEmailAddresses_);
                this.bitField0_ |= 0x20;
                this.onChanged();
                return this;
            }

            public Builder clearPermittedEmailAddresses() {
                this.permittedEmailAddresses_ = LazyStringArrayList.emptyList();
                this.bitField0_ &= 0xFFFFFFDF;
                this.onChanged();
                return this;
            }

            public Builder addPermittedEmailAddressesBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                NameConstraints.checkByteStringIsUtf8((ByteString)value);
                this.ensurePermittedEmailAddressesIsMutable();
                this.permittedEmailAddresses_.add(value);
                this.bitField0_ |= 0x20;
                this.onChanged();
                return this;
            }

            private void ensureExcludedEmailAddressesIsMutable() {
                if (!this.excludedEmailAddresses_.isModifiable()) {
                    this.excludedEmailAddresses_ = new LazyStringArrayList((LazyStringList)this.excludedEmailAddresses_);
                }
                this.bitField0_ |= 0x40;
            }

            public ProtocolStringList getExcludedEmailAddressesList() {
                this.excludedEmailAddresses_.makeImmutable();
                return this.excludedEmailAddresses_;
            }

            @Override
            public int getExcludedEmailAddressesCount() {
                return this.excludedEmailAddresses_.size();
            }

            @Override
            public String getExcludedEmailAddresses(int index) {
                return this.excludedEmailAddresses_.get(index);
            }

            @Override
            public ByteString getExcludedEmailAddressesBytes(int index) {
                return this.excludedEmailAddresses_.getByteString(index);
            }

            public Builder setExcludedEmailAddresses(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureExcludedEmailAddressesIsMutable();
                this.excludedEmailAddresses_.set(index, value);
                this.bitField0_ |= 0x40;
                this.onChanged();
                return this;
            }

            public Builder addExcludedEmailAddresses(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureExcludedEmailAddressesIsMutable();
                this.excludedEmailAddresses_.add((Object)value);
                this.bitField0_ |= 0x40;
                this.onChanged();
                return this;
            }

            public Builder addAllExcludedEmailAddresses(Iterable<String> values) {
                this.ensureExcludedEmailAddressesIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.excludedEmailAddresses_);
                this.bitField0_ |= 0x40;
                this.onChanged();
                return this;
            }

            public Builder clearExcludedEmailAddresses() {
                this.excludedEmailAddresses_ = LazyStringArrayList.emptyList();
                this.bitField0_ &= 0xFFFFFFBF;
                this.onChanged();
                return this;
            }

            public Builder addExcludedEmailAddressesBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                NameConstraints.checkByteStringIsUtf8((ByteString)value);
                this.ensureExcludedEmailAddressesIsMutable();
                this.excludedEmailAddresses_.add(value);
                this.bitField0_ |= 0x40;
                this.onChanged();
                return this;
            }

            private void ensurePermittedUrisIsMutable() {
                if (!this.permittedUris_.isModifiable()) {
                    this.permittedUris_ = new LazyStringArrayList((LazyStringList)this.permittedUris_);
                }
                this.bitField0_ |= 0x80;
            }

            public ProtocolStringList getPermittedUrisList() {
                this.permittedUris_.makeImmutable();
                return this.permittedUris_;
            }

            @Override
            public int getPermittedUrisCount() {
                return this.permittedUris_.size();
            }

            @Override
            public String getPermittedUris(int index) {
                return this.permittedUris_.get(index);
            }

            @Override
            public ByteString getPermittedUrisBytes(int index) {
                return this.permittedUris_.getByteString(index);
            }

            public Builder setPermittedUris(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePermittedUrisIsMutable();
                this.permittedUris_.set(index, value);
                this.bitField0_ |= 0x80;
                this.onChanged();
                return this;
            }

            public Builder addPermittedUris(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePermittedUrisIsMutable();
                this.permittedUris_.add((Object)value);
                this.bitField0_ |= 0x80;
                this.onChanged();
                return this;
            }

            public Builder addAllPermittedUris(Iterable<String> values) {
                this.ensurePermittedUrisIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.permittedUris_);
                this.bitField0_ |= 0x80;
                this.onChanged();
                return this;
            }

            public Builder clearPermittedUris() {
                this.permittedUris_ = LazyStringArrayList.emptyList();
                this.bitField0_ &= 0xFFFFFF7F;
                this.onChanged();
                return this;
            }

            public Builder addPermittedUrisBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                NameConstraints.checkByteStringIsUtf8((ByteString)value);
                this.ensurePermittedUrisIsMutable();
                this.permittedUris_.add(value);
                this.bitField0_ |= 0x80;
                this.onChanged();
                return this;
            }

            private void ensureExcludedUrisIsMutable() {
                if (!this.excludedUris_.isModifiable()) {
                    this.excludedUris_ = new LazyStringArrayList((LazyStringList)this.excludedUris_);
                }
                this.bitField0_ |= 0x100;
            }

            public ProtocolStringList getExcludedUrisList() {
                this.excludedUris_.makeImmutable();
                return this.excludedUris_;
            }

            @Override
            public int getExcludedUrisCount() {
                return this.excludedUris_.size();
            }

            @Override
            public String getExcludedUris(int index) {
                return this.excludedUris_.get(index);
            }

            @Override
            public ByteString getExcludedUrisBytes(int index) {
                return this.excludedUris_.getByteString(index);
            }

            public Builder setExcludedUris(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureExcludedUrisIsMutable();
                this.excludedUris_.set(index, value);
                this.bitField0_ |= 0x100;
                this.onChanged();
                return this;
            }

            public Builder addExcludedUris(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureExcludedUrisIsMutable();
                this.excludedUris_.add((Object)value);
                this.bitField0_ |= 0x100;
                this.onChanged();
                return this;
            }

            public Builder addAllExcludedUris(Iterable<String> values) {
                this.ensureExcludedUrisIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.excludedUris_);
                this.bitField0_ |= 0x100;
                this.onChanged();
                return this;
            }

            public Builder clearExcludedUris() {
                this.excludedUris_ = LazyStringArrayList.emptyList();
                this.bitField0_ &= 0xFFFFFEFF;
                this.onChanged();
                return this;
            }

            public Builder addExcludedUrisBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                NameConstraints.checkByteStringIsUtf8((ByteString)value);
                this.ensureExcludedUrisIsMutable();
                this.excludedUris_.add(value);
                this.bitField0_ |= 0x100;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface NameConstraintsOrBuilder
    extends MessageOrBuilder {
        public boolean getCritical();

        public List<String> getPermittedDnsNamesList();

        public int getPermittedDnsNamesCount();

        public String getPermittedDnsNames(int var1);

        public ByteString getPermittedDnsNamesBytes(int var1);

        public List<String> getExcludedDnsNamesList();

        public int getExcludedDnsNamesCount();

        public String getExcludedDnsNames(int var1);

        public ByteString getExcludedDnsNamesBytes(int var1);

        public List<String> getPermittedIpRangesList();

        public int getPermittedIpRangesCount();

        public String getPermittedIpRanges(int var1);

        public ByteString getPermittedIpRangesBytes(int var1);

        public List<String> getExcludedIpRangesList();

        public int getExcludedIpRangesCount();

        public String getExcludedIpRanges(int var1);

        public ByteString getExcludedIpRangesBytes(int var1);

        public List<String> getPermittedEmailAddressesList();

        public int getPermittedEmailAddressesCount();

        public String getPermittedEmailAddresses(int var1);

        public ByteString getPermittedEmailAddressesBytes(int var1);

        public List<String> getExcludedEmailAddressesList();

        public int getExcludedEmailAddressesCount();

        public String getExcludedEmailAddresses(int var1);

        public ByteString getExcludedEmailAddressesBytes(int var1);

        public List<String> getPermittedUrisList();

        public int getPermittedUrisCount();

        public String getPermittedUris(int var1);

        public ByteString getPermittedUrisBytes(int var1);

        public List<String> getExcludedUrisList();

        public int getExcludedUrisCount();

        public String getExcludedUris(int var1);

        public ByteString getExcludedUrisBytes(int var1);
    }

    public static final class CaOptions
    extends GeneratedMessageV3
    implements CaOptionsOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int IS_CA_FIELD_NUMBER = 1;
        private boolean isCa_ = false;
        public static final int MAX_ISSUER_PATH_LENGTH_FIELD_NUMBER = 2;
        private int maxIssuerPathLength_ = 0;
        private byte memoizedIsInitialized = (byte)-1;
        private static final CaOptions DEFAULT_INSTANCE = new CaOptions();
        private static final Parser<CaOptions> PARSER = new AbstractParser<CaOptions>(){

            public CaOptions parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = CaOptions.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private CaOptions(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private CaOptions() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new CaOptions();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return PrivateCaResourcesProto.internal_static_google_cloud_security_privateca_v1_X509Parameters_CaOptions_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return PrivateCaResourcesProto.internal_static_google_cloud_security_privateca_v1_X509Parameters_CaOptions_fieldAccessorTable.ensureFieldAccessorsInitialized(CaOptions.class, Builder.class);
        }

        @Override
        public boolean hasIsCa() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public boolean getIsCa() {
            return this.isCa_;
        }

        @Override
        public boolean hasMaxIssuerPathLength() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public int getMaxIssuerPathLength() {
            return this.maxIssuerPathLength_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                output.writeBool(1, this.isCa_);
            }
            if ((this.bitField0_ & 2) != 0) {
                output.writeInt32(2, this.maxIssuerPathLength_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeBoolSize((int)1, (boolean)this.isCa_);
            }
            if ((this.bitField0_ & 2) != 0) {
                size += CodedOutputStream.computeInt32Size((int)2, (int)this.maxIssuerPathLength_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CaOptions)) {
                return super.equals(obj);
            }
            CaOptions other = (CaOptions)obj;
            if (this.hasIsCa() != other.hasIsCa()) {
                return false;
            }
            if (this.hasIsCa() && this.getIsCa() != other.getIsCa()) {
                return false;
            }
            if (this.hasMaxIssuerPathLength() != other.hasMaxIssuerPathLength()) {
                return false;
            }
            if (this.hasMaxIssuerPathLength() && this.getMaxIssuerPathLength() != other.getMaxIssuerPathLength()) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + CaOptions.getDescriptor().hashCode();
            if (this.hasIsCa()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + Internal.hashBoolean((boolean)this.getIsCa());
            }
            if (this.hasMaxIssuerPathLength()) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getMaxIssuerPathLength();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static CaOptions parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (CaOptions)PARSER.parseFrom(data);
        }

        public static CaOptions parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (CaOptions)PARSER.parseFrom(data, extensionRegistry);
        }

        public static CaOptions parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (CaOptions)PARSER.parseFrom(data);
        }

        public static CaOptions parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (CaOptions)PARSER.parseFrom(data, extensionRegistry);
        }

        public static CaOptions parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (CaOptions)PARSER.parseFrom(data);
        }

        public static CaOptions parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (CaOptions)PARSER.parseFrom(data, extensionRegistry);
        }

        public static CaOptions parseFrom(InputStream input) throws IOException {
            return (CaOptions)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static CaOptions parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (CaOptions)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static CaOptions parseDelimitedFrom(InputStream input) throws IOException {
            return (CaOptions)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static CaOptions parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (CaOptions)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static CaOptions parseFrom(CodedInputStream input) throws IOException {
            return (CaOptions)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static CaOptions parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (CaOptions)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return CaOptions.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(CaOptions prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static CaOptions getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<CaOptions> parser() {
            return PARSER;
        }

        public Parser<CaOptions> getParserForType() {
            return PARSER;
        }

        public CaOptions getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements CaOptionsOrBuilder {
            private int bitField0_;
            private boolean isCa_;
            private int maxIssuerPathLength_;

            public static final Descriptors.Descriptor getDescriptor() {
                return PrivateCaResourcesProto.internal_static_google_cloud_security_privateca_v1_X509Parameters_CaOptions_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return PrivateCaResourcesProto.internal_static_google_cloud_security_privateca_v1_X509Parameters_CaOptions_fieldAccessorTable.ensureFieldAccessorsInitialized(CaOptions.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.isCa_ = false;
                this.maxIssuerPathLength_ = 0;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return PrivateCaResourcesProto.internal_static_google_cloud_security_privateca_v1_X509Parameters_CaOptions_descriptor;
            }

            public CaOptions getDefaultInstanceForType() {
                return CaOptions.getDefaultInstance();
            }

            public CaOptions build() {
                CaOptions result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public CaOptions buildPartial() {
                CaOptions result = new CaOptions(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(CaOptions result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.isCa_ = this.isCa_;
                    to_bitField0_ |= 1;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.maxIssuerPathLength_ = this.maxIssuerPathLength_;
                    to_bitField0_ |= 2;
                }
                CaOptions caOptions = result;
                caOptions.bitField0_ = caOptions.bitField0_ | to_bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof CaOptions) {
                    return this.mergeFrom((CaOptions)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(CaOptions other) {
                if (other == CaOptions.getDefaultInstance()) {
                    return this;
                }
                if (other.hasIsCa()) {
                    this.setIsCa(other.getIsCa());
                }
                if (other.hasMaxIssuerPathLength()) {
                    this.setMaxIssuerPathLength(other.getMaxIssuerPathLength());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 8: {
                                this.isCa_ = input.readBool();
                                this.bitField0_ |= 1;
                                continue block10;
                            }
                            case 16: {
                                this.maxIssuerPathLength_ = input.readInt32();
                                this.bitField0_ |= 2;
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasIsCa() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public boolean getIsCa() {
                return this.isCa_;
            }

            public Builder setIsCa(boolean value) {
                this.isCa_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearIsCa() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.isCa_ = false;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasMaxIssuerPathLength() {
                return (this.bitField0_ & 2) != 0;
            }

            @Override
            public int getMaxIssuerPathLength() {
                return this.maxIssuerPathLength_;
            }

            public Builder setMaxIssuerPathLength(int value) {
                this.maxIssuerPathLength_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearMaxIssuerPathLength() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.maxIssuerPathLength_ = 0;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface CaOptionsOrBuilder
    extends MessageOrBuilder {
        public boolean hasIsCa();

        public boolean getIsCa();

        public boolean hasMaxIssuerPathLength();

        public int getMaxIssuerPathLength();
    }
}

