/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securesourcemanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class IssueName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPOSITORY_ISSUE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/repositories/{repository}/issues/{issue}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String repository;
    private final String issue;

    @Deprecated
    protected IssueName() {
        this.project = null;
        this.location = null;
        this.repository = null;
        this.issue = null;
    }

    private IssueName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.repository = (String)Preconditions.checkNotNull((Object)builder.getRepository());
        this.issue = (String)Preconditions.checkNotNull((Object)builder.getIssue());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getIssue() {
        return this.issue;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static IssueName of(String project, String location, String repository, String issue) {
        return IssueName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setIssue(issue).build();
    }

    public static String format(String project, String location, String repository, String issue) {
        return IssueName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setIssue(issue).build().toString();
    }

    public static IssueName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPOSITORY_ISSUE.validatedMatch(formattedString, "IssueName.parse: formattedString not in valid format");
        return IssueName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("repository"), (String)matchMap.get("issue"));
    }

    public static List<IssueName> parseList(List<String> formattedStrings) {
        ArrayList<IssueName> list = new ArrayList<IssueName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(IssueName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<IssueName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (IssueName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPOSITORY_ISSUE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            IssueName issueName = this;
            synchronized (issueName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.repository != null) {
                        fieldMapBuilder.put((Object)"repository", (Object)this.repository);
                    }
                    if (this.issue != null) {
                        fieldMapBuilder.put((Object)"issue", (Object)this.issue);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPOSITORY_ISSUE.instantiate(new String[]{"project", this.project, "location", this.location, "repository", this.repository, "issue", this.issue});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            IssueName that = (IssueName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.repository, that.repository) && Objects.equals(this.issue, that.issue);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.repository);
        h *= 1000003;
        return h ^= Objects.hashCode(this.issue);
    }

    public static class Builder {
        private String project;
        private String location;
        private String repository;
        private String issue;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getIssue() {
            return this.issue;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRepository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder setIssue(String issue) {
            this.issue = issue;
            return this;
        }

        private Builder(IssueName issueName) {
            this.project = issueName.project;
            this.location = issueName.location;
            this.repository = issueName.repository;
            this.issue = issueName.issue;
        }

        public IssueName build() {
            return new IssueName(this);
        }
    }
}

