/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/vendor_settings.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.run.v2;

/**
 *
 *
 * <pre>
 * Describes the Build step of the function that builds a container from the
 * given source.
 * </pre>
 *
 * Protobuf type {@code google.cloud.run.v2.BuildConfig}
 */
public final class BuildConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.run.v2.BuildConfig)
    BuildConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use BuildConfig.newBuilder() to construct.
  private BuildConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BuildConfig() {
    name_ = "";
    sourceLocation_ = "";
    functionTarget_ = "";
    imageUri_ = "";
    baseImage_ = "";
    workerPool_ = "";
    serviceAccount_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BuildConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.run.v2.VendorSettingsProto
        .internal_static_google_cloud_run_v2_BuildConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 8:
        return internalGetEnvironmentVariables();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.run.v2.VendorSettingsProto
        .internal_static_google_cloud_run_v2_BuildConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.run.v2.BuildConfig.class,
            com.google.cloud.run.v2.BuildConfig.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The Cloud Build name of the latest successful deployment of
   * the function.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The Cloud Build name of the latest successful deployment of
   * the function.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_LOCATION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceLocation_ = "";

  /**
   *
   *
   * <pre>
   * The Cloud Storage bucket URI where the function source code is located.
   * </pre>
   *
   * <code>string source_location = 2;</code>
   *
   * @return The sourceLocation.
   */
  @java.lang.Override
  public java.lang.String getSourceLocation() {
    java.lang.Object ref = sourceLocation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceLocation_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The Cloud Storage bucket URI where the function source code is located.
   * </pre>
   *
   * <code>string source_location = 2;</code>
   *
   * @return The bytes for sourceLocation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceLocationBytes() {
    java.lang.Object ref = sourceLocation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceLocation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FUNCTION_TARGET_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object functionTarget_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The name of the function (as defined in source code) that will be
   * executed. Defaults to the resource name suffix, if not specified. For
   * backward compatibility, if function with given name is not found, then the
   * system will try to use function named "function".
   * </pre>
   *
   * <code>string function_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The functionTarget.
   */
  @java.lang.Override
  public java.lang.String getFunctionTarget() {
    java.lang.Object ref = functionTarget_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      functionTarget_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The name of the function (as defined in source code) that will be
   * executed. Defaults to the resource name suffix, if not specified. For
   * backward compatibility, if function with given name is not found, then the
   * system will try to use function named "function".
   * </pre>
   *
   * <code>string function_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for functionTarget.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFunctionTargetBytes() {
    java.lang.Object ref = functionTarget_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      functionTarget_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IMAGE_URI_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object imageUri_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Artifact Registry URI to store the built image.
   * </pre>
   *
   * <code>string image_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The imageUri.
   */
  @java.lang.Override
  public java.lang.String getImageUri() {
    java.lang.Object ref = imageUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      imageUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Artifact Registry URI to store the built image.
   * </pre>
   *
   * <code>string image_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for imageUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImageUriBytes() {
    java.lang.Object ref = imageUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      imageUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BASE_IMAGE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object baseImage_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The base image used to build the function.
   * </pre>
   *
   * <code>string base_image = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The baseImage.
   */
  @java.lang.Override
  public java.lang.String getBaseImage() {
    java.lang.Object ref = baseImage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      baseImage_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The base image used to build the function.
   * </pre>
   *
   * <code>string base_image = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for baseImage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBaseImageBytes() {
    java.lang.Object ref = baseImage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      baseImage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_AUTOMATIC_UPDATES_FIELD_NUMBER = 6;
  private boolean enableAutomaticUpdates_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Sets whether the function will receive automatic base image
   * updates.
   * </pre>
   *
   * <code>bool enable_automatic_updates = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableAutomaticUpdates.
   */
  @java.lang.Override
  public boolean getEnableAutomaticUpdates() {
    return enableAutomaticUpdates_;
  }

  public static final int WORKER_POOL_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object workerPool_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Name of the Cloud Build Custom Worker Pool that should be used to
   * build the Cloud Run function. The format of this field is
   * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
   * `{project}` and `{region}` are the project id and region respectively where
   * the worker pool is defined and `{workerPool}` is the short name of the
   * worker pool.
   * </pre>
   *
   * <code>
   * string worker_pool = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The workerPool.
   */
  @java.lang.Override
  public java.lang.String getWorkerPool() {
    java.lang.Object ref = workerPool_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      workerPool_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Name of the Cloud Build Custom Worker Pool that should be used to
   * build the Cloud Run function. The format of this field is
   * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
   * `{project}` and `{region}` are the project id and region respectively where
   * the worker pool is defined and `{workerPool}` is the short name of the
   * worker pool.
   * </pre>
   *
   * <code>
   * string worker_pool = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for workerPool.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWorkerPoolBytes() {
    java.lang.Object ref = workerPool_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      workerPool_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENVIRONMENT_VARIABLES_FIELD_NUMBER = 8;

  private static final class EnvironmentVariablesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.run.v2.VendorSettingsProto
                .internal_static_google_cloud_run_v2_BuildConfig_EnvironmentVariablesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> environmentVariables_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetEnvironmentVariables() {
    if (environmentVariables_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          EnvironmentVariablesDefaultEntryHolder.defaultEntry);
    }
    return environmentVariables_;
  }

  public int getEnvironmentVariablesCount() {
    return internalGetEnvironmentVariables().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. User-provided build-time environment variables for the function
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; environment_variables = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsEnvironmentVariables(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetEnvironmentVariables().getMap().containsKey(key);
  }

  /** Use {@link #getEnvironmentVariablesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariables() {
    return getEnvironmentVariablesMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. User-provided build-time environment variables for the function
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; environment_variables = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariablesMap() {
    return internalGetEnvironmentVariables().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. User-provided build-time environment variables for the function
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; environment_variables = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getEnvironmentVariablesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetEnvironmentVariables().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. User-provided build-time environment variables for the function
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; environment_variables = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getEnvironmentVariablesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetEnvironmentVariables().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Service account to be used for building the container. The format
   * of this field is
   * `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
   * </pre>
   *
   * <code>string service_account = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Service account to be used for building the container. The format
   * of this field is
   * `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
   * </pre>
   *
   * <code>string service_account = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceLocation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sourceLocation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(functionTarget_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, functionTarget_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, imageUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(baseImage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, baseImage_);
    }
    if (enableAutomaticUpdates_ != false) {
      output.writeBool(6, enableAutomaticUpdates_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workerPool_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, workerPool_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetEnvironmentVariables(),
        EnvironmentVariablesDefaultEntryHolder.defaultEntry,
        8);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, serviceAccount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceLocation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, sourceLocation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(functionTarget_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, functionTarget_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, imageUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(baseImage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, baseImage_);
    }
    if (enableAutomaticUpdates_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, enableAutomaticUpdates_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workerPool_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, workerPool_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetEnvironmentVariables().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> environmentVariables__ =
          EnvironmentVariablesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, environmentVariables__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, serviceAccount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.run.v2.BuildConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.run.v2.BuildConfig other = (com.google.cloud.run.v2.BuildConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getSourceLocation().equals(other.getSourceLocation())) return false;
    if (!getFunctionTarget().equals(other.getFunctionTarget())) return false;
    if (!getImageUri().equals(other.getImageUri())) return false;
    if (!getBaseImage().equals(other.getBaseImage())) return false;
    if (getEnableAutomaticUpdates() != other.getEnableAutomaticUpdates()) return false;
    if (!getWorkerPool().equals(other.getWorkerPool())) return false;
    if (!internalGetEnvironmentVariables().equals(other.internalGetEnvironmentVariables()))
      return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + SOURCE_LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getSourceLocation().hashCode();
    hash = (37 * hash) + FUNCTION_TARGET_FIELD_NUMBER;
    hash = (53 * hash) + getFunctionTarget().hashCode();
    hash = (37 * hash) + IMAGE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getImageUri().hashCode();
    hash = (37 * hash) + BASE_IMAGE_FIELD_NUMBER;
    hash = (53 * hash) + getBaseImage().hashCode();
    hash = (37 * hash) + ENABLE_AUTOMATIC_UPDATES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableAutomaticUpdates());
    hash = (37 * hash) + WORKER_POOL_FIELD_NUMBER;
    hash = (53 * hash) + getWorkerPool().hashCode();
    if (!internalGetEnvironmentVariables().getMap().isEmpty()) {
      hash = (37 * hash) + ENVIRONMENT_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetEnvironmentVariables().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.run.v2.BuildConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.BuildConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.BuildConfig parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.BuildConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.BuildConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.BuildConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.BuildConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.BuildConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.BuildConfig parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.BuildConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.BuildConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.BuildConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.run.v2.BuildConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Describes the Build step of the function that builds a container from the
   * given source.
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.BuildConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.BuildConfig)
      com.google.cloud.run.v2.BuildConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.VendorSettingsProto
          .internal_static_google_cloud_run_v2_BuildConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 8:
          return internalGetEnvironmentVariables();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 8:
          return internalGetMutableEnvironmentVariables();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.VendorSettingsProto
          .internal_static_google_cloud_run_v2_BuildConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.BuildConfig.class,
              com.google.cloud.run.v2.BuildConfig.Builder.class);
    }

    // Construct using com.google.cloud.run.v2.BuildConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      sourceLocation_ = "";
      functionTarget_ = "";
      imageUri_ = "";
      baseImage_ = "";
      enableAutomaticUpdates_ = false;
      workerPool_ = "";
      internalGetMutableEnvironmentVariables().clear();
      serviceAccount_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.run.v2.VendorSettingsProto
          .internal_static_google_cloud_run_v2_BuildConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.BuildConfig getDefaultInstanceForType() {
      return com.google.cloud.run.v2.BuildConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.run.v2.BuildConfig build() {
      com.google.cloud.run.v2.BuildConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.BuildConfig buildPartial() {
      com.google.cloud.run.v2.BuildConfig result = new com.google.cloud.run.v2.BuildConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.run.v2.BuildConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.sourceLocation_ = sourceLocation_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.functionTarget_ = functionTarget_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.imageUri_ = imageUri_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.baseImage_ = baseImage_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.enableAutomaticUpdates_ = enableAutomaticUpdates_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.workerPool_ = workerPool_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.environmentVariables_ = internalGetEnvironmentVariables();
        result.environmentVariables_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.run.v2.BuildConfig) {
        return mergeFrom((com.google.cloud.run.v2.BuildConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.run.v2.BuildConfig other) {
      if (other == com.google.cloud.run.v2.BuildConfig.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getSourceLocation().isEmpty()) {
        sourceLocation_ = other.sourceLocation_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getFunctionTarget().isEmpty()) {
        functionTarget_ = other.functionTarget_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getImageUri().isEmpty()) {
        imageUri_ = other.imageUri_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getBaseImage().isEmpty()) {
        baseImage_ = other.baseImage_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getEnableAutomaticUpdates() != false) {
        setEnableAutomaticUpdates(other.getEnableAutomaticUpdates());
      }
      if (!other.getWorkerPool().isEmpty()) {
        workerPool_ = other.workerPool_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      internalGetMutableEnvironmentVariables().mergeFrom(other.internalGetEnvironmentVariables());
      bitField0_ |= 0x00000080;
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                sourceLocation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                functionTarget_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                imageUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                baseImage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                enableAutomaticUpdates_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                workerPool_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    environmentVariables__ =
                        input.readMessage(
                            EnvironmentVariablesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableEnvironmentVariables()
                    .getMutableMap()
                    .put(environmentVariables__.getKey(), environmentVariables__.getValue());
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build name of the latest successful deployment of
     * the function.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build name of the latest successful deployment of
     * the function.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build name of the latest successful deployment of
     * the function.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build name of the latest successful deployment of
     * the function.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The Cloud Build name of the latest successful deployment of
     * the function.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object sourceLocation_ = "";

    /**
     *
     *
     * <pre>
     * The Cloud Storage bucket URI where the function source code is located.
     * </pre>
     *
     * <code>string source_location = 2;</code>
     *
     * @return The sourceLocation.
     */
    public java.lang.String getSourceLocation() {
      java.lang.Object ref = sourceLocation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceLocation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage bucket URI where the function source code is located.
     * </pre>
     *
     * <code>string source_location = 2;</code>
     *
     * @return The bytes for sourceLocation.
     */
    public com.google.protobuf.ByteString getSourceLocationBytes() {
      java.lang.Object ref = sourceLocation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceLocation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage bucket URI where the function source code is located.
     * </pre>
     *
     * <code>string source_location = 2;</code>
     *
     * @param value The sourceLocation to set.
     * @return This builder for chaining.
     */
    public Builder setSourceLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceLocation_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage bucket URI where the function source code is located.
     * </pre>
     *
     * <code>string source_location = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceLocation() {
      sourceLocation_ = getDefaultInstance().getSourceLocation();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Cloud Storage bucket URI where the function source code is located.
     * </pre>
     *
     * <code>string source_location = 2;</code>
     *
     * @param value The bytes for sourceLocation to set.
     * @return This builder for chaining.
     */
    public Builder setSourceLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceLocation_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object functionTarget_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     * </pre>
     *
     * <code>string function_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The functionTarget.
     */
    public java.lang.String getFunctionTarget() {
      java.lang.Object ref = functionTarget_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        functionTarget_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     * </pre>
     *
     * <code>string function_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for functionTarget.
     */
    public com.google.protobuf.ByteString getFunctionTargetBytes() {
      java.lang.Object ref = functionTarget_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        functionTarget_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     * </pre>
     *
     * <code>string function_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The functionTarget to set.
     * @return This builder for chaining.
     */
    public Builder setFunctionTarget(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      functionTarget_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     * </pre>
     *
     * <code>string function_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFunctionTarget() {
      functionTarget_ = getDefaultInstance().getFunctionTarget();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     * </pre>
     *
     * <code>string function_target = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for functionTarget to set.
     * @return This builder for chaining.
     */
    public Builder setFunctionTargetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      functionTarget_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object imageUri_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Artifact Registry URI to store the built image.
     * </pre>
     *
     * <code>string image_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The imageUri.
     */
    public java.lang.String getImageUri() {
      java.lang.Object ref = imageUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Artifact Registry URI to store the built image.
     * </pre>
     *
     * <code>string image_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for imageUri.
     */
    public com.google.protobuf.ByteString getImageUriBytes() {
      java.lang.Object ref = imageUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Artifact Registry URI to store the built image.
     * </pre>
     *
     * <code>string image_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The imageUri to set.
     * @return This builder for chaining.
     */
    public Builder setImageUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      imageUri_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Artifact Registry URI to store the built image.
     * </pre>
     *
     * <code>string image_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImageUri() {
      imageUri_ = getDefaultInstance().getImageUri();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Artifact Registry URI to store the built image.
     * </pre>
     *
     * <code>string image_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for imageUri to set.
     * @return This builder for chaining.
     */
    public Builder setImageUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      imageUri_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object baseImage_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The base image used to build the function.
     * </pre>
     *
     * <code>string base_image = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The baseImage.
     */
    public java.lang.String getBaseImage() {
      java.lang.Object ref = baseImage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        baseImage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The base image used to build the function.
     * </pre>
     *
     * <code>string base_image = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for baseImage.
     */
    public com.google.protobuf.ByteString getBaseImageBytes() {
      java.lang.Object ref = baseImage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        baseImage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The base image used to build the function.
     * </pre>
     *
     * <code>string base_image = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The baseImage to set.
     * @return This builder for chaining.
     */
    public Builder setBaseImage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      baseImage_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The base image used to build the function.
     * </pre>
     *
     * <code>string base_image = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBaseImage() {
      baseImage_ = getDefaultInstance().getBaseImage();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The base image used to build the function.
     * </pre>
     *
     * <code>string base_image = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for baseImage to set.
     * @return This builder for chaining.
     */
    public Builder setBaseImageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      baseImage_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private boolean enableAutomaticUpdates_;

    /**
     *
     *
     * <pre>
     * Optional. Sets whether the function will receive automatic base image
     * updates.
     * </pre>
     *
     * <code>bool enable_automatic_updates = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableAutomaticUpdates.
     */
    @java.lang.Override
    public boolean getEnableAutomaticUpdates() {
      return enableAutomaticUpdates_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Sets whether the function will receive automatic base image
     * updates.
     * </pre>
     *
     * <code>bool enable_automatic_updates = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enableAutomaticUpdates to set.
     * @return This builder for chaining.
     */
    public Builder setEnableAutomaticUpdates(boolean value) {

      enableAutomaticUpdates_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Sets whether the function will receive automatic base image
     * updates.
     * </pre>
     *
     * <code>bool enable_automatic_updates = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableAutomaticUpdates() {
      bitField0_ = (bitField0_ & ~0x00000020);
      enableAutomaticUpdates_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object workerPool_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Name of the Cloud Build Custom Worker Pool that should be used to
     * build the Cloud Run function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * `{project}` and `{region}` are the project id and region respectively where
     * the worker pool is defined and `{workerPool}` is the short name of the
     * worker pool.
     * </pre>
     *
     * <code>
     * string worker_pool = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The workerPool.
     */
    public java.lang.String getWorkerPool() {
      java.lang.Object ref = workerPool_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        workerPool_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Name of the Cloud Build Custom Worker Pool that should be used to
     * build the Cloud Run function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * `{project}` and `{region}` are the project id and region respectively where
     * the worker pool is defined and `{workerPool}` is the short name of the
     * worker pool.
     * </pre>
     *
     * <code>
     * string worker_pool = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for workerPool.
     */
    public com.google.protobuf.ByteString getWorkerPoolBytes() {
      java.lang.Object ref = workerPool_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        workerPool_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Name of the Cloud Build Custom Worker Pool that should be used to
     * build the Cloud Run function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * `{project}` and `{region}` are the project id and region respectively where
     * the worker pool is defined and `{workerPool}` is the short name of the
     * worker pool.
     * </pre>
     *
     * <code>
     * string worker_pool = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The workerPool to set.
     * @return This builder for chaining.
     */
    public Builder setWorkerPool(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      workerPool_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Name of the Cloud Build Custom Worker Pool that should be used to
     * build the Cloud Run function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * `{project}` and `{region}` are the project id and region respectively where
     * the worker pool is defined and `{workerPool}` is the short name of the
     * worker pool.
     * </pre>
     *
     * <code>
     * string worker_pool = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWorkerPool() {
      workerPool_ = getDefaultInstance().getWorkerPool();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Name of the Cloud Build Custom Worker Pool that should be used to
     * build the Cloud Run function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * `{project}` and `{region}` are the project id and region respectively where
     * the worker pool is defined and `{workerPool}` is the short name of the
     * worker pool.
     * </pre>
     *
     * <code>
     * string worker_pool = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for workerPool to set.
     * @return This builder for chaining.
     */
    public Builder setWorkerPoolBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      workerPool_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> environmentVariables_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetEnvironmentVariables() {
      if (environmentVariables_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            EnvironmentVariablesDefaultEntryHolder.defaultEntry);
      }
      return environmentVariables_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableEnvironmentVariables() {
      if (environmentVariables_ == null) {
        environmentVariables_ =
            com.google.protobuf.MapField.newMapField(
                EnvironmentVariablesDefaultEntryHolder.defaultEntry);
      }
      if (!environmentVariables_.isMutable()) {
        environmentVariables_ = environmentVariables_.copy();
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return environmentVariables_;
    }

    public int getEnvironmentVariablesCount() {
      return internalGetEnvironmentVariables().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. User-provided build-time environment variables for the function
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; environment_variables = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsEnvironmentVariables(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetEnvironmentVariables().getMap().containsKey(key);
    }

    /** Use {@link #getEnvironmentVariablesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariables() {
      return getEnvironmentVariablesMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. User-provided build-time environment variables for the function
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; environment_variables = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariablesMap() {
      return internalGetEnvironmentVariables().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. User-provided build-time environment variables for the function
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; environment_variables = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getEnvironmentVariablesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetEnvironmentVariables().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-provided build-time environment variables for the function
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; environment_variables = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getEnvironmentVariablesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetEnvironmentVariables().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearEnvironmentVariables() {
      bitField0_ = (bitField0_ & ~0x00000080);
      internalGetMutableEnvironmentVariables().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-provided build-time environment variables for the function
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; environment_variables = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeEnvironmentVariables(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableEnvironmentVariables().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableEnvironmentVariables() {
      bitField0_ |= 0x00000080;
      return internalGetMutableEnvironmentVariables().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. User-provided build-time environment variables for the function
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; environment_variables = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putEnvironmentVariables(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableEnvironmentVariables().getMutableMap().put(key, value);
      bitField0_ |= 0x00000080;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-provided build-time environment variables for the function
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; environment_variables = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllEnvironmentVariables(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableEnvironmentVariables().getMutableMap().putAll(values);
      bitField0_ |= 0x00000080;
      return this;
    }

    private java.lang.Object serviceAccount_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Service account to be used for building the container. The format
     * of this field is
     * `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
     * </pre>
     *
     * <code>string service_account = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Service account to be used for building the container. The format
     * of this field is
     * `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
     * </pre>
     *
     * <code>string service_account = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Service account to be used for building the container. The format
     * of this field is
     * `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
     * </pre>
     *
     * <code>string service_account = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Service account to be used for building the container. The format
     * of this field is
     * `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
     * </pre>
     *
     * <code>string service_account = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Service account to be used for building the container. The format
     * of this field is
     * `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
     * </pre>
     *
     * <code>string service_account = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.BuildConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.run.v2.BuildConfig)
  private static final com.google.cloud.run.v2.BuildConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.run.v2.BuildConfig();
  }

  public static com.google.cloud.run.v2.BuildConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BuildConfig> PARSER =
      new com.google.protobuf.AbstractParser<BuildConfig>() {
        @java.lang.Override
        public BuildConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BuildConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BuildConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.run.v2.BuildConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
