/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServingConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CATALOG_SERVING_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/catalogs/{catalog}/servingConfigs/{serving_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String catalog;
    private final String servingConfig;

    @Deprecated
    protected ServingConfigName() {
        this.project = null;
        this.location = null;
        this.catalog = null;
        this.servingConfig = null;
    }

    private ServingConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.catalog = (String)Preconditions.checkNotNull((Object)builder.getCatalog());
        this.servingConfig = (String)Preconditions.checkNotNull((Object)builder.getServingConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getServingConfig() {
        return this.servingConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ServingConfigName of(String project, String location, String catalog, String servingConfig) {
        return ServingConfigName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).setServingConfig(servingConfig).build();
    }

    public static String format(String project, String location, String catalog, String servingConfig) {
        return ServingConfigName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).setServingConfig(servingConfig).build().toString();
    }

    public static ServingConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CATALOG_SERVING_CONFIG.validatedMatch(formattedString, "ServingConfigName.parse: formattedString not in valid format");
        return ServingConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("catalog"), (String)matchMap.get("serving_config"));
    }

    public static List<ServingConfigName> parseList(List<String> formattedStrings) {
        ArrayList<ServingConfigName> list = new ArrayList<ServingConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServingConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServingConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServingConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CATALOG_SERVING_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServingConfigName servingConfigName = this;
            synchronized (servingConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.catalog != null) {
                        fieldMapBuilder.put((Object)"catalog", (Object)this.catalog);
                    }
                    if (this.servingConfig != null) {
                        fieldMapBuilder.put((Object)"serving_config", (Object)this.servingConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CATALOG_SERVING_CONFIG.instantiate(new String[]{"project", this.project, "location", this.location, "catalog", this.catalog, "serving_config", this.servingConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ServingConfigName that = (ServingConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.catalog, that.catalog) && Objects.equals(this.servingConfig, that.servingConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.catalog);
        h *= 1000003;
        return h ^= Objects.hashCode(this.servingConfig);
    }

    public static class Builder {
        private String project;
        private String location;
        private String catalog;
        private String servingConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getServingConfig() {
            return this.servingConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder setServingConfig(String servingConfig) {
            this.servingConfig = servingConfig;
            return this;
        }

        private Builder(ServingConfigName servingConfigName) {
            this.project = servingConfigName.project;
            this.location = servingConfigName.location;
            this.catalog = servingConfigName.catalog;
            this.servingConfig = servingConfigName.servingConfig;
        }

        public ServingConfigName build() {
            return new ServingConfigName(this);
        }
    }
}

