/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha;

import com.google.cloud.retail.v2alpha.Interval;
import com.google.cloud.retail.v2alpha.IntervalOrBuilder;
import com.google.cloud.retail.v2alpha.Product;
import com.google.cloud.retail.v2alpha.ProductOrBuilder;
import com.google.cloud.retail.v2alpha.SearchRequest;
import com.google.cloud.retail.v2alpha.SearchResponseOrBuilder;
import com.google.cloud.retail.v2alpha.SearchServiceProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.FieldMask;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.Value;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class SearchResponse
extends GeneratedMessageV3
implements SearchResponseOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int RESULTS_FIELD_NUMBER = 1;
    private List<SearchResult> results_;
    public static final int FACETS_FIELD_NUMBER = 2;
    private List<Facet> facets_;
    public static final int TOTAL_SIZE_FIELD_NUMBER = 3;
    private int totalSize_ = 0;
    public static final int CORRECTED_QUERY_FIELD_NUMBER = 4;
    private volatile Object correctedQuery_ = "";
    public static final int ATTRIBUTION_TOKEN_FIELD_NUMBER = 5;
    private volatile Object attributionToken_ = "";
    public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 6;
    private volatile Object nextPageToken_ = "";
    public static final int QUERY_EXPANSION_INFO_FIELD_NUMBER = 7;
    private QueryExpansionInfo queryExpansionInfo_;
    public static final int REDIRECT_URI_FIELD_NUMBER = 10;
    private volatile Object redirectUri_ = "";
    public static final int APPLIED_CONTROLS_FIELD_NUMBER = 12;
    private LazyStringList appliedControls_;
    public static final int INVALID_CONDITION_BOOST_SPECS_FIELD_NUMBER = 14;
    private List<SearchRequest.BoostSpec.ConditionBoostSpec> invalidConditionBoostSpecs_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final SearchResponse DEFAULT_INSTANCE = new SearchResponse();
    private static final Parser<SearchResponse> PARSER = new AbstractParser<SearchResponse>(){

        public SearchResponse parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = SearchResponse.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private SearchResponse(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private SearchResponse() {
        this.results_ = Collections.emptyList();
        this.facets_ = Collections.emptyList();
        this.correctedQuery_ = "";
        this.attributionToken_ = "";
        this.nextPageToken_ = "";
        this.redirectUri_ = "";
        this.appliedControls_ = LazyStringArrayList.EMPTY;
        this.invalidConditionBoostSpecs_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new SearchResponse();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_fieldAccessorTable.ensureFieldAccessorsInitialized(SearchResponse.class, Builder.class);
    }

    @Override
    public List<SearchResult> getResultsList() {
        return this.results_;
    }

    @Override
    public List<? extends SearchResultOrBuilder> getResultsOrBuilderList() {
        return this.results_;
    }

    @Override
    public int getResultsCount() {
        return this.results_.size();
    }

    @Override
    public SearchResult getResults(int index) {
        return this.results_.get(index);
    }

    @Override
    public SearchResultOrBuilder getResultsOrBuilder(int index) {
        return this.results_.get(index);
    }

    @Override
    public List<Facet> getFacetsList() {
        return this.facets_;
    }

    @Override
    public List<? extends FacetOrBuilder> getFacetsOrBuilderList() {
        return this.facets_;
    }

    @Override
    public int getFacetsCount() {
        return this.facets_.size();
    }

    @Override
    public Facet getFacets(int index) {
        return this.facets_.get(index);
    }

    @Override
    public FacetOrBuilder getFacetsOrBuilder(int index) {
        return this.facets_.get(index);
    }

    @Override
    public int getTotalSize() {
        return this.totalSize_;
    }

    @Override
    public String getCorrectedQuery() {
        Object ref = this.correctedQuery_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.correctedQuery_ = s;
        return s;
    }

    @Override
    public ByteString getCorrectedQueryBytes() {
        Object ref = this.correctedQuery_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.correctedQuery_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getAttributionToken() {
        Object ref = this.attributionToken_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.attributionToken_ = s;
        return s;
    }

    @Override
    public ByteString getAttributionTokenBytes() {
        Object ref = this.attributionToken_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.attributionToken_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getNextPageToken() {
        Object ref = this.nextPageToken_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.nextPageToken_ = s;
        return s;
    }

    @Override
    public ByteString getNextPageTokenBytes() {
        Object ref = this.nextPageToken_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.nextPageToken_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasQueryExpansionInfo() {
        return this.queryExpansionInfo_ != null;
    }

    @Override
    public QueryExpansionInfo getQueryExpansionInfo() {
        return this.queryExpansionInfo_ == null ? QueryExpansionInfo.getDefaultInstance() : this.queryExpansionInfo_;
    }

    @Override
    public QueryExpansionInfoOrBuilder getQueryExpansionInfoOrBuilder() {
        return this.queryExpansionInfo_ == null ? QueryExpansionInfo.getDefaultInstance() : this.queryExpansionInfo_;
    }

    @Override
    public String getRedirectUri() {
        Object ref = this.redirectUri_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.redirectUri_ = s;
        return s;
    }

    @Override
    public ByteString getRedirectUriBytes() {
        Object ref = this.redirectUri_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.redirectUri_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public ProtocolStringList getAppliedControlsList() {
        return this.appliedControls_;
    }

    @Override
    public int getAppliedControlsCount() {
        return this.appliedControls_.size();
    }

    @Override
    public String getAppliedControls(int index) {
        return (String)this.appliedControls_.get(index);
    }

    @Override
    public ByteString getAppliedControlsBytes(int index) {
        return this.appliedControls_.getByteString(index);
    }

    @Override
    public List<SearchRequest.BoostSpec.ConditionBoostSpec> getInvalidConditionBoostSpecsList() {
        return this.invalidConditionBoostSpecs_;
    }

    @Override
    public List<? extends SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder> getInvalidConditionBoostSpecsOrBuilderList() {
        return this.invalidConditionBoostSpecs_;
    }

    @Override
    public int getInvalidConditionBoostSpecsCount() {
        return this.invalidConditionBoostSpecs_.size();
    }

    @Override
    public SearchRequest.BoostSpec.ConditionBoostSpec getInvalidConditionBoostSpecs(int index) {
        return this.invalidConditionBoostSpecs_.get(index);
    }

    @Override
    public SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder getInvalidConditionBoostSpecsOrBuilder(int index) {
        return this.invalidConditionBoostSpecs_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        for (i = 0; i < this.results_.size(); ++i) {
            output.writeMessage(1, (MessageLite)this.results_.get(i));
        }
        for (i = 0; i < this.facets_.size(); ++i) {
            output.writeMessage(2, (MessageLite)this.facets_.get(i));
        }
        if (this.totalSize_ != 0) {
            output.writeInt32(3, this.totalSize_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.correctedQuery_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.correctedQuery_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.attributionToken_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.attributionToken_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.nextPageToken_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.nextPageToken_);
        }
        if (this.queryExpansionInfo_ != null) {
            output.writeMessage(7, (MessageLite)this.getQueryExpansionInfo());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.redirectUri_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)10, (Object)this.redirectUri_);
        }
        for (i = 0; i < this.appliedControls_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)12, (Object)this.appliedControls_.getRaw(i));
        }
        for (i = 0; i < this.invalidConditionBoostSpecs_.size(); ++i) {
            output.writeMessage(14, (MessageLite)this.invalidConditionBoostSpecs_.get(i));
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        for (i = 0; i < this.results_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)((MessageLite)this.results_.get(i)));
        }
        for (i = 0; i < this.facets_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)((MessageLite)this.facets_.get(i)));
        }
        if (this.totalSize_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)3, (int)this.totalSize_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.correctedQuery_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.correctedQuery_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.attributionToken_)) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.attributionToken_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.nextPageToken_)) {
            size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.nextPageToken_);
        }
        if (this.queryExpansionInfo_ != null) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getQueryExpansionInfo());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.redirectUri_)) {
            size += GeneratedMessageV3.computeStringSize((int)10, (Object)this.redirectUri_);
        }
        int dataSize = 0;
        for (int i2 = 0; i2 < this.appliedControls_.size(); ++i2) {
            dataSize += SearchResponse.computeStringSizeNoTag((Object)this.appliedControls_.getRaw(i2));
        }
        size += dataSize;
        size += 1 * this.getAppliedControlsList().size();
        for (i = 0; i < this.invalidConditionBoostSpecs_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)14, (MessageLite)((MessageLite)this.invalidConditionBoostSpecs_.get(i)));
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchResponse)) {
            return super.equals(obj);
        }
        SearchResponse other = (SearchResponse)obj;
        if (!this.getResultsList().equals(other.getResultsList())) {
            return false;
        }
        if (!this.getFacetsList().equals(other.getFacetsList())) {
            return false;
        }
        if (this.getTotalSize() != other.getTotalSize()) {
            return false;
        }
        if (!this.getCorrectedQuery().equals(other.getCorrectedQuery())) {
            return false;
        }
        if (!this.getAttributionToken().equals(other.getAttributionToken())) {
            return false;
        }
        if (!this.getNextPageToken().equals(other.getNextPageToken())) {
            return false;
        }
        if (this.hasQueryExpansionInfo() != other.hasQueryExpansionInfo()) {
            return false;
        }
        if (this.hasQueryExpansionInfo() && !this.getQueryExpansionInfo().equals(other.getQueryExpansionInfo())) {
            return false;
        }
        if (!this.getRedirectUri().equals(other.getRedirectUri())) {
            return false;
        }
        if (!this.getAppliedControlsList().equals(other.getAppliedControlsList())) {
            return false;
        }
        if (!this.getInvalidConditionBoostSpecsList().equals(other.getInvalidConditionBoostSpecsList())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + SearchResponse.getDescriptor().hashCode();
        if (this.getResultsCount() > 0) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getResultsList().hashCode();
        }
        if (this.getFacetsCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getFacetsList().hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getTotalSize();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getCorrectedQuery().hashCode();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getAttributionToken().hashCode();
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getNextPageToken().hashCode();
        if (this.hasQueryExpansionInfo()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getQueryExpansionInfo().hashCode();
        }
        hash = 37 * hash + 10;
        hash = 53 * hash + this.getRedirectUri().hashCode();
        if (this.getAppliedControlsCount() > 0) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.getAppliedControlsList().hashCode();
        }
        if (this.getInvalidConditionBoostSpecsCount() > 0) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getInvalidConditionBoostSpecsList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static SearchResponse parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (SearchResponse)PARSER.parseFrom(data);
    }

    public static SearchResponse parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (SearchResponse)PARSER.parseFrom(data, extensionRegistry);
    }

    public static SearchResponse parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (SearchResponse)PARSER.parseFrom(data);
    }

    public static SearchResponse parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (SearchResponse)PARSER.parseFrom(data, extensionRegistry);
    }

    public static SearchResponse parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (SearchResponse)PARSER.parseFrom(data);
    }

    public static SearchResponse parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (SearchResponse)PARSER.parseFrom(data, extensionRegistry);
    }

    public static SearchResponse parseFrom(InputStream input) throws IOException {
        return (SearchResponse)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static SearchResponse parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (SearchResponse)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static SearchResponse parseDelimitedFrom(InputStream input) throws IOException {
        return (SearchResponse)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static SearchResponse parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (SearchResponse)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static SearchResponse parseFrom(CodedInputStream input) throws IOException {
        return (SearchResponse)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static SearchResponse parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (SearchResponse)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return SearchResponse.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SearchResponse prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static SearchResponse getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<SearchResponse> parser() {
        return PARSER;
    }

    public Parser<SearchResponse> getParserForType() {
        return PARSER;
    }

    public SearchResponse getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements SearchResponseOrBuilder {
        private int bitField0_;
        private List<SearchResult> results_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<SearchResult, SearchResult.Builder, SearchResultOrBuilder> resultsBuilder_;
        private List<Facet> facets_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Facet, Facet.Builder, FacetOrBuilder> facetsBuilder_;
        private int totalSize_;
        private Object correctedQuery_ = "";
        private Object attributionToken_ = "";
        private Object nextPageToken_ = "";
        private QueryExpansionInfo queryExpansionInfo_;
        private SingleFieldBuilderV3<QueryExpansionInfo, QueryExpansionInfo.Builder, QueryExpansionInfoOrBuilder> queryExpansionInfoBuilder_;
        private Object redirectUri_ = "";
        private LazyStringList appliedControls_ = LazyStringArrayList.EMPTY;
        private List<SearchRequest.BoostSpec.ConditionBoostSpec> invalidConditionBoostSpecs_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<SearchRequest.BoostSpec.ConditionBoostSpec, SearchRequest.BoostSpec.ConditionBoostSpec.Builder, SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder> invalidConditionBoostSpecsBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_fieldAccessorTable.ensureFieldAccessorsInitialized(SearchResponse.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            if (this.resultsBuilder_ == null) {
                this.results_ = Collections.emptyList();
            } else {
                this.results_ = null;
                this.resultsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFE;
            if (this.facetsBuilder_ == null) {
                this.facets_ = Collections.emptyList();
            } else {
                this.facets_ = null;
                this.facetsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFD;
            this.totalSize_ = 0;
            this.correctedQuery_ = "";
            this.attributionToken_ = "";
            this.nextPageToken_ = "";
            this.queryExpansionInfo_ = null;
            if (this.queryExpansionInfoBuilder_ != null) {
                this.queryExpansionInfoBuilder_.dispose();
                this.queryExpansionInfoBuilder_ = null;
            }
            this.redirectUri_ = "";
            this.appliedControls_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFEFF;
            if (this.invalidConditionBoostSpecsBuilder_ == null) {
                this.invalidConditionBoostSpecs_ = Collections.emptyList();
            } else {
                this.invalidConditionBoostSpecs_ = null;
                this.invalidConditionBoostSpecsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFDFF;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_descriptor;
        }

        public SearchResponse getDefaultInstanceForType() {
            return SearchResponse.getDefaultInstance();
        }

        public SearchResponse build() {
            SearchResponse result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public SearchResponse buildPartial() {
            SearchResponse result = new SearchResponse(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(SearchResponse result) {
            if (this.resultsBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0) {
                    this.results_ = Collections.unmodifiableList(this.results_);
                    this.bitField0_ &= 0xFFFFFFFE;
                }
                result.results_ = this.results_;
            } else {
                result.results_ = this.resultsBuilder_.build();
            }
            if (this.facetsBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.facets_ = Collections.unmodifiableList(this.facets_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.facets_ = this.facets_;
            } else {
                result.facets_ = this.facetsBuilder_.build();
            }
            if ((this.bitField0_ & 0x100) != 0) {
                this.appliedControls_ = this.appliedControls_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFEFF;
            }
            result.appliedControls_ = this.appliedControls_;
            if (this.invalidConditionBoostSpecsBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0) {
                    this.invalidConditionBoostSpecs_ = Collections.unmodifiableList(this.invalidConditionBoostSpecs_);
                    this.bitField0_ &= 0xFFFFFDFF;
                }
                result.invalidConditionBoostSpecs_ = this.invalidConditionBoostSpecs_;
            } else {
                result.invalidConditionBoostSpecs_ = this.invalidConditionBoostSpecsBuilder_.build();
            }
        }

        private void buildPartial0(SearchResponse result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 4) != 0) {
                result.totalSize_ = this.totalSize_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.correctedQuery_ = this.correctedQuery_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.attributionToken_ = this.attributionToken_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.nextPageToken_ = this.nextPageToken_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.queryExpansionInfo_ = this.queryExpansionInfoBuilder_ == null ? this.queryExpansionInfo_ : (QueryExpansionInfo)this.queryExpansionInfoBuilder_.build();
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.redirectUri_ = this.redirectUri_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof SearchResponse) {
                return this.mergeFrom((SearchResponse)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(SearchResponse other) {
            if (other == SearchResponse.getDefaultInstance()) {
                return this;
            }
            if (this.resultsBuilder_ == null) {
                if (!other.results_.isEmpty()) {
                    if (this.results_.isEmpty()) {
                        this.results_ = other.results_;
                        this.bitField0_ &= 0xFFFFFFFE;
                    } else {
                        this.ensureResultsIsMutable();
                        this.results_.addAll(other.results_);
                    }
                    this.onChanged();
                }
            } else if (!other.results_.isEmpty()) {
                if (this.resultsBuilder_.isEmpty()) {
                    this.resultsBuilder_.dispose();
                    this.resultsBuilder_ = null;
                    this.results_ = other.results_;
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.resultsBuilder_ = alwaysUseFieldBuilders ? this.getResultsFieldBuilder() : null;
                } else {
                    this.resultsBuilder_.addAllMessages((Iterable)other.results_);
                }
            }
            if (this.facetsBuilder_ == null) {
                if (!other.facets_.isEmpty()) {
                    if (this.facets_.isEmpty()) {
                        this.facets_ = other.facets_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureFacetsIsMutable();
                        this.facets_.addAll(other.facets_);
                    }
                    this.onChanged();
                }
            } else if (!other.facets_.isEmpty()) {
                if (this.facetsBuilder_.isEmpty()) {
                    this.facetsBuilder_.dispose();
                    this.facetsBuilder_ = null;
                    this.facets_ = other.facets_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.facetsBuilder_ = alwaysUseFieldBuilders ? this.getFacetsFieldBuilder() : null;
                } else {
                    this.facetsBuilder_.addAllMessages((Iterable)other.facets_);
                }
            }
            if (other.getTotalSize() != 0) {
                this.setTotalSize(other.getTotalSize());
            }
            if (!other.getCorrectedQuery().isEmpty()) {
                this.correctedQuery_ = other.correctedQuery_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (!other.getAttributionToken().isEmpty()) {
                this.attributionToken_ = other.attributionToken_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (!other.getNextPageToken().isEmpty()) {
                this.nextPageToken_ = other.nextPageToken_;
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            if (other.hasQueryExpansionInfo()) {
                this.mergeQueryExpansionInfo(other.getQueryExpansionInfo());
            }
            if (!other.getRedirectUri().isEmpty()) {
                this.redirectUri_ = other.redirectUri_;
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            if (!other.appliedControls_.isEmpty()) {
                if (this.appliedControls_.isEmpty()) {
                    this.appliedControls_ = other.appliedControls_;
                    this.bitField0_ &= 0xFFFFFEFF;
                } else {
                    this.ensureAppliedControlsIsMutable();
                    this.appliedControls_.addAll((Collection)other.appliedControls_);
                }
                this.onChanged();
            }
            if (this.invalidConditionBoostSpecsBuilder_ == null) {
                if (!other.invalidConditionBoostSpecs_.isEmpty()) {
                    if (this.invalidConditionBoostSpecs_.isEmpty()) {
                        this.invalidConditionBoostSpecs_ = other.invalidConditionBoostSpecs_;
                        this.bitField0_ &= 0xFFFFFDFF;
                    } else {
                        this.ensureInvalidConditionBoostSpecsIsMutable();
                        this.invalidConditionBoostSpecs_.addAll(other.invalidConditionBoostSpecs_);
                    }
                    this.onChanged();
                }
            } else if (!other.invalidConditionBoostSpecs_.isEmpty()) {
                if (this.invalidConditionBoostSpecsBuilder_.isEmpty()) {
                    this.invalidConditionBoostSpecsBuilder_.dispose();
                    this.invalidConditionBoostSpecsBuilder_ = null;
                    this.invalidConditionBoostSpecs_ = other.invalidConditionBoostSpecs_;
                    this.bitField0_ &= 0xFFFFFDFF;
                    this.invalidConditionBoostSpecsBuilder_ = alwaysUseFieldBuilders ? this.getInvalidConditionBoostSpecsFieldBuilder() : null;
                } else {
                    this.invalidConditionBoostSpecsBuilder_.addAllMessages((Iterable)other.invalidConditionBoostSpecs_);
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block18: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block18;
                        }
                        case 10: {
                            GeneratedMessageV3 m = (SearchResult)input.readMessage(SearchResult.parser(), extensionRegistry);
                            if (this.resultsBuilder_ == null) {
                                this.ensureResultsIsMutable();
                                this.results_.add((SearchResult)m);
                                continue block18;
                            }
                            this.resultsBuilder_.addMessage((AbstractMessage)m);
                            continue block18;
                        }
                        case 18: {
                            GeneratedMessageV3 m = (Facet)input.readMessage(Facet.parser(), extensionRegistry);
                            if (this.facetsBuilder_ == null) {
                                this.ensureFacetsIsMutable();
                                this.facets_.add((Facet)m);
                                continue block18;
                            }
                            this.facetsBuilder_.addMessage((AbstractMessage)m);
                            continue block18;
                        }
                        case 24: {
                            this.totalSize_ = input.readInt32();
                            this.bitField0_ |= 4;
                            continue block18;
                        }
                        case 34: {
                            this.correctedQuery_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block18;
                        }
                        case 42: {
                            this.attributionToken_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block18;
                        }
                        case 50: {
                            this.nextPageToken_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x20;
                            continue block18;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getQueryExpansionInfoFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40;
                            continue block18;
                        }
                        case 82: {
                            this.redirectUri_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x80;
                            continue block18;
                        }
                        case 98: {
                            String s = input.readStringRequireUtf8();
                            this.ensureAppliedControlsIsMutable();
                            this.appliedControls_.add((Object)s);
                            continue block18;
                        }
                        case 114: {
                            GeneratedMessageV3 m = (SearchRequest.BoostSpec.ConditionBoostSpec)input.readMessage(SearchRequest.BoostSpec.ConditionBoostSpec.parser(), extensionRegistry);
                            if (this.invalidConditionBoostSpecsBuilder_ == null) {
                                this.ensureInvalidConditionBoostSpecsIsMutable();
                                this.invalidConditionBoostSpecs_.add((SearchRequest.BoostSpec.ConditionBoostSpec)m);
                                continue block18;
                            }
                            this.invalidConditionBoostSpecsBuilder_.addMessage((AbstractMessage)m);
                            continue block18;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        private void ensureResultsIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.results_ = new ArrayList<SearchResult>(this.results_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<SearchResult> getResultsList() {
            if (this.resultsBuilder_ == null) {
                return Collections.unmodifiableList(this.results_);
            }
            return this.resultsBuilder_.getMessageList();
        }

        @Override
        public int getResultsCount() {
            if (this.resultsBuilder_ == null) {
                return this.results_.size();
            }
            return this.resultsBuilder_.getCount();
        }

        @Override
        public SearchResult getResults(int index) {
            if (this.resultsBuilder_ == null) {
                return this.results_.get(index);
            }
            return (SearchResult)this.resultsBuilder_.getMessage(index);
        }

        public Builder setResults(int index, SearchResult value) {
            if (this.resultsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureResultsIsMutable();
                this.results_.set(index, value);
                this.onChanged();
            } else {
                this.resultsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setResults(int index, SearchResult.Builder builderForValue) {
            if (this.resultsBuilder_ == null) {
                this.ensureResultsIsMutable();
                this.results_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.resultsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addResults(SearchResult value) {
            if (this.resultsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureResultsIsMutable();
                this.results_.add(value);
                this.onChanged();
            } else {
                this.resultsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addResults(int index, SearchResult value) {
            if (this.resultsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureResultsIsMutable();
                this.results_.add(index, value);
                this.onChanged();
            } else {
                this.resultsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addResults(SearchResult.Builder builderForValue) {
            if (this.resultsBuilder_ == null) {
                this.ensureResultsIsMutable();
                this.results_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.resultsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addResults(int index, SearchResult.Builder builderForValue) {
            if (this.resultsBuilder_ == null) {
                this.ensureResultsIsMutable();
                this.results_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.resultsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllResults(Iterable<? extends SearchResult> values) {
            if (this.resultsBuilder_ == null) {
                this.ensureResultsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.results_);
                this.onChanged();
            } else {
                this.resultsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearResults() {
            if (this.resultsBuilder_ == null) {
                this.results_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
            } else {
                this.resultsBuilder_.clear();
            }
            return this;
        }

        public Builder removeResults(int index) {
            if (this.resultsBuilder_ == null) {
                this.ensureResultsIsMutable();
                this.results_.remove(index);
                this.onChanged();
            } else {
                this.resultsBuilder_.remove(index);
            }
            return this;
        }

        public SearchResult.Builder getResultsBuilder(int index) {
            return (SearchResult.Builder)this.getResultsFieldBuilder().getBuilder(index);
        }

        @Override
        public SearchResultOrBuilder getResultsOrBuilder(int index) {
            if (this.resultsBuilder_ == null) {
                return this.results_.get(index);
            }
            return (SearchResultOrBuilder)this.resultsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends SearchResultOrBuilder> getResultsOrBuilderList() {
            if (this.resultsBuilder_ != null) {
                return this.resultsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.results_);
        }

        public SearchResult.Builder addResultsBuilder() {
            return (SearchResult.Builder)this.getResultsFieldBuilder().addBuilder((AbstractMessage)SearchResult.getDefaultInstance());
        }

        public SearchResult.Builder addResultsBuilder(int index) {
            return (SearchResult.Builder)this.getResultsFieldBuilder().addBuilder(index, (AbstractMessage)SearchResult.getDefaultInstance());
        }

        public List<SearchResult.Builder> getResultsBuilderList() {
            return this.getResultsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<SearchResult, SearchResult.Builder, SearchResultOrBuilder> getResultsFieldBuilder() {
            if (this.resultsBuilder_ == null) {
                this.resultsBuilder_ = new RepeatedFieldBuilderV3(this.results_, (this.bitField0_ & 1) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.results_ = null;
            }
            return this.resultsBuilder_;
        }

        private void ensureFacetsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.facets_ = new ArrayList<Facet>(this.facets_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<Facet> getFacetsList() {
            if (this.facetsBuilder_ == null) {
                return Collections.unmodifiableList(this.facets_);
            }
            return this.facetsBuilder_.getMessageList();
        }

        @Override
        public int getFacetsCount() {
            if (this.facetsBuilder_ == null) {
                return this.facets_.size();
            }
            return this.facetsBuilder_.getCount();
        }

        @Override
        public Facet getFacets(int index) {
            if (this.facetsBuilder_ == null) {
                return this.facets_.get(index);
            }
            return (Facet)this.facetsBuilder_.getMessage(index);
        }

        public Builder setFacets(int index, Facet value) {
            if (this.facetsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureFacetsIsMutable();
                this.facets_.set(index, value);
                this.onChanged();
            } else {
                this.facetsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setFacets(int index, Facet.Builder builderForValue) {
            if (this.facetsBuilder_ == null) {
                this.ensureFacetsIsMutable();
                this.facets_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.facetsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addFacets(Facet value) {
            if (this.facetsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureFacetsIsMutable();
                this.facets_.add(value);
                this.onChanged();
            } else {
                this.facetsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addFacets(int index, Facet value) {
            if (this.facetsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureFacetsIsMutable();
                this.facets_.add(index, value);
                this.onChanged();
            } else {
                this.facetsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addFacets(Facet.Builder builderForValue) {
            if (this.facetsBuilder_ == null) {
                this.ensureFacetsIsMutable();
                this.facets_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.facetsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addFacets(int index, Facet.Builder builderForValue) {
            if (this.facetsBuilder_ == null) {
                this.ensureFacetsIsMutable();
                this.facets_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.facetsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllFacets(Iterable<? extends Facet> values) {
            if (this.facetsBuilder_ == null) {
                this.ensureFacetsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.facets_);
                this.onChanged();
            } else {
                this.facetsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearFacets() {
            if (this.facetsBuilder_ == null) {
                this.facets_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.facetsBuilder_.clear();
            }
            return this;
        }

        public Builder removeFacets(int index) {
            if (this.facetsBuilder_ == null) {
                this.ensureFacetsIsMutable();
                this.facets_.remove(index);
                this.onChanged();
            } else {
                this.facetsBuilder_.remove(index);
            }
            return this;
        }

        public Facet.Builder getFacetsBuilder(int index) {
            return (Facet.Builder)this.getFacetsFieldBuilder().getBuilder(index);
        }

        @Override
        public FacetOrBuilder getFacetsOrBuilder(int index) {
            if (this.facetsBuilder_ == null) {
                return this.facets_.get(index);
            }
            return (FacetOrBuilder)this.facetsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends FacetOrBuilder> getFacetsOrBuilderList() {
            if (this.facetsBuilder_ != null) {
                return this.facetsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.facets_);
        }

        public Facet.Builder addFacetsBuilder() {
            return (Facet.Builder)this.getFacetsFieldBuilder().addBuilder((AbstractMessage)Facet.getDefaultInstance());
        }

        public Facet.Builder addFacetsBuilder(int index) {
            return (Facet.Builder)this.getFacetsFieldBuilder().addBuilder(index, (AbstractMessage)Facet.getDefaultInstance());
        }

        public List<Facet.Builder> getFacetsBuilderList() {
            return this.getFacetsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Facet, Facet.Builder, FacetOrBuilder> getFacetsFieldBuilder() {
            if (this.facetsBuilder_ == null) {
                this.facetsBuilder_ = new RepeatedFieldBuilderV3(this.facets_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.facets_ = null;
            }
            return this.facetsBuilder_;
        }

        @Override
        public int getTotalSize() {
            return this.totalSize_;
        }

        public Builder setTotalSize(int value) {
            this.totalSize_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearTotalSize() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.totalSize_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getCorrectedQuery() {
            Object ref = this.correctedQuery_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.correctedQuery_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCorrectedQueryBytes() {
            Object ref = this.correctedQuery_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.correctedQuery_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCorrectedQuery(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.correctedQuery_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearCorrectedQuery() {
            this.correctedQuery_ = SearchResponse.getDefaultInstance().getCorrectedQuery();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setCorrectedQueryBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SearchResponse.checkByteStringIsUtf8((ByteString)value);
            this.correctedQuery_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public String getAttributionToken() {
            Object ref = this.attributionToken_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.attributionToken_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getAttributionTokenBytes() {
            Object ref = this.attributionToken_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.attributionToken_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setAttributionToken(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.attributionToken_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearAttributionToken() {
            this.attributionToken_ = SearchResponse.getDefaultInstance().getAttributionToken();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setAttributionTokenBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SearchResponse.checkByteStringIsUtf8((ByteString)value);
            this.attributionToken_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public String getNextPageToken() {
            Object ref = this.nextPageToken_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.nextPageToken_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNextPageTokenBytes() {
            Object ref = this.nextPageToken_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.nextPageToken_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setNextPageToken(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.nextPageToken_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearNextPageToken() {
            this.nextPageToken_ = SearchResponse.getDefaultInstance().getNextPageToken();
            this.bitField0_ &= 0xFFFFFFDF;
            this.onChanged();
            return this;
        }

        public Builder setNextPageTokenBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SearchResponse.checkByteStringIsUtf8((ByteString)value);
            this.nextPageToken_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasQueryExpansionInfo() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public QueryExpansionInfo getQueryExpansionInfo() {
            if (this.queryExpansionInfoBuilder_ == null) {
                return this.queryExpansionInfo_ == null ? QueryExpansionInfo.getDefaultInstance() : this.queryExpansionInfo_;
            }
            return (QueryExpansionInfo)this.queryExpansionInfoBuilder_.getMessage();
        }

        public Builder setQueryExpansionInfo(QueryExpansionInfo value) {
            if (this.queryExpansionInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.queryExpansionInfo_ = value;
            } else {
                this.queryExpansionInfoBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder setQueryExpansionInfo(QueryExpansionInfo.Builder builderForValue) {
            if (this.queryExpansionInfoBuilder_ == null) {
                this.queryExpansionInfo_ = builderForValue.build();
            } else {
                this.queryExpansionInfoBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder mergeQueryExpansionInfo(QueryExpansionInfo value) {
            if (this.queryExpansionInfoBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0 && this.queryExpansionInfo_ != null && this.queryExpansionInfo_ != QueryExpansionInfo.getDefaultInstance()) {
                    this.getQueryExpansionInfoBuilder().mergeFrom(value);
                } else {
                    this.queryExpansionInfo_ = value;
                }
            } else {
                this.queryExpansionInfoBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearQueryExpansionInfo() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.queryExpansionInfo_ = null;
            if (this.queryExpansionInfoBuilder_ != null) {
                this.queryExpansionInfoBuilder_.dispose();
                this.queryExpansionInfoBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public QueryExpansionInfo.Builder getQueryExpansionInfoBuilder() {
            this.bitField0_ |= 0x40;
            this.onChanged();
            return (QueryExpansionInfo.Builder)this.getQueryExpansionInfoFieldBuilder().getBuilder();
        }

        @Override
        public QueryExpansionInfoOrBuilder getQueryExpansionInfoOrBuilder() {
            if (this.queryExpansionInfoBuilder_ != null) {
                return (QueryExpansionInfoOrBuilder)this.queryExpansionInfoBuilder_.getMessageOrBuilder();
            }
            return this.queryExpansionInfo_ == null ? QueryExpansionInfo.getDefaultInstance() : this.queryExpansionInfo_;
        }

        private SingleFieldBuilderV3<QueryExpansionInfo, QueryExpansionInfo.Builder, QueryExpansionInfoOrBuilder> getQueryExpansionInfoFieldBuilder() {
            if (this.queryExpansionInfoBuilder_ == null) {
                this.queryExpansionInfoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getQueryExpansionInfo(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.queryExpansionInfo_ = null;
            }
            return this.queryExpansionInfoBuilder_;
        }

        @Override
        public String getRedirectUri() {
            Object ref = this.redirectUri_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.redirectUri_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRedirectUriBytes() {
            Object ref = this.redirectUri_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.redirectUri_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRedirectUri(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.redirectUri_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearRedirectUri() {
            this.redirectUri_ = SearchResponse.getDefaultInstance().getRedirectUri();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        public Builder setRedirectUriBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SearchResponse.checkByteStringIsUtf8((ByteString)value);
            this.redirectUri_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        private void ensureAppliedControlsIsMutable() {
            if ((this.bitField0_ & 0x100) == 0) {
                this.appliedControls_ = new LazyStringArrayList(this.appliedControls_);
                this.bitField0_ |= 0x100;
            }
        }

        public ProtocolStringList getAppliedControlsList() {
            return this.appliedControls_.getUnmodifiableView();
        }

        @Override
        public int getAppliedControlsCount() {
            return this.appliedControls_.size();
        }

        @Override
        public String getAppliedControls(int index) {
            return (String)this.appliedControls_.get(index);
        }

        @Override
        public ByteString getAppliedControlsBytes(int index) {
            return this.appliedControls_.getByteString(index);
        }

        public Builder setAppliedControls(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAppliedControlsIsMutable();
            this.appliedControls_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAppliedControls(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAppliedControlsIsMutable();
            this.appliedControls_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllAppliedControls(Iterable<String> values) {
            this.ensureAppliedControlsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.appliedControls_);
            this.onChanged();
            return this;
        }

        public Builder clearAppliedControls() {
            this.appliedControls_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        public Builder addAppliedControlsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SearchResponse.checkByteStringIsUtf8((ByteString)value);
            this.ensureAppliedControlsIsMutable();
            this.appliedControls_.add(value);
            this.onChanged();
            return this;
        }

        private void ensureInvalidConditionBoostSpecsIsMutable() {
            if ((this.bitField0_ & 0x200) == 0) {
                this.invalidConditionBoostSpecs_ = new ArrayList<SearchRequest.BoostSpec.ConditionBoostSpec>(this.invalidConditionBoostSpecs_);
                this.bitField0_ |= 0x200;
            }
        }

        @Override
        public List<SearchRequest.BoostSpec.ConditionBoostSpec> getInvalidConditionBoostSpecsList() {
            if (this.invalidConditionBoostSpecsBuilder_ == null) {
                return Collections.unmodifiableList(this.invalidConditionBoostSpecs_);
            }
            return this.invalidConditionBoostSpecsBuilder_.getMessageList();
        }

        @Override
        public int getInvalidConditionBoostSpecsCount() {
            if (this.invalidConditionBoostSpecsBuilder_ == null) {
                return this.invalidConditionBoostSpecs_.size();
            }
            return this.invalidConditionBoostSpecsBuilder_.getCount();
        }

        @Override
        public SearchRequest.BoostSpec.ConditionBoostSpec getInvalidConditionBoostSpecs(int index) {
            if (this.invalidConditionBoostSpecsBuilder_ == null) {
                return this.invalidConditionBoostSpecs_.get(index);
            }
            return (SearchRequest.BoostSpec.ConditionBoostSpec)this.invalidConditionBoostSpecsBuilder_.getMessage(index);
        }

        public Builder setInvalidConditionBoostSpecs(int index, SearchRequest.BoostSpec.ConditionBoostSpec value) {
            if (this.invalidConditionBoostSpecsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureInvalidConditionBoostSpecsIsMutable();
                this.invalidConditionBoostSpecs_.set(index, value);
                this.onChanged();
            } else {
                this.invalidConditionBoostSpecsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setInvalidConditionBoostSpecs(int index, SearchRequest.BoostSpec.ConditionBoostSpec.Builder builderForValue) {
            if (this.invalidConditionBoostSpecsBuilder_ == null) {
                this.ensureInvalidConditionBoostSpecsIsMutable();
                this.invalidConditionBoostSpecs_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.invalidConditionBoostSpecsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addInvalidConditionBoostSpecs(SearchRequest.BoostSpec.ConditionBoostSpec value) {
            if (this.invalidConditionBoostSpecsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureInvalidConditionBoostSpecsIsMutable();
                this.invalidConditionBoostSpecs_.add(value);
                this.onChanged();
            } else {
                this.invalidConditionBoostSpecsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addInvalidConditionBoostSpecs(int index, SearchRequest.BoostSpec.ConditionBoostSpec value) {
            if (this.invalidConditionBoostSpecsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureInvalidConditionBoostSpecsIsMutable();
                this.invalidConditionBoostSpecs_.add(index, value);
                this.onChanged();
            } else {
                this.invalidConditionBoostSpecsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addInvalidConditionBoostSpecs(SearchRequest.BoostSpec.ConditionBoostSpec.Builder builderForValue) {
            if (this.invalidConditionBoostSpecsBuilder_ == null) {
                this.ensureInvalidConditionBoostSpecsIsMutable();
                this.invalidConditionBoostSpecs_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.invalidConditionBoostSpecsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addInvalidConditionBoostSpecs(int index, SearchRequest.BoostSpec.ConditionBoostSpec.Builder builderForValue) {
            if (this.invalidConditionBoostSpecsBuilder_ == null) {
                this.ensureInvalidConditionBoostSpecsIsMutable();
                this.invalidConditionBoostSpecs_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.invalidConditionBoostSpecsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllInvalidConditionBoostSpecs(Iterable<? extends SearchRequest.BoostSpec.ConditionBoostSpec> values) {
            if (this.invalidConditionBoostSpecsBuilder_ == null) {
                this.ensureInvalidConditionBoostSpecsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.invalidConditionBoostSpecs_);
                this.onChanged();
            } else {
                this.invalidConditionBoostSpecsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearInvalidConditionBoostSpecs() {
            if (this.invalidConditionBoostSpecsBuilder_ == null) {
                this.invalidConditionBoostSpecs_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFDFF;
                this.onChanged();
            } else {
                this.invalidConditionBoostSpecsBuilder_.clear();
            }
            return this;
        }

        public Builder removeInvalidConditionBoostSpecs(int index) {
            if (this.invalidConditionBoostSpecsBuilder_ == null) {
                this.ensureInvalidConditionBoostSpecsIsMutable();
                this.invalidConditionBoostSpecs_.remove(index);
                this.onChanged();
            } else {
                this.invalidConditionBoostSpecsBuilder_.remove(index);
            }
            return this;
        }

        public SearchRequest.BoostSpec.ConditionBoostSpec.Builder getInvalidConditionBoostSpecsBuilder(int index) {
            return (SearchRequest.BoostSpec.ConditionBoostSpec.Builder)this.getInvalidConditionBoostSpecsFieldBuilder().getBuilder(index);
        }

        @Override
        public SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder getInvalidConditionBoostSpecsOrBuilder(int index) {
            if (this.invalidConditionBoostSpecsBuilder_ == null) {
                return this.invalidConditionBoostSpecs_.get(index);
            }
            return (SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder)this.invalidConditionBoostSpecsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder> getInvalidConditionBoostSpecsOrBuilderList() {
            if (this.invalidConditionBoostSpecsBuilder_ != null) {
                return this.invalidConditionBoostSpecsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.invalidConditionBoostSpecs_);
        }

        public SearchRequest.BoostSpec.ConditionBoostSpec.Builder addInvalidConditionBoostSpecsBuilder() {
            return (SearchRequest.BoostSpec.ConditionBoostSpec.Builder)this.getInvalidConditionBoostSpecsFieldBuilder().addBuilder((AbstractMessage)SearchRequest.BoostSpec.ConditionBoostSpec.getDefaultInstance());
        }

        public SearchRequest.BoostSpec.ConditionBoostSpec.Builder addInvalidConditionBoostSpecsBuilder(int index) {
            return (SearchRequest.BoostSpec.ConditionBoostSpec.Builder)this.getInvalidConditionBoostSpecsFieldBuilder().addBuilder(index, (AbstractMessage)SearchRequest.BoostSpec.ConditionBoostSpec.getDefaultInstance());
        }

        public List<SearchRequest.BoostSpec.ConditionBoostSpec.Builder> getInvalidConditionBoostSpecsBuilderList() {
            return this.getInvalidConditionBoostSpecsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<SearchRequest.BoostSpec.ConditionBoostSpec, SearchRequest.BoostSpec.ConditionBoostSpec.Builder, SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder> getInvalidConditionBoostSpecsFieldBuilder() {
            if (this.invalidConditionBoostSpecsBuilder_ == null) {
                this.invalidConditionBoostSpecsBuilder_ = new RepeatedFieldBuilderV3(this.invalidConditionBoostSpecs_, (this.bitField0_ & 0x200) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.invalidConditionBoostSpecs_ = null;
            }
            return this.invalidConditionBoostSpecsBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class QueryExpansionInfo
    extends GeneratedMessageV3
    implements QueryExpansionInfoOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int EXPANDED_QUERY_FIELD_NUMBER = 1;
        private boolean expandedQuery_ = false;
        public static final int PINNED_RESULT_COUNT_FIELD_NUMBER = 2;
        private long pinnedResultCount_ = 0L;
        private byte memoizedIsInitialized = (byte)-1;
        private static final QueryExpansionInfo DEFAULT_INSTANCE = new QueryExpansionInfo();
        private static final Parser<QueryExpansionInfo> PARSER = new AbstractParser<QueryExpansionInfo>(){

            public QueryExpansionInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = QueryExpansionInfo.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private QueryExpansionInfo(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private QueryExpansionInfo() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new QueryExpansionInfo();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_QueryExpansionInfo_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_QueryExpansionInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(QueryExpansionInfo.class, Builder.class);
        }

        @Override
        public boolean getExpandedQuery() {
            return this.expandedQuery_;
        }

        @Override
        public long getPinnedResultCount() {
            return this.pinnedResultCount_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.expandedQuery_) {
                output.writeBool(1, this.expandedQuery_);
            }
            if (this.pinnedResultCount_ != 0L) {
                output.writeInt64(2, this.pinnedResultCount_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.expandedQuery_) {
                size += CodedOutputStream.computeBoolSize((int)1, (boolean)this.expandedQuery_);
            }
            if (this.pinnedResultCount_ != 0L) {
                size += CodedOutputStream.computeInt64Size((int)2, (long)this.pinnedResultCount_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof QueryExpansionInfo)) {
                return super.equals(obj);
            }
            QueryExpansionInfo other = (QueryExpansionInfo)obj;
            if (this.getExpandedQuery() != other.getExpandedQuery()) {
                return false;
            }
            if (this.getPinnedResultCount() != other.getPinnedResultCount()) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + QueryExpansionInfo.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + Internal.hashBoolean((boolean)this.getExpandedQuery());
            hash = 37 * hash + 2;
            hash = 53 * hash + Internal.hashLong((long)this.getPinnedResultCount());
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static QueryExpansionInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (QueryExpansionInfo)PARSER.parseFrom(data);
        }

        public static QueryExpansionInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (QueryExpansionInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static QueryExpansionInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (QueryExpansionInfo)PARSER.parseFrom(data);
        }

        public static QueryExpansionInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (QueryExpansionInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static QueryExpansionInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (QueryExpansionInfo)PARSER.parseFrom(data);
        }

        public static QueryExpansionInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (QueryExpansionInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static QueryExpansionInfo parseFrom(InputStream input) throws IOException {
            return (QueryExpansionInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static QueryExpansionInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (QueryExpansionInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static QueryExpansionInfo parseDelimitedFrom(InputStream input) throws IOException {
            return (QueryExpansionInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static QueryExpansionInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (QueryExpansionInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static QueryExpansionInfo parseFrom(CodedInputStream input) throws IOException {
            return (QueryExpansionInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static QueryExpansionInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (QueryExpansionInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return QueryExpansionInfo.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(QueryExpansionInfo prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static QueryExpansionInfo getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<QueryExpansionInfo> parser() {
            return PARSER;
        }

        public Parser<QueryExpansionInfo> getParserForType() {
            return PARSER;
        }

        public QueryExpansionInfo getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements QueryExpansionInfoOrBuilder {
            private int bitField0_;
            private boolean expandedQuery_;
            private long pinnedResultCount_;

            public static final Descriptors.Descriptor getDescriptor() {
                return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_QueryExpansionInfo_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_QueryExpansionInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(QueryExpansionInfo.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.expandedQuery_ = false;
                this.pinnedResultCount_ = 0L;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_QueryExpansionInfo_descriptor;
            }

            public QueryExpansionInfo getDefaultInstanceForType() {
                return QueryExpansionInfo.getDefaultInstance();
            }

            public QueryExpansionInfo build() {
                QueryExpansionInfo result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public QueryExpansionInfo buildPartial() {
                QueryExpansionInfo result = new QueryExpansionInfo(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(QueryExpansionInfo result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.expandedQuery_ = this.expandedQuery_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.pinnedResultCount_ = this.pinnedResultCount_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof QueryExpansionInfo) {
                    return this.mergeFrom((QueryExpansionInfo)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(QueryExpansionInfo other) {
                if (other == QueryExpansionInfo.getDefaultInstance()) {
                    return this;
                }
                if (other.getExpandedQuery()) {
                    this.setExpandedQuery(other.getExpandedQuery());
                }
                if (other.getPinnedResultCount() != 0L) {
                    this.setPinnedResultCount(other.getPinnedResultCount());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 8: {
                                this.expandedQuery_ = input.readBool();
                                this.bitField0_ |= 1;
                                continue block10;
                            }
                            case 16: {
                                this.pinnedResultCount_ = input.readInt64();
                                this.bitField0_ |= 2;
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean getExpandedQuery() {
                return this.expandedQuery_;
            }

            public Builder setExpandedQuery(boolean value) {
                this.expandedQuery_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearExpandedQuery() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.expandedQuery_ = false;
                this.onChanged();
                return this;
            }

            @Override
            public long getPinnedResultCount() {
                return this.pinnedResultCount_;
            }

            public Builder setPinnedResultCount(long value) {
                this.pinnedResultCount_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearPinnedResultCount() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.pinnedResultCount_ = 0L;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface QueryExpansionInfoOrBuilder
    extends MessageOrBuilder {
        public boolean getExpandedQuery();

        public long getPinnedResultCount();
    }

    public static final class Facet
    extends GeneratedMessageV3
    implements FacetOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int KEY_FIELD_NUMBER = 1;
        private volatile Object key_ = "";
        public static final int VALUES_FIELD_NUMBER = 2;
        private List<FacetValue> values_;
        public static final int DYNAMIC_FACET_FIELD_NUMBER = 3;
        private boolean dynamicFacet_ = false;
        private byte memoizedIsInitialized = (byte)-1;
        private static final Facet DEFAULT_INSTANCE = new Facet();
        private static final Parser<Facet> PARSER = new AbstractParser<Facet>(){

            public Facet parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = Facet.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private Facet(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private Facet() {
            this.key_ = "";
            this.values_ = Collections.emptyList();
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new Facet();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_Facet_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_Facet_fieldAccessorTable.ensureFieldAccessorsInitialized(Facet.class, Builder.class);
        }

        @Override
        public String getKey() {
            Object ref = this.key_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.key_ = s;
            return s;
        }

        @Override
        public ByteString getKeyBytes() {
            Object ref = this.key_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.key_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public List<FacetValue> getValuesList() {
            return this.values_;
        }

        @Override
        public List<? extends FacetValueOrBuilder> getValuesOrBuilderList() {
            return this.values_;
        }

        @Override
        public int getValuesCount() {
            return this.values_.size();
        }

        @Override
        public FacetValue getValues(int index) {
            return this.values_.get(index);
        }

        @Override
        public FacetValueOrBuilder getValuesOrBuilder(int index) {
            return this.values_.get(index);
        }

        @Override
        public boolean getDynamicFacet() {
            return this.dynamicFacet_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (!GeneratedMessageV3.isStringEmpty((Object)this.key_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.key_);
            }
            for (int i = 0; i < this.values_.size(); ++i) {
                output.writeMessage(2, (MessageLite)this.values_.get(i));
            }
            if (this.dynamicFacet_) {
                output.writeBool(3, this.dynamicFacet_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!GeneratedMessageV3.isStringEmpty((Object)this.key_)) {
                size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.key_);
            }
            for (int i = 0; i < this.values_.size(); ++i) {
                size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)((MessageLite)this.values_.get(i)));
            }
            if (this.dynamicFacet_) {
                size += CodedOutputStream.computeBoolSize((int)3, (boolean)this.dynamicFacet_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Facet)) {
                return super.equals(obj);
            }
            Facet other = (Facet)obj;
            if (!this.getKey().equals(other.getKey())) {
                return false;
            }
            if (!this.getValuesList().equals(other.getValuesList())) {
                return false;
            }
            if (this.getDynamicFacet() != other.getDynamicFacet()) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + Facet.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getKey().hashCode();
            if (this.getValuesCount() > 0) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getValuesList().hashCode();
            }
            hash = 37 * hash + 3;
            hash = 53 * hash + Internal.hashBoolean((boolean)this.getDynamicFacet());
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static Facet parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (Facet)PARSER.parseFrom(data);
        }

        public static Facet parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Facet)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Facet parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (Facet)PARSER.parseFrom(data);
        }

        public static Facet parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Facet)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Facet parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (Facet)PARSER.parseFrom(data);
        }

        public static Facet parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Facet)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Facet parseFrom(InputStream input) throws IOException {
            return (Facet)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static Facet parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Facet)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Facet parseDelimitedFrom(InputStream input) throws IOException {
            return (Facet)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static Facet parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Facet)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Facet parseFrom(CodedInputStream input) throws IOException {
            return (Facet)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static Facet parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Facet)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return Facet.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(Facet prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static Facet getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<Facet> parser() {
            return PARSER;
        }

        public Parser<Facet> getParserForType() {
            return PARSER;
        }

        public Facet getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements FacetOrBuilder {
            private int bitField0_;
            private Object key_ = "";
            private List<FacetValue> values_ = Collections.emptyList();
            private RepeatedFieldBuilderV3<FacetValue, FacetValue.Builder, FacetValueOrBuilder> valuesBuilder_;
            private boolean dynamicFacet_;

            public static final Descriptors.Descriptor getDescriptor() {
                return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_Facet_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_Facet_fieldAccessorTable.ensureFieldAccessorsInitialized(Facet.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.key_ = "";
                if (this.valuesBuilder_ == null) {
                    this.values_ = Collections.emptyList();
                } else {
                    this.values_ = null;
                    this.valuesBuilder_.clear();
                }
                this.bitField0_ &= 0xFFFFFFFD;
                this.dynamicFacet_ = false;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_Facet_descriptor;
            }

            public Facet getDefaultInstanceForType() {
                return Facet.getDefaultInstance();
            }

            public Facet build() {
                Facet result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public Facet buildPartial() {
                Facet result = new Facet(this);
                this.buildPartialRepeatedFields(result);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartialRepeatedFields(Facet result) {
                if (this.valuesBuilder_ == null) {
                    if ((this.bitField0_ & 2) != 0) {
                        this.values_ = Collections.unmodifiableList(this.values_);
                        this.bitField0_ &= 0xFFFFFFFD;
                    }
                    result.values_ = this.values_;
                } else {
                    result.values_ = this.valuesBuilder_.build();
                }
            }

            private void buildPartial0(Facet result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.key_ = this.key_;
                }
                if ((from_bitField0_ & 4) != 0) {
                    result.dynamicFacet_ = this.dynamicFacet_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof Facet) {
                    return this.mergeFrom((Facet)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(Facet other) {
                if (other == Facet.getDefaultInstance()) {
                    return this;
                }
                if (!other.getKey().isEmpty()) {
                    this.key_ = other.key_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                if (this.valuesBuilder_ == null) {
                    if (!other.values_.isEmpty()) {
                        if (this.values_.isEmpty()) {
                            this.values_ = other.values_;
                            this.bitField0_ &= 0xFFFFFFFD;
                        } else {
                            this.ensureValuesIsMutable();
                            this.values_.addAll(other.values_);
                        }
                        this.onChanged();
                    }
                } else if (!other.values_.isEmpty()) {
                    if (this.valuesBuilder_.isEmpty()) {
                        this.valuesBuilder_.dispose();
                        this.valuesBuilder_ = null;
                        this.values_ = other.values_;
                        this.bitField0_ &= 0xFFFFFFFD;
                        this.valuesBuilder_ = alwaysUseFieldBuilders ? this.getValuesFieldBuilder() : null;
                    } else {
                        this.valuesBuilder_.addAllMessages((Iterable)other.values_);
                    }
                }
                if (other.getDynamicFacet()) {
                    this.setDynamicFacet(other.getDynamicFacet());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block11: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block11;
                            }
                            case 10: {
                                this.key_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block11;
                            }
                            case 18: {
                                FacetValue m = (FacetValue)input.readMessage(FacetValue.parser(), extensionRegistry);
                                if (this.valuesBuilder_ == null) {
                                    this.ensureValuesIsMutable();
                                    this.values_.add(m);
                                    continue block11;
                                }
                                this.valuesBuilder_.addMessage((AbstractMessage)m);
                                continue block11;
                            }
                            case 24: {
                                this.dynamicFacet_ = input.readBool();
                                this.bitField0_ |= 4;
                                continue block11;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public String getKey() {
                Object ref = this.key_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.key_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getKeyBytes() {
                Object ref = this.key_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.key_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setKey(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.key_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearKey() {
                this.key_ = Facet.getDefaultInstance().getKey();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setKeyBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                Facet.checkByteStringIsUtf8((ByteString)value);
                this.key_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            private void ensureValuesIsMutable() {
                if ((this.bitField0_ & 2) == 0) {
                    this.values_ = new ArrayList<FacetValue>(this.values_);
                    this.bitField0_ |= 2;
                }
            }

            @Override
            public List<FacetValue> getValuesList() {
                if (this.valuesBuilder_ == null) {
                    return Collections.unmodifiableList(this.values_);
                }
                return this.valuesBuilder_.getMessageList();
            }

            @Override
            public int getValuesCount() {
                if (this.valuesBuilder_ == null) {
                    return this.values_.size();
                }
                return this.valuesBuilder_.getCount();
            }

            @Override
            public FacetValue getValues(int index) {
                if (this.valuesBuilder_ == null) {
                    return this.values_.get(index);
                }
                return (FacetValue)this.valuesBuilder_.getMessage(index);
            }

            public Builder setValues(int index, FacetValue value) {
                if (this.valuesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureValuesIsMutable();
                    this.values_.set(index, value);
                    this.onChanged();
                } else {
                    this.valuesBuilder_.setMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            public Builder setValues(int index, FacetValue.Builder builderForValue) {
                if (this.valuesBuilder_ == null) {
                    this.ensureValuesIsMutable();
                    this.values_.set(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.valuesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addValues(FacetValue value) {
                if (this.valuesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureValuesIsMutable();
                    this.values_.add(value);
                    this.onChanged();
                } else {
                    this.valuesBuilder_.addMessage((AbstractMessage)value);
                }
                return this;
            }

            public Builder addValues(int index, FacetValue value) {
                if (this.valuesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureValuesIsMutable();
                    this.values_.add(index, value);
                    this.onChanged();
                } else {
                    this.valuesBuilder_.addMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            public Builder addValues(FacetValue.Builder builderForValue) {
                if (this.valuesBuilder_ == null) {
                    this.ensureValuesIsMutable();
                    this.values_.add(builderForValue.build());
                    this.onChanged();
                } else {
                    this.valuesBuilder_.addMessage((AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addValues(int index, FacetValue.Builder builderForValue) {
                if (this.valuesBuilder_ == null) {
                    this.ensureValuesIsMutable();
                    this.values_.add(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.valuesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addAllValues(Iterable<? extends FacetValue> values) {
                if (this.valuesBuilder_ == null) {
                    this.ensureValuesIsMutable();
                    AbstractMessageLite.Builder.addAll(values, this.values_);
                    this.onChanged();
                } else {
                    this.valuesBuilder_.addAllMessages(values);
                }
                return this;
            }

            public Builder clearValues() {
                if (this.valuesBuilder_ == null) {
                    this.values_ = Collections.emptyList();
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.onChanged();
                } else {
                    this.valuesBuilder_.clear();
                }
                return this;
            }

            public Builder removeValues(int index) {
                if (this.valuesBuilder_ == null) {
                    this.ensureValuesIsMutable();
                    this.values_.remove(index);
                    this.onChanged();
                } else {
                    this.valuesBuilder_.remove(index);
                }
                return this;
            }

            public FacetValue.Builder getValuesBuilder(int index) {
                return (FacetValue.Builder)this.getValuesFieldBuilder().getBuilder(index);
            }

            @Override
            public FacetValueOrBuilder getValuesOrBuilder(int index) {
                if (this.valuesBuilder_ == null) {
                    return this.values_.get(index);
                }
                return (FacetValueOrBuilder)this.valuesBuilder_.getMessageOrBuilder(index);
            }

            @Override
            public List<? extends FacetValueOrBuilder> getValuesOrBuilderList() {
                if (this.valuesBuilder_ != null) {
                    return this.valuesBuilder_.getMessageOrBuilderList();
                }
                return Collections.unmodifiableList(this.values_);
            }

            public FacetValue.Builder addValuesBuilder() {
                return (FacetValue.Builder)this.getValuesFieldBuilder().addBuilder((AbstractMessage)FacetValue.getDefaultInstance());
            }

            public FacetValue.Builder addValuesBuilder(int index) {
                return (FacetValue.Builder)this.getValuesFieldBuilder().addBuilder(index, (AbstractMessage)FacetValue.getDefaultInstance());
            }

            public List<FacetValue.Builder> getValuesBuilderList() {
                return this.getValuesFieldBuilder().getBuilderList();
            }

            private RepeatedFieldBuilderV3<FacetValue, FacetValue.Builder, FacetValueOrBuilder> getValuesFieldBuilder() {
                if (this.valuesBuilder_ == null) {
                    this.valuesBuilder_ = new RepeatedFieldBuilderV3(this.values_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.values_ = null;
                }
                return this.valuesBuilder_;
            }

            @Override
            public boolean getDynamicFacet() {
                return this.dynamicFacet_;
            }

            public Builder setDynamicFacet(boolean value) {
                this.dynamicFacet_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder clearDynamicFacet() {
                this.bitField0_ &= 0xFFFFFFFB;
                this.dynamicFacet_ = false;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        public static final class FacetValue
        extends GeneratedMessageV3
        implements FacetValueOrBuilder {
            private static final long serialVersionUID = 0L;
            private int facetValueCase_ = 0;
            private Object facetValue_;
            public static final int VALUE_FIELD_NUMBER = 1;
            public static final int INTERVAL_FIELD_NUMBER = 2;
            public static final int COUNT_FIELD_NUMBER = 3;
            private long count_ = 0L;
            public static final int MIN_VALUE_FIELD_NUMBER = 5;
            private double minValue_ = 0.0;
            public static final int MAX_VALUE_FIELD_NUMBER = 6;
            private double maxValue_ = 0.0;
            private byte memoizedIsInitialized = (byte)-1;
            private static final FacetValue DEFAULT_INSTANCE = new FacetValue();
            private static final Parser<FacetValue> PARSER = new AbstractParser<FacetValue>(){

                public FacetValue parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    Builder builder = FacetValue.newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (IOException e) {
                        throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };

            private FacetValue(GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }

            private FacetValue() {
            }

            protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
                return new FacetValue();
            }

            public final UnknownFieldSet getUnknownFields() {
                return this.unknownFields;
            }

            public static final Descriptors.Descriptor getDescriptor() {
                return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_Facet_FacetValue_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_Facet_FacetValue_fieldAccessorTable.ensureFieldAccessorsInitialized(FacetValue.class, Builder.class);
            }

            @Override
            public FacetValueCase getFacetValueCase() {
                return FacetValueCase.forNumber(this.facetValueCase_);
            }

            @Override
            public boolean hasValue() {
                return this.facetValueCase_ == 1;
            }

            @Override
            public String getValue() {
                Object ref = "";
                if (this.facetValueCase_ == 1) {
                    ref = this.facetValue_;
                }
                if (ref instanceof String) {
                    return (String)ref;
                }
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                if (this.facetValueCase_ == 1) {
                    this.facetValue_ = s;
                }
                return s;
            }

            @Override
            public ByteString getValueBytes() {
                Object ref = "";
                if (this.facetValueCase_ == 1) {
                    ref = this.facetValue_;
                }
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    if (this.facetValueCase_ == 1) {
                        this.facetValue_ = b;
                    }
                    return b;
                }
                return (ByteString)ref;
            }

            @Override
            public boolean hasInterval() {
                return this.facetValueCase_ == 2;
            }

            @Override
            public Interval getInterval() {
                if (this.facetValueCase_ == 2) {
                    return (Interval)this.facetValue_;
                }
                return Interval.getDefaultInstance();
            }

            @Override
            public IntervalOrBuilder getIntervalOrBuilder() {
                if (this.facetValueCase_ == 2) {
                    return (Interval)this.facetValue_;
                }
                return Interval.getDefaultInstance();
            }

            @Override
            public long getCount() {
                return this.count_;
            }

            @Override
            public double getMinValue() {
                return this.minValue_;
            }

            @Override
            public double getMaxValue() {
                return this.maxValue_;
            }

            public final boolean isInitialized() {
                byte isInitialized = this.memoizedIsInitialized;
                if (isInitialized == 1) {
                    return true;
                }
                if (isInitialized == 0) {
                    return false;
                }
                this.memoizedIsInitialized = 1;
                return true;
            }

            public void writeTo(CodedOutputStream output) throws IOException {
                if (this.facetValueCase_ == 1) {
                    GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.facetValue_);
                }
                if (this.facetValueCase_ == 2) {
                    output.writeMessage(2, (MessageLite)((Interval)this.facetValue_));
                }
                if (this.count_ != 0L) {
                    output.writeInt64(3, this.count_);
                }
                if (Double.doubleToRawLongBits(this.minValue_) != 0L) {
                    output.writeDouble(5, this.minValue_);
                }
                if (Double.doubleToRawLongBits(this.maxValue_) != 0L) {
                    output.writeDouble(6, this.maxValue_);
                }
                this.getUnknownFields().writeTo(output);
            }

            public int getSerializedSize() {
                int size = this.memoizedSize;
                if (size != -1) {
                    return size;
                }
                size = 0;
                if (this.facetValueCase_ == 1) {
                    size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.facetValue_);
                }
                if (this.facetValueCase_ == 2) {
                    size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)((Interval)this.facetValue_));
                }
                if (this.count_ != 0L) {
                    size += CodedOutputStream.computeInt64Size((int)3, (long)this.count_);
                }
                if (Double.doubleToRawLongBits(this.minValue_) != 0L) {
                    size += CodedOutputStream.computeDoubleSize((int)5, (double)this.minValue_);
                }
                if (Double.doubleToRawLongBits(this.maxValue_) != 0L) {
                    size += CodedOutputStream.computeDoubleSize((int)6, (double)this.maxValue_);
                }
                this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
                return size;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof FacetValue)) {
                    return super.equals(obj);
                }
                FacetValue other = (FacetValue)obj;
                if (this.getCount() != other.getCount()) {
                    return false;
                }
                if (Double.doubleToLongBits(this.getMinValue()) != Double.doubleToLongBits(other.getMinValue())) {
                    return false;
                }
                if (Double.doubleToLongBits(this.getMaxValue()) != Double.doubleToLongBits(other.getMaxValue())) {
                    return false;
                }
                if (!this.getFacetValueCase().equals((Object)other.getFacetValueCase())) {
                    return false;
                }
                switch (this.facetValueCase_) {
                    case 1: {
                        if (this.getValue().equals(other.getValue())) break;
                        return false;
                    }
                    case 2: {
                        if (this.getInterval().equals(other.getInterval())) break;
                        return false;
                    }
                }
                return this.getUnknownFields().equals((Object)other.getUnknownFields());
            }

            public int hashCode() {
                if (this.memoizedHashCode != 0) {
                    return this.memoizedHashCode;
                }
                int hash = 41;
                hash = 19 * hash + FacetValue.getDescriptor().hashCode();
                hash = 37 * hash + 3;
                hash = 53 * hash + Internal.hashLong((long)this.getCount());
                hash = 37 * hash + 5;
                hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getMinValue()));
                hash = 37 * hash + 6;
                hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getMaxValue()));
                switch (this.facetValueCase_) {
                    case 1: {
                        hash = 37 * hash + 1;
                        hash = 53 * hash + this.getValue().hashCode();
                        break;
                    }
                    case 2: {
                        hash = 37 * hash + 2;
                        hash = 53 * hash + this.getInterval().hashCode();
                        break;
                    }
                }
                this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
                return hash;
            }

            public static FacetValue parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
                return (FacetValue)PARSER.parseFrom(data);
            }

            public static FacetValue parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (FacetValue)PARSER.parseFrom(data, extensionRegistry);
            }

            public static FacetValue parseFrom(ByteString data) throws InvalidProtocolBufferException {
                return (FacetValue)PARSER.parseFrom(data);
            }

            public static FacetValue parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (FacetValue)PARSER.parseFrom(data, extensionRegistry);
            }

            public static FacetValue parseFrom(byte[] data) throws InvalidProtocolBufferException {
                return (FacetValue)PARSER.parseFrom(data);
            }

            public static FacetValue parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (FacetValue)PARSER.parseFrom(data, extensionRegistry);
            }

            public static FacetValue parseFrom(InputStream input) throws IOException {
                return (FacetValue)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
            }

            public static FacetValue parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (FacetValue)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static FacetValue parseDelimitedFrom(InputStream input) throws IOException {
                return (FacetValue)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
            }

            public static FacetValue parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (FacetValue)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static FacetValue parseFrom(CodedInputStream input) throws IOException {
                return (FacetValue)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
            }

            public static FacetValue parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (FacetValue)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public Builder newBuilderForType() {
                return FacetValue.newBuilder();
            }

            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(FacetValue prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }

            public static FacetValue getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            public static Parser<FacetValue> parser() {
                return PARSER;
            }

            public Parser<FacetValue> getParserForType() {
                return PARSER;
            }

            public FacetValue getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

            public static final class Builder
            extends GeneratedMessageV3.Builder<Builder>
            implements FacetValueOrBuilder {
                private int facetValueCase_ = 0;
                private Object facetValue_;
                private int bitField0_;
                private SingleFieldBuilderV3<Interval, Interval.Builder, IntervalOrBuilder> intervalBuilder_;
                private long count_;
                private double minValue_;
                private double maxValue_;

                public static final Descriptors.Descriptor getDescriptor() {
                    return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_Facet_FacetValue_descriptor;
                }

                protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                    return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_Facet_FacetValue_fieldAccessorTable.ensureFieldAccessorsInitialized(FacetValue.class, Builder.class);
                }

                private Builder() {
                }

                private Builder(GeneratedMessageV3.BuilderParent parent) {
                    super(parent);
                }

                public Builder clear() {
                    super.clear();
                    this.bitField0_ = 0;
                    if (this.intervalBuilder_ != null) {
                        this.intervalBuilder_.clear();
                    }
                    this.count_ = 0L;
                    this.minValue_ = 0.0;
                    this.maxValue_ = 0.0;
                    this.facetValueCase_ = 0;
                    this.facetValue_ = null;
                    return this;
                }

                public Descriptors.Descriptor getDescriptorForType() {
                    return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_Facet_FacetValue_descriptor;
                }

                public FacetValue getDefaultInstanceForType() {
                    return FacetValue.getDefaultInstance();
                }

                public FacetValue build() {
                    FacetValue result = this.buildPartial();
                    if (!result.isInitialized()) {
                        throw Builder.newUninitializedMessageException((Message)result);
                    }
                    return result;
                }

                public FacetValue buildPartial() {
                    FacetValue result = new FacetValue(this);
                    if (this.bitField0_ != 0) {
                        this.buildPartial0(result);
                    }
                    this.buildPartialOneofs(result);
                    this.onBuilt();
                    return result;
                }

                private void buildPartial0(FacetValue result) {
                    int from_bitField0_ = this.bitField0_;
                    if ((from_bitField0_ & 4) != 0) {
                        result.count_ = this.count_;
                    }
                    if ((from_bitField0_ & 8) != 0) {
                        result.minValue_ = this.minValue_;
                    }
                    if ((from_bitField0_ & 0x10) != 0) {
                        result.maxValue_ = this.maxValue_;
                    }
                }

                private void buildPartialOneofs(FacetValue result) {
                    result.facetValueCase_ = this.facetValueCase_;
                    result.facetValue_ = this.facetValue_;
                    if (this.facetValueCase_ == 2 && this.intervalBuilder_ != null) {
                        result.facetValue_ = this.intervalBuilder_.build();
                    }
                }

                public Builder clone() {
                    return (Builder)super.clone();
                }

                public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.setField(field, value);
                }

                public Builder clearField(Descriptors.FieldDescriptor field) {
                    return (Builder)super.clearField(field);
                }

                public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                    return (Builder)super.clearOneof(oneof);
                }

                public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                    return (Builder)super.setRepeatedField(field, index, value);
                }

                public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.addRepeatedField(field, value);
                }

                public Builder mergeFrom(Message other) {
                    if (other instanceof FacetValue) {
                        return this.mergeFrom((FacetValue)other);
                    }
                    super.mergeFrom(other);
                    return this;
                }

                public Builder mergeFrom(FacetValue other) {
                    if (other == FacetValue.getDefaultInstance()) {
                        return this;
                    }
                    if (other.getCount() != 0L) {
                        this.setCount(other.getCount());
                    }
                    if (other.getMinValue() != 0.0) {
                        this.setMinValue(other.getMinValue());
                    }
                    if (other.getMaxValue() != 0.0) {
                        this.setMaxValue(other.getMaxValue());
                    }
                    switch (other.getFacetValueCase()) {
                        case VALUE: {
                            this.facetValueCase_ = 1;
                            this.facetValue_ = other.facetValue_;
                            this.onChanged();
                            break;
                        }
                        case INTERVAL: {
                            this.mergeInterval(other.getInterval());
                            break;
                        }
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    this.onChanged();
                    return this;
                }

                public final boolean isInitialized() {
                    return true;
                }

                public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                    if (extensionRegistry == null) {
                        throw new NullPointerException();
                    }
                    try {
                        boolean done = false;
                        block13: while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0: {
                                    done = true;
                                    continue block13;
                                }
                                case 10: {
                                    String s = input.readStringRequireUtf8();
                                    this.facetValueCase_ = 1;
                                    this.facetValue_ = s;
                                    continue block13;
                                }
                                case 18: {
                                    input.readMessage((MessageLite.Builder)this.getIntervalFieldBuilder().getBuilder(), extensionRegistry);
                                    this.facetValueCase_ = 2;
                                    continue block13;
                                }
                                case 24: {
                                    this.count_ = input.readInt64();
                                    this.bitField0_ |= 4;
                                    continue block13;
                                }
                                case 41: {
                                    this.minValue_ = input.readDouble();
                                    this.bitField0_ |= 8;
                                    continue block13;
                                }
                                case 49: {
                                    this.maxValue_ = input.readDouble();
                                    this.bitField0_ |= 0x10;
                                    continue block13;
                                }
                            }
                            if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                            done = true;
                        }
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    }
                    finally {
                        this.onChanged();
                    }
                    return this;
                }

                @Override
                public FacetValueCase getFacetValueCase() {
                    return FacetValueCase.forNumber(this.facetValueCase_);
                }

                public Builder clearFacetValue() {
                    this.facetValueCase_ = 0;
                    this.facetValue_ = null;
                    this.onChanged();
                    return this;
                }

                @Override
                public boolean hasValue() {
                    return this.facetValueCase_ == 1;
                }

                @Override
                public String getValue() {
                    Object ref = "";
                    if (this.facetValueCase_ == 1) {
                        ref = this.facetValue_;
                    }
                    if (!(ref instanceof String)) {
                        ByteString bs = (ByteString)ref;
                        String s = bs.toStringUtf8();
                        if (this.facetValueCase_ == 1) {
                            this.facetValue_ = s;
                        }
                        return s;
                    }
                    return (String)ref;
                }

                @Override
                public ByteString getValueBytes() {
                    Object ref = "";
                    if (this.facetValueCase_ == 1) {
                        ref = this.facetValue_;
                    }
                    if (ref instanceof String) {
                        ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                        if (this.facetValueCase_ == 1) {
                            this.facetValue_ = b;
                        }
                        return b;
                    }
                    return (ByteString)ref;
                }

                public Builder setValue(String value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.facetValueCase_ = 1;
                    this.facetValue_ = value;
                    this.onChanged();
                    return this;
                }

                public Builder clearValue() {
                    if (this.facetValueCase_ == 1) {
                        this.facetValueCase_ = 0;
                        this.facetValue_ = null;
                        this.onChanged();
                    }
                    return this;
                }

                public Builder setValueBytes(ByteString value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    FacetValue.checkByteStringIsUtf8((ByteString)value);
                    this.facetValueCase_ = 1;
                    this.facetValue_ = value;
                    this.onChanged();
                    return this;
                }

                @Override
                public boolean hasInterval() {
                    return this.facetValueCase_ == 2;
                }

                @Override
                public Interval getInterval() {
                    if (this.intervalBuilder_ == null) {
                        if (this.facetValueCase_ == 2) {
                            return (Interval)this.facetValue_;
                        }
                        return Interval.getDefaultInstance();
                    }
                    if (this.facetValueCase_ == 2) {
                        return (Interval)this.intervalBuilder_.getMessage();
                    }
                    return Interval.getDefaultInstance();
                }

                public Builder setInterval(Interval value) {
                    if (this.intervalBuilder_ == null) {
                        if (value == null) {
                            throw new NullPointerException();
                        }
                        this.facetValue_ = value;
                        this.onChanged();
                    } else {
                        this.intervalBuilder_.setMessage((AbstractMessage)value);
                    }
                    this.facetValueCase_ = 2;
                    return this;
                }

                public Builder setInterval(Interval.Builder builderForValue) {
                    if (this.intervalBuilder_ == null) {
                        this.facetValue_ = builderForValue.build();
                        this.onChanged();
                    } else {
                        this.intervalBuilder_.setMessage((AbstractMessage)builderForValue.build());
                    }
                    this.facetValueCase_ = 2;
                    return this;
                }

                public Builder mergeInterval(Interval value) {
                    if (this.intervalBuilder_ == null) {
                        this.facetValue_ = this.facetValueCase_ == 2 && this.facetValue_ != Interval.getDefaultInstance() ? Interval.newBuilder((Interval)this.facetValue_).mergeFrom(value).buildPartial() : value;
                        this.onChanged();
                    } else if (this.facetValueCase_ == 2) {
                        this.intervalBuilder_.mergeFrom((AbstractMessage)value);
                    } else {
                        this.intervalBuilder_.setMessage((AbstractMessage)value);
                    }
                    this.facetValueCase_ = 2;
                    return this;
                }

                public Builder clearInterval() {
                    if (this.intervalBuilder_ == null) {
                        if (this.facetValueCase_ == 2) {
                            this.facetValueCase_ = 0;
                            this.facetValue_ = null;
                            this.onChanged();
                        }
                    } else {
                        if (this.facetValueCase_ == 2) {
                            this.facetValueCase_ = 0;
                            this.facetValue_ = null;
                        }
                        this.intervalBuilder_.clear();
                    }
                    return this;
                }

                public Interval.Builder getIntervalBuilder() {
                    return (Interval.Builder)this.getIntervalFieldBuilder().getBuilder();
                }

                @Override
                public IntervalOrBuilder getIntervalOrBuilder() {
                    if (this.facetValueCase_ == 2 && this.intervalBuilder_ != null) {
                        return (IntervalOrBuilder)this.intervalBuilder_.getMessageOrBuilder();
                    }
                    if (this.facetValueCase_ == 2) {
                        return (Interval)this.facetValue_;
                    }
                    return Interval.getDefaultInstance();
                }

                private SingleFieldBuilderV3<Interval, Interval.Builder, IntervalOrBuilder> getIntervalFieldBuilder() {
                    if (this.intervalBuilder_ == null) {
                        if (this.facetValueCase_ != 2) {
                            this.facetValue_ = Interval.getDefaultInstance();
                        }
                        this.intervalBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((Interval)this.facetValue_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                        this.facetValue_ = null;
                    }
                    this.facetValueCase_ = 2;
                    this.onChanged();
                    return this.intervalBuilder_;
                }

                @Override
                public long getCount() {
                    return this.count_;
                }

                public Builder setCount(long value) {
                    this.count_ = value;
                    this.bitField0_ |= 4;
                    this.onChanged();
                    return this;
                }

                public Builder clearCount() {
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.count_ = 0L;
                    this.onChanged();
                    return this;
                }

                @Override
                public double getMinValue() {
                    return this.minValue_;
                }

                public Builder setMinValue(double value) {
                    this.minValue_ = value;
                    this.bitField0_ |= 8;
                    this.onChanged();
                    return this;
                }

                public Builder clearMinValue() {
                    this.bitField0_ &= 0xFFFFFFF7;
                    this.minValue_ = 0.0;
                    this.onChanged();
                    return this;
                }

                @Override
                public double getMaxValue() {
                    return this.maxValue_;
                }

                public Builder setMaxValue(double value) {
                    this.maxValue_ = value;
                    this.bitField0_ |= 0x10;
                    this.onChanged();
                    return this;
                }

                public Builder clearMaxValue() {
                    this.bitField0_ &= 0xFFFFFFEF;
                    this.maxValue_ = 0.0;
                    this.onChanged();
                    return this;
                }

                public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.setUnknownFields(unknownFields);
                }

                public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.mergeUnknownFields(unknownFields);
                }
            }

            public static enum FacetValueCase implements Internal.EnumLite,
            AbstractMessageLite.InternalOneOfEnum
            {
                VALUE(1),
                INTERVAL(2),
                FACETVALUE_NOT_SET(0);

                private final int value;

                private FacetValueCase(int value) {
                    this.value = value;
                }

                @Deprecated
                public static FacetValueCase valueOf(int value) {
                    return FacetValueCase.forNumber(value);
                }

                public static FacetValueCase forNumber(int value) {
                    switch (value) {
                        case 1: {
                            return VALUE;
                        }
                        case 2: {
                            return INTERVAL;
                        }
                        case 0: {
                            return FACETVALUE_NOT_SET;
                        }
                    }
                    return null;
                }

                public int getNumber() {
                    return this.value;
                }
            }
        }

        public static interface FacetValueOrBuilder
        extends MessageOrBuilder {
            public boolean hasValue();

            public String getValue();

            public ByteString getValueBytes();

            public boolean hasInterval();

            public Interval getInterval();

            public IntervalOrBuilder getIntervalOrBuilder();

            public long getCount();

            public double getMinValue();

            public double getMaxValue();

            public FacetValue.FacetValueCase getFacetValueCase();
        }
    }

    public static interface FacetOrBuilder
    extends MessageOrBuilder {
        public String getKey();

        public ByteString getKeyBytes();

        public List<Facet.FacetValue> getValuesList();

        public Facet.FacetValue getValues(int var1);

        public int getValuesCount();

        public List<? extends Facet.FacetValueOrBuilder> getValuesOrBuilderList();

        public Facet.FacetValueOrBuilder getValuesOrBuilder(int var1);

        public boolean getDynamicFacet();
    }

    public static final class SearchResult
    extends GeneratedMessageV3
    implements SearchResultOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int ID_FIELD_NUMBER = 1;
        private volatile Object id_ = "";
        public static final int PRODUCT_FIELD_NUMBER = 2;
        private Product product_;
        public static final int MATCHING_VARIANT_COUNT_FIELD_NUMBER = 3;
        private int matchingVariantCount_ = 0;
        public static final int MATCHING_VARIANT_FIELDS_FIELD_NUMBER = 4;
        private MapField<String, FieldMask> matchingVariantFields_;
        public static final int VARIANT_ROLLUP_VALUES_FIELD_NUMBER = 5;
        private MapField<String, Value> variantRollupValues_;
        public static final int PERSONAL_LABELS_FIELD_NUMBER = 7;
        private LazyStringList personalLabels_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final SearchResult DEFAULT_INSTANCE = new SearchResult();
        private static final Parser<SearchResult> PARSER = new AbstractParser<SearchResult>(){

            public SearchResult parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = SearchResult.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private SearchResult(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private SearchResult() {
            this.id_ = "";
            this.personalLabels_ = LazyStringArrayList.EMPTY;
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new SearchResult();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_SearchResult_descriptor;
        }

        protected MapField internalGetMapField(int number) {
            switch (number) {
                case 4: {
                    return this.internalGetMatchingVariantFields();
                }
                case 5: {
                    return this.internalGetVariantRollupValues();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_SearchResult_fieldAccessorTable.ensureFieldAccessorsInitialized(SearchResult.class, Builder.class);
        }

        @Override
        public String getId() {
            Object ref = this.id_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.id_ = s;
            return s;
        }

        @Override
        public ByteString getIdBytes() {
            Object ref = this.id_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.id_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public boolean hasProduct() {
            return this.product_ != null;
        }

        @Override
        public Product getProduct() {
            return this.product_ == null ? Product.getDefaultInstance() : this.product_;
        }

        @Override
        public ProductOrBuilder getProductOrBuilder() {
            return this.product_ == null ? Product.getDefaultInstance() : this.product_;
        }

        @Override
        public int getMatchingVariantCount() {
            return this.matchingVariantCount_;
        }

        private MapField<String, FieldMask> internalGetMatchingVariantFields() {
            if (this.matchingVariantFields_ == null) {
                return MapField.emptyMapField(MatchingVariantFieldsDefaultEntryHolder.defaultEntry);
            }
            return this.matchingVariantFields_;
        }

        @Override
        public int getMatchingVariantFieldsCount() {
            return this.internalGetMatchingVariantFields().getMap().size();
        }

        @Override
        public boolean containsMatchingVariantFields(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetMatchingVariantFields().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, FieldMask> getMatchingVariantFields() {
            return this.getMatchingVariantFieldsMap();
        }

        @Override
        public Map<String, FieldMask> getMatchingVariantFieldsMap() {
            return this.internalGetMatchingVariantFields().getMap();
        }

        @Override
        public FieldMask getMatchingVariantFieldsOrDefault(String key, FieldMask defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetMatchingVariantFields().getMap();
            return map.containsKey(key) ? (FieldMask)map.get(key) : defaultValue;
        }

        @Override
        public FieldMask getMatchingVariantFieldsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetMatchingVariantFields().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (FieldMask)map.get(key);
        }

        private MapField<String, Value> internalGetVariantRollupValues() {
            if (this.variantRollupValues_ == null) {
                return MapField.emptyMapField(VariantRollupValuesDefaultEntryHolder.defaultEntry);
            }
            return this.variantRollupValues_;
        }

        @Override
        public int getVariantRollupValuesCount() {
            return this.internalGetVariantRollupValues().getMap().size();
        }

        @Override
        public boolean containsVariantRollupValues(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetVariantRollupValues().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, Value> getVariantRollupValues() {
            return this.getVariantRollupValuesMap();
        }

        @Override
        public Map<String, Value> getVariantRollupValuesMap() {
            return this.internalGetVariantRollupValues().getMap();
        }

        @Override
        public Value getVariantRollupValuesOrDefault(String key, Value defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetVariantRollupValues().getMap();
            return map.containsKey(key) ? (Value)map.get(key) : defaultValue;
        }

        @Override
        public Value getVariantRollupValuesOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetVariantRollupValues().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (Value)map.get(key);
        }

        public ProtocolStringList getPersonalLabelsList() {
            return this.personalLabels_;
        }

        @Override
        public int getPersonalLabelsCount() {
            return this.personalLabels_.size();
        }

        @Override
        public String getPersonalLabels(int index) {
            return (String)this.personalLabels_.get(index);
        }

        @Override
        public ByteString getPersonalLabelsBytes(int index) {
            return this.personalLabels_.getByteString(index);
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (!GeneratedMessageV3.isStringEmpty((Object)this.id_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.id_);
            }
            if (this.product_ != null) {
                output.writeMessage(2, (MessageLite)this.getProduct());
            }
            if (this.matchingVariantCount_ != 0) {
                output.writeInt32(3, this.matchingVariantCount_);
            }
            GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetMatchingVariantFields(), MatchingVariantFieldsDefaultEntryHolder.defaultEntry, (int)4);
            GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetVariantRollupValues(), VariantRollupValuesDefaultEntryHolder.defaultEntry, (int)5);
            for (int i = 0; i < this.personalLabels_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.personalLabels_.getRaw(i));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!GeneratedMessageV3.isStringEmpty((Object)this.id_)) {
                size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.id_);
            }
            if (this.product_ != null) {
                size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getProduct());
            }
            if (this.matchingVariantCount_ != 0) {
                size += CodedOutputStream.computeInt32Size((int)3, (int)this.matchingVariantCount_);
            }
            for (Map.Entry entry : this.internalGetMatchingVariantFields().getMap().entrySet()) {
                MapEntry matchingVariantFields__ = MatchingVariantFieldsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
                size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)matchingVariantFields__);
            }
            for (Map.Entry entry : this.internalGetVariantRollupValues().getMap().entrySet()) {
                MapEntry variantRollupValues__ = VariantRollupValuesDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
                size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)variantRollupValues__);
            }
            int dataSize = 0;
            for (int i = 0; i < this.personalLabels_.size(); ++i) {
                dataSize += SearchResult.computeStringSizeNoTag((Object)this.personalLabels_.getRaw(i));
            }
            size += dataSize;
            size += 1 * this.getPersonalLabelsList().size();
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SearchResult)) {
                return super.equals(obj);
            }
            SearchResult other = (SearchResult)obj;
            if (!this.getId().equals(other.getId())) {
                return false;
            }
            if (this.hasProduct() != other.hasProduct()) {
                return false;
            }
            if (this.hasProduct() && !this.getProduct().equals(other.getProduct())) {
                return false;
            }
            if (this.getMatchingVariantCount() != other.getMatchingVariantCount()) {
                return false;
            }
            if (!this.internalGetMatchingVariantFields().equals(other.internalGetMatchingVariantFields())) {
                return false;
            }
            if (!this.internalGetVariantRollupValues().equals(other.internalGetVariantRollupValues())) {
                return false;
            }
            if (!this.getPersonalLabelsList().equals(other.getPersonalLabelsList())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + SearchResult.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getId().hashCode();
            if (this.hasProduct()) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getProduct().hashCode();
            }
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getMatchingVariantCount();
            if (!this.internalGetMatchingVariantFields().getMap().isEmpty()) {
                hash = 37 * hash + 4;
                hash = 53 * hash + this.internalGetMatchingVariantFields().hashCode();
            }
            if (!this.internalGetVariantRollupValues().getMap().isEmpty()) {
                hash = 37 * hash + 5;
                hash = 53 * hash + this.internalGetVariantRollupValues().hashCode();
            }
            if (this.getPersonalLabelsCount() > 0) {
                hash = 37 * hash + 7;
                hash = 53 * hash + this.getPersonalLabelsList().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static SearchResult parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (SearchResult)PARSER.parseFrom(data);
        }

        public static SearchResult parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (SearchResult)PARSER.parseFrom(data, extensionRegistry);
        }

        public static SearchResult parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (SearchResult)PARSER.parseFrom(data);
        }

        public static SearchResult parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (SearchResult)PARSER.parseFrom(data, extensionRegistry);
        }

        public static SearchResult parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (SearchResult)PARSER.parseFrom(data);
        }

        public static SearchResult parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (SearchResult)PARSER.parseFrom(data, extensionRegistry);
        }

        public static SearchResult parseFrom(InputStream input) throws IOException {
            return (SearchResult)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static SearchResult parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (SearchResult)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static SearchResult parseDelimitedFrom(InputStream input) throws IOException {
            return (SearchResult)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static SearchResult parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (SearchResult)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static SearchResult parseFrom(CodedInputStream input) throws IOException {
            return (SearchResult)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static SearchResult parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (SearchResult)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return SearchResult.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(SearchResult prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static SearchResult getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<SearchResult> parser() {
            return PARSER;
        }

        public Parser<SearchResult> getParserForType() {
            return PARSER;
        }

        public SearchResult getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements SearchResultOrBuilder {
            private int bitField0_;
            private Object id_ = "";
            private Product product_;
            private SingleFieldBuilderV3<Product, Product.Builder, ProductOrBuilder> productBuilder_;
            private int matchingVariantCount_;
            private MapField<String, FieldMask> matchingVariantFields_;
            private MapField<String, Value> variantRollupValues_;
            private LazyStringList personalLabels_ = LazyStringArrayList.EMPTY;

            public static final Descriptors.Descriptor getDescriptor() {
                return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_SearchResult_descriptor;
            }

            protected MapField internalGetMapField(int number) {
                switch (number) {
                    case 4: {
                        return this.internalGetMatchingVariantFields();
                    }
                    case 5: {
                        return this.internalGetVariantRollupValues();
                    }
                }
                throw new RuntimeException("Invalid map field number: " + number);
            }

            protected MapField internalGetMutableMapField(int number) {
                switch (number) {
                    case 4: {
                        return this.internalGetMutableMatchingVariantFields();
                    }
                    case 5: {
                        return this.internalGetMutableVariantRollupValues();
                    }
                }
                throw new RuntimeException("Invalid map field number: " + number);
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_SearchResult_fieldAccessorTable.ensureFieldAccessorsInitialized(SearchResult.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.id_ = "";
                this.product_ = null;
                if (this.productBuilder_ != null) {
                    this.productBuilder_.dispose();
                    this.productBuilder_ = null;
                }
                this.matchingVariantCount_ = 0;
                this.internalGetMutableMatchingVariantFields().clear();
                this.internalGetMutableVariantRollupValues().clear();
                this.personalLabels_ = LazyStringArrayList.EMPTY;
                this.bitField0_ &= 0xFFFFFFDF;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_SearchResult_descriptor;
            }

            public SearchResult getDefaultInstanceForType() {
                return SearchResult.getDefaultInstance();
            }

            public SearchResult build() {
                SearchResult result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public SearchResult buildPartial() {
                SearchResult result = new SearchResult(this);
                this.buildPartialRepeatedFields(result);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartialRepeatedFields(SearchResult result) {
                if ((this.bitField0_ & 0x20) != 0) {
                    this.personalLabels_ = this.personalLabels_.getUnmodifiableView();
                    this.bitField0_ &= 0xFFFFFFDF;
                }
                result.personalLabels_ = this.personalLabels_;
            }

            private void buildPartial0(SearchResult result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.id_ = this.id_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.product_ = this.productBuilder_ == null ? this.product_ : (Product)this.productBuilder_.build();
                }
                if ((from_bitField0_ & 4) != 0) {
                    result.matchingVariantCount_ = this.matchingVariantCount_;
                }
                if ((from_bitField0_ & 8) != 0) {
                    result.matchingVariantFields_ = this.internalGetMatchingVariantFields();
                    result.matchingVariantFields_.makeImmutable();
                }
                if ((from_bitField0_ & 0x10) != 0) {
                    result.variantRollupValues_ = this.internalGetVariantRollupValues();
                    result.variantRollupValues_.makeImmutable();
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof SearchResult) {
                    return this.mergeFrom((SearchResult)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(SearchResult other) {
                if (other == SearchResult.getDefaultInstance()) {
                    return this;
                }
                if (!other.getId().isEmpty()) {
                    this.id_ = other.id_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                if (other.hasProduct()) {
                    this.mergeProduct(other.getProduct());
                }
                if (other.getMatchingVariantCount() != 0) {
                    this.setMatchingVariantCount(other.getMatchingVariantCount());
                }
                this.internalGetMutableMatchingVariantFields().mergeFrom(other.internalGetMatchingVariantFields());
                this.bitField0_ |= 8;
                this.internalGetMutableVariantRollupValues().mergeFrom(other.internalGetVariantRollupValues());
                this.bitField0_ |= 0x10;
                if (!other.personalLabels_.isEmpty()) {
                    if (this.personalLabels_.isEmpty()) {
                        this.personalLabels_ = other.personalLabels_;
                        this.bitField0_ &= 0xFFFFFFDF;
                    } else {
                        this.ensurePersonalLabelsIsMutable();
                        this.personalLabels_.addAll((Collection)other.personalLabels_);
                    }
                    this.onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block14: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block14;
                            }
                            case 10: {
                                this.id_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block14;
                            }
                            case 18: {
                                input.readMessage((MessageLite.Builder)this.getProductFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 2;
                                continue block14;
                            }
                            case 24: {
                                this.matchingVariantCount_ = input.readInt32();
                                this.bitField0_ |= 4;
                                continue block14;
                            }
                            case 34: {
                                MapEntry matchingVariantFields__ = (MapEntry)input.readMessage(MatchingVariantFieldsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                                this.internalGetMutableMatchingVariantFields().getMutableMap().put(matchingVariantFields__.getKey(), matchingVariantFields__.getValue());
                                this.bitField0_ |= 8;
                                continue block14;
                            }
                            case 42: {
                                MapEntry variantRollupValues__ = (MapEntry)input.readMessage(VariantRollupValuesDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                                this.internalGetMutableVariantRollupValues().getMutableMap().put(variantRollupValues__.getKey(), variantRollupValues__.getValue());
                                this.bitField0_ |= 0x10;
                                continue block14;
                            }
                            case 58: {
                                String s = input.readStringRequireUtf8();
                                this.ensurePersonalLabelsIsMutable();
                                this.personalLabels_.add((Object)s);
                                continue block14;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public String getId() {
                Object ref = this.id_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.id_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getIdBytes() {
                Object ref = this.id_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.id_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setId(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.id_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearId() {
                this.id_ = SearchResult.getDefaultInstance().getId();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setIdBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                SearchResult.checkByteStringIsUtf8((ByteString)value);
                this.id_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasProduct() {
                return (this.bitField0_ & 2) != 0;
            }

            @Override
            public Product getProduct() {
                if (this.productBuilder_ == null) {
                    return this.product_ == null ? Product.getDefaultInstance() : this.product_;
                }
                return (Product)this.productBuilder_.getMessage();
            }

            public Builder setProduct(Product value) {
                if (this.productBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.product_ = value;
                } else {
                    this.productBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder setProduct(Product.Builder builderForValue) {
                if (this.productBuilder_ == null) {
                    this.product_ = builderForValue.build();
                } else {
                    this.productBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder mergeProduct(Product value) {
                if (this.productBuilder_ == null) {
                    if ((this.bitField0_ & 2) != 0 && this.product_ != null && this.product_ != Product.getDefaultInstance()) {
                        this.getProductBuilder().mergeFrom(value);
                    } else {
                        this.product_ = value;
                    }
                } else {
                    this.productBuilder_.mergeFrom((AbstractMessage)value);
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearProduct() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.product_ = null;
                if (this.productBuilder_ != null) {
                    this.productBuilder_.dispose();
                    this.productBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public Product.Builder getProductBuilder() {
                this.bitField0_ |= 2;
                this.onChanged();
                return (Product.Builder)this.getProductFieldBuilder().getBuilder();
            }

            @Override
            public ProductOrBuilder getProductOrBuilder() {
                if (this.productBuilder_ != null) {
                    return (ProductOrBuilder)this.productBuilder_.getMessageOrBuilder();
                }
                return this.product_ == null ? Product.getDefaultInstance() : this.product_;
            }

            private SingleFieldBuilderV3<Product, Product.Builder, ProductOrBuilder> getProductFieldBuilder() {
                if (this.productBuilder_ == null) {
                    this.productBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getProduct(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.product_ = null;
                }
                return this.productBuilder_;
            }

            @Override
            public int getMatchingVariantCount() {
                return this.matchingVariantCount_;
            }

            public Builder setMatchingVariantCount(int value) {
                this.matchingVariantCount_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder clearMatchingVariantCount() {
                this.bitField0_ &= 0xFFFFFFFB;
                this.matchingVariantCount_ = 0;
                this.onChanged();
                return this;
            }

            private MapField<String, FieldMask> internalGetMatchingVariantFields() {
                if (this.matchingVariantFields_ == null) {
                    return MapField.emptyMapField(MatchingVariantFieldsDefaultEntryHolder.defaultEntry);
                }
                return this.matchingVariantFields_;
            }

            private MapField<String, FieldMask> internalGetMutableMatchingVariantFields() {
                if (this.matchingVariantFields_ == null) {
                    this.matchingVariantFields_ = MapField.newMapField(MatchingVariantFieldsDefaultEntryHolder.defaultEntry);
                }
                if (!this.matchingVariantFields_.isMutable()) {
                    this.matchingVariantFields_ = this.matchingVariantFields_.copy();
                }
                this.bitField0_ |= 8;
                this.onChanged();
                return this.matchingVariantFields_;
            }

            @Override
            public int getMatchingVariantFieldsCount() {
                return this.internalGetMatchingVariantFields().getMap().size();
            }

            @Override
            public boolean containsMatchingVariantFields(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                return this.internalGetMatchingVariantFields().getMap().containsKey(key);
            }

            @Override
            @Deprecated
            public Map<String, FieldMask> getMatchingVariantFields() {
                return this.getMatchingVariantFieldsMap();
            }

            @Override
            public Map<String, FieldMask> getMatchingVariantFieldsMap() {
                return this.internalGetMatchingVariantFields().getMap();
            }

            @Override
            public FieldMask getMatchingVariantFieldsOrDefault(String key, FieldMask defaultValue) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                Map map = this.internalGetMatchingVariantFields().getMap();
                return map.containsKey(key) ? (FieldMask)map.get(key) : defaultValue;
            }

            @Override
            public FieldMask getMatchingVariantFieldsOrThrow(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                Map map = this.internalGetMatchingVariantFields().getMap();
                if (!map.containsKey(key)) {
                    throw new IllegalArgumentException();
                }
                return (FieldMask)map.get(key);
            }

            public Builder clearMatchingVariantFields() {
                this.bitField0_ &= 0xFFFFFFF7;
                this.internalGetMutableMatchingVariantFields().getMutableMap().clear();
                return this;
            }

            public Builder removeMatchingVariantFields(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                this.internalGetMutableMatchingVariantFields().getMutableMap().remove(key);
                return this;
            }

            @Deprecated
            public Map<String, FieldMask> getMutableMatchingVariantFields() {
                this.bitField0_ |= 8;
                return this.internalGetMutableMatchingVariantFields().getMutableMap();
            }

            public Builder putMatchingVariantFields(String key, FieldMask value) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                if (value == null) {
                    throw new NullPointerException("map value");
                }
                this.internalGetMutableMatchingVariantFields().getMutableMap().put(key, value);
                this.bitField0_ |= 8;
                return this;
            }

            public Builder putAllMatchingVariantFields(Map<String, FieldMask> values) {
                this.internalGetMutableMatchingVariantFields().getMutableMap().putAll(values);
                this.bitField0_ |= 8;
                return this;
            }

            private MapField<String, Value> internalGetVariantRollupValues() {
                if (this.variantRollupValues_ == null) {
                    return MapField.emptyMapField(VariantRollupValuesDefaultEntryHolder.defaultEntry);
                }
                return this.variantRollupValues_;
            }

            private MapField<String, Value> internalGetMutableVariantRollupValues() {
                if (this.variantRollupValues_ == null) {
                    this.variantRollupValues_ = MapField.newMapField(VariantRollupValuesDefaultEntryHolder.defaultEntry);
                }
                if (!this.variantRollupValues_.isMutable()) {
                    this.variantRollupValues_ = this.variantRollupValues_.copy();
                }
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this.variantRollupValues_;
            }

            @Override
            public int getVariantRollupValuesCount() {
                return this.internalGetVariantRollupValues().getMap().size();
            }

            @Override
            public boolean containsVariantRollupValues(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                return this.internalGetVariantRollupValues().getMap().containsKey(key);
            }

            @Override
            @Deprecated
            public Map<String, Value> getVariantRollupValues() {
                return this.getVariantRollupValuesMap();
            }

            @Override
            public Map<String, Value> getVariantRollupValuesMap() {
                return this.internalGetVariantRollupValues().getMap();
            }

            @Override
            public Value getVariantRollupValuesOrDefault(String key, Value defaultValue) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                Map map = this.internalGetVariantRollupValues().getMap();
                return map.containsKey(key) ? (Value)map.get(key) : defaultValue;
            }

            @Override
            public Value getVariantRollupValuesOrThrow(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                Map map = this.internalGetVariantRollupValues().getMap();
                if (!map.containsKey(key)) {
                    throw new IllegalArgumentException();
                }
                return (Value)map.get(key);
            }

            public Builder clearVariantRollupValues() {
                this.bitField0_ &= 0xFFFFFFEF;
                this.internalGetMutableVariantRollupValues().getMutableMap().clear();
                return this;
            }

            public Builder removeVariantRollupValues(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                this.internalGetMutableVariantRollupValues().getMutableMap().remove(key);
                return this;
            }

            @Deprecated
            public Map<String, Value> getMutableVariantRollupValues() {
                this.bitField0_ |= 0x10;
                return this.internalGetMutableVariantRollupValues().getMutableMap();
            }

            public Builder putVariantRollupValues(String key, Value value) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                if (value == null) {
                    throw new NullPointerException("map value");
                }
                this.internalGetMutableVariantRollupValues().getMutableMap().put(key, value);
                this.bitField0_ |= 0x10;
                return this;
            }

            public Builder putAllVariantRollupValues(Map<String, Value> values) {
                this.internalGetMutableVariantRollupValues().getMutableMap().putAll(values);
                this.bitField0_ |= 0x10;
                return this;
            }

            private void ensurePersonalLabelsIsMutable() {
                if ((this.bitField0_ & 0x20) == 0) {
                    this.personalLabels_ = new LazyStringArrayList(this.personalLabels_);
                    this.bitField0_ |= 0x20;
                }
            }

            public ProtocolStringList getPersonalLabelsList() {
                return this.personalLabels_.getUnmodifiableView();
            }

            @Override
            public int getPersonalLabelsCount() {
                return this.personalLabels_.size();
            }

            @Override
            public String getPersonalLabels(int index) {
                return (String)this.personalLabels_.get(index);
            }

            @Override
            public ByteString getPersonalLabelsBytes(int index) {
                return this.personalLabels_.getByteString(index);
            }

            public Builder setPersonalLabels(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePersonalLabelsIsMutable();
                this.personalLabels_.set(index, (Object)value);
                this.onChanged();
                return this;
            }

            public Builder addPersonalLabels(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePersonalLabelsIsMutable();
                this.personalLabels_.add((Object)value);
                this.onChanged();
                return this;
            }

            public Builder addAllPersonalLabels(Iterable<String> values) {
                this.ensurePersonalLabelsIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.personalLabels_);
                this.onChanged();
                return this;
            }

            public Builder clearPersonalLabels() {
                this.personalLabels_ = LazyStringArrayList.EMPTY;
                this.bitField0_ &= 0xFFFFFFDF;
                this.onChanged();
                return this;
            }

            public Builder addPersonalLabelsBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                SearchResult.checkByteStringIsUtf8((ByteString)value);
                this.ensurePersonalLabelsIsMutable();
                this.personalLabels_.add(value);
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        private static final class VariantRollupValuesDefaultEntryHolder {
            static final MapEntry<String, Value> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_SearchResult_VariantRollupValuesEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.MESSAGE, (Object)Value.getDefaultInstance());

            private VariantRollupValuesDefaultEntryHolder() {
            }
        }

        private static final class MatchingVariantFieldsDefaultEntryHolder {
            static final MapEntry<String, FieldMask> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)SearchServiceProto.internal_static_google_cloud_retail_v2alpha_SearchResponse_SearchResult_MatchingVariantFieldsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.MESSAGE, (Object)FieldMask.getDefaultInstance());

            private MatchingVariantFieldsDefaultEntryHolder() {
            }
        }
    }

    public static interface SearchResultOrBuilder
    extends MessageOrBuilder {
        public String getId();

        public ByteString getIdBytes();

        public boolean hasProduct();

        public Product getProduct();

        public ProductOrBuilder getProductOrBuilder();

        public int getMatchingVariantCount();

        public int getMatchingVariantFieldsCount();

        public boolean containsMatchingVariantFields(String var1);

        @Deprecated
        public Map<String, FieldMask> getMatchingVariantFields();

        public Map<String, FieldMask> getMatchingVariantFieldsMap();

        public FieldMask getMatchingVariantFieldsOrDefault(String var1, FieldMask var2);

        public FieldMask getMatchingVariantFieldsOrThrow(String var1);

        public int getVariantRollupValuesCount();

        public boolean containsVariantRollupValues(String var1);

        @Deprecated
        public Map<String, Value> getVariantRollupValues();

        public Map<String, Value> getVariantRollupValuesMap();

        public Value getVariantRollupValuesOrDefault(String var1, Value var2);

        public Value getVariantRollupValuesOrThrow(String var1);

        public List<String> getPersonalLabelsList();

        public int getPersonalLabelsCount();

        public String getPersonalLabels(int var1);

        public ByteString getPersonalLabelsBytes(int var1);
    }
}

