/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2;

import com.google.cloud.retail.v2.AttributeConfigLevel;
import com.google.cloud.retail.v2.AttributesConfigOrBuilder;
import com.google.cloud.retail.v2.CatalogAttribute;
import com.google.cloud.retail.v2.CatalogAttributeOrBuilder;
import com.google.cloud.retail.v2.CatalogProto;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.MapFieldBuilder;
import com.google.protobuf.MapFieldReflectionAccessor;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public final class AttributesConfig
extends GeneratedMessageV3
implements AttributesConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int CATALOG_ATTRIBUTES_FIELD_NUMBER = 2;
    private MapField<String, CatalogAttribute> catalogAttributes_;
    public static final int ATTRIBUTE_CONFIG_LEVEL_FIELD_NUMBER = 3;
    private int attributeConfigLevel_ = 0;
    private byte memoizedIsInitialized = (byte)-1;
    private static final AttributesConfig DEFAULT_INSTANCE = new AttributesConfig();
    private static final Parser<AttributesConfig> PARSER = new AbstractParser<AttributesConfig>(){

        public AttributesConfig parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = AttributesConfig.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private AttributesConfig(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private AttributesConfig() {
        this.name_ = "";
        this.attributeConfigLevel_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new AttributesConfig();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return CatalogProto.internal_static_google_cloud_retail_v2_AttributesConfig_descriptor;
    }

    protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
        switch (number) {
            case 2: {
                return this.internalGetCatalogAttributes();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return CatalogProto.internal_static_google_cloud_retail_v2_AttributesConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(AttributesConfig.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    private MapField<String, CatalogAttribute> internalGetCatalogAttributes() {
        if (this.catalogAttributes_ == null) {
            return MapField.emptyMapField(CatalogAttributesDefaultEntryHolder.defaultEntry);
        }
        return this.catalogAttributes_;
    }

    @Override
    public int getCatalogAttributesCount() {
        return this.internalGetCatalogAttributes().getMap().size();
    }

    @Override
    public boolean containsCatalogAttributes(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetCatalogAttributes().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, CatalogAttribute> getCatalogAttributes() {
        return this.getCatalogAttributesMap();
    }

    @Override
    public Map<String, CatalogAttribute> getCatalogAttributesMap() {
        return this.internalGetCatalogAttributes().getMap();
    }

    @Override
    public CatalogAttribute getCatalogAttributesOrDefault(String key, CatalogAttribute defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetCatalogAttributes().getMap();
        return map.containsKey(key) ? (CatalogAttribute)map.get(key) : defaultValue;
    }

    @Override
    public CatalogAttribute getCatalogAttributesOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetCatalogAttributes().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (CatalogAttribute)map.get(key);
    }

    @Override
    public int getAttributeConfigLevelValue() {
        return this.attributeConfigLevel_;
    }

    @Override
    public AttributeConfigLevel getAttributeConfigLevel() {
        AttributeConfigLevel result = AttributeConfigLevel.forNumber(this.attributeConfigLevel_);
        return result == null ? AttributeConfigLevel.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetCatalogAttributes(), CatalogAttributesDefaultEntryHolder.defaultEntry, (int)2);
        if (this.attributeConfigLevel_ != AttributeConfigLevel.ATTRIBUTE_CONFIG_LEVEL_UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.attributeConfigLevel_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        for (Map.Entry entry : this.internalGetCatalogAttributes().getMap().entrySet()) {
            MapEntry catalogAttributes__ = CatalogAttributesDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)catalogAttributes__);
        }
        if (this.attributeConfigLevel_ != AttributeConfigLevel.ATTRIBUTE_CONFIG_LEVEL_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.attributeConfigLevel_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AttributesConfig)) {
            return super.equals(obj);
        }
        AttributesConfig other = (AttributesConfig)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.internalGetCatalogAttributes().equals(other.internalGetCatalogAttributes())) {
            return false;
        }
        if (this.attributeConfigLevel_ != other.attributeConfigLevel_) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + AttributesConfig.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        if (!this.internalGetCatalogAttributes().getMap().isEmpty()) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.internalGetCatalogAttributes().hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + this.attributeConfigLevel_;
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static AttributesConfig parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (AttributesConfig)PARSER.parseFrom(data);
    }

    public static AttributesConfig parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AttributesConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AttributesConfig parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (AttributesConfig)PARSER.parseFrom(data);
    }

    public static AttributesConfig parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AttributesConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AttributesConfig parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (AttributesConfig)PARSER.parseFrom(data);
    }

    public static AttributesConfig parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AttributesConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AttributesConfig parseFrom(InputStream input) throws IOException {
        return (AttributesConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static AttributesConfig parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AttributesConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AttributesConfig parseDelimitedFrom(InputStream input) throws IOException {
        return (AttributesConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static AttributesConfig parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AttributesConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AttributesConfig parseFrom(CodedInputStream input) throws IOException {
        return (AttributesConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static AttributesConfig parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AttributesConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return AttributesConfig.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AttributesConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static AttributesConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<AttributesConfig> parser() {
        return PARSER;
    }

    public Parser<AttributesConfig> getParserForType() {
        return PARSER;
    }

    public AttributesConfig getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements AttributesConfigOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private static final CatalogAttributesConverter catalogAttributesConverter = new CatalogAttributesConverter();
        private MapFieldBuilder<String, CatalogAttributeOrBuilder, CatalogAttribute, CatalogAttribute.Builder> catalogAttributes_;
        private int attributeConfigLevel_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return CatalogProto.internal_static_google_cloud_retail_v2_AttributesConfig_descriptor;
        }

        protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
            switch (number) {
                case 2: {
                    return this.internalGetCatalogAttributes();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapFieldReflectionAccessor internalGetMutableMapFieldReflection(int number) {
            switch (number) {
                case 2: {
                    return this.internalGetMutableCatalogAttributes();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CatalogProto.internal_static_google_cloud_retail_v2_AttributesConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(AttributesConfig.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.name_ = "";
            this.internalGetMutableCatalogAttributes().clear();
            this.attributeConfigLevel_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return CatalogProto.internal_static_google_cloud_retail_v2_AttributesConfig_descriptor;
        }

        public AttributesConfig getDefaultInstanceForType() {
            return AttributesConfig.getDefaultInstance();
        }

        public AttributesConfig build() {
            AttributesConfig result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public AttributesConfig buildPartial() {
            AttributesConfig result = new AttributesConfig(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartial0(AttributesConfig result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.catalogAttributes_ = this.internalGetCatalogAttributes().build(CatalogAttributesDefaultEntryHolder.defaultEntry);
            }
            if ((from_bitField0_ & 4) != 0) {
                result.attributeConfigLevel_ = this.attributeConfigLevel_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof AttributesConfig) {
                return this.mergeFrom((AttributesConfig)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(AttributesConfig other) {
            if (other == AttributesConfig.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            this.internalGetMutableCatalogAttributes().mergeFrom(other.internalGetCatalogAttributes());
            this.bitField0_ |= 2;
            if (other.attributeConfigLevel_ != 0) {
                this.setAttributeConfigLevelValue(other.getAttributeConfigLevelValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block11: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block11;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block11;
                        }
                        case 18: {
                            MapEntry catalogAttributes__ = (MapEntry)input.readMessage(CatalogAttributesDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableCatalogAttributes().ensureBuilderMap().put(catalogAttributes__.getKey(), catalogAttributes__.getValue());
                            this.bitField0_ |= 2;
                            continue block11;
                        }
                        case 24: {
                            this.attributeConfigLevel_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block11;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = AttributesConfig.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AttributesConfig.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        private MapFieldBuilder<String, CatalogAttributeOrBuilder, CatalogAttribute, CatalogAttribute.Builder> internalGetCatalogAttributes() {
            if (this.catalogAttributes_ == null) {
                return new MapFieldBuilder((MapFieldBuilder.Converter)catalogAttributesConverter);
            }
            return this.catalogAttributes_;
        }

        private MapFieldBuilder<String, CatalogAttributeOrBuilder, CatalogAttribute, CatalogAttribute.Builder> internalGetMutableCatalogAttributes() {
            if (this.catalogAttributes_ == null) {
                this.catalogAttributes_ = new MapFieldBuilder((MapFieldBuilder.Converter)catalogAttributesConverter);
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this.catalogAttributes_;
        }

        @Override
        public int getCatalogAttributesCount() {
            return this.internalGetCatalogAttributes().ensureBuilderMap().size();
        }

        @Override
        public boolean containsCatalogAttributes(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetCatalogAttributes().ensureBuilderMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, CatalogAttribute> getCatalogAttributes() {
            return this.getCatalogAttributesMap();
        }

        @Override
        public Map<String, CatalogAttribute> getCatalogAttributesMap() {
            return this.internalGetCatalogAttributes().getImmutableMap();
        }

        @Override
        public CatalogAttribute getCatalogAttributesOrDefault(String key, CatalogAttribute defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetMutableCatalogAttributes().ensureBuilderMap();
            return map.containsKey(key) ? catalogAttributesConverter.build((CatalogAttributeOrBuilder)map.get(key)) : defaultValue;
        }

        @Override
        public CatalogAttribute getCatalogAttributesOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetMutableCatalogAttributes().ensureBuilderMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return catalogAttributesConverter.build((CatalogAttributeOrBuilder)map.get(key));
        }

        public Builder clearCatalogAttributes() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.internalGetMutableCatalogAttributes().clear();
            return this;
        }

        public Builder removeCatalogAttributes(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableCatalogAttributes().ensureBuilderMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, CatalogAttribute> getMutableCatalogAttributes() {
            this.bitField0_ |= 2;
            return this.internalGetMutableCatalogAttributes().ensureMessageMap();
        }

        public Builder putCatalogAttributes(String key, CatalogAttribute value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableCatalogAttributes().ensureBuilderMap().put(key, value);
            this.bitField0_ |= 2;
            return this;
        }

        public Builder putAllCatalogAttributes(Map<String, CatalogAttribute> values) {
            for (Map.Entry<String, CatalogAttribute> e : values.entrySet()) {
                if (e.getKey() != null && e.getValue() != null) continue;
                throw new NullPointerException();
            }
            this.internalGetMutableCatalogAttributes().ensureBuilderMap().putAll(values);
            this.bitField0_ |= 2;
            return this;
        }

        public CatalogAttribute.Builder putCatalogAttributesBuilderIfAbsent(String key) {
            Map builderMap = this.internalGetMutableCatalogAttributes().ensureBuilderMap();
            CatalogAttributeOrBuilder entry = (CatalogAttributeOrBuilder)builderMap.get(key);
            if (entry == null) {
                entry = CatalogAttribute.newBuilder();
                builderMap.put(key, entry);
            }
            if (entry instanceof CatalogAttribute) {
                entry = ((CatalogAttribute)entry).toBuilder();
                builderMap.put(key, entry);
            }
            return (CatalogAttribute.Builder)entry;
        }

        @Override
        public int getAttributeConfigLevelValue() {
            return this.attributeConfigLevel_;
        }

        public Builder setAttributeConfigLevelValue(int value) {
            this.attributeConfigLevel_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public AttributeConfigLevel getAttributeConfigLevel() {
            AttributeConfigLevel result = AttributeConfigLevel.forNumber(this.attributeConfigLevel_);
            return result == null ? AttributeConfigLevel.UNRECOGNIZED : result;
        }

        public Builder setAttributeConfigLevel(AttributeConfigLevel value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.attributeConfigLevel_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAttributeConfigLevel() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.attributeConfigLevel_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }

        private static final class CatalogAttributesConverter
        implements MapFieldBuilder.Converter<String, CatalogAttributeOrBuilder, CatalogAttribute> {
            private CatalogAttributesConverter() {
            }

            public CatalogAttribute build(CatalogAttributeOrBuilder val) {
                if (val instanceof CatalogAttribute) {
                    return (CatalogAttribute)val;
                }
                return ((CatalogAttribute.Builder)val).build();
            }

            public MapEntry<String, CatalogAttribute> defaultEntry() {
                return CatalogAttributesDefaultEntryHolder.defaultEntry;
            }
        }
    }

    private static final class CatalogAttributesDefaultEntryHolder {
        static final MapEntry<String, CatalogAttribute> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)CatalogProto.internal_static_google_cloud_retail_v2_AttributesConfig_CatalogAttributesEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.MESSAGE, (Object)CatalogAttribute.getDefaultInstance());

        private CatalogAttributesDefaultEntryHolder() {
        }
    }
}

