/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2;

import com.google.cloud.retail.v2.CommonProto;
import com.google.cloud.retail.v2.Interval;
import com.google.cloud.retail.v2.IntervalOrBuilder;
import com.google.cloud.retail.v2.PriceInfoOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class PriceInfo
extends GeneratedMessageV3
implements PriceInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int CURRENCY_CODE_FIELD_NUMBER = 1;
    private volatile Object currencyCode_;
    public static final int PRICE_FIELD_NUMBER = 2;
    private float price_;
    public static final int ORIGINAL_PRICE_FIELD_NUMBER = 3;
    private float originalPrice_;
    public static final int COST_FIELD_NUMBER = 4;
    private float cost_;
    public static final int PRICE_EFFECTIVE_TIME_FIELD_NUMBER = 5;
    private Timestamp priceEffectiveTime_;
    public static final int PRICE_EXPIRE_TIME_FIELD_NUMBER = 6;
    private Timestamp priceExpireTime_;
    public static final int PRICE_RANGE_FIELD_NUMBER = 7;
    private PriceRange priceRange_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final PriceInfo DEFAULT_INSTANCE = new PriceInfo();
    private static final Parser<PriceInfo> PARSER = new AbstractParser<PriceInfo>(){

        public PriceInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new PriceInfo(input, extensionRegistry);
        }
    };

    private PriceInfo(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private PriceInfo() {
        this.currencyCode_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new PriceInfo();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private PriceInfo(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block16: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block16;
                    }
                    case 10: {
                        String s = input.readStringRequireUtf8();
                        this.currencyCode_ = s;
                        continue block16;
                    }
                    case 21: {
                        this.price_ = input.readFloat();
                        continue block16;
                    }
                    case 29: {
                        this.originalPrice_ = input.readFloat();
                        continue block16;
                    }
                    case 37: {
                        this.cost_ = input.readFloat();
                        continue block16;
                    }
                    case 42: {
                        Object subBuilder = null;
                        if (this.priceEffectiveTime_ != null) {
                            subBuilder = this.priceEffectiveTime_.toBuilder();
                        }
                        this.priceEffectiveTime_ = (Timestamp)input.readMessage(Timestamp.parser(), extensionRegistry);
                        if (subBuilder == null) continue block16;
                        subBuilder.mergeFrom(this.priceEffectiveTime_);
                        this.priceEffectiveTime_ = subBuilder.buildPartial();
                        continue block16;
                    }
                    case 50: {
                        Object subBuilder = null;
                        if (this.priceExpireTime_ != null) {
                            subBuilder = this.priceExpireTime_.toBuilder();
                        }
                        this.priceExpireTime_ = (Timestamp)input.readMessage(Timestamp.parser(), extensionRegistry);
                        if (subBuilder == null) continue block16;
                        subBuilder.mergeFrom(this.priceExpireTime_);
                        this.priceExpireTime_ = subBuilder.buildPartial();
                        continue block16;
                    }
                    case 58: {
                        Object subBuilder = null;
                        if (this.priceRange_ != null) {
                            subBuilder = this.priceRange_.toBuilder();
                        }
                        this.priceRange_ = (PriceRange)input.readMessage(PriceRange.parser(), extensionRegistry);
                        if (subBuilder == null) continue block16;
                        ((PriceRange.Builder)subBuilder).mergeFrom(this.priceRange_);
                        this.priceRange_ = ((PriceRange.Builder)subBuilder).buildPartial();
                        continue block16;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return CommonProto.internal_static_google_cloud_retail_v2_PriceInfo_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return CommonProto.internal_static_google_cloud_retail_v2_PriceInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(PriceInfo.class, Builder.class);
    }

    @Override
    public String getCurrencyCode() {
        Object ref = this.currencyCode_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.currencyCode_ = s;
        return s;
    }

    @Override
    public ByteString getCurrencyCodeBytes() {
        Object ref = this.currencyCode_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.currencyCode_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public float getPrice() {
        return this.price_;
    }

    @Override
    public float getOriginalPrice() {
        return this.originalPrice_;
    }

    @Override
    public float getCost() {
        return this.cost_;
    }

    @Override
    public boolean hasPriceEffectiveTime() {
        return this.priceEffectiveTime_ != null;
    }

    @Override
    public Timestamp getPriceEffectiveTime() {
        return this.priceEffectiveTime_ == null ? Timestamp.getDefaultInstance() : this.priceEffectiveTime_;
    }

    @Override
    public TimestampOrBuilder getPriceEffectiveTimeOrBuilder() {
        return this.getPriceEffectiveTime();
    }

    @Override
    public boolean hasPriceExpireTime() {
        return this.priceExpireTime_ != null;
    }

    @Override
    public Timestamp getPriceExpireTime() {
        return this.priceExpireTime_ == null ? Timestamp.getDefaultInstance() : this.priceExpireTime_;
    }

    @Override
    public TimestampOrBuilder getPriceExpireTimeOrBuilder() {
        return this.getPriceExpireTime();
    }

    @Override
    public boolean hasPriceRange() {
        return this.priceRange_ != null;
    }

    @Override
    public PriceRange getPriceRange() {
        return this.priceRange_ == null ? PriceRange.getDefaultInstance() : this.priceRange_;
    }

    @Override
    public PriceRangeOrBuilder getPriceRangeOrBuilder() {
        return this.getPriceRange();
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.currencyCode_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.currencyCode_);
        }
        if (this.price_ != 0.0f) {
            output.writeFloat(2, this.price_);
        }
        if (this.originalPrice_ != 0.0f) {
            output.writeFloat(3, this.originalPrice_);
        }
        if (this.cost_ != 0.0f) {
            output.writeFloat(4, this.cost_);
        }
        if (this.priceEffectiveTime_ != null) {
            output.writeMessage(5, (MessageLite)this.getPriceEffectiveTime());
        }
        if (this.priceExpireTime_ != null) {
            output.writeMessage(6, (MessageLite)this.getPriceExpireTime());
        }
        if (this.priceRange_ != null) {
            output.writeMessage(7, (MessageLite)this.getPriceRange());
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.currencyCode_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.currencyCode_);
        }
        if (this.price_ != 0.0f) {
            size += CodedOutputStream.computeFloatSize((int)2, (float)this.price_);
        }
        if (this.originalPrice_ != 0.0f) {
            size += CodedOutputStream.computeFloatSize((int)3, (float)this.originalPrice_);
        }
        if (this.cost_ != 0.0f) {
            size += CodedOutputStream.computeFloatSize((int)4, (float)this.cost_);
        }
        if (this.priceEffectiveTime_ != null) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getPriceEffectiveTime());
        }
        if (this.priceExpireTime_ != null) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getPriceExpireTime());
        }
        if (this.priceRange_ != null) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getPriceRange());
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PriceInfo)) {
            return super.equals(obj);
        }
        PriceInfo other = (PriceInfo)obj;
        if (!this.getCurrencyCode().equals(other.getCurrencyCode())) {
            return false;
        }
        if (Float.floatToIntBits(this.getPrice()) != Float.floatToIntBits(other.getPrice())) {
            return false;
        }
        if (Float.floatToIntBits(this.getOriginalPrice()) != Float.floatToIntBits(other.getOriginalPrice())) {
            return false;
        }
        if (Float.floatToIntBits(this.getCost()) != Float.floatToIntBits(other.getCost())) {
            return false;
        }
        if (this.hasPriceEffectiveTime() != other.hasPriceEffectiveTime()) {
            return false;
        }
        if (this.hasPriceEffectiveTime() && !this.getPriceEffectiveTime().equals((Object)other.getPriceEffectiveTime())) {
            return false;
        }
        if (this.hasPriceExpireTime() != other.hasPriceExpireTime()) {
            return false;
        }
        if (this.hasPriceExpireTime() && !this.getPriceExpireTime().equals((Object)other.getPriceExpireTime())) {
            return false;
        }
        if (this.hasPriceRange() != other.hasPriceRange()) {
            return false;
        }
        if (this.hasPriceRange() && !this.getPriceRange().equals(other.getPriceRange())) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + PriceInfo.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getCurrencyCode().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + Float.floatToIntBits(this.getPrice());
        hash = 37 * hash + 3;
        hash = 53 * hash + Float.floatToIntBits(this.getOriginalPrice());
        hash = 37 * hash + 4;
        hash = 53 * hash + Float.floatToIntBits(this.getCost());
        if (this.hasPriceEffectiveTime()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getPriceEffectiveTime().hashCode();
        }
        if (this.hasPriceExpireTime()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getPriceExpireTime().hashCode();
        }
        if (this.hasPriceRange()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getPriceRange().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static PriceInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (PriceInfo)PARSER.parseFrom(data);
    }

    public static PriceInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (PriceInfo)PARSER.parseFrom(data, extensionRegistry);
    }

    public static PriceInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (PriceInfo)PARSER.parseFrom(data);
    }

    public static PriceInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (PriceInfo)PARSER.parseFrom(data, extensionRegistry);
    }

    public static PriceInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (PriceInfo)PARSER.parseFrom(data);
    }

    public static PriceInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (PriceInfo)PARSER.parseFrom(data, extensionRegistry);
    }

    public static PriceInfo parseFrom(InputStream input) throws IOException {
        return (PriceInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static PriceInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (PriceInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static PriceInfo parseDelimitedFrom(InputStream input) throws IOException {
        return (PriceInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static PriceInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (PriceInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static PriceInfo parseFrom(CodedInputStream input) throws IOException {
        return (PriceInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static PriceInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (PriceInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return PriceInfo.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(PriceInfo prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static PriceInfo getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<PriceInfo> parser() {
        return PARSER;
    }

    public Parser<PriceInfo> getParserForType() {
        return PARSER;
    }

    public PriceInfo getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements PriceInfoOrBuilder {
        private Object currencyCode_ = "";
        private float price_;
        private float originalPrice_;
        private float cost_;
        private Timestamp priceEffectiveTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> priceEffectiveTimeBuilder_;
        private Timestamp priceExpireTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> priceExpireTimeBuilder_;
        private PriceRange priceRange_;
        private SingleFieldBuilderV3<PriceRange, PriceRange.Builder, PriceRangeOrBuilder> priceRangeBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return CommonProto.internal_static_google_cloud_retail_v2_PriceInfo_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CommonProto.internal_static_google_cloud_retail_v2_PriceInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(PriceInfo.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                // empty if block
            }
        }

        public Builder clear() {
            super.clear();
            this.currencyCode_ = "";
            this.price_ = 0.0f;
            this.originalPrice_ = 0.0f;
            this.cost_ = 0.0f;
            if (this.priceEffectiveTimeBuilder_ == null) {
                this.priceEffectiveTime_ = null;
            } else {
                this.priceEffectiveTime_ = null;
                this.priceEffectiveTimeBuilder_ = null;
            }
            if (this.priceExpireTimeBuilder_ == null) {
                this.priceExpireTime_ = null;
            } else {
                this.priceExpireTime_ = null;
                this.priceExpireTimeBuilder_ = null;
            }
            if (this.priceRangeBuilder_ == null) {
                this.priceRange_ = null;
            } else {
                this.priceRange_ = null;
                this.priceRangeBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return CommonProto.internal_static_google_cloud_retail_v2_PriceInfo_descriptor;
        }

        public PriceInfo getDefaultInstanceForType() {
            return PriceInfo.getDefaultInstance();
        }

        public PriceInfo build() {
            PriceInfo result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public PriceInfo buildPartial() {
            PriceInfo result = new PriceInfo(this);
            result.currencyCode_ = this.currencyCode_;
            result.price_ = this.price_;
            result.originalPrice_ = this.originalPrice_;
            result.cost_ = this.cost_;
            if (this.priceEffectiveTimeBuilder_ == null) {
                result.priceEffectiveTime_ = this.priceEffectiveTime_;
            } else {
                result.priceEffectiveTime_ = (Timestamp)this.priceEffectiveTimeBuilder_.build();
            }
            if (this.priceExpireTimeBuilder_ == null) {
                result.priceExpireTime_ = this.priceExpireTime_;
            } else {
                result.priceExpireTime_ = (Timestamp)this.priceExpireTimeBuilder_.build();
            }
            if (this.priceRangeBuilder_ == null) {
                result.priceRange_ = this.priceRange_;
            } else {
                result.priceRange_ = (PriceRange)this.priceRangeBuilder_.build();
            }
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof PriceInfo) {
                return this.mergeFrom((PriceInfo)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(PriceInfo other) {
            if (other == PriceInfo.getDefaultInstance()) {
                return this;
            }
            if (!other.getCurrencyCode().isEmpty()) {
                this.currencyCode_ = other.currencyCode_;
                this.onChanged();
            }
            if (other.getPrice() != 0.0f) {
                this.setPrice(other.getPrice());
            }
            if (other.getOriginalPrice() != 0.0f) {
                this.setOriginalPrice(other.getOriginalPrice());
            }
            if (other.getCost() != 0.0f) {
                this.setCost(other.getCost());
            }
            if (other.hasPriceEffectiveTime()) {
                this.mergePriceEffectiveTime(other.getPriceEffectiveTime());
            }
            if (other.hasPriceExpireTime()) {
                this.mergePriceExpireTime(other.getPriceExpireTime());
            }
            if (other.hasPriceRange()) {
                this.mergePriceRange(other.getPriceRange());
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            PriceInfo parsedMessage = null;
            try {
                parsedMessage = (PriceInfo)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (PriceInfo)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public String getCurrencyCode() {
            Object ref = this.currencyCode_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.currencyCode_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCurrencyCodeBytes() {
            Object ref = this.currencyCode_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.currencyCode_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCurrencyCode(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.currencyCode_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearCurrencyCode() {
            this.currencyCode_ = PriceInfo.getDefaultInstance().getCurrencyCode();
            this.onChanged();
            return this;
        }

        public Builder setCurrencyCodeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            PriceInfo.checkByteStringIsUtf8((ByteString)value);
            this.currencyCode_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public float getPrice() {
            return this.price_;
        }

        public Builder setPrice(float value) {
            this.price_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearPrice() {
            this.price_ = 0.0f;
            this.onChanged();
            return this;
        }

        @Override
        public float getOriginalPrice() {
            return this.originalPrice_;
        }

        public Builder setOriginalPrice(float value) {
            this.originalPrice_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearOriginalPrice() {
            this.originalPrice_ = 0.0f;
            this.onChanged();
            return this;
        }

        @Override
        public float getCost() {
            return this.cost_;
        }

        public Builder setCost(float value) {
            this.cost_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearCost() {
            this.cost_ = 0.0f;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPriceEffectiveTime() {
            return this.priceEffectiveTimeBuilder_ != null || this.priceEffectiveTime_ != null;
        }

        @Override
        public Timestamp getPriceEffectiveTime() {
            if (this.priceEffectiveTimeBuilder_ == null) {
                return this.priceEffectiveTime_ == null ? Timestamp.getDefaultInstance() : this.priceEffectiveTime_;
            }
            return (Timestamp)this.priceEffectiveTimeBuilder_.getMessage();
        }

        public Builder setPriceEffectiveTime(Timestamp value) {
            if (this.priceEffectiveTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.priceEffectiveTime_ = value;
                this.onChanged();
            } else {
                this.priceEffectiveTimeBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setPriceEffectiveTime(Timestamp.Builder builderForValue) {
            if (this.priceEffectiveTimeBuilder_ == null) {
                this.priceEffectiveTime_ = builderForValue.build();
                this.onChanged();
            } else {
                this.priceEffectiveTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergePriceEffectiveTime(Timestamp value) {
            if (this.priceEffectiveTimeBuilder_ == null) {
                this.priceEffectiveTime_ = this.priceEffectiveTime_ != null ? Timestamp.newBuilder((Timestamp)this.priceEffectiveTime_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.priceEffectiveTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearPriceEffectiveTime() {
            if (this.priceEffectiveTimeBuilder_ == null) {
                this.priceEffectiveTime_ = null;
                this.onChanged();
            } else {
                this.priceEffectiveTime_ = null;
                this.priceEffectiveTimeBuilder_ = null;
            }
            return this;
        }

        public Timestamp.Builder getPriceEffectiveTimeBuilder() {
            this.onChanged();
            return (Timestamp.Builder)this.getPriceEffectiveTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getPriceEffectiveTimeOrBuilder() {
            if (this.priceEffectiveTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.priceEffectiveTimeBuilder_.getMessageOrBuilder();
            }
            return this.priceEffectiveTime_ == null ? Timestamp.getDefaultInstance() : this.priceEffectiveTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getPriceEffectiveTimeFieldBuilder() {
            if (this.priceEffectiveTimeBuilder_ == null) {
                this.priceEffectiveTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPriceEffectiveTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.priceEffectiveTime_ = null;
            }
            return this.priceEffectiveTimeBuilder_;
        }

        @Override
        public boolean hasPriceExpireTime() {
            return this.priceExpireTimeBuilder_ != null || this.priceExpireTime_ != null;
        }

        @Override
        public Timestamp getPriceExpireTime() {
            if (this.priceExpireTimeBuilder_ == null) {
                return this.priceExpireTime_ == null ? Timestamp.getDefaultInstance() : this.priceExpireTime_;
            }
            return (Timestamp)this.priceExpireTimeBuilder_.getMessage();
        }

        public Builder setPriceExpireTime(Timestamp value) {
            if (this.priceExpireTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.priceExpireTime_ = value;
                this.onChanged();
            } else {
                this.priceExpireTimeBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setPriceExpireTime(Timestamp.Builder builderForValue) {
            if (this.priceExpireTimeBuilder_ == null) {
                this.priceExpireTime_ = builderForValue.build();
                this.onChanged();
            } else {
                this.priceExpireTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergePriceExpireTime(Timestamp value) {
            if (this.priceExpireTimeBuilder_ == null) {
                this.priceExpireTime_ = this.priceExpireTime_ != null ? Timestamp.newBuilder((Timestamp)this.priceExpireTime_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.priceExpireTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearPriceExpireTime() {
            if (this.priceExpireTimeBuilder_ == null) {
                this.priceExpireTime_ = null;
                this.onChanged();
            } else {
                this.priceExpireTime_ = null;
                this.priceExpireTimeBuilder_ = null;
            }
            return this;
        }

        public Timestamp.Builder getPriceExpireTimeBuilder() {
            this.onChanged();
            return (Timestamp.Builder)this.getPriceExpireTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getPriceExpireTimeOrBuilder() {
            if (this.priceExpireTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.priceExpireTimeBuilder_.getMessageOrBuilder();
            }
            return this.priceExpireTime_ == null ? Timestamp.getDefaultInstance() : this.priceExpireTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getPriceExpireTimeFieldBuilder() {
            if (this.priceExpireTimeBuilder_ == null) {
                this.priceExpireTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPriceExpireTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.priceExpireTime_ = null;
            }
            return this.priceExpireTimeBuilder_;
        }

        @Override
        public boolean hasPriceRange() {
            return this.priceRangeBuilder_ != null || this.priceRange_ != null;
        }

        @Override
        public PriceRange getPriceRange() {
            if (this.priceRangeBuilder_ == null) {
                return this.priceRange_ == null ? PriceRange.getDefaultInstance() : this.priceRange_;
            }
            return (PriceRange)this.priceRangeBuilder_.getMessage();
        }

        public Builder setPriceRange(PriceRange value) {
            if (this.priceRangeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.priceRange_ = value;
                this.onChanged();
            } else {
                this.priceRangeBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setPriceRange(PriceRange.Builder builderForValue) {
            if (this.priceRangeBuilder_ == null) {
                this.priceRange_ = builderForValue.build();
                this.onChanged();
            } else {
                this.priceRangeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergePriceRange(PriceRange value) {
            if (this.priceRangeBuilder_ == null) {
                this.priceRange_ = this.priceRange_ != null ? PriceRange.newBuilder(this.priceRange_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.priceRangeBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearPriceRange() {
            if (this.priceRangeBuilder_ == null) {
                this.priceRange_ = null;
                this.onChanged();
            } else {
                this.priceRange_ = null;
                this.priceRangeBuilder_ = null;
            }
            return this;
        }

        public PriceRange.Builder getPriceRangeBuilder() {
            this.onChanged();
            return (PriceRange.Builder)this.getPriceRangeFieldBuilder().getBuilder();
        }

        @Override
        public PriceRangeOrBuilder getPriceRangeOrBuilder() {
            if (this.priceRangeBuilder_ != null) {
                return (PriceRangeOrBuilder)this.priceRangeBuilder_.getMessageOrBuilder();
            }
            return this.priceRange_ == null ? PriceRange.getDefaultInstance() : this.priceRange_;
        }

        private SingleFieldBuilderV3<PriceRange, PriceRange.Builder, PriceRangeOrBuilder> getPriceRangeFieldBuilder() {
            if (this.priceRangeBuilder_ == null) {
                this.priceRangeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPriceRange(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.priceRange_ = null;
            }
            return this.priceRangeBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class PriceRange
    extends GeneratedMessageV3
    implements PriceRangeOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int PRICE_FIELD_NUMBER = 1;
        private Interval price_;
        public static final int ORIGINAL_PRICE_FIELD_NUMBER = 2;
        private Interval originalPrice_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final PriceRange DEFAULT_INSTANCE = new PriceRange();
        private static final Parser<PriceRange> PARSER = new AbstractParser<PriceRange>(){

            public PriceRange parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return new PriceRange(input, extensionRegistry);
            }
        };

        private PriceRange(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private PriceRange() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new PriceRange();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        private PriceRange(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
            try {
                boolean done = false;
                block11: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block11;
                        }
                        case 10: {
                            Interval.Builder subBuilder = null;
                            if (this.price_ != null) {
                                subBuilder = this.price_.toBuilder();
                            }
                            this.price_ = (Interval)input.readMessage(Interval.parser(), extensionRegistry);
                            if (subBuilder == null) continue block11;
                            subBuilder.mergeFrom(this.price_);
                            this.price_ = subBuilder.buildPartial();
                            continue block11;
                        }
                        case 18: {
                            Interval.Builder subBuilder = null;
                            if (this.originalPrice_ != null) {
                                subBuilder = this.originalPrice_.toBuilder();
                            }
                            this.originalPrice_ = (Interval)input.readMessage(Interval.parser(), extensionRegistry);
                            if (subBuilder == null) continue block11;
                            subBuilder.mergeFrom(this.originalPrice_);
                            this.originalPrice_ = subBuilder.buildPartial();
                            continue block11;
                        }
                    }
                    if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)this);
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
            }
            finally {
                this.unknownFields = unknownFields.build();
                this.makeExtensionsImmutable();
            }
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return CommonProto.internal_static_google_cloud_retail_v2_PriceInfo_PriceRange_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CommonProto.internal_static_google_cloud_retail_v2_PriceInfo_PriceRange_fieldAccessorTable.ensureFieldAccessorsInitialized(PriceRange.class, Builder.class);
        }

        @Override
        public boolean hasPrice() {
            return this.price_ != null;
        }

        @Override
        public Interval getPrice() {
            return this.price_ == null ? Interval.getDefaultInstance() : this.price_;
        }

        @Override
        public IntervalOrBuilder getPriceOrBuilder() {
            return this.getPrice();
        }

        @Override
        public boolean hasOriginalPrice() {
            return this.originalPrice_ != null;
        }

        @Override
        public Interval getOriginalPrice() {
            return this.originalPrice_ == null ? Interval.getDefaultInstance() : this.originalPrice_;
        }

        @Override
        public IntervalOrBuilder getOriginalPriceOrBuilder() {
            return this.getOriginalPrice();
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.price_ != null) {
                output.writeMessage(1, (MessageLite)this.getPrice());
            }
            if (this.originalPrice_ != null) {
                output.writeMessage(2, (MessageLite)this.getOriginalPrice());
            }
            this.unknownFields.writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.price_ != null) {
                size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getPrice());
            }
            if (this.originalPrice_ != null) {
                size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getOriginalPrice());
            }
            this.memoizedSize = size += this.unknownFields.getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PriceRange)) {
                return super.equals(obj);
            }
            PriceRange other = (PriceRange)obj;
            if (this.hasPrice() != other.hasPrice()) {
                return false;
            }
            if (this.hasPrice() && !this.getPrice().equals(other.getPrice())) {
                return false;
            }
            if (this.hasOriginalPrice() != other.hasOriginalPrice()) {
                return false;
            }
            if (this.hasOriginalPrice() && !this.getOriginalPrice().equals(other.getOriginalPrice())) {
                return false;
            }
            return this.unknownFields.equals((Object)other.unknownFields);
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + PriceRange.getDescriptor().hashCode();
            if (this.hasPrice()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getPrice().hashCode();
            }
            if (this.hasOriginalPrice()) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getOriginalPrice().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
            return hash;
        }

        public static PriceRange parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (PriceRange)PARSER.parseFrom(data);
        }

        public static PriceRange parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (PriceRange)PARSER.parseFrom(data, extensionRegistry);
        }

        public static PriceRange parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (PriceRange)PARSER.parseFrom(data);
        }

        public static PriceRange parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (PriceRange)PARSER.parseFrom(data, extensionRegistry);
        }

        public static PriceRange parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (PriceRange)PARSER.parseFrom(data);
        }

        public static PriceRange parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (PriceRange)PARSER.parseFrom(data, extensionRegistry);
        }

        public static PriceRange parseFrom(InputStream input) throws IOException {
            return (PriceRange)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static PriceRange parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (PriceRange)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static PriceRange parseDelimitedFrom(InputStream input) throws IOException {
            return (PriceRange)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static PriceRange parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (PriceRange)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static PriceRange parseFrom(CodedInputStream input) throws IOException {
            return (PriceRange)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static PriceRange parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (PriceRange)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return PriceRange.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(PriceRange prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static PriceRange getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<PriceRange> parser() {
            return PARSER;
        }

        public Parser<PriceRange> getParserForType() {
            return PARSER;
        }

        public PriceRange getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements PriceRangeOrBuilder {
            private Interval price_;
            private SingleFieldBuilderV3<Interval, Interval.Builder, IntervalOrBuilder> priceBuilder_;
            private Interval originalPrice_;
            private SingleFieldBuilderV3<Interval, Interval.Builder, IntervalOrBuilder> originalPriceBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return CommonProto.internal_static_google_cloud_retail_v2_PriceInfo_PriceRange_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return CommonProto.internal_static_google_cloud_retail_v2_PriceInfo_PriceRange_fieldAccessorTable.ensureFieldAccessorsInitialized(PriceRange.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    // empty if block
                }
            }

            public Builder clear() {
                super.clear();
                if (this.priceBuilder_ == null) {
                    this.price_ = null;
                } else {
                    this.price_ = null;
                    this.priceBuilder_ = null;
                }
                if (this.originalPriceBuilder_ == null) {
                    this.originalPrice_ = null;
                } else {
                    this.originalPrice_ = null;
                    this.originalPriceBuilder_ = null;
                }
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return CommonProto.internal_static_google_cloud_retail_v2_PriceInfo_PriceRange_descriptor;
            }

            public PriceRange getDefaultInstanceForType() {
                return PriceRange.getDefaultInstance();
            }

            public PriceRange build() {
                PriceRange result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public PriceRange buildPartial() {
                PriceRange result = new PriceRange(this);
                if (this.priceBuilder_ == null) {
                    result.price_ = this.price_;
                } else {
                    result.price_ = (Interval)this.priceBuilder_.build();
                }
                if (this.originalPriceBuilder_ == null) {
                    result.originalPrice_ = this.originalPrice_;
                } else {
                    result.originalPrice_ = (Interval)this.originalPriceBuilder_.build();
                }
                this.onBuilt();
                return result;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof PriceRange) {
                    return this.mergeFrom((PriceRange)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(PriceRange other) {
                if (other == PriceRange.getDefaultInstance()) {
                    return this;
                }
                if (other.hasPrice()) {
                    this.mergePrice(other.getPrice());
                }
                if (other.hasOriginalPrice()) {
                    this.mergeOriginalPrice(other.getOriginalPrice());
                }
                this.mergeUnknownFields(other.unknownFields);
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                PriceRange parsedMessage = null;
                try {
                    parsedMessage = (PriceRange)PARSER.parsePartialFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    parsedMessage = (PriceRange)e.getUnfinishedMessage();
                    throw e.unwrapIOException();
                }
                finally {
                    if (parsedMessage != null) {
                        this.mergeFrom(parsedMessage);
                    }
                }
                return this;
            }

            @Override
            public boolean hasPrice() {
                return this.priceBuilder_ != null || this.price_ != null;
            }

            @Override
            public Interval getPrice() {
                if (this.priceBuilder_ == null) {
                    return this.price_ == null ? Interval.getDefaultInstance() : this.price_;
                }
                return (Interval)this.priceBuilder_.getMessage();
            }

            public Builder setPrice(Interval value) {
                if (this.priceBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.price_ = value;
                    this.onChanged();
                } else {
                    this.priceBuilder_.setMessage((AbstractMessage)value);
                }
                return this;
            }

            public Builder setPrice(Interval.Builder builderForValue) {
                if (this.priceBuilder_ == null) {
                    this.price_ = builderForValue.build();
                    this.onChanged();
                } else {
                    this.priceBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder mergePrice(Interval value) {
                if (this.priceBuilder_ == null) {
                    this.price_ = this.price_ != null ? Interval.newBuilder(this.price_).mergeFrom(value).buildPartial() : value;
                    this.onChanged();
                } else {
                    this.priceBuilder_.mergeFrom((AbstractMessage)value);
                }
                return this;
            }

            public Builder clearPrice() {
                if (this.priceBuilder_ == null) {
                    this.price_ = null;
                    this.onChanged();
                } else {
                    this.price_ = null;
                    this.priceBuilder_ = null;
                }
                return this;
            }

            public Interval.Builder getPriceBuilder() {
                this.onChanged();
                return (Interval.Builder)this.getPriceFieldBuilder().getBuilder();
            }

            @Override
            public IntervalOrBuilder getPriceOrBuilder() {
                if (this.priceBuilder_ != null) {
                    return (IntervalOrBuilder)this.priceBuilder_.getMessageOrBuilder();
                }
                return this.price_ == null ? Interval.getDefaultInstance() : this.price_;
            }

            private SingleFieldBuilderV3<Interval, Interval.Builder, IntervalOrBuilder> getPriceFieldBuilder() {
                if (this.priceBuilder_ == null) {
                    this.priceBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPrice(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.price_ = null;
                }
                return this.priceBuilder_;
            }

            @Override
            public boolean hasOriginalPrice() {
                return this.originalPriceBuilder_ != null || this.originalPrice_ != null;
            }

            @Override
            public Interval getOriginalPrice() {
                if (this.originalPriceBuilder_ == null) {
                    return this.originalPrice_ == null ? Interval.getDefaultInstance() : this.originalPrice_;
                }
                return (Interval)this.originalPriceBuilder_.getMessage();
            }

            public Builder setOriginalPrice(Interval value) {
                if (this.originalPriceBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.originalPrice_ = value;
                    this.onChanged();
                } else {
                    this.originalPriceBuilder_.setMessage((AbstractMessage)value);
                }
                return this;
            }

            public Builder setOriginalPrice(Interval.Builder builderForValue) {
                if (this.originalPriceBuilder_ == null) {
                    this.originalPrice_ = builderForValue.build();
                    this.onChanged();
                } else {
                    this.originalPriceBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder mergeOriginalPrice(Interval value) {
                if (this.originalPriceBuilder_ == null) {
                    this.originalPrice_ = this.originalPrice_ != null ? Interval.newBuilder(this.originalPrice_).mergeFrom(value).buildPartial() : value;
                    this.onChanged();
                } else {
                    this.originalPriceBuilder_.mergeFrom((AbstractMessage)value);
                }
                return this;
            }

            public Builder clearOriginalPrice() {
                if (this.originalPriceBuilder_ == null) {
                    this.originalPrice_ = null;
                    this.onChanged();
                } else {
                    this.originalPrice_ = null;
                    this.originalPriceBuilder_ = null;
                }
                return this;
            }

            public Interval.Builder getOriginalPriceBuilder() {
                this.onChanged();
                return (Interval.Builder)this.getOriginalPriceFieldBuilder().getBuilder();
            }

            @Override
            public IntervalOrBuilder getOriginalPriceOrBuilder() {
                if (this.originalPriceBuilder_ != null) {
                    return (IntervalOrBuilder)this.originalPriceBuilder_.getMessageOrBuilder();
                }
                return this.originalPrice_ == null ? Interval.getDefaultInstance() : this.originalPrice_;
            }

            private SingleFieldBuilderV3<Interval, Interval.Builder, IntervalOrBuilder> getOriginalPriceFieldBuilder() {
                if (this.originalPriceBuilder_ == null) {
                    this.originalPriceBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getOriginalPrice(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.originalPrice_ = null;
                }
                return this.originalPriceBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface PriceRangeOrBuilder
    extends MessageOrBuilder {
        public boolean hasPrice();

        public Interval getPrice();

        public IntervalOrBuilder getPriceOrBuilder();

        public boolean hasOriginalPrice();

        public Interval getOriginalPrice();

        public IntervalOrBuilder getOriginalPriceOrBuilder();
    }
}

