/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/resourcemanager/v3/tag_keys.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.resourcemanager.v3;

/**
 *
 *
 * <pre>
 * A TagKey, used to group a set of TagValues.
 * </pre>
 *
 * Protobuf type {@code google.cloud.resourcemanager.v3.TagKey}
 */
public final class TagKey extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.resourcemanager.v3.TagKey)
    TagKeyOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use TagKey.newBuilder() to construct.
  private TagKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TagKey() {
    name_ = "";
    parent_ = "";
    shortName_ = "";
    namespacedName_ = "";
    description_ = "";
    etag_ = "";
    purpose_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TagKey();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.resourcemanager.v3.TagKeysProto
        .internal_static_google_cloud_resourcemanager_v3_TagKey_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 12:
        return internalGetPurposeData();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.resourcemanager.v3.TagKeysProto
        .internal_static_google_cloud_resourcemanager_v3_TagKey_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.resourcemanager.v3.TagKey.class,
            com.google.cloud.resourcemanager.v3.TagKey.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Immutable. The resource name for a TagKey. Must be in the format
   * `tagKeys/{tag_key_id}`, where `tag_key_id` is the generated numeric id for
   * the TagKey.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. The resource name for a TagKey. Must be in the format
   * `tagKeys/{tag_key_id}`, where `tag_key_id` is the generated numeric id for
   * the TagKey.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the TagKey's parent. A TagKey can be
   * parented by an Organization or a Project. For a TagKey parented by an
   * Organization, its parent must be in the form `organizations/{org_id}`. For
   * a TagKey parented by a Project, its parent can be in the form
   * `projects/{project_id}` or `projects/{project_number}`.
   * </pre>
   *
   * <code>string parent = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the TagKey's parent. A TagKey can be
   * parented by an Organization or a Project. For a TagKey parented by an
   * Organization, its parent must be in the form `organizations/{org_id}`. For
   * a TagKey parented by a Project, its parent can be in the form
   * `projects/{project_id}` or `projects/{project_number}`.
   * </pre>
   *
   * <code>string parent = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SHORT_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object shortName_ = "";

  /**
   *
   *
   * <pre>
   * Required. Immutable. The user friendly name for a TagKey. The short name
   * should be unique for TagKeys within the same tag namespace.
   *
   * The short name must be 1-63 characters, beginning and ending with
   * an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_),
   * dots (.), and alphanumerics between.
   * </pre>
   *
   * <code>
   * string short_name = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The shortName.
   */
  @java.lang.Override
  public java.lang.String getShortName() {
    java.lang.Object ref = shortName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      shortName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Immutable. The user friendly name for a TagKey. The short name
   * should be unique for TagKeys within the same tag namespace.
   *
   * The short name must be 1-63 characters, beginning and ending with
   * an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_),
   * dots (.), and alphanumerics between.
   * </pre>
   *
   * <code>
   * string short_name = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for shortName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getShortNameBytes() {
    java.lang.Object ref = shortName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      shortName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAMESPACED_NAME_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object namespacedName_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Immutable. Namespaced name of the TagKey.
   * </pre>
   *
   * <code>
   * string namespaced_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The namespacedName.
   */
  @java.lang.Override
  public java.lang.String getNamespacedName() {
    java.lang.Object ref = namespacedName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      namespacedName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Immutable. Namespaced name of the TagKey.
   * </pre>
   *
   * <code>
   * string namespaced_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for namespacedName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNamespacedNameBytes() {
    java.lang.Object ref = namespacedName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      namespacedName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * Optional. User-assigned description of the TagKey. Must not exceed 256
   * characters.
   *
   * Read-write.
   * </pre>
   *
   * <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. User-assigned description of the TagKey. Must not exceed 256
   * characters.
   *
   * Read-write.
   * </pre>
   *
   * <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. Creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. Update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int ETAG_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Entity tag which users can pass to prevent race conditions. This
   * field is always set in server responses. See UpdateTagKeyRequest for
   * details.
   * </pre>
   *
   * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Entity tag which users can pass to prevent race conditions. This
   * field is always set in server responses. See UpdateTagKeyRequest for
   * details.
   * </pre>
   *
   * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PURPOSE_FIELD_NUMBER = 11;
  private int purpose_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. A purpose denotes that this Tag is intended for use in policies
   * of a specific policy engine, and will involve that policy engine in
   * management operations involving this Tag. A purpose does not grant a
   * policy engine exclusive rights to the Tag, and it may be referenced by
   * other policy engines.
   *
   * A purpose cannot be changed once set.
   * </pre>
   *
   * <code>
   * .google.cloud.resourcemanager.v3.Purpose purpose = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for purpose.
   */
  @java.lang.Override
  public int getPurposeValue() {
    return purpose_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A purpose denotes that this Tag is intended for use in policies
   * of a specific policy engine, and will involve that policy engine in
   * management operations involving this Tag. A purpose does not grant a
   * policy engine exclusive rights to the Tag, and it may be referenced by
   * other policy engines.
   *
   * A purpose cannot be changed once set.
   * </pre>
   *
   * <code>
   * .google.cloud.resourcemanager.v3.Purpose purpose = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The purpose.
   */
  @java.lang.Override
  public com.google.cloud.resourcemanager.v3.Purpose getPurpose() {
    com.google.cloud.resourcemanager.v3.Purpose result =
        com.google.cloud.resourcemanager.v3.Purpose.forNumber(purpose_);
    return result == null ? com.google.cloud.resourcemanager.v3.Purpose.UNRECOGNIZED : result;
  }

  public static final int PURPOSE_DATA_FIELD_NUMBER = 12;

  private static final class PurposeDataDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.resourcemanager.v3.TagKeysProto
                .internal_static_google_cloud_resourcemanager_v3_TagKey_PurposeDataEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> purposeData_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetPurposeData() {
    if (purposeData_ == null) {
      return com.google.protobuf.MapField.emptyMapField(PurposeDataDefaultEntryHolder.defaultEntry);
    }
    return purposeData_;
  }

  public int getPurposeDataCount() {
    return internalGetPurposeData().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Purpose data corresponds to the policy system that the tag is
   * intended for. See documentation for `Purpose` for formatting of this field.
   *
   * Purpose data cannot be changed once set.
   * </pre>
   *
   * <code>map&lt;string, string&gt; purpose_data = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsPurposeData(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetPurposeData().getMap().containsKey(key);
  }

  /** Use {@link #getPurposeDataMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getPurposeData() {
    return getPurposeDataMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Purpose data corresponds to the policy system that the tag is
   * intended for. See documentation for `Purpose` for formatting of this field.
   *
   * Purpose data cannot be changed once set.
   * </pre>
   *
   * <code>map&lt;string, string&gt; purpose_data = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getPurposeDataMap() {
    return internalGetPurposeData().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Purpose data corresponds to the policy system that the tag is
   * intended for. See documentation for `Purpose` for formatting of this field.
   *
   * Purpose data cannot be changed once set.
   * </pre>
   *
   * <code>map&lt;string, string&gt; purpose_data = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getPurposeDataOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetPurposeData().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. Purpose data corresponds to the policy system that the tag is
   * intended for. See documentation for `Purpose` for formatting of this field.
   *
   * Purpose data cannot be changed once set.
   * </pre>
   *
   * <code>map&lt;string, string&gt; purpose_data = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getPurposeDataOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetPurposeData().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(shortName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, shortName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namespacedName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, namespacedName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, etag_);
    }
    if (purpose_ != com.google.cloud.resourcemanager.v3.Purpose.PURPOSE_UNSPECIFIED.getNumber()) {
      output.writeEnum(11, purpose_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetPurposeData(), PurposeDataDefaultEntryHolder.defaultEntry, 12);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(shortName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, shortName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namespacedName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, namespacedName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, etag_);
    }
    if (purpose_ != com.google.cloud.resourcemanager.v3.Purpose.PURPOSE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(11, purpose_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetPurposeData().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> purposeData__ =
          PurposeDataDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, purposeData__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.resourcemanager.v3.TagKey)) {
      return super.equals(obj);
    }
    com.google.cloud.resourcemanager.v3.TagKey other =
        (com.google.cloud.resourcemanager.v3.TagKey) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getParent().equals(other.getParent())) return false;
    if (!getShortName().equals(other.getShortName())) return false;
    if (!getNamespacedName().equals(other.getNamespacedName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (purpose_ != other.purpose_) return false;
    if (!internalGetPurposeData().equals(other.internalGetPurposeData())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + SHORT_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getShortName().hashCode();
    hash = (37 * hash) + NAMESPACED_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getNamespacedName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + PURPOSE_FIELD_NUMBER;
    hash = (53 * hash) + purpose_;
    if (!internalGetPurposeData().getMap().isEmpty()) {
      hash = (37 * hash) + PURPOSE_DATA_FIELD_NUMBER;
      hash = (53 * hash) + internalGetPurposeData().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.resourcemanager.v3.TagKey parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.resourcemanager.v3.TagKey parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.TagKey parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.resourcemanager.v3.TagKey parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.TagKey parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.resourcemanager.v3.TagKey parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.TagKey parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.resourcemanager.v3.TagKey parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.TagKey parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.resourcemanager.v3.TagKey parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.TagKey parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.resourcemanager.v3.TagKey parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.resourcemanager.v3.TagKey prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A TagKey, used to group a set of TagValues.
   * </pre>
   *
   * Protobuf type {@code google.cloud.resourcemanager.v3.TagKey}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.resourcemanager.v3.TagKey)
      com.google.cloud.resourcemanager.v3.TagKeyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.resourcemanager.v3.TagKeysProto
          .internal_static_google_cloud_resourcemanager_v3_TagKey_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 12:
          return internalGetPurposeData();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 12:
          return internalGetMutablePurposeData();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.resourcemanager.v3.TagKeysProto
          .internal_static_google_cloud_resourcemanager_v3_TagKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.resourcemanager.v3.TagKey.class,
              com.google.cloud.resourcemanager.v3.TagKey.Builder.class);
    }

    // Construct using com.google.cloud.resourcemanager.v3.TagKey.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      parent_ = "";
      shortName_ = "";
      namespacedName_ = "";
      description_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      etag_ = "";
      purpose_ = 0;
      internalGetMutablePurposeData().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.resourcemanager.v3.TagKeysProto
          .internal_static_google_cloud_resourcemanager_v3_TagKey_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.resourcemanager.v3.TagKey getDefaultInstanceForType() {
      return com.google.cloud.resourcemanager.v3.TagKey.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.resourcemanager.v3.TagKey build() {
      com.google.cloud.resourcemanager.v3.TagKey result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.resourcemanager.v3.TagKey buildPartial() {
      com.google.cloud.resourcemanager.v3.TagKey result =
          new com.google.cloud.resourcemanager.v3.TagKey(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.resourcemanager.v3.TagKey result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.shortName_ = shortName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.namespacedName_ = namespacedName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.description_ = description_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.purpose_ = purpose_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.purposeData_ = internalGetPurposeData();
        result.purposeData_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.resourcemanager.v3.TagKey) {
        return mergeFrom((com.google.cloud.resourcemanager.v3.TagKey) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.resourcemanager.v3.TagKey other) {
      if (other == com.google.cloud.resourcemanager.v3.TagKey.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getShortName().isEmpty()) {
        shortName_ = other.shortName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getNamespacedName().isEmpty()) {
        namespacedName_ = other.namespacedName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.purpose_ != 0) {
        setPurposeValue(other.getPurposeValue());
      }
      internalGetMutablePurposeData().mergeFrom(other.internalGetPurposeData());
      bitField0_ |= 0x00000200;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                shortName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                namespacedName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 88:
              {
                purpose_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 88
            case 98:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> purposeData__ =
                    input.readMessage(
                        PurposeDataDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutablePurposeData()
                    .getMutableMap()
                    .put(purposeData__.getKey(), purposeData__.getValue());
                bitField0_ |= 0x00000200;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. The resource name for a TagKey. Must be in the format
     * `tagKeys/{tag_key_id}`, where `tag_key_id` is the generated numeric id for
     * the TagKey.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The resource name for a TagKey. Must be in the format
     * `tagKeys/{tag_key_id}`, where `tag_key_id` is the generated numeric id for
     * the TagKey.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The resource name for a TagKey. Must be in the format
     * `tagKeys/{tag_key_id}`, where `tag_key_id` is the generated numeric id for
     * the TagKey.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The resource name for a TagKey. Must be in the format
     * `tagKeys/{tag_key_id}`, where `tag_key_id` is the generated numeric id for
     * the TagKey.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The resource name for a TagKey. Must be in the format
     * `tagKeys/{tag_key_id}`, where `tag_key_id` is the generated numeric id for
     * the TagKey.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the TagKey's parent. A TagKey can be
     * parented by an Organization or a Project. For a TagKey parented by an
     * Organization, its parent must be in the form `organizations/{org_id}`. For
     * a TagKey parented by a Project, its parent can be in the form
     * `projects/{project_id}` or `projects/{project_number}`.
     * </pre>
     *
     * <code>string parent = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the TagKey's parent. A TagKey can be
     * parented by an Organization or a Project. For a TagKey parented by an
     * Organization, its parent must be in the form `organizations/{org_id}`. For
     * a TagKey parented by a Project, its parent can be in the form
     * `projects/{project_id}` or `projects/{project_number}`.
     * </pre>
     *
     * <code>string parent = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the TagKey's parent. A TagKey can be
     * parented by an Organization or a Project. For a TagKey parented by an
     * Organization, its parent must be in the form `organizations/{org_id}`. For
     * a TagKey parented by a Project, its parent can be in the form
     * `projects/{project_id}` or `projects/{project_number}`.
     * </pre>
     *
     * <code>string parent = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the TagKey's parent. A TagKey can be
     * parented by an Organization or a Project. For a TagKey parented by an
     * Organization, its parent must be in the form `organizations/{org_id}`. For
     * a TagKey parented by a Project, its parent can be in the form
     * `projects/{project_id}` or `projects/{project_number}`.
     * </pre>
     *
     * <code>string parent = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the TagKey's parent. A TagKey can be
     * parented by an Organization or a Project. For a TagKey parented by an
     * Organization, its parent must be in the form `organizations/{org_id}`. For
     * a TagKey parented by a Project, its parent can be in the form
     * `projects/{project_id}` or `projects/{project_number}`.
     * </pre>
     *
     * <code>string parent = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object shortName_ = "";

    /**
     *
     *
     * <pre>
     * Required. Immutable. The user friendly name for a TagKey. The short name
     * should be unique for TagKeys within the same tag namespace.
     *
     * The short name must be 1-63 characters, beginning and ending with
     * an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_),
     * dots (.), and alphanumerics between.
     * </pre>
     *
     * <code>
     * string short_name = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The shortName.
     */
    public java.lang.String getShortName() {
      java.lang.Object ref = shortName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        shortName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. The user friendly name for a TagKey. The short name
     * should be unique for TagKeys within the same tag namespace.
     *
     * The short name must be 1-63 characters, beginning and ending with
     * an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_),
     * dots (.), and alphanumerics between.
     * </pre>
     *
     * <code>
     * string short_name = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for shortName.
     */
    public com.google.protobuf.ByteString getShortNameBytes() {
      java.lang.Object ref = shortName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        shortName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. The user friendly name for a TagKey. The short name
     * should be unique for TagKeys within the same tag namespace.
     *
     * The short name must be 1-63 characters, beginning and ending with
     * an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_),
     * dots (.), and alphanumerics between.
     * </pre>
     *
     * <code>
     * string short_name = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The shortName to set.
     * @return This builder for chaining.
     */
    public Builder setShortName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      shortName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. The user friendly name for a TagKey. The short name
     * should be unique for TagKeys within the same tag namespace.
     *
     * The short name must be 1-63 characters, beginning and ending with
     * an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_),
     * dots (.), and alphanumerics between.
     * </pre>
     *
     * <code>
     * string short_name = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearShortName() {
      shortName_ = getDefaultInstance().getShortName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. The user friendly name for a TagKey. The short name
     * should be unique for TagKeys within the same tag namespace.
     *
     * The short name must be 1-63 characters, beginning and ending with
     * an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_),
     * dots (.), and alphanumerics between.
     * </pre>
     *
     * <code>
     * string short_name = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for shortName to set.
     * @return This builder for chaining.
     */
    public Builder setShortNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      shortName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object namespacedName_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Immutable. Namespaced name of the TagKey.
     * </pre>
     *
     * <code>
     * string namespaced_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The namespacedName.
     */
    public java.lang.String getNamespacedName() {
      java.lang.Object ref = namespacedName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        namespacedName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Immutable. Namespaced name of the TagKey.
     * </pre>
     *
     * <code>
     * string namespaced_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for namespacedName.
     */
    public com.google.protobuf.ByteString getNamespacedNameBytes() {
      java.lang.Object ref = namespacedName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        namespacedName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Immutable. Namespaced name of the TagKey.
     * </pre>
     *
     * <code>
     * string namespaced_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The namespacedName to set.
     * @return This builder for chaining.
     */
    public Builder setNamespacedName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      namespacedName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Immutable. Namespaced name of the TagKey.
     * </pre>
     *
     * <code>
     * string namespaced_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNamespacedName() {
      namespacedName_ = getDefaultInstance().getNamespacedName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Immutable. Namespaced name of the TagKey.
     * </pre>
     *
     * <code>
     * string namespaced_name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for namespacedName to set.
     * @return This builder for chaining.
     */
    public Builder setNamespacedNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      namespacedName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * Optional. User-assigned description of the TagKey. Must not exceed 256
     * characters.
     *
     * Read-write.
     * </pre>
     *
     * <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. User-assigned description of the TagKey. Must not exceed 256
     * characters.
     *
     * Read-write.
     * </pre>
     *
     * <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. User-assigned description of the TagKey. Must not exceed 256
     * characters.
     *
     * Read-write.
     * </pre>
     *
     * <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-assigned description of the TagKey. Must not exceed 256
     * characters.
     *
     * Read-write.
     * </pre>
     *
     * <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-assigned description of the TagKey. Must not exceed 256
     * characters.
     *
     * Read-write.
     * </pre>
     *
     * <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object etag_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Entity tag which users can pass to prevent race conditions. This
     * field is always set in server responses. See UpdateTagKeyRequest for
     * details.
     * </pre>
     *
     * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Entity tag which users can pass to prevent race conditions. This
     * field is always set in server responses. See UpdateTagKeyRequest for
     * details.
     * </pre>
     *
     * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Entity tag which users can pass to prevent race conditions. This
     * field is always set in server responses. See UpdateTagKeyRequest for
     * details.
     * </pre>
     *
     * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Entity tag which users can pass to prevent race conditions. This
     * field is always set in server responses. See UpdateTagKeyRequest for
     * details.
     * </pre>
     *
     * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Entity tag which users can pass to prevent race conditions. This
     * field is always set in server responses. See UpdateTagKeyRequest for
     * details.
     * </pre>
     *
     * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private int purpose_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. A purpose denotes that this Tag is intended for use in policies
     * of a specific policy engine, and will involve that policy engine in
     * management operations involving this Tag. A purpose does not grant a
     * policy engine exclusive rights to the Tag, and it may be referenced by
     * other policy engines.
     *
     * A purpose cannot be changed once set.
     * </pre>
     *
     * <code>
     * .google.cloud.resourcemanager.v3.Purpose purpose = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for purpose.
     */
    @java.lang.Override
    public int getPurposeValue() {
      return purpose_;
    }

    /**
     *
     *
     * <pre>
     * Optional. A purpose denotes that this Tag is intended for use in policies
     * of a specific policy engine, and will involve that policy engine in
     * management operations involving this Tag. A purpose does not grant a
     * policy engine exclusive rights to the Tag, and it may be referenced by
     * other policy engines.
     *
     * A purpose cannot be changed once set.
     * </pre>
     *
     * <code>
     * .google.cloud.resourcemanager.v3.Purpose purpose = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for purpose to set.
     * @return This builder for chaining.
     */
    public Builder setPurposeValue(int value) {
      purpose_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A purpose denotes that this Tag is intended for use in policies
     * of a specific policy engine, and will involve that policy engine in
     * management operations involving this Tag. A purpose does not grant a
     * policy engine exclusive rights to the Tag, and it may be referenced by
     * other policy engines.
     *
     * A purpose cannot be changed once set.
     * </pre>
     *
     * <code>
     * .google.cloud.resourcemanager.v3.Purpose purpose = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The purpose.
     */
    @java.lang.Override
    public com.google.cloud.resourcemanager.v3.Purpose getPurpose() {
      com.google.cloud.resourcemanager.v3.Purpose result =
          com.google.cloud.resourcemanager.v3.Purpose.forNumber(purpose_);
      return result == null ? com.google.cloud.resourcemanager.v3.Purpose.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. A purpose denotes that this Tag is intended for use in policies
     * of a specific policy engine, and will involve that policy engine in
     * management operations involving this Tag. A purpose does not grant a
     * policy engine exclusive rights to the Tag, and it may be referenced by
     * other policy engines.
     *
     * A purpose cannot be changed once set.
     * </pre>
     *
     * <code>
     * .google.cloud.resourcemanager.v3.Purpose purpose = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The purpose to set.
     * @return This builder for chaining.
     */
    public Builder setPurpose(com.google.cloud.resourcemanager.v3.Purpose value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      purpose_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A purpose denotes that this Tag is intended for use in policies
     * of a specific policy engine, and will involve that policy engine in
     * management operations involving this Tag. A purpose does not grant a
     * policy engine exclusive rights to the Tag, and it may be referenced by
     * other policy engines.
     *
     * A purpose cannot be changed once set.
     * </pre>
     *
     * <code>
     * .google.cloud.resourcemanager.v3.Purpose purpose = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPurpose() {
      bitField0_ = (bitField0_ & ~0x00000100);
      purpose_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> purposeData_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetPurposeData() {
      if (purposeData_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            PurposeDataDefaultEntryHolder.defaultEntry);
      }
      return purposeData_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutablePurposeData() {
      if (purposeData_ == null) {
        purposeData_ =
            com.google.protobuf.MapField.newMapField(PurposeDataDefaultEntryHolder.defaultEntry);
      }
      if (!purposeData_.isMutable()) {
        purposeData_ = purposeData_.copy();
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return purposeData_;
    }

    public int getPurposeDataCount() {
      return internalGetPurposeData().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Purpose data corresponds to the policy system that the tag is
     * intended for. See documentation for `Purpose` for formatting of this field.
     *
     * Purpose data cannot be changed once set.
     * </pre>
     *
     * <code>map&lt;string, string&gt; purpose_data = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsPurposeData(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetPurposeData().getMap().containsKey(key);
    }

    /** Use {@link #getPurposeDataMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getPurposeData() {
      return getPurposeDataMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Purpose data corresponds to the policy system that the tag is
     * intended for. See documentation for `Purpose` for formatting of this field.
     *
     * Purpose data cannot be changed once set.
     * </pre>
     *
     * <code>map&lt;string, string&gt; purpose_data = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getPurposeDataMap() {
      return internalGetPurposeData().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Purpose data corresponds to the policy system that the tag is
     * intended for. See documentation for `Purpose` for formatting of this field.
     *
     * Purpose data cannot be changed once set.
     * </pre>
     *
     * <code>map&lt;string, string&gt; purpose_data = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getPurposeDataOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetPurposeData().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. Purpose data corresponds to the policy system that the tag is
     * intended for. See documentation for `Purpose` for formatting of this field.
     *
     * Purpose data cannot be changed once set.
     * </pre>
     *
     * <code>map&lt;string, string&gt; purpose_data = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getPurposeDataOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetPurposeData().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearPurposeData() {
      bitField0_ = (bitField0_ & ~0x00000200);
      internalGetMutablePurposeData().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Purpose data corresponds to the policy system that the tag is
     * intended for. See documentation for `Purpose` for formatting of this field.
     *
     * Purpose data cannot be changed once set.
     * </pre>
     *
     * <code>map&lt;string, string&gt; purpose_data = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removePurposeData(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutablePurposeData().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutablePurposeData() {
      bitField0_ |= 0x00000200;
      return internalGetMutablePurposeData().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Purpose data corresponds to the policy system that the tag is
     * intended for. See documentation for `Purpose` for formatting of this field.
     *
     * Purpose data cannot be changed once set.
     * </pre>
     *
     * <code>map&lt;string, string&gt; purpose_data = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putPurposeData(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutablePurposeData().getMutableMap().put(key, value);
      bitField0_ |= 0x00000200;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Purpose data corresponds to the policy system that the tag is
     * intended for. See documentation for `Purpose` for formatting of this field.
     *
     * Purpose data cannot be changed once set.
     * </pre>
     *
     * <code>map&lt;string, string&gt; purpose_data = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllPurposeData(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutablePurposeData().getMutableMap().putAll(values);
      bitField0_ |= 0x00000200;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.resourcemanager.v3.TagKey)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.resourcemanager.v3.TagKey)
  private static final com.google.cloud.resourcemanager.v3.TagKey DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.resourcemanager.v3.TagKey();
  }

  public static com.google.cloud.resourcemanager.v3.TagKey getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TagKey> PARSER =
      new com.google.protobuf.AbstractParser<TagKey>() {
        @java.lang.Override
        public TagKey parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TagKey> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TagKey> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.resourcemanager.v3.TagKey getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
