/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FolderName
implements ResourceName {
    private static final PathTemplate FOLDER = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}");
    private volatile Map<String, String> fieldValuesMap;
    private final String folder;

    @Deprecated
    protected FolderName() {
        this.folder = null;
    }

    private FolderName(Builder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
    }

    public String getFolder() {
        return this.folder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FolderName of(String folder) {
        return FolderName.newBuilder().setFolder(folder).build();
    }

    public static String format(String folder) {
        return FolderName.newBuilder().setFolder(folder).build().toString();
    }

    public static FolderName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = FOLDER.validatedMatch(formattedString, "FolderName.parse: formattedString not in valid format");
        return FolderName.of((String)matchMap.get("folder"));
    }

    public static List<FolderName> parseList(List<String> formattedStrings) {
        ArrayList<FolderName> list = new ArrayList<FolderName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FolderName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FolderName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FolderName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return FOLDER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FolderName folderName = this;
            synchronized (folderName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return FOLDER.instantiate(new String[]{"folder", this.folder});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            FolderName that = (FolderName)o;
            return Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.folder);
    }

    public static class Builder {
        private String folder;

        protected Builder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public Builder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        private Builder(FolderName folderName) {
            this.folder = folderName.folder;
        }

        public FolderName build() {
            return new FolderName(this);
        }
    }
}

