/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TagBindingName
implements ResourceName {
    private static final PathTemplate TAG_BINDING = PathTemplate.createWithoutUrlEncoding((String)"tagBindings/{tag_binding}");
    private volatile Map<String, String> fieldValuesMap;
    private final String tagBinding;

    @Deprecated
    protected TagBindingName() {
        this.tagBinding = null;
    }

    private TagBindingName(Builder builder) {
        this.tagBinding = (String)Preconditions.checkNotNull((Object)builder.getTagBinding());
    }

    public String getTagBinding() {
        return this.tagBinding;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TagBindingName of(String tagBinding) {
        return TagBindingName.newBuilder().setTagBinding(tagBinding).build();
    }

    public static String format(String tagBinding) {
        return TagBindingName.newBuilder().setTagBinding(tagBinding).build().toString();
    }

    public static TagBindingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = TAG_BINDING.validatedMatch(formattedString, "TagBindingName.parse: formattedString not in valid format");
        return TagBindingName.of((String)matchMap.get("tag_binding"));
    }

    public static List<TagBindingName> parseList(List<String> formattedStrings) {
        ArrayList<TagBindingName> list = new ArrayList<TagBindingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TagBindingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TagBindingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TagBindingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return TAG_BINDING.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TagBindingName tagBindingName = this;
            synchronized (tagBindingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.tagBinding != null) {
                        fieldMapBuilder.put((Object)"tag_binding", (Object)this.tagBinding);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return TAG_BINDING.instantiate(new String[]{"tag_binding", this.tagBinding});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            TagBindingName that = (TagBindingName)o;
            return Objects.equals(this.tagBinding, that.tagBinding);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.tagBinding);
    }

    public static class Builder {
        private String tagBinding;

        protected Builder() {
        }

        public String getTagBinding() {
            return this.tagBinding;
        }

        public Builder setTagBinding(String tagBinding) {
            this.tagBinding = tagBinding;
            return this;
        }

        private Builder(TagBindingName tagBindingName) {
            this.tagBinding = tagBindingName.tagBinding;
        }

        public TagBindingName build() {
            return new TagBindingName(this);
        }
    }
}

