/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommender.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InsightTypeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_INSIGHT_TYPE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/insightTypes/{insight_type}");
    private static final PathTemplate BILLING_ACCOUNT_LOCATION_INSIGHT_TYPE = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}/locations/{location}/insightTypes/{insight_type}");
    private static final PathTemplate FOLDER_LOCATION_INSIGHT_TYPE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}/insightTypes/{insight_type}");
    private static final PathTemplate ORGANIZATION_LOCATION_INSIGHT_TYPE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/insightTypes/{insight_type}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String insightType;
    private final String billingAccount;
    private final String folder;
    private final String organization;

    @Deprecated
    protected InsightTypeName() {
        this.project = null;
        this.location = null;
        this.insightType = null;
        this.billingAccount = null;
        this.folder = null;
        this.organization = null;
    }

    private InsightTypeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.insightType = (String)Preconditions.checkNotNull((Object)builder.getInsightType());
        this.billingAccount = null;
        this.folder = null;
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_INSIGHT_TYPE;
    }

    private InsightTypeName(BillingAccountLocationInsightTypeBuilder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.insightType = (String)Preconditions.checkNotNull((Object)builder.getInsightType());
        this.project = null;
        this.folder = null;
        this.organization = null;
        this.pathTemplate = BILLING_ACCOUNT_LOCATION_INSIGHT_TYPE;
    }

    private InsightTypeName(FolderLocationInsightTypeBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.insightType = (String)Preconditions.checkNotNull((Object)builder.getInsightType());
        this.project = null;
        this.billingAccount = null;
        this.organization = null;
        this.pathTemplate = FOLDER_LOCATION_INSIGHT_TYPE;
    }

    private InsightTypeName(OrganizationLocationInsightTypeBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.insightType = (String)Preconditions.checkNotNull((Object)builder.getInsightType());
        this.project = null;
        this.billingAccount = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_LOCATION_INSIGHT_TYPE;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInsightType() {
        return this.insightType;
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationInsightTypeBuilder() {
        return new Builder();
    }

    public static BillingAccountLocationInsightTypeBuilder newBillingAccountLocationInsightTypeBuilder() {
        return new BillingAccountLocationInsightTypeBuilder();
    }

    public static FolderLocationInsightTypeBuilder newFolderLocationInsightTypeBuilder() {
        return new FolderLocationInsightTypeBuilder();
    }

    public static OrganizationLocationInsightTypeBuilder newOrganizationLocationInsightTypeBuilder() {
        return new OrganizationLocationInsightTypeBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InsightTypeName of(String project, String location, String insightType) {
        return InsightTypeName.newBuilder().setProject(project).setLocation(location).setInsightType(insightType).build();
    }

    public static InsightTypeName ofProjectLocationInsightTypeName(String project, String location, String insightType) {
        return InsightTypeName.newBuilder().setProject(project).setLocation(location).setInsightType(insightType).build();
    }

    public static InsightTypeName ofBillingAccountLocationInsightTypeName(String billingAccount, String location, String insightType) {
        return InsightTypeName.newBillingAccountLocationInsightTypeBuilder().setBillingAccount(billingAccount).setLocation(location).setInsightType(insightType).build();
    }

    public static InsightTypeName ofFolderLocationInsightTypeName(String folder, String location, String insightType) {
        return InsightTypeName.newFolderLocationInsightTypeBuilder().setFolder(folder).setLocation(location).setInsightType(insightType).build();
    }

    public static InsightTypeName ofOrganizationLocationInsightTypeName(String organization, String location, String insightType) {
        return InsightTypeName.newOrganizationLocationInsightTypeBuilder().setOrganization(organization).setLocation(location).setInsightType(insightType).build();
    }

    public static String format(String project, String location, String insightType) {
        return InsightTypeName.newBuilder().setProject(project).setLocation(location).setInsightType(insightType).build().toString();
    }

    public static String formatProjectLocationInsightTypeName(String project, String location, String insightType) {
        return InsightTypeName.newBuilder().setProject(project).setLocation(location).setInsightType(insightType).build().toString();
    }

    public static String formatBillingAccountLocationInsightTypeName(String billingAccount, String location, String insightType) {
        return InsightTypeName.newBillingAccountLocationInsightTypeBuilder().setBillingAccount(billingAccount).setLocation(location).setInsightType(insightType).build().toString();
    }

    public static String formatFolderLocationInsightTypeName(String folder, String location, String insightType) {
        return InsightTypeName.newFolderLocationInsightTypeBuilder().setFolder(folder).setLocation(location).setInsightType(insightType).build().toString();
    }

    public static String formatOrganizationLocationInsightTypeName(String organization, String location, String insightType) {
        return InsightTypeName.newOrganizationLocationInsightTypeBuilder().setOrganization(organization).setLocation(location).setInsightType(insightType).build().toString();
    }

    public static InsightTypeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_INSIGHT_TYPE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_INSIGHT_TYPE.match(formattedString);
            return InsightTypeName.ofProjectLocationInsightTypeName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("insight_type"));
        }
        if (BILLING_ACCOUNT_LOCATION_INSIGHT_TYPE.matches(formattedString)) {
            Map matchMap = BILLING_ACCOUNT_LOCATION_INSIGHT_TYPE.match(formattedString);
            return InsightTypeName.ofBillingAccountLocationInsightTypeName((String)matchMap.get("billing_account"), (String)matchMap.get("location"), (String)matchMap.get("insight_type"));
        }
        if (FOLDER_LOCATION_INSIGHT_TYPE.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION_INSIGHT_TYPE.match(formattedString);
            return InsightTypeName.ofFolderLocationInsightTypeName((String)matchMap.get("folder"), (String)matchMap.get("location"), (String)matchMap.get("insight_type"));
        }
        if (ORGANIZATION_LOCATION_INSIGHT_TYPE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_INSIGHT_TYPE.match(formattedString);
            return InsightTypeName.ofOrganizationLocationInsightTypeName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("insight_type"));
        }
        throw new ValidationException("InsightTypeName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<InsightTypeName> parseList(List<String> formattedStrings) {
        ArrayList<InsightTypeName> list = new ArrayList<InsightTypeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InsightTypeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InsightTypeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InsightTypeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_INSIGHT_TYPE.matches(formattedString) || BILLING_ACCOUNT_LOCATION_INSIGHT_TYPE.matches(formattedString) || FOLDER_LOCATION_INSIGHT_TYPE.matches(formattedString) || ORGANIZATION_LOCATION_INSIGHT_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InsightTypeName insightTypeName = this;
            synchronized (insightTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.insightType != null) {
                        fieldMapBuilder.put((Object)"insight_type", (Object)this.insightType);
                    }
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put((Object)"billing_account", (Object)this.billingAccount);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            InsightTypeName that = (InsightTypeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.insightType, that.insightType) && Objects.equals(this.billingAccount, that.billingAccount) && Objects.equals(this.folder, that.folder) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.insightType);
        h *= 1000003;
        h ^= Objects.hashCode(this.billingAccount);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    public static class OrganizationLocationInsightTypeBuilder {
        private String organization;
        private String location;
        private String insightType;

        protected OrganizationLocationInsightTypeBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInsightType() {
            return this.insightType;
        }

        public OrganizationLocationInsightTypeBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationInsightTypeBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationInsightTypeBuilder setInsightType(String insightType) {
            this.insightType = insightType;
            return this;
        }

        public InsightTypeName build() {
            return new InsightTypeName(this);
        }
    }

    public static class FolderLocationInsightTypeBuilder {
        private String folder;
        private String location;
        private String insightType;

        protected FolderLocationInsightTypeBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInsightType() {
            return this.insightType;
        }

        public FolderLocationInsightTypeBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationInsightTypeBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationInsightTypeBuilder setInsightType(String insightType) {
            this.insightType = insightType;
            return this;
        }

        public InsightTypeName build() {
            return new InsightTypeName(this);
        }
    }

    public static class BillingAccountLocationInsightTypeBuilder {
        private String billingAccount;
        private String location;
        private String insightType;

        protected BillingAccountLocationInsightTypeBuilder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInsightType() {
            return this.insightType;
        }

        public BillingAccountLocationInsightTypeBuilder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public BillingAccountLocationInsightTypeBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public BillingAccountLocationInsightTypeBuilder setInsightType(String insightType) {
            this.insightType = insightType;
            return this;
        }

        public InsightTypeName build() {
            return new InsightTypeName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String insightType;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInsightType() {
            return this.insightType;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInsightType(String insightType) {
            this.insightType = insightType;
            return this;
        }

        private Builder(InsightTypeName insightTypeName) {
            Preconditions.checkArgument((boolean)Objects.equals(insightTypeName.pathTemplate, PROJECT_LOCATION_INSIGHT_TYPE), (Object)"toBuilder is only supported when InsightTypeName has the pattern of projects/{project}/locations/{location}/insightTypes/{insight_type}");
            this.project = insightTypeName.project;
            this.location = insightTypeName.location;
            this.insightType = insightTypeName.insightType;
        }

        public InsightTypeName build() {
            return new InsightTypeName(this);
        }
    }
}

