/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommender.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RecommenderName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RECOMMENDER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/recommenders/{recommender}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String recommender;

    @Deprecated
    protected RecommenderName() {
        this.project = null;
        this.location = null;
        this.recommender = null;
    }

    private RecommenderName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.recommender = (String)Preconditions.checkNotNull((Object)builder.getRecommender());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRecommender() {
        return this.recommender;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RecommenderName of(String project, String location, String recommender) {
        return RecommenderName.newBuilder().setProject(project).setLocation(location).setRecommender(recommender).build();
    }

    public static String format(String project, String location, String recommender) {
        return RecommenderName.newBuilder().setProject(project).setLocation(location).setRecommender(recommender).build().toString();
    }

    public static RecommenderName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RECOMMENDER.validatedMatch(formattedString, "RecommenderName.parse: formattedString not in valid format");
        return RecommenderName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("recommender"));
    }

    public static List<RecommenderName> parseList(List<String> formattedStrings) {
        ArrayList<RecommenderName> list = new ArrayList<RecommenderName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RecommenderName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RecommenderName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RecommenderName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RECOMMENDER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RecommenderName recommenderName = this;
            synchronized (recommenderName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.recommender != null) {
                        fieldMapBuilder.put((Object)"recommender", (Object)this.recommender);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RECOMMENDER.instantiate(new String[]{"project", this.project, "location", this.location, "recommender", this.recommender});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            RecommenderName that = (RecommenderName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.recommender, that.recommender);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.recommender);
    }

    public static class Builder {
        private String project;
        private String location;
        private String recommender;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRecommender() {
            return this.recommender;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRecommender(String recommender) {
            this.recommender = recommender;
            return this;
        }

        private Builder(RecommenderName recommenderName) {
            this.project = recommenderName.project;
            this.location = recommenderName.location;
            this.recommender = recommenderName.recommender;
        }

        public RecommenderName build() {
            return new RecommenderName(this);
        }
    }
}

