/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.proto;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SubscriptionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/subscriptions/{subscription}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String subscription;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private SubscriptionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.subscription = (String)Preconditions.checkNotNull((Object)builder.getSubscription());
    }

    public static SubscriptionName of(String project, String location, String subscription) {
        return SubscriptionName.newBuilder().setProject(project).setLocation(location).setSubscription(subscription).build();
    }

    public static String format(String project, String location, String subscription) {
        return SubscriptionName.newBuilder().setProject(project).setLocation(location).setSubscription(subscription).build().toString();
    }

    public static SubscriptionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "SubscriptionName.parse: formattedString not in valid format");
        return SubscriptionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("subscription"));
    }

    public static List<SubscriptionName> parseList(List<String> formattedStrings) {
        ArrayList<SubscriptionName> list = new ArrayList<SubscriptionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SubscriptionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SubscriptionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SubscriptionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SubscriptionName subscriptionName = this;
            synchronized (subscriptionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"subscription", (Object)this.subscription);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "subscription", this.subscription});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SubscriptionName) {
            SubscriptionName that = (SubscriptionName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.subscription.equals(that.subscription);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.subscription.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String subscription;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSubscription() {
            return this.subscription;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSubscription(String subscription) {
            this.subscription = subscription;
            return this;
        }

        private Builder() {
        }

        private Builder(SubscriptionName subscriptionName) {
            this.project = subscriptionName.project;
            this.location = subscriptionName.location;
            this.subscription = subscriptionName.subscription;
        }

        public SubscriptionName build() {
            return new SubscriptionName(this);
        }
    }
}

