/*
 * Decompiled with CFR 0.152.
 */
package com.google.pubsub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SchemaName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/schemas/{schema}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String schema;

    public String getProject() {
        return this.project;
    }

    public String getSchema() {
        return this.schema;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private SchemaName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.schema = (String)Preconditions.checkNotNull((Object)builder.getSchema());
    }

    public static SchemaName of(String project, String schema) {
        return SchemaName.newBuilder().setProject(project).setSchema(schema).build();
    }

    public static String format(String project, String schema) {
        return SchemaName.newBuilder().setProject(project).setSchema(schema).build().toString();
    }

    public static SchemaName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "SchemaName.parse: formattedString not in valid format");
        return SchemaName.of((String)matchMap.get("project"), (String)matchMap.get("schema"));
    }

    public static List<SchemaName> parseList(List<String> formattedStrings) {
        ArrayList<SchemaName> list = new ArrayList<SchemaName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SchemaName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SchemaName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SchemaName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SchemaName schemaName = this;
            synchronized (schemaName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"schema", (Object)this.schema);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "schema", this.schema});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SchemaName) {
            SchemaName that = (SchemaName)o;
            return this.project.equals(that.project) && this.schema.equals(that.schema);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.schema.hashCode();
    }

    public static class Builder {
        private String project;
        private String schema;

        public String getProject() {
            return this.project;
        }

        public String getSchema() {
            return this.schema;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        private Builder() {
        }

        private Builder(SchemaName schemaName) {
            this.project = schemaName.project;
            this.schema = schemaName.schema;
        }

        public SchemaName build() {
            return new SchemaName(this);
        }
    }
}

