/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/pubsub.proto

// Protobuf Java Version: 3.25.5
package com.google.pubsub.v1;

/**
 *
 *
 * <pre>
 * Configuration for a BigQuery subscription.
 * </pre>
 *
 * Protobuf type {@code google.pubsub.v1.BigQueryConfig}
 */
public final class BigQueryConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.pubsub.v1.BigQueryConfig)
    BigQueryConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BigQueryConfig.newBuilder() to construct.
  private BigQueryConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BigQueryConfig() {
    table_ = "";
    state_ = 0;
    serviceAccountEmail_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BigQueryConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_BigQueryConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_BigQueryConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.pubsub.v1.BigQueryConfig.class,
            com.google.pubsub.v1.BigQueryConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible states for a BigQuery subscription.
   * </pre>
   *
   * Protobuf enum {@code google.pubsub.v1.BigQueryConfig.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The subscription can actively send messages to BigQuery
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    ACTIVE(1),
    /**
     *
     *
     * <pre>
     * Cannot write to the BigQuery table because of permission denied errors.
     * This can happen if
     * - Pub/Sub SA has not been granted the [appropriate BigQuery IAM
     * permissions](https://cloud.google.com/pubsub/docs/create-subscription#assign_bigquery_service_account)
     * - bigquery.googleapis.com API is not enabled for the project
     * ([instructions](https://cloud.google.com/service-usage/docs/enable-disable))
     * </pre>
     *
     * <code>PERMISSION_DENIED = 2;</code>
     */
    PERMISSION_DENIED(2),
    /**
     *
     *
     * <pre>
     * Cannot write to the BigQuery table because it does not exist.
     * </pre>
     *
     * <code>NOT_FOUND = 3;</code>
     */
    NOT_FOUND(3),
    /**
     *
     *
     * <pre>
     * Cannot write to the BigQuery table due to a schema mismatch.
     * </pre>
     *
     * <code>SCHEMA_MISMATCH = 4;</code>
     */
    SCHEMA_MISMATCH(4),
    /**
     *
     *
     * <pre>
     * Cannot write to the destination because enforce_in_transit is set to true
     * and the destination locations are not in the allowed regions.
     * </pre>
     *
     * <code>IN_TRANSIT_LOCATION_RESTRICTION = 5;</code>
     */
    IN_TRANSIT_LOCATION_RESTRICTION(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The subscription can actively send messages to BigQuery
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    public static final int ACTIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Cannot write to the BigQuery table because of permission denied errors.
     * This can happen if
     * - Pub/Sub SA has not been granted the [appropriate BigQuery IAM
     * permissions](https://cloud.google.com/pubsub/docs/create-subscription#assign_bigquery_service_account)
     * - bigquery.googleapis.com API is not enabled for the project
     * ([instructions](https://cloud.google.com/service-usage/docs/enable-disable))
     * </pre>
     *
     * <code>PERMISSION_DENIED = 2;</code>
     */
    public static final int PERMISSION_DENIED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Cannot write to the BigQuery table because it does not exist.
     * </pre>
     *
     * <code>NOT_FOUND = 3;</code>
     */
    public static final int NOT_FOUND_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Cannot write to the BigQuery table due to a schema mismatch.
     * </pre>
     *
     * <code>SCHEMA_MISMATCH = 4;</code>
     */
    public static final int SCHEMA_MISMATCH_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Cannot write to the destination because enforce_in_transit is set to true
     * and the destination locations are not in the allowed regions.
     * </pre>
     *
     * <code>IN_TRANSIT_LOCATION_RESTRICTION = 5;</code>
     */
    public static final int IN_TRANSIT_LOCATION_RESTRICTION_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return ACTIVE;
        case 2:
          return PERMISSION_DENIED;
        case 3:
          return NOT_FOUND;
        case 4:
          return SCHEMA_MISMATCH;
        case 5:
          return IN_TRANSIT_LOCATION_RESTRICTION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.pubsub.v1.BigQueryConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.pubsub.v1.BigQueryConfig.State)
  }

  public static final int TABLE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object table_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The name of the table to which to write data, of the form
   * {projectId}.{datasetId}.{tableId}
   * </pre>
   *
   * <code>string table = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The table.
   */
  @java.lang.Override
  public java.lang.String getTable() {
    java.lang.Object ref = table_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      table_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of the table to which to write data, of the form
   * {projectId}.{datasetId}.{tableId}
   * </pre>
   *
   * <code>string table = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for table.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableBytes() {
    java.lang.Object ref = table_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      table_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USE_TOPIC_SCHEMA_FIELD_NUMBER = 2;
  private boolean useTopicSchema_ = false;
  /**
   *
   *
   * <pre>
   * Optional. When true, use the topic's schema as the columns to write to in
   * BigQuery, if it exists. `use_topic_schema` and `use_table_schema` cannot be
   * enabled at the same time.
   * </pre>
   *
   * <code>bool use_topic_schema = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The useTopicSchema.
   */
  @java.lang.Override
  public boolean getUseTopicSchema() {
    return useTopicSchema_;
  }

  public static final int WRITE_METADATA_FIELD_NUMBER = 3;
  private boolean writeMetadata_ = false;
  /**
   *
   *
   * <pre>
   * Optional. When true, write the subscription name, message_id, publish_time,
   * attributes, and ordering_key to additional columns in the table. The
   * subscription name, message_id, and publish_time fields are put in their own
   * columns while all other message properties (other than data) are written to
   * a JSON object in the attributes column.
   * </pre>
   *
   * <code>bool write_metadata = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The writeMetadata.
   */
  @java.lang.Override
  public boolean getWriteMetadata() {
    return writeMetadata_;
  }

  public static final int DROP_UNKNOWN_FIELDS_FIELD_NUMBER = 4;
  private boolean dropUnknownFields_ = false;
  /**
   *
   *
   * <pre>
   * Optional. When true and use_topic_schema is true, any fields that are a
   * part of the topic schema that are not part of the BigQuery table schema are
   * dropped when writing to BigQuery. Otherwise, the schemas must be kept in
   * sync and any messages with extra fields are not written and remain in the
   * subscription's backlog.
   * </pre>
   *
   * <code>bool drop_unknown_fields = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The dropUnknownFields.
   */
  @java.lang.Override
  public boolean getDropUnknownFields() {
    return dropUnknownFields_;
  }

  public static final int STATE_FIELD_NUMBER = 5;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. An output-only field that indicates whether or not the
   * subscription can receive messages.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.BigQueryConfig.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. An output-only field that indicates whether or not the
   * subscription can receive messages.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.BigQueryConfig.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.pubsub.v1.BigQueryConfig.State getState() {
    com.google.pubsub.v1.BigQueryConfig.State result =
        com.google.pubsub.v1.BigQueryConfig.State.forNumber(state_);
    return result == null ? com.google.pubsub.v1.BigQueryConfig.State.UNRECOGNIZED : result;
  }

  public static final int USE_TABLE_SCHEMA_FIELD_NUMBER = 6;
  private boolean useTableSchema_ = false;
  /**
   *
   *
   * <pre>
   * Optional. When true, use the BigQuery table's schema as the columns to
   * write to in BigQuery. `use_table_schema` and `use_topic_schema` cannot be
   * enabled at the same time.
   * </pre>
   *
   * <code>bool use_table_schema = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The useTableSchema.
   */
  @java.lang.Override
  public boolean getUseTableSchema() {
    return useTableSchema_;
  }

  public static final int SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccountEmail_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The service account to use to write to BigQuery. The subscription
   * creator or updater that specifies this field must have
   * `iam.serviceAccounts.actAs` permission on the service account. If not
   * specified, the Pub/Sub [service
   * agent](https://cloud.google.com/iam/docs/service-agents),
   * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com, is used.
   * </pre>
   *
   * <code>string service_account_email = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The serviceAccountEmail.
   */
  @java.lang.Override
  public java.lang.String getServiceAccountEmail() {
    java.lang.Object ref = serviceAccountEmail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccountEmail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The service account to use to write to BigQuery. The subscription
   * creator or updater that specifies this field must have
   * `iam.serviceAccounts.actAs` permission on the service account. If not
   * specified, the Pub/Sub [service
   * agent](https://cloud.google.com/iam/docs/service-agents),
   * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com, is used.
   * </pre>
   *
   * <code>string service_account_email = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for serviceAccountEmail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountEmailBytes() {
    java.lang.Object ref = serviceAccountEmail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccountEmail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, table_);
    }
    if (useTopicSchema_ != false) {
      output.writeBool(2, useTopicSchema_);
    }
    if (writeMetadata_ != false) {
      output.writeBool(3, writeMetadata_);
    }
    if (dropUnknownFields_ != false) {
      output.writeBool(4, dropUnknownFields_);
    }
    if (state_ != com.google.pubsub.v1.BigQueryConfig.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, state_);
    }
    if (useTableSchema_ != false) {
      output.writeBool(6, useTableSchema_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccountEmail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, serviceAccountEmail_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, table_);
    }
    if (useTopicSchema_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, useTopicSchema_);
    }
    if (writeMetadata_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, writeMetadata_);
    }
    if (dropUnknownFields_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, dropUnknownFields_);
    }
    if (state_ != com.google.pubsub.v1.BigQueryConfig.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, state_);
    }
    if (useTableSchema_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, useTableSchema_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccountEmail_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, serviceAccountEmail_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.pubsub.v1.BigQueryConfig)) {
      return super.equals(obj);
    }
    com.google.pubsub.v1.BigQueryConfig other = (com.google.pubsub.v1.BigQueryConfig) obj;

    if (!getTable().equals(other.getTable())) return false;
    if (getUseTopicSchema() != other.getUseTopicSchema()) return false;
    if (getWriteMetadata() != other.getWriteMetadata()) return false;
    if (getDropUnknownFields() != other.getDropUnknownFields()) return false;
    if (state_ != other.state_) return false;
    if (getUseTableSchema() != other.getUseTableSchema()) return false;
    if (!getServiceAccountEmail().equals(other.getServiceAccountEmail())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TABLE_FIELD_NUMBER;
    hash = (53 * hash) + getTable().hashCode();
    hash = (37 * hash) + USE_TOPIC_SCHEMA_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseTopicSchema());
    hash = (37 * hash) + WRITE_METADATA_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getWriteMetadata());
    hash = (37 * hash) + DROP_UNKNOWN_FIELDS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDropUnknownFields());
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + USE_TABLE_SCHEMA_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseTableSchema());
    hash = (37 * hash) + SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccountEmail().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.pubsub.v1.BigQueryConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.BigQueryConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.BigQueryConfig parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.BigQueryConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.BigQueryConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.BigQueryConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.BigQueryConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.BigQueryConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.BigQueryConfig parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.BigQueryConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.BigQueryConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.BigQueryConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.pubsub.v1.BigQueryConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for a BigQuery subscription.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.BigQueryConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.pubsub.v1.BigQueryConfig)
      com.google.pubsub.v1.BigQueryConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_BigQueryConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_BigQueryConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.BigQueryConfig.class,
              com.google.pubsub.v1.BigQueryConfig.Builder.class);
    }

    // Construct using com.google.pubsub.v1.BigQueryConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      table_ = "";
      useTopicSchema_ = false;
      writeMetadata_ = false;
      dropUnknownFields_ = false;
      state_ = 0;
      useTableSchema_ = false;
      serviceAccountEmail_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_BigQueryConfig_descriptor;
    }

    @java.lang.Override
    public com.google.pubsub.v1.BigQueryConfig getDefaultInstanceForType() {
      return com.google.pubsub.v1.BigQueryConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.pubsub.v1.BigQueryConfig build() {
      com.google.pubsub.v1.BigQueryConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.pubsub.v1.BigQueryConfig buildPartial() {
      com.google.pubsub.v1.BigQueryConfig result = new com.google.pubsub.v1.BigQueryConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.pubsub.v1.BigQueryConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.table_ = table_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.useTopicSchema_ = useTopicSchema_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.writeMetadata_ = writeMetadata_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.dropUnknownFields_ = dropUnknownFields_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.useTableSchema_ = useTableSchema_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.serviceAccountEmail_ = serviceAccountEmail_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.pubsub.v1.BigQueryConfig) {
        return mergeFrom((com.google.pubsub.v1.BigQueryConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.pubsub.v1.BigQueryConfig other) {
      if (other == com.google.pubsub.v1.BigQueryConfig.getDefaultInstance()) return this;
      if (!other.getTable().isEmpty()) {
        table_ = other.table_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getUseTopicSchema() != false) {
        setUseTopicSchema(other.getUseTopicSchema());
      }
      if (other.getWriteMetadata() != false) {
        setWriteMetadata(other.getWriteMetadata());
      }
      if (other.getDropUnknownFields() != false) {
        setDropUnknownFields(other.getDropUnknownFields());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.getUseTableSchema() != false) {
        setUseTableSchema(other.getUseTableSchema());
      }
      if (!other.getServiceAccountEmail().isEmpty()) {
        serviceAccountEmail_ = other.serviceAccountEmail_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                table_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                useTopicSchema_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                writeMetadata_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                dropUnknownFields_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                useTableSchema_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                serviceAccountEmail_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object table_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The name of the table to which to write data, of the form
     * {projectId}.{datasetId}.{tableId}
     * </pre>
     *
     * <code>string table = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The table.
     */
    public java.lang.String getTable() {
      java.lang.Object ref = table_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        table_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the table to which to write data, of the form
     * {projectId}.{datasetId}.{tableId}
     * </pre>
     *
     * <code>string table = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for table.
     */
    public com.google.protobuf.ByteString getTableBytes() {
      java.lang.Object ref = table_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        table_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the table to which to write data, of the form
     * {projectId}.{datasetId}.{tableId}
     * </pre>
     *
     * <code>string table = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The table to set.
     * @return This builder for chaining.
     */
    public Builder setTable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      table_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the table to which to write data, of the form
     * {projectId}.{datasetId}.{tableId}
     * </pre>
     *
     * <code>string table = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTable() {
      table_ = getDefaultInstance().getTable();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the table to which to write data, of the form
     * {projectId}.{datasetId}.{tableId}
     * </pre>
     *
     * <code>string table = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for table to set.
     * @return This builder for chaining.
     */
    public Builder setTableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      table_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean useTopicSchema_;
    /**
     *
     *
     * <pre>
     * Optional. When true, use the topic's schema as the columns to write to in
     * BigQuery, if it exists. `use_topic_schema` and `use_table_schema` cannot be
     * enabled at the same time.
     * </pre>
     *
     * <code>bool use_topic_schema = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The useTopicSchema.
     */
    @java.lang.Override
    public boolean getUseTopicSchema() {
      return useTopicSchema_;
    }
    /**
     *
     *
     * <pre>
     * Optional. When true, use the topic's schema as the columns to write to in
     * BigQuery, if it exists. `use_topic_schema` and `use_table_schema` cannot be
     * enabled at the same time.
     * </pre>
     *
     * <code>bool use_topic_schema = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The useTopicSchema to set.
     * @return This builder for chaining.
     */
    public Builder setUseTopicSchema(boolean value) {

      useTopicSchema_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When true, use the topic's schema as the columns to write to in
     * BigQuery, if it exists. `use_topic_schema` and `use_table_schema` cannot be
     * enabled at the same time.
     * </pre>
     *
     * <code>bool use_topic_schema = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUseTopicSchema() {
      bitField0_ = (bitField0_ & ~0x00000002);
      useTopicSchema_ = false;
      onChanged();
      return this;
    }

    private boolean writeMetadata_;
    /**
     *
     *
     * <pre>
     * Optional. When true, write the subscription name, message_id, publish_time,
     * attributes, and ordering_key to additional columns in the table. The
     * subscription name, message_id, and publish_time fields are put in their own
     * columns while all other message properties (other than data) are written to
     * a JSON object in the attributes column.
     * </pre>
     *
     * <code>bool write_metadata = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The writeMetadata.
     */
    @java.lang.Override
    public boolean getWriteMetadata() {
      return writeMetadata_;
    }
    /**
     *
     *
     * <pre>
     * Optional. When true, write the subscription name, message_id, publish_time,
     * attributes, and ordering_key to additional columns in the table. The
     * subscription name, message_id, and publish_time fields are put in their own
     * columns while all other message properties (other than data) are written to
     * a JSON object in the attributes column.
     * </pre>
     *
     * <code>bool write_metadata = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The writeMetadata to set.
     * @return This builder for chaining.
     */
    public Builder setWriteMetadata(boolean value) {

      writeMetadata_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When true, write the subscription name, message_id, publish_time,
     * attributes, and ordering_key to additional columns in the table. The
     * subscription name, message_id, and publish_time fields are put in their own
     * columns while all other message properties (other than data) are written to
     * a JSON object in the attributes column.
     * </pre>
     *
     * <code>bool write_metadata = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWriteMetadata() {
      bitField0_ = (bitField0_ & ~0x00000004);
      writeMetadata_ = false;
      onChanged();
      return this;
    }

    private boolean dropUnknownFields_;
    /**
     *
     *
     * <pre>
     * Optional. When true and use_topic_schema is true, any fields that are a
     * part of the topic schema that are not part of the BigQuery table schema are
     * dropped when writing to BigQuery. Otherwise, the schemas must be kept in
     * sync and any messages with extra fields are not written and remain in the
     * subscription's backlog.
     * </pre>
     *
     * <code>bool drop_unknown_fields = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The dropUnknownFields.
     */
    @java.lang.Override
    public boolean getDropUnknownFields() {
      return dropUnknownFields_;
    }
    /**
     *
     *
     * <pre>
     * Optional. When true and use_topic_schema is true, any fields that are a
     * part of the topic schema that are not part of the BigQuery table schema are
     * dropped when writing to BigQuery. Otherwise, the schemas must be kept in
     * sync and any messages with extra fields are not written and remain in the
     * subscription's backlog.
     * </pre>
     *
     * <code>bool drop_unknown_fields = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The dropUnknownFields to set.
     * @return This builder for chaining.
     */
    public Builder setDropUnknownFields(boolean value) {

      dropUnknownFields_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When true and use_topic_schema is true, any fields that are a
     * part of the topic schema that are not part of the BigQuery table schema are
     * dropped when writing to BigQuery. Otherwise, the schemas must be kept in
     * sync and any messages with extra fields are not written and remain in the
     * subscription's backlog.
     * </pre>
     *
     * <code>bool drop_unknown_fields = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDropUnknownFields() {
      bitField0_ = (bitField0_ & ~0x00000008);
      dropUnknownFields_ = false;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates whether or not the
     * subscription can receive messages.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.BigQueryConfig.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates whether or not the
     * subscription can receive messages.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.BigQueryConfig.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates whether or not the
     * subscription can receive messages.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.BigQueryConfig.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.pubsub.v1.BigQueryConfig.State getState() {
      com.google.pubsub.v1.BigQueryConfig.State result =
          com.google.pubsub.v1.BigQueryConfig.State.forNumber(state_);
      return result == null ? com.google.pubsub.v1.BigQueryConfig.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates whether or not the
     * subscription can receive messages.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.BigQueryConfig.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.pubsub.v1.BigQueryConfig.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates whether or not the
     * subscription can receive messages.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.BigQueryConfig.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      state_ = 0;
      onChanged();
      return this;
    }

    private boolean useTableSchema_;
    /**
     *
     *
     * <pre>
     * Optional. When true, use the BigQuery table's schema as the columns to
     * write to in BigQuery. `use_table_schema` and `use_topic_schema` cannot be
     * enabled at the same time.
     * </pre>
     *
     * <code>bool use_table_schema = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The useTableSchema.
     */
    @java.lang.Override
    public boolean getUseTableSchema() {
      return useTableSchema_;
    }
    /**
     *
     *
     * <pre>
     * Optional. When true, use the BigQuery table's schema as the columns to
     * write to in BigQuery. `use_table_schema` and `use_topic_schema` cannot be
     * enabled at the same time.
     * </pre>
     *
     * <code>bool use_table_schema = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The useTableSchema to set.
     * @return This builder for chaining.
     */
    public Builder setUseTableSchema(boolean value) {

      useTableSchema_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When true, use the BigQuery table's schema as the columns to
     * write to in BigQuery. `use_table_schema` and `use_topic_schema` cannot be
     * enabled at the same time.
     * </pre>
     *
     * <code>bool use_table_schema = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUseTableSchema() {
      bitField0_ = (bitField0_ & ~0x00000020);
      useTableSchema_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccountEmail_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The service account to use to write to BigQuery. The subscription
     * creator or updater that specifies this field must have
     * `iam.serviceAccounts.actAs` permission on the service account. If not
     * specified, the Pub/Sub [service
     * agent](https://cloud.google.com/iam/docs/service-agents),
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com, is used.
     * </pre>
     *
     * <code>string service_account_email = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The serviceAccountEmail.
     */
    public java.lang.String getServiceAccountEmail() {
      java.lang.Object ref = serviceAccountEmail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccountEmail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account to use to write to BigQuery. The subscription
     * creator or updater that specifies this field must have
     * `iam.serviceAccounts.actAs` permission on the service account. If not
     * specified, the Pub/Sub [service
     * agent](https://cloud.google.com/iam/docs/service-agents),
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com, is used.
     * </pre>
     *
     * <code>string service_account_email = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for serviceAccountEmail.
     */
    public com.google.protobuf.ByteString getServiceAccountEmailBytes() {
      java.lang.Object ref = serviceAccountEmail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccountEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account to use to write to BigQuery. The subscription
     * creator or updater that specifies this field must have
     * `iam.serviceAccounts.actAs` permission on the service account. If not
     * specified, the Pub/Sub [service
     * agent](https://cloud.google.com/iam/docs/service-agents),
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com, is used.
     * </pre>
     *
     * <code>string service_account_email = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The serviceAccountEmail to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccountEmail_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account to use to write to BigQuery. The subscription
     * creator or updater that specifies this field must have
     * `iam.serviceAccounts.actAs` permission on the service account. If not
     * specified, the Pub/Sub [service
     * agent](https://cloud.google.com/iam/docs/service-agents),
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com, is used.
     * </pre>
     *
     * <code>string service_account_email = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccountEmail() {
      serviceAccountEmail_ = getDefaultInstance().getServiceAccountEmail();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account to use to write to BigQuery. The subscription
     * creator or updater that specifies this field must have
     * `iam.serviceAccounts.actAs` permission on the service account. If not
     * specified, the Pub/Sub [service
     * agent](https://cloud.google.com/iam/docs/service-agents),
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com, is used.
     * </pre>
     *
     * <code>string service_account_email = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for serviceAccountEmail to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccountEmail_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.pubsub.v1.BigQueryConfig)
  }

  // @@protoc_insertion_point(class_scope:google.pubsub.v1.BigQueryConfig)
  private static final com.google.pubsub.v1.BigQueryConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.pubsub.v1.BigQueryConfig();
  }

  public static com.google.pubsub.v1.BigQueryConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BigQueryConfig> PARSER =
      new com.google.protobuf.AbstractParser<BigQueryConfig>() {
        @java.lang.Override
        public BigQueryConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BigQueryConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BigQueryConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.pubsub.v1.BigQueryConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
