/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/pubsub.proto

// Protobuf Java Version: 3.25.5
package com.google.pubsub.v1;

/**
 *
 *
 * <pre>
 * Settings for an ingestion data source on a topic.
 * </pre>
 *
 * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings}
 */
public final class IngestionDataSourceSettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionDataSourceSettings)
    IngestionDataSourceSettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use IngestionDataSourceSettings.newBuilder() to construct.
  private IngestionDataSourceSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IngestionDataSourceSettings() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IngestionDataSourceSettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_IngestionDataSourceSettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_IngestionDataSourceSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.pubsub.v1.IngestionDataSourceSettings.class,
            com.google.pubsub.v1.IngestionDataSourceSettings.Builder.class);
  }

  public interface AwsKinesisOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Kinesis
     * ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Kinesis
     * ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State getState();

    /**
     *
     *
     * <pre>
     * Required. The Kinesis stream ARN to ingest data from.
     * </pre>
     *
     * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The streamArn.
     */
    java.lang.String getStreamArn();
    /**
     *
     *
     * <pre>
     * Required. The Kinesis stream ARN to ingest data from.
     * </pre>
     *
     * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for streamArn.
     */
    com.google.protobuf.ByteString getStreamArnBytes();

    /**
     *
     *
     * <pre>
     * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
     * Fan-Out mode. The consumer must be already created and ready to be used.
     * </pre>
     *
     * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The consumerArn.
     */
    java.lang.String getConsumerArn();
    /**
     *
     *
     * <pre>
     * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
     * Fan-Out mode. The consumer must be already created and ready to be used.
     * </pre>
     *
     * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for consumerArn.
     */
    com.google.protobuf.ByteString getConsumerArnBytes();

    /**
     *
     *
     * <pre>
     * Required. AWS role ARN to be used for Federated Identity authentication
     * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
     * required permissions that need to be attached to it.
     * </pre>
     *
     * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The awsRoleArn.
     */
    java.lang.String getAwsRoleArn();
    /**
     *
     *
     * <pre>
     * Required. AWS role ARN to be used for Federated Identity authentication
     * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
     * required permissions that need to be attached to it.
     * </pre>
     *
     * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for awsRoleArn.
     */
    com.google.protobuf.ByteString getAwsRoleArnBytes();

    /**
     *
     *
     * <pre>
     * Required. The GCP service account to be used for Federated Identity
     * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
     * the provided role). The `aws_role_arn` must be set up with
     * `accounts.google.com:sub` equals to this service account number.
     * </pre>
     *
     * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The gcpServiceAccount.
     */
    java.lang.String getGcpServiceAccount();
    /**
     *
     *
     * <pre>
     * Required. The GCP service account to be used for Federated Identity
     * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
     * the provided role). The `aws_role_arn` must be set up with
     * `accounts.google.com:sub` equals to this service account number.
     * </pre>
     *
     * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for gcpServiceAccount.
     */
    com.google.protobuf.ByteString getGcpServiceAccountBytes();
  }
  /**
   *
   *
   * <pre>
   * Ingestion settings for Amazon Kinesis Data Streams.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis}
   */
  public static final class AwsKinesis extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis)
      AwsKinesisOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AwsKinesis.newBuilder() to construct.
    private AwsKinesis(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AwsKinesis() {
      state_ = 0;
      streamArn_ = "";
      consumerArn_ = "";
      awsRoleArn_ = "";
      gcpServiceAccount_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AwsKinesis();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AwsKinesis_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AwsKinesis_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.class,
              com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Possible states for ingestion from Amazon Kinesis Data Streams.
     * </pre>
     *
     * Protobuf enum {@code google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State}
     */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Ingestion is active.
       * </pre>
       *
       * <code>ACTIVE = 1;</code>
       */
      ACTIVE(1),
      /**
       *
       *
       * <pre>
       * Permission denied encountered while consuming data from Kinesis.
       * This can happen if:
       *   - The provided `aws_role_arn` does not exist or does not have the
       *     appropriate permissions attached.
       *   - The provided `aws_role_arn` is not set up properly for Identity
       *     Federation using `gcp_service_account`.
       *   - The Pub/Sub SA is not granted the
       *     `iam.serviceAccounts.getOpenIdToken` permission on
       *     `gcp_service_account`.
       * </pre>
       *
       * <code>KINESIS_PERMISSION_DENIED = 2;</code>
       */
      KINESIS_PERMISSION_DENIED(2),
      /**
       *
       *
       * <pre>
       * Permission denied encountered while publishing to the topic. This can
       * happen if the Pub/Sub SA has not been granted the [appropriate publish
       * permissions](https://cloud.google.com/pubsub/docs/access-control#pubsub.publisher)
       * </pre>
       *
       * <code>PUBLISH_PERMISSION_DENIED = 3;</code>
       */
      PUBLISH_PERMISSION_DENIED(3),
      /**
       *
       *
       * <pre>
       * The Kinesis stream does not exist.
       * </pre>
       *
       * <code>STREAM_NOT_FOUND = 4;</code>
       */
      STREAM_NOT_FOUND(4),
      /**
       *
       *
       * <pre>
       * The Kinesis consumer does not exist.
       * </pre>
       *
       * <code>CONSUMER_NOT_FOUND = 5;</code>
       */
      CONSUMER_NOT_FOUND(5),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      public static final int STATE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Ingestion is active.
       * </pre>
       *
       * <code>ACTIVE = 1;</code>
       */
      public static final int ACTIVE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Permission denied encountered while consuming data from Kinesis.
       * This can happen if:
       *   - The provided `aws_role_arn` does not exist or does not have the
       *     appropriate permissions attached.
       *   - The provided `aws_role_arn` is not set up properly for Identity
       *     Federation using `gcp_service_account`.
       *   - The Pub/Sub SA is not granted the
       *     `iam.serviceAccounts.getOpenIdToken` permission on
       *     `gcp_service_account`.
       * </pre>
       *
       * <code>KINESIS_PERMISSION_DENIED = 2;</code>
       */
      public static final int KINESIS_PERMISSION_DENIED_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Permission denied encountered while publishing to the topic. This can
       * happen if the Pub/Sub SA has not been granted the [appropriate publish
       * permissions](https://cloud.google.com/pubsub/docs/access-control#pubsub.publisher)
       * </pre>
       *
       * <code>PUBLISH_PERMISSION_DENIED = 3;</code>
       */
      public static final int PUBLISH_PERMISSION_DENIED_VALUE = 3;
      /**
       *
       *
       * <pre>
       * The Kinesis stream does not exist.
       * </pre>
       *
       * <code>STREAM_NOT_FOUND = 4;</code>
       */
      public static final int STREAM_NOT_FOUND_VALUE = 4;
      /**
       *
       *
       * <pre>
       * The Kinesis consumer does not exist.
       * </pre>
       *
       * <code>CONSUMER_NOT_FOUND = 5;</code>
       */
      public static final int CONSUMER_NOT_FOUND_VALUE = 5;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return ACTIVE;
          case 2:
            return KINESIS_PERMISSION_DENIED;
          case 3:
            return PUBLISH_PERMISSION_DENIED;
          case 4:
            return STREAM_NOT_FOUND;
          case 5:
            return CONSUMER_NOT_FOUND;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State)
    }

    public static final int STATE_FIELD_NUMBER = 1;
    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Kinesis
     * ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Kinesis
     * ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State getState() {
      com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State result =
          com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State.forNumber(state_);
      return result == null
          ? com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State.UNRECOGNIZED
          : result;
    }

    public static final int STREAM_ARN_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object streamArn_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Kinesis stream ARN to ingest data from.
     * </pre>
     *
     * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The streamArn.
     */
    @java.lang.Override
    public java.lang.String getStreamArn() {
      java.lang.Object ref = streamArn_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        streamArn_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Kinesis stream ARN to ingest data from.
     * </pre>
     *
     * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for streamArn.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStreamArnBytes() {
      java.lang.Object ref = streamArn_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        streamArn_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONSUMER_ARN_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object consumerArn_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
     * Fan-Out mode. The consumer must be already created and ready to be used.
     * </pre>
     *
     * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The consumerArn.
     */
    @java.lang.Override
    public java.lang.String getConsumerArn() {
      java.lang.Object ref = consumerArn_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        consumerArn_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
     * Fan-Out mode. The consumer must be already created and ready to be used.
     * </pre>
     *
     * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for consumerArn.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getConsumerArnBytes() {
      java.lang.Object ref = consumerArn_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        consumerArn_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AWS_ROLE_ARN_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object awsRoleArn_ = "";
    /**
     *
     *
     * <pre>
     * Required. AWS role ARN to be used for Federated Identity authentication
     * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
     * required permissions that need to be attached to it.
     * </pre>
     *
     * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The awsRoleArn.
     */
    @java.lang.Override
    public java.lang.String getAwsRoleArn() {
      java.lang.Object ref = awsRoleArn_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        awsRoleArn_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. AWS role ARN to be used for Federated Identity authentication
     * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
     * required permissions that need to be attached to it.
     * </pre>
     *
     * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for awsRoleArn.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAwsRoleArnBytes() {
      java.lang.Object ref = awsRoleArn_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        awsRoleArn_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GCP_SERVICE_ACCOUNT_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object gcpServiceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Required. The GCP service account to be used for Federated Identity
     * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
     * the provided role). The `aws_role_arn` must be set up with
     * `accounts.google.com:sub` equals to this service account number.
     * </pre>
     *
     * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The gcpServiceAccount.
     */
    @java.lang.Override
    public java.lang.String getGcpServiceAccount() {
      java.lang.Object ref = gcpServiceAccount_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcpServiceAccount_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The GCP service account to be used for Federated Identity
     * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
     * the provided role). The `aws_role_arn` must be set up with
     * `accounts.google.com:sub` equals to this service account number.
     * </pre>
     *
     * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for gcpServiceAccount.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcpServiceAccountBytes() {
      java.lang.Object ref = gcpServiceAccount_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcpServiceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (state_
          != com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State.STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(streamArn_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, streamArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(consumerArn_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, consumerArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(awsRoleArn_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, awsRoleArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcpServiceAccount_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, gcpServiceAccount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (state_
          != com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State.STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(streamArn_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, streamArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(consumerArn_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, consumerArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(awsRoleArn_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, awsRoleArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcpServiceAccount_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, gcpServiceAccount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis)) {
        return super.equals(obj);
      }
      com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis other =
          (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) obj;

      if (state_ != other.state_) return false;
      if (!getStreamArn().equals(other.getStreamArn())) return false;
      if (!getConsumerArn().equals(other.getConsumerArn())) return false;
      if (!getAwsRoleArn().equals(other.getAwsRoleArn())) return false;
      if (!getGcpServiceAccount().equals(other.getGcpServiceAccount())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      hash = (37 * hash) + STREAM_ARN_FIELD_NUMBER;
      hash = (53 * hash) + getStreamArn().hashCode();
      hash = (37 * hash) + CONSUMER_ARN_FIELD_NUMBER;
      hash = (53 * hash) + getConsumerArn().hashCode();
      hash = (37 * hash) + AWS_ROLE_ARN_FIELD_NUMBER;
      hash = (53 * hash) + getAwsRoleArn().hashCode();
      hash = (37 * hash) + GCP_SERVICE_ACCOUNT_FIELD_NUMBER;
      hash = (53 * hash) + getGcpServiceAccount().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Ingestion settings for Amazon Kinesis Data Streams.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis)
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesisOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AwsKinesis_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AwsKinesis_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.class,
                com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder.class);
      }

      // Construct using com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        state_ = 0;
        streamArn_ = "";
        consumerArn_ = "";
        awsRoleArn_ = "";
        gcpServiceAccount_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AwsKinesis_descriptor;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
          getDefaultInstanceForType() {
        return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis build() {
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis buildPartial() {
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis result =
            new com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.state_ = state_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.streamArn_ = streamArn_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.consumerArn_ = consumerArn_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.awsRoleArn_ = awsRoleArn_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.gcpServiceAccount_ = gcpServiceAccount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) {
          return mergeFrom((com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis other) {
        if (other
            == com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance())
          return this;
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (!other.getStreamArn().isEmpty()) {
          streamArn_ = other.streamArn_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getConsumerArn().isEmpty()) {
          consumerArn_ = other.consumerArn_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getAwsRoleArn().isEmpty()) {
          awsRoleArn_ = other.awsRoleArn_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getGcpServiceAccount().isEmpty()) {
          gcpServiceAccount_ = other.gcpServiceAccount_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  streamArn_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  consumerArn_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  awsRoleArn_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  gcpServiceAccount_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int state_ = 0;
      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Kinesis
       * ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Kinesis
       * ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Kinesis
       * ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State getState() {
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State result =
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State.forNumber(state_);
        return result == null
            ? com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Kinesis
       * ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(
          com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Kinesis
       * ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000001);
        state_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object streamArn_ = "";
      /**
       *
       *
       * <pre>
       * Required. The Kinesis stream ARN to ingest data from.
       * </pre>
       *
       * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The streamArn.
       */
      public java.lang.String getStreamArn() {
        java.lang.Object ref = streamArn_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          streamArn_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Kinesis stream ARN to ingest data from.
       * </pre>
       *
       * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for streamArn.
       */
      public com.google.protobuf.ByteString getStreamArnBytes() {
        java.lang.Object ref = streamArn_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          streamArn_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Kinesis stream ARN to ingest data from.
       * </pre>
       *
       * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The streamArn to set.
       * @return This builder for chaining.
       */
      public Builder setStreamArn(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        streamArn_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Kinesis stream ARN to ingest data from.
       * </pre>
       *
       * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStreamArn() {
        streamArn_ = getDefaultInstance().getStreamArn();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Kinesis stream ARN to ingest data from.
       * </pre>
       *
       * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for streamArn to set.
       * @return This builder for chaining.
       */
      public Builder setStreamArnBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        streamArn_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object consumerArn_ = "";
      /**
       *
       *
       * <pre>
       * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
       * Fan-Out mode. The consumer must be already created and ready to be used.
       * </pre>
       *
       * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The consumerArn.
       */
      public java.lang.String getConsumerArn() {
        java.lang.Object ref = consumerArn_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          consumerArn_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
       * Fan-Out mode. The consumer must be already created and ready to be used.
       * </pre>
       *
       * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for consumerArn.
       */
      public com.google.protobuf.ByteString getConsumerArnBytes() {
        java.lang.Object ref = consumerArn_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          consumerArn_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
       * Fan-Out mode. The consumer must be already created and ready to be used.
       * </pre>
       *
       * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The consumerArn to set.
       * @return This builder for chaining.
       */
      public Builder setConsumerArn(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        consumerArn_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
       * Fan-Out mode. The consumer must be already created and ready to be used.
       * </pre>
       *
       * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearConsumerArn() {
        consumerArn_ = getDefaultInstance().getConsumerArn();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
       * Fan-Out mode. The consumer must be already created and ready to be used.
       * </pre>
       *
       * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for consumerArn to set.
       * @return This builder for chaining.
       */
      public Builder setConsumerArnBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        consumerArn_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object awsRoleArn_ = "";
      /**
       *
       *
       * <pre>
       * Required. AWS role ARN to be used for Federated Identity authentication
       * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
       * required permissions that need to be attached to it.
       * </pre>
       *
       * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The awsRoleArn.
       */
      public java.lang.String getAwsRoleArn() {
        java.lang.Object ref = awsRoleArn_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          awsRoleArn_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. AWS role ARN to be used for Federated Identity authentication
       * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
       * required permissions that need to be attached to it.
       * </pre>
       *
       * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for awsRoleArn.
       */
      public com.google.protobuf.ByteString getAwsRoleArnBytes() {
        java.lang.Object ref = awsRoleArn_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          awsRoleArn_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. AWS role ARN to be used for Federated Identity authentication
       * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
       * required permissions that need to be attached to it.
       * </pre>
       *
       * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The awsRoleArn to set.
       * @return This builder for chaining.
       */
      public Builder setAwsRoleArn(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        awsRoleArn_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. AWS role ARN to be used for Federated Identity authentication
       * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
       * required permissions that need to be attached to it.
       * </pre>
       *
       * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAwsRoleArn() {
        awsRoleArn_ = getDefaultInstance().getAwsRoleArn();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. AWS role ARN to be used for Federated Identity authentication
       * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
       * required permissions that need to be attached to it.
       * </pre>
       *
       * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for awsRoleArn to set.
       * @return This builder for chaining.
       */
      public Builder setAwsRoleArnBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        awsRoleArn_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object gcpServiceAccount_ = "";
      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
       * the provided role). The `aws_role_arn` must be set up with
       * `accounts.google.com:sub` equals to this service account number.
       * </pre>
       *
       * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The gcpServiceAccount.
       */
      public java.lang.String getGcpServiceAccount() {
        java.lang.Object ref = gcpServiceAccount_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gcpServiceAccount_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
       * the provided role). The `aws_role_arn` must be set up with
       * `accounts.google.com:sub` equals to this service account number.
       * </pre>
       *
       * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for gcpServiceAccount.
       */
      public com.google.protobuf.ByteString getGcpServiceAccountBytes() {
        java.lang.Object ref = gcpServiceAccount_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gcpServiceAccount_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
       * the provided role). The `aws_role_arn` must be set up with
       * `accounts.google.com:sub` equals to this service account number.
       * </pre>
       *
       * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The gcpServiceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setGcpServiceAccount(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        gcpServiceAccount_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
       * the provided role). The `aws_role_arn` must be set up with
       * `accounts.google.com:sub` equals to this service account number.
       * </pre>
       *
       * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcpServiceAccount() {
        gcpServiceAccount_ = getDefaultInstance().getGcpServiceAccount();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
       * the provided role). The `aws_role_arn` must be set up with
       * `accounts.google.com:sub` equals to this service account number.
       * </pre>
       *
       * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for gcpServiceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setGcpServiceAccountBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        gcpServiceAccount_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis)
    }

    // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis)
    private static final com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis();
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AwsKinesis> PARSER =
        new com.google.protobuf.AbstractParser<AwsKinesis>() {
          @java.lang.Override
          public AwsKinesis parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AwsKinesis> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AwsKinesis> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CloudStorageOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Cloud
     * Storage ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Cloud
     * Storage ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State getState();

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage bucket. The bucket name must be without any
     * prefix like "gs://". See the [bucket naming requirements]
     * (https://cloud.google.com/storage/docs/buckets#naming).
     * </pre>
     *
     * <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bucket.
     */
    java.lang.String getBucket();
    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage bucket. The bucket name must be without any
     * prefix like "gs://". See the [bucket naming requirements]
     * (https://cloud.google.com/storage/docs/buckets#naming).
     * </pre>
     *
     * <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for bucket.
     */
    com.google.protobuf.ByteString getBucketBytes();

    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted as text.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the textFormat field is set.
     */
    boolean hasTextFormat();
    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted as text.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The textFormat.
     */
    com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat getTextFormat();
    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted as text.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormatOrBuilder
        getTextFormatOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted in Avro format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the avroFormat field is set.
     */
    boolean hasAvroFormat();
    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted in Avro format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The avroFormat.
     */
    com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat getAvroFormat();
    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted in Avro format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormatOrBuilder
        getAvroFormatOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. It will be assumed data from Cloud Storage was written via
     * [Cloud Storage
     * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the pubsubAvroFormat field is set.
     */
    boolean hasPubsubAvroFormat();
    /**
     *
     *
     * <pre>
     * Optional. It will be assumed data from Cloud Storage was written via
     * [Cloud Storage
     * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The pubsubAvroFormat.
     */
    com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
        getPubsubAvroFormat();
    /**
     *
     *
     * <pre>
     * Optional. It will be assumed data from Cloud Storage was written via
     * [Cloud Storage
     * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormatOrBuilder
        getPubsubAvroFormatOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Only objects with a larger or equal creation timestamp will be
     * ingested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the minimumObjectCreateTime field is set.
     */
    boolean hasMinimumObjectCreateTime();
    /**
     *
     *
     * <pre>
     * Optional. Only objects with a larger or equal creation timestamp will be
     * ingested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The minimumObjectCreateTime.
     */
    com.google.protobuf.Timestamp getMinimumObjectCreateTime();
    /**
     *
     *
     * <pre>
     * Optional. Only objects with a larger or equal creation timestamp will be
     * ingested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getMinimumObjectCreateTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Glob pattern used to match objects that will be ingested. If
     * unset, all objects will be ingested. See the [supported
     * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
     * </pre>
     *
     * <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The matchGlob.
     */
    java.lang.String getMatchGlob();
    /**
     *
     *
     * <pre>
     * Optional. Glob pattern used to match objects that will be ingested. If
     * unset, all objects will be ingested. See the [supported
     * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
     * </pre>
     *
     * <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for matchGlob.
     */
    com.google.protobuf.ByteString getMatchGlobBytes();

    com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.InputFormatCase
        getInputFormatCase();
  }
  /**
   *
   *
   * <pre>
   * Ingestion settings for Cloud Storage.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.CloudStorage}
   */
  public static final class CloudStorage extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage)
      CloudStorageOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CloudStorage.newBuilder() to construct.
    private CloudStorage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CloudStorage() {
      state_ = 0;
      bucket_ = "";
      matchGlob_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CloudStorage();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.class,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Possible states for ingestion from Cloud Storage.
     * </pre>
     *
     * Protobuf enum {@code google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State}
     */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Ingestion is active.
       * </pre>
       *
       * <code>ACTIVE = 1;</code>
       */
      ACTIVE(1),
      /**
       *
       *
       * <pre>
       * Permission denied encountered while calling the Cloud Storage API. This
       * can happen if the Pub/Sub SA has not been granted the
       * [appropriate
       * permissions](https://cloud.google.com/storage/docs/access-control/iam-permissions):
       * - storage.objects.list: to list the objects in a bucket.
       * - storage.objects.get: to read the objects in a bucket.
       * - storage.buckets.get: to verify the bucket exists.
       * </pre>
       *
       * <code>CLOUD_STORAGE_PERMISSION_DENIED = 2;</code>
       */
      CLOUD_STORAGE_PERMISSION_DENIED(2),
      /**
       *
       *
       * <pre>
       * Permission denied encountered while publishing to the topic. This can
       * happen if the Pub/Sub SA has not been granted the [appropriate publish
       * permissions](https://cloud.google.com/pubsub/docs/access-control#pubsub.publisher)
       * </pre>
       *
       * <code>PUBLISH_PERMISSION_DENIED = 3;</code>
       */
      PUBLISH_PERMISSION_DENIED(3),
      /**
       *
       *
       * <pre>
       * The provided Cloud Storage bucket doesn't exist.
       * </pre>
       *
       * <code>BUCKET_NOT_FOUND = 4;</code>
       */
      BUCKET_NOT_FOUND(4),
      /**
       *
       *
       * <pre>
       * The Cloud Storage bucket has too many objects, ingestion will be
       * paused.
       * </pre>
       *
       * <code>TOO_MANY_OBJECTS = 5;</code>
       */
      TOO_MANY_OBJECTS(5),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      public static final int STATE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Ingestion is active.
       * </pre>
       *
       * <code>ACTIVE = 1;</code>
       */
      public static final int ACTIVE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Permission denied encountered while calling the Cloud Storage API. This
       * can happen if the Pub/Sub SA has not been granted the
       * [appropriate
       * permissions](https://cloud.google.com/storage/docs/access-control/iam-permissions):
       * - storage.objects.list: to list the objects in a bucket.
       * - storage.objects.get: to read the objects in a bucket.
       * - storage.buckets.get: to verify the bucket exists.
       * </pre>
       *
       * <code>CLOUD_STORAGE_PERMISSION_DENIED = 2;</code>
       */
      public static final int CLOUD_STORAGE_PERMISSION_DENIED_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Permission denied encountered while publishing to the topic. This can
       * happen if the Pub/Sub SA has not been granted the [appropriate publish
       * permissions](https://cloud.google.com/pubsub/docs/access-control#pubsub.publisher)
       * </pre>
       *
       * <code>PUBLISH_PERMISSION_DENIED = 3;</code>
       */
      public static final int PUBLISH_PERMISSION_DENIED_VALUE = 3;
      /**
       *
       *
       * <pre>
       * The provided Cloud Storage bucket doesn't exist.
       * </pre>
       *
       * <code>BUCKET_NOT_FOUND = 4;</code>
       */
      public static final int BUCKET_NOT_FOUND_VALUE = 4;
      /**
       *
       *
       * <pre>
       * The Cloud Storage bucket has too many objects, ingestion will be
       * paused.
       * </pre>
       *
       * <code>TOO_MANY_OBJECTS = 5;</code>
       */
      public static final int TOO_MANY_OBJECTS_VALUE = 5;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return ACTIVE;
          case 2:
            return CLOUD_STORAGE_PERMISSION_DENIED;
          case 3:
            return PUBLISH_PERMISSION_DENIED;
          case 4:
            return BUCKET_NOT_FOUND;
          case 5:
            return TOO_MANY_OBJECTS;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State)
    }

    public interface TextFormatOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. When unset, '&#92;n' is used.
       * </pre>
       *
       * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return Whether the delimiter field is set.
       */
      boolean hasDelimiter();
      /**
       *
       *
       * <pre>
       * Optional. When unset, '&#92;n' is used.
       * </pre>
       *
       * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The delimiter.
       */
      java.lang.String getDelimiter();
      /**
       *
       *
       * <pre>
       * Optional. When unset, '&#92;n' is used.
       * </pre>
       *
       * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for delimiter.
       */
      com.google.protobuf.ByteString getDelimiterBytes();
    }
    /**
     *
     *
     * <pre>
     * Configuration for reading Cloud Storage data in text format. Each line of
     * text as specified by the delimiter will be set to the `data` field of a
     * Pub/Sub message.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat}
     */
    public static final class TextFormat extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
        TextFormatOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use TextFormat.newBuilder() to construct.
      private TextFormat(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private TextFormat() {
        delimiter_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new TextFormat();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_TextFormat_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_TextFormat_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.class,
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.Builder
                    .class);
      }

      private int bitField0_;
      public static final int DELIMITER_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object delimiter_ = "";
      /**
       *
       *
       * <pre>
       * Optional. When unset, '&#92;n' is used.
       * </pre>
       *
       * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return Whether the delimiter field is set.
       */
      @java.lang.Override
      public boolean hasDelimiter() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. When unset, '&#92;n' is used.
       * </pre>
       *
       * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The delimiter.
       */
      @java.lang.Override
      public java.lang.String getDelimiter() {
        java.lang.Object ref = delimiter_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          delimiter_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. When unset, '&#92;n' is used.
       * </pre>
       *
       * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for delimiter.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDelimiterBytes() {
        java.lang.Object ref = delimiter_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          delimiter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, delimiter_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, delimiter_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)) {
          return super.equals(obj);
        }
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat other =
            (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat) obj;

        if (hasDelimiter() != other.hasDelimiter()) return false;
        if (hasDelimiter()) {
          if (!getDelimiter().equals(other.getDelimiter())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasDelimiter()) {
          hash = (37 * hash) + DELIMITER_FIELD_NUMBER;
          hash = (53 * hash) + getDelimiter().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Configuration for reading Cloud Storage data in text format. Each line of
       * text as specified by the delimiter will be set to the `data` field of a
       * Pub/Sub message.
       * </pre>
       *
       * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormatOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.pubsub.v1.PubsubProto
              .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_TextFormat_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.pubsub.v1.PubsubProto
              .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_TextFormat_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.class,
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.Builder
                      .class);
        }

        // Construct using
        // com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          delimiter_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.pubsub.v1.PubsubProto
              .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_TextFormat_descriptor;
        }

        @java.lang.Override
        public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
            getDefaultInstanceForType() {
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat build() {
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
            buildPartial() {
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat result =
              new com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.delimiter_ = delimiter_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat) {
            return mergeFrom(
                (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat other) {
          if (other
              == com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
                  .getDefaultInstance()) return this;
          if (other.hasDelimiter()) {
            delimiter_ = other.delimiter_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    delimiter_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object delimiter_ = "";
        /**
         *
         *
         * <pre>
         * Optional. When unset, '&#92;n' is used.
         * </pre>
         *
         * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return Whether the delimiter field is set.
         */
        public boolean hasDelimiter() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. When unset, '&#92;n' is used.
         * </pre>
         *
         * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The delimiter.
         */
        public java.lang.String getDelimiter() {
          java.lang.Object ref = delimiter_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            delimiter_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. When unset, '&#92;n' is used.
         * </pre>
         *
         * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for delimiter.
         */
        public com.google.protobuf.ByteString getDelimiterBytes() {
          java.lang.Object ref = delimiter_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            delimiter_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. When unset, '&#92;n' is used.
         * </pre>
         *
         * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The delimiter to set.
         * @return This builder for chaining.
         */
        public Builder setDelimiter(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          delimiter_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. When unset, '&#92;n' is used.
         * </pre>
         *
         * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDelimiter() {
          delimiter_ = getDefaultInstance().getDelimiter();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. When unset, '&#92;n' is used.
         * </pre>
         *
         * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for delimiter to set.
         * @return This builder for chaining.
         */
        public Builder setDelimiterBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          delimiter_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
      }

      // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
      private static final com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat();
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<TextFormat> PARSER =
          new com.google.protobuf.AbstractParser<TextFormat>() {
            @java.lang.Override
            public TextFormat parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<TextFormat> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<TextFormat> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface AvroFormatOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
        com.google.protobuf.MessageOrBuilder {}
    /**
     *
     *
     * <pre>
     * Configuration for reading Cloud Storage data in Avro binary format. The
     * bytes of each object will be set to the `data` field of a Pub/Sub
     * message.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat}
     */
    public static final class AvroFormat extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
        AvroFormatOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use AvroFormat.newBuilder() to construct.
      private AvroFormat(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private AvroFormat() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new AvroFormat();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_AvroFormat_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_AvroFormat_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.class,
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.Builder
                    .class);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)) {
          return super.equals(obj);
        }
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat other =
            (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat) obj;

        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Configuration for reading Cloud Storage data in Avro binary format. The
       * bytes of each object will be set to the `data` field of a Pub/Sub
       * message.
       * </pre>
       *
       * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormatOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.pubsub.v1.PubsubProto
              .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_AvroFormat_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.pubsub.v1.PubsubProto
              .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_AvroFormat_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.class,
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.Builder
                      .class);
        }

        // Construct using
        // com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.pubsub.v1.PubsubProto
              .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_AvroFormat_descriptor;
        }

        @java.lang.Override
        public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
            getDefaultInstanceForType() {
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat build() {
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
            buildPartial() {
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat result =
              new com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat(this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat) {
            return mergeFrom(
                (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat other) {
          if (other
              == com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
                  .getDefaultInstance()) return this;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
      }

      // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
      private static final com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat();
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<AvroFormat> PARSER =
          new com.google.protobuf.AbstractParser<AvroFormat>() {
            @java.lang.Override
            public AvroFormat parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<AvroFormat> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<AvroFormat> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface PubSubAvroFormatOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
        com.google.protobuf.MessageOrBuilder {}
    /**
     *
     *
     * <pre>
     * Configuration for reading Cloud Storage data written via [Cloud Storage
     * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage). The
     * data and attributes fields of the originally exported Pub/Sub message
     * will be restored when publishing.
     * </pre>
     *
     * Protobuf type {@code
     * google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat}
     */
    public static final class PubSubAvroFormat extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
        PubSubAvroFormatOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use PubSubAvroFormat.newBuilder() to construct.
      private PubSubAvroFormat(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private PubSubAvroFormat() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new PubSubAvroFormat();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                    .class,
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                    .Builder.class);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)) {
          return super.equals(obj);
        }
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat other =
            (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat) obj;

        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Configuration for reading Cloud Storage data written via [Cloud Storage
       * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage). The
       * data and attributes fields of the originally exported Pub/Sub message
       * will be restored when publishing.
       * </pre>
       *
       * Protobuf type {@code
       * google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormatOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.pubsub.v1.PubsubProto
              .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.pubsub.v1.PubsubProto
              .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                      .class,
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                      .Builder.class);
        }

        // Construct using
        // com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.pubsub.v1.PubsubProto
              .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat_descriptor;
        }

        @java.lang.Override
        public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
            getDefaultInstanceForType() {
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
            build() {
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
            buildPartial() {
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat result =
              new com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat(
                  this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat) {
            return mergeFrom(
                (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat other) {
          if (other
              == com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                  .getDefaultInstance()) return this;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
      }

      // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
      private static final com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
              .PubSubAvroFormat
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat();
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<PubSubAvroFormat> PARSER =
          new com.google.protobuf.AbstractParser<PubSubAvroFormat>() {
            @java.lang.Override
            public PubSubAvroFormat parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<PubSubAvroFormat> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<PubSubAvroFormat> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    private int inputFormatCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object inputFormat_;

    public enum InputFormatCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      TEXT_FORMAT(3),
      AVRO_FORMAT(4),
      PUBSUB_AVRO_FORMAT(5),
      INPUTFORMAT_NOT_SET(0);
      private final int value;

      private InputFormatCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static InputFormatCase valueOf(int value) {
        return forNumber(value);
      }

      public static InputFormatCase forNumber(int value) {
        switch (value) {
          case 3:
            return TEXT_FORMAT;
          case 4:
            return AVRO_FORMAT;
          case 5:
            return PUBSUB_AVRO_FORMAT;
          case 0:
            return INPUTFORMAT_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public InputFormatCase getInputFormatCase() {
      return InputFormatCase.forNumber(inputFormatCase_);
    }

    public static final int STATE_FIELD_NUMBER = 1;
    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Cloud
     * Storage ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Cloud
     * Storage ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State getState() {
      com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State result =
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State.forNumber(state_);
      return result == null
          ? com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State.UNRECOGNIZED
          : result;
    }

    public static final int BUCKET_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object bucket_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage bucket. The bucket name must be without any
     * prefix like "gs://". See the [bucket naming requirements]
     * (https://cloud.google.com/storage/docs/buckets#naming).
     * </pre>
     *
     * <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bucket.
     */
    @java.lang.Override
    public java.lang.String getBucket() {
      java.lang.Object ref = bucket_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucket_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage bucket. The bucket name must be without any
     * prefix like "gs://". See the [bucket naming requirements]
     * (https://cloud.google.com/storage/docs/buckets#naming).
     * </pre>
     *
     * <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for bucket.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBucketBytes() {
      java.lang.Object ref = bucket_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TEXT_FORMAT_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted as text.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the textFormat field is set.
     */
    @java.lang.Override
    public boolean hasTextFormat() {
      return inputFormatCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted as text.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The textFormat.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
        getTextFormat() {
      if (inputFormatCase_ == 3) {
        return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
            inputFormat_;
      }
      return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted as text.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormatOrBuilder
        getTextFormatOrBuilder() {
      if (inputFormatCase_ == 3) {
        return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
            inputFormat_;
      }
      return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          .getDefaultInstance();
    }

    public static final int AVRO_FORMAT_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted in Avro format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the avroFormat field is set.
     */
    @java.lang.Override
    public boolean hasAvroFormat() {
      return inputFormatCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted in Avro format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The avroFormat.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
        getAvroFormat() {
      if (inputFormatCase_ == 4) {
        return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
            inputFormat_;
      }
      return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted in Avro format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormatOrBuilder
        getAvroFormatOrBuilder() {
      if (inputFormatCase_ == 4) {
        return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
            inputFormat_;
      }
      return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          .getDefaultInstance();
    }

    public static final int PUBSUB_AVRO_FORMAT_FIELD_NUMBER = 5;
    /**
     *
     *
     * <pre>
     * Optional. It will be assumed data from Cloud Storage was written via
     * [Cloud Storage
     * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the pubsubAvroFormat field is set.
     */
    @java.lang.Override
    public boolean hasPubsubAvroFormat() {
      return inputFormatCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Optional. It will be assumed data from Cloud Storage was written via
     * [Cloud Storage
     * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The pubsubAvroFormat.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
        getPubsubAvroFormat() {
      if (inputFormatCase_ == 5) {
        return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
            inputFormat_;
      }
      return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Optional. It will be assumed data from Cloud Storage was written via
     * [Cloud Storage
     * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormatOrBuilder
        getPubsubAvroFormatOrBuilder() {
      if (inputFormatCase_ == 5) {
        return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
            inputFormat_;
      }
      return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          .getDefaultInstance();
    }

    public static final int MINIMUM_OBJECT_CREATE_TIME_FIELD_NUMBER = 6;
    private com.google.protobuf.Timestamp minimumObjectCreateTime_;
    /**
     *
     *
     * <pre>
     * Optional. Only objects with a larger or equal creation timestamp will be
     * ingested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the minimumObjectCreateTime field is set.
     */
    @java.lang.Override
    public boolean hasMinimumObjectCreateTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Only objects with a larger or equal creation timestamp will be
     * ingested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The minimumObjectCreateTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getMinimumObjectCreateTime() {
      return minimumObjectCreateTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : minimumObjectCreateTime_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Only objects with a larger or equal creation timestamp will be
     * ingested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getMinimumObjectCreateTimeOrBuilder() {
      return minimumObjectCreateTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : minimumObjectCreateTime_;
    }

    public static final int MATCH_GLOB_FIELD_NUMBER = 9;

    @SuppressWarnings("serial")
    private volatile java.lang.Object matchGlob_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Glob pattern used to match objects that will be ingested. If
     * unset, all objects will be ingested. See the [supported
     * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
     * </pre>
     *
     * <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The matchGlob.
     */
    @java.lang.Override
    public java.lang.String getMatchGlob() {
      java.lang.Object ref = matchGlob_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        matchGlob_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Glob pattern used to match objects that will be ingested. If
     * unset, all objects will be ingested. See the [supported
     * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
     * </pre>
     *
     * <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for matchGlob.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMatchGlobBytes() {
      java.lang.Object ref = matchGlob_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        matchGlob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (state_
          != com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State.STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, bucket_);
      }
      if (inputFormatCase_ == 3) {
        output.writeMessage(
            3,
            (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
                inputFormat_);
      }
      if (inputFormatCase_ == 4) {
        output.writeMessage(
            4,
            (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
                inputFormat_);
      }
      if (inputFormatCase_ == 5) {
        output.writeMessage(
            5,
            (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
                inputFormat_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(6, getMinimumObjectCreateTime());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(matchGlob_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 9, matchGlob_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (state_
          != com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State.STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, bucket_);
      }
      if (inputFormatCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3,
                (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
                    inputFormat_);
      }
      if (inputFormatCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4,
                (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
                    inputFormat_);
      }
      if (inputFormatCase_ == 5) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5,
                (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
                    inputFormat_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                6, getMinimumObjectCreateTime());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(matchGlob_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, matchGlob_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage)) {
        return super.equals(obj);
      }
      com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage other =
          (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) obj;

      if (state_ != other.state_) return false;
      if (!getBucket().equals(other.getBucket())) return false;
      if (hasMinimumObjectCreateTime() != other.hasMinimumObjectCreateTime()) return false;
      if (hasMinimumObjectCreateTime()) {
        if (!getMinimumObjectCreateTime().equals(other.getMinimumObjectCreateTime())) return false;
      }
      if (!getMatchGlob().equals(other.getMatchGlob())) return false;
      if (!getInputFormatCase().equals(other.getInputFormatCase())) return false;
      switch (inputFormatCase_) {
        case 3:
          if (!getTextFormat().equals(other.getTextFormat())) return false;
          break;
        case 4:
          if (!getAvroFormat().equals(other.getAvroFormat())) return false;
          break;
        case 5:
          if (!getPubsubAvroFormat().equals(other.getPubsubAvroFormat())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      hash = (37 * hash) + BUCKET_FIELD_NUMBER;
      hash = (53 * hash) + getBucket().hashCode();
      if (hasMinimumObjectCreateTime()) {
        hash = (37 * hash) + MINIMUM_OBJECT_CREATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getMinimumObjectCreateTime().hashCode();
      }
      hash = (37 * hash) + MATCH_GLOB_FIELD_NUMBER;
      hash = (53 * hash) + getMatchGlob().hashCode();
      switch (inputFormatCase_) {
        case 3:
          hash = (37 * hash) + TEXT_FORMAT_FIELD_NUMBER;
          hash = (53 * hash) + getTextFormat().hashCode();
          break;
        case 4:
          hash = (37 * hash) + AVRO_FORMAT_FIELD_NUMBER;
          hash = (53 * hash) + getAvroFormat().hashCode();
          break;
        case 5:
          hash = (37 * hash) + PUBSUB_AVRO_FORMAT_FIELD_NUMBER;
          hash = (53 * hash) + getPubsubAvroFormat().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Ingestion settings for Cloud Storage.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.CloudStorage}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage)
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.class,
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.Builder.class);
      }

      // Construct using com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMinimumObjectCreateTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        state_ = 0;
        bucket_ = "";
        if (textFormatBuilder_ != null) {
          textFormatBuilder_.clear();
        }
        if (avroFormatBuilder_ != null) {
          avroFormatBuilder_.clear();
        }
        if (pubsubAvroFormatBuilder_ != null) {
          pubsubAvroFormatBuilder_.clear();
        }
        minimumObjectCreateTime_ = null;
        if (minimumObjectCreateTimeBuilder_ != null) {
          minimumObjectCreateTimeBuilder_.dispose();
          minimumObjectCreateTimeBuilder_ = null;
        }
        matchGlob_ = "";
        inputFormatCase_ = 0;
        inputFormat_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_descriptor;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
          getDefaultInstanceForType() {
        return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage build() {
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage buildPartial() {
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage result =
            new com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.state_ = state_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.bucket_ = bucket_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.minimumObjectCreateTime_ =
              minimumObjectCreateTimeBuilder_ == null
                  ? minimumObjectCreateTime_
                  : minimumObjectCreateTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.matchGlob_ = matchGlob_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage result) {
        result.inputFormatCase_ = inputFormatCase_;
        result.inputFormat_ = this.inputFormat_;
        if (inputFormatCase_ == 3 && textFormatBuilder_ != null) {
          result.inputFormat_ = textFormatBuilder_.build();
        }
        if (inputFormatCase_ == 4 && avroFormatBuilder_ != null) {
          result.inputFormat_ = avroFormatBuilder_.build();
        }
        if (inputFormatCase_ == 5 && pubsubAvroFormatBuilder_ != null) {
          result.inputFormat_ = pubsubAvroFormatBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) {
          return mergeFrom((com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage other) {
        if (other
            == com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.getDefaultInstance())
          return this;
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (!other.getBucket().isEmpty()) {
          bucket_ = other.bucket_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasMinimumObjectCreateTime()) {
          mergeMinimumObjectCreateTime(other.getMinimumObjectCreateTime());
        }
        if (!other.getMatchGlob().isEmpty()) {
          matchGlob_ = other.matchGlob_;
          bitField0_ |= 0x00000040;
          onChanged();
        }
        switch (other.getInputFormatCase()) {
          case TEXT_FORMAT:
            {
              mergeTextFormat(other.getTextFormat());
              break;
            }
          case AVRO_FORMAT:
            {
              mergeAvroFormat(other.getAvroFormat());
              break;
            }
          case PUBSUB_AVRO_FORMAT:
            {
              mergePubsubAvroFormat(other.getPubsubAvroFormat());
              break;
            }
          case INPUTFORMAT_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  bucket_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getTextFormatFieldBuilder().getBuilder(), extensionRegistry);
                  inputFormatCase_ = 3;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getAvroFormatFieldBuilder().getBuilder(), extensionRegistry);
                  inputFormatCase_ = 4;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(
                      getPubsubAvroFormatFieldBuilder().getBuilder(), extensionRegistry);
                  inputFormatCase_ = 5;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(
                      getMinimumObjectCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              case 74:
                {
                  matchGlob_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 74
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int inputFormatCase_ = 0;
      private java.lang.Object inputFormat_;

      public InputFormatCase getInputFormatCase() {
        return InputFormatCase.forNumber(inputFormatCase_);
      }

      public Builder clearInputFormat() {
        inputFormatCase_ = 0;
        inputFormat_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private int state_ = 0;
      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Cloud
       * Storage ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Cloud
       * Storage ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Cloud
       * Storage ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State getState() {
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State result =
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State.forNumber(state_);
        return result == null
            ? com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Cloud
       * Storage ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Cloud
       * Storage ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000001);
        state_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object bucket_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Cloud Storage bucket. The bucket name must be without any
       * prefix like "gs://". See the [bucket naming requirements]
       * (https://cloud.google.com/storage/docs/buckets#naming).
       * </pre>
       *
       * <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bucket.
       */
      public java.lang.String getBucket() {
        java.lang.Object ref = bucket_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          bucket_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Cloud Storage bucket. The bucket name must be without any
       * prefix like "gs://". See the [bucket naming requirements]
       * (https://cloud.google.com/storage/docs/buckets#naming).
       * </pre>
       *
       * <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for bucket.
       */
      public com.google.protobuf.ByteString getBucketBytes() {
        java.lang.Object ref = bucket_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          bucket_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Cloud Storage bucket. The bucket name must be without any
       * prefix like "gs://". See the [bucket naming requirements]
       * (https://cloud.google.com/storage/docs/buckets#naming).
       * </pre>
       *
       * <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bucket to set.
       * @return This builder for chaining.
       */
      public Builder setBucket(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bucket_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Cloud Storage bucket. The bucket name must be without any
       * prefix like "gs://". See the [bucket naming requirements]
       * (https://cloud.google.com/storage/docs/buckets#naming).
       * </pre>
       *
       * <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBucket() {
        bucket_ = getDefaultInstance().getBucket();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Cloud Storage bucket. The bucket name must be without any
       * prefix like "gs://". See the [bucket naming requirements]
       * (https://cloud.google.com/storage/docs/buckets#naming).
       * </pre>
       *
       * <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for bucket to set.
       * @return This builder for chaining.
       */
      public Builder setBucketBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        bucket_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.Builder,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormatOrBuilder>
          textFormatBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted as text.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the textFormat field is set.
       */
      @java.lang.Override
      public boolean hasTextFormat() {
        return inputFormatCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted as text.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The textFormat.
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          getTextFormat() {
        if (textFormatBuilder_ == null) {
          if (inputFormatCase_ == 3) {
            return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
                inputFormat_;
          }
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
              .getDefaultInstance();
        } else {
          if (inputFormatCase_ == 3) {
            return textFormatBuilder_.getMessage();
          }
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted as text.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setTextFormat(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat value) {
        if (textFormatBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          inputFormat_ = value;
          onChanged();
        } else {
          textFormatBuilder_.setMessage(value);
        }
        inputFormatCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted as text.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setTextFormat(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.Builder
              builderForValue) {
        if (textFormatBuilder_ == null) {
          inputFormat_ = builderForValue.build();
          onChanged();
        } else {
          textFormatBuilder_.setMessage(builderForValue.build());
        }
        inputFormatCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted as text.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeTextFormat(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat value) {
        if (textFormatBuilder_ == null) {
          if (inputFormatCase_ == 3
              && inputFormat_
                  != com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
                      .getDefaultInstance()) {
            inputFormat_ =
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.newBuilder(
                        (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
                            inputFormat_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            inputFormat_ = value;
          }
          onChanged();
        } else {
          if (inputFormatCase_ == 3) {
            textFormatBuilder_.mergeFrom(value);
          } else {
            textFormatBuilder_.setMessage(value);
          }
        }
        inputFormatCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted as text.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearTextFormat() {
        if (textFormatBuilder_ == null) {
          if (inputFormatCase_ == 3) {
            inputFormatCase_ = 0;
            inputFormat_ = null;
            onChanged();
          }
        } else {
          if (inputFormatCase_ == 3) {
            inputFormatCase_ = 0;
            inputFormat_ = null;
          }
          textFormatBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted as text.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.Builder
          getTextFormatBuilder() {
        return getTextFormatFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted as text.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormatOrBuilder
          getTextFormatOrBuilder() {
        if ((inputFormatCase_ == 3) && (textFormatBuilder_ != null)) {
          return textFormatBuilder_.getMessageOrBuilder();
        } else {
          if (inputFormatCase_ == 3) {
            return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
                inputFormat_;
          }
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted as text.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.Builder,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormatOrBuilder>
          getTextFormatFieldBuilder() {
        if (textFormatBuilder_ == null) {
          if (!(inputFormatCase_ == 3)) {
            inputFormat_ =
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
                    .getDefaultInstance();
          }
          textFormatBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat,
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.Builder,
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                      .TextFormatOrBuilder>(
                  (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
                      inputFormat_,
                  getParentForChildren(),
                  isClean());
          inputFormat_ = null;
        }
        inputFormatCase_ = 3;
        onChanged();
        return textFormatBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.Builder,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormatOrBuilder>
          avroFormatBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted in Avro format.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the avroFormat field is set.
       */
      @java.lang.Override
      public boolean hasAvroFormat() {
        return inputFormatCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted in Avro format.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The avroFormat.
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          getAvroFormat() {
        if (avroFormatBuilder_ == null) {
          if (inputFormatCase_ == 4) {
            return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
                inputFormat_;
          }
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
              .getDefaultInstance();
        } else {
          if (inputFormatCase_ == 4) {
            return avroFormatBuilder_.getMessage();
          }
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted in Avro format.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setAvroFormat(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat value) {
        if (avroFormatBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          inputFormat_ = value;
          onChanged();
        } else {
          avroFormatBuilder_.setMessage(value);
        }
        inputFormatCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted in Avro format.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setAvroFormat(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.Builder
              builderForValue) {
        if (avroFormatBuilder_ == null) {
          inputFormat_ = builderForValue.build();
          onChanged();
        } else {
          avroFormatBuilder_.setMessage(builderForValue.build());
        }
        inputFormatCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted in Avro format.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeAvroFormat(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat value) {
        if (avroFormatBuilder_ == null) {
          if (inputFormatCase_ == 4
              && inputFormat_
                  != com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
                      .getDefaultInstance()) {
            inputFormat_ =
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.newBuilder(
                        (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
                            inputFormat_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            inputFormat_ = value;
          }
          onChanged();
        } else {
          if (inputFormatCase_ == 4) {
            avroFormatBuilder_.mergeFrom(value);
          } else {
            avroFormatBuilder_.setMessage(value);
          }
        }
        inputFormatCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted in Avro format.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearAvroFormat() {
        if (avroFormatBuilder_ == null) {
          if (inputFormatCase_ == 4) {
            inputFormatCase_ = 0;
            inputFormat_ = null;
            onChanged();
          }
        } else {
          if (inputFormatCase_ == 4) {
            inputFormatCase_ = 0;
            inputFormat_ = null;
          }
          avroFormatBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted in Avro format.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.Builder
          getAvroFormatBuilder() {
        return getAvroFormatFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted in Avro format.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormatOrBuilder
          getAvroFormatOrBuilder() {
        if ((inputFormatCase_ == 4) && (avroFormatBuilder_ != null)) {
          return avroFormatBuilder_.getMessageOrBuilder();
        } else {
          if (inputFormatCase_ == 4) {
            return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
                inputFormat_;
          }
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted in Avro format.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.Builder,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormatOrBuilder>
          getAvroFormatFieldBuilder() {
        if (avroFormatBuilder_ == null) {
          if (!(inputFormatCase_ == 4)) {
            inputFormat_ =
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
                    .getDefaultInstance();
          }
          avroFormatBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat,
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.Builder,
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                      .AvroFormatOrBuilder>(
                  (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
                      inputFormat_,
                  getParentForChildren(),
                  isClean());
          inputFormat_ = null;
        }
        inputFormatCase_ = 4;
        onChanged();
        return avroFormatBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                  .Builder,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                  .PubSubAvroFormatOrBuilder>
          pubsubAvroFormatBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. It will be assumed data from Cloud Storage was written via
       * [Cloud Storage
       * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the pubsubAvroFormat field is set.
       */
      @java.lang.Override
      public boolean hasPubsubAvroFormat() {
        return inputFormatCase_ == 5;
      }
      /**
       *
       *
       * <pre>
       * Optional. It will be assumed data from Cloud Storage was written via
       * [Cloud Storage
       * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The pubsubAvroFormat.
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          getPubsubAvroFormat() {
        if (pubsubAvroFormatBuilder_ == null) {
          if (inputFormatCase_ == 5) {
            return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
                inputFormat_;
          }
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
              .getDefaultInstance();
        } else {
          if (inputFormatCase_ == 5) {
            return pubsubAvroFormatBuilder_.getMessage();
          }
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. It will be assumed data from Cloud Storage was written via
       * [Cloud Storage
       * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setPubsubAvroFormat(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat value) {
        if (pubsubAvroFormatBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          inputFormat_ = value;
          onChanged();
        } else {
          pubsubAvroFormatBuilder_.setMessage(value);
        }
        inputFormatCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. It will be assumed data from Cloud Storage was written via
       * [Cloud Storage
       * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setPubsubAvroFormat(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat.Builder
              builderForValue) {
        if (pubsubAvroFormatBuilder_ == null) {
          inputFormat_ = builderForValue.build();
          onChanged();
        } else {
          pubsubAvroFormatBuilder_.setMessage(builderForValue.build());
        }
        inputFormatCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. It will be assumed data from Cloud Storage was written via
       * [Cloud Storage
       * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergePubsubAvroFormat(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat value) {
        if (pubsubAvroFormatBuilder_ == null) {
          if (inputFormatCase_ == 5
              && inputFormat_
                  != com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                      .getDefaultInstance()) {
            inputFormat_ =
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                    .newBuilder(
                        (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                                .PubSubAvroFormat)
                            inputFormat_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            inputFormat_ = value;
          }
          onChanged();
        } else {
          if (inputFormatCase_ == 5) {
            pubsubAvroFormatBuilder_.mergeFrom(value);
          } else {
            pubsubAvroFormatBuilder_.setMessage(value);
          }
        }
        inputFormatCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. It will be assumed data from Cloud Storage was written via
       * [Cloud Storage
       * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearPubsubAvroFormat() {
        if (pubsubAvroFormatBuilder_ == null) {
          if (inputFormatCase_ == 5) {
            inputFormatCase_ = 0;
            inputFormat_ = null;
            onChanged();
          }
        } else {
          if (inputFormatCase_ == 5) {
            inputFormatCase_ = 0;
            inputFormat_ = null;
          }
          pubsubAvroFormatBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. It will be assumed data from Cloud Storage was written via
       * [Cloud Storage
       * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat.Builder
          getPubsubAvroFormatBuilder() {
        return getPubsubAvroFormatFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. It will be assumed data from Cloud Storage was written via
       * [Cloud Storage
       * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormatOrBuilder
          getPubsubAvroFormatOrBuilder() {
        if ((inputFormatCase_ == 5) && (pubsubAvroFormatBuilder_ != null)) {
          return pubsubAvroFormatBuilder_.getMessageOrBuilder();
        } else {
          if (inputFormatCase_ == 5) {
            return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
                inputFormat_;
          }
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. It will be assumed data from Cloud Storage was written via
       * [Cloud Storage
       * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                  .Builder,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                  .PubSubAvroFormatOrBuilder>
          getPubsubAvroFormatFieldBuilder() {
        if (pubsubAvroFormatBuilder_ == null) {
          if (!(inputFormatCase_ == 5)) {
            inputFormat_ =
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                    .getDefaultInstance();
          }
          pubsubAvroFormatBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat,
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                      .Builder,
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                      .PubSubAvroFormatOrBuilder>(
                  (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
                      inputFormat_,
                  getParentForChildren(),
                  isClean());
          inputFormat_ = null;
        }
        inputFormatCase_ = 5;
        onChanged();
        return pubsubAvroFormatBuilder_;
      }

      private com.google.protobuf.Timestamp minimumObjectCreateTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          minimumObjectCreateTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Only objects with a larger or equal creation timestamp will be
       * ingested.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the minimumObjectCreateTime field is set.
       */
      public boolean hasMinimumObjectCreateTime() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Only objects with a larger or equal creation timestamp will be
       * ingested.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The minimumObjectCreateTime.
       */
      public com.google.protobuf.Timestamp getMinimumObjectCreateTime() {
        if (minimumObjectCreateTimeBuilder_ == null) {
          return minimumObjectCreateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : minimumObjectCreateTime_;
        } else {
          return minimumObjectCreateTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Only objects with a larger or equal creation timestamp will be
       * ingested.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setMinimumObjectCreateTime(com.google.protobuf.Timestamp value) {
        if (minimumObjectCreateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          minimumObjectCreateTime_ = value;
        } else {
          minimumObjectCreateTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Only objects with a larger or equal creation timestamp will be
       * ingested.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setMinimumObjectCreateTime(
          com.google.protobuf.Timestamp.Builder builderForValue) {
        if (minimumObjectCreateTimeBuilder_ == null) {
          minimumObjectCreateTime_ = builderForValue.build();
        } else {
          minimumObjectCreateTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Only objects with a larger or equal creation timestamp will be
       * ingested.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeMinimumObjectCreateTime(com.google.protobuf.Timestamp value) {
        if (minimumObjectCreateTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && minimumObjectCreateTime_ != null
              && minimumObjectCreateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getMinimumObjectCreateTimeBuilder().mergeFrom(value);
          } else {
            minimumObjectCreateTime_ = value;
          }
        } else {
          minimumObjectCreateTimeBuilder_.mergeFrom(value);
        }
        if (minimumObjectCreateTime_ != null) {
          bitField0_ |= 0x00000020;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Only objects with a larger or equal creation timestamp will be
       * ingested.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearMinimumObjectCreateTime() {
        bitField0_ = (bitField0_ & ~0x00000020);
        minimumObjectCreateTime_ = null;
        if (minimumObjectCreateTimeBuilder_ != null) {
          minimumObjectCreateTimeBuilder_.dispose();
          minimumObjectCreateTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Only objects with a larger or equal creation timestamp will be
       * ingested.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getMinimumObjectCreateTimeBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getMinimumObjectCreateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Only objects with a larger or equal creation timestamp will be
       * ingested.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getMinimumObjectCreateTimeOrBuilder() {
        if (minimumObjectCreateTimeBuilder_ != null) {
          return minimumObjectCreateTimeBuilder_.getMessageOrBuilder();
        } else {
          return minimumObjectCreateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : minimumObjectCreateTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Only objects with a larger or equal creation timestamp will be
       * ingested.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getMinimumObjectCreateTimeFieldBuilder() {
        if (minimumObjectCreateTimeBuilder_ == null) {
          minimumObjectCreateTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getMinimumObjectCreateTime(), getParentForChildren(), isClean());
          minimumObjectCreateTime_ = null;
        }
        return minimumObjectCreateTimeBuilder_;
      }

      private java.lang.Object matchGlob_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Glob pattern used to match objects that will be ingested. If
       * unset, all objects will be ingested. See the [supported
       * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
       * </pre>
       *
       * <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The matchGlob.
       */
      public java.lang.String getMatchGlob() {
        java.lang.Object ref = matchGlob_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          matchGlob_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Glob pattern used to match objects that will be ingested. If
       * unset, all objects will be ingested. See the [supported
       * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
       * </pre>
       *
       * <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for matchGlob.
       */
      public com.google.protobuf.ByteString getMatchGlobBytes() {
        java.lang.Object ref = matchGlob_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          matchGlob_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Glob pattern used to match objects that will be ingested. If
       * unset, all objects will be ingested. See the [supported
       * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
       * </pre>
       *
       * <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The matchGlob to set.
       * @return This builder for chaining.
       */
      public Builder setMatchGlob(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        matchGlob_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Glob pattern used to match objects that will be ingested. If
       * unset, all objects will be ingested. See the [supported
       * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
       * </pre>
       *
       * <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMatchGlob() {
        matchGlob_ = getDefaultInstance().getMatchGlob();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Glob pattern used to match objects that will be ingested. If
       * unset, all objects will be ingested. See the [supported
       * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
       * </pre>
       *
       * <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for matchGlob to set.
       * @return This builder for chaining.
       */
      public Builder setMatchGlobBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        matchGlob_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage)
    }

    // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage)
    private static final com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage();
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CloudStorage> PARSER =
        new com.google.protobuf.AbstractParser<CloudStorage>() {
          @java.lang.Override
          public CloudStorage parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CloudStorage> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CloudStorage> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AWS_KINESIS(1),
    CLOUD_STORAGE(2),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 1:
          return AWS_KINESIS;
        case 2:
          return CLOUD_STORAGE;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int AWS_KINESIS_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Optional. Amazon Kinesis Data Streams.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the awsKinesis field is set.
   */
  @java.lang.Override
  public boolean hasAwsKinesis() {
    return sourceCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Optional. Amazon Kinesis Data Streams.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The awsKinesis.
   */
  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis getAwsKinesis() {
    if (sourceCase_ == 1) {
      return (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_;
    }
    return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Amazon Kinesis Data Streams.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesisOrBuilder
      getAwsKinesisOrBuilder() {
    if (sourceCase_ == 1) {
      return (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_;
    }
    return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
  }

  public static final int CLOUD_STORAGE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Optional. Cloud Storage.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the cloudStorage field is set.
   */
  @java.lang.Override
  public boolean hasCloudStorage() {
    return sourceCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Optional. Cloud Storage.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The cloudStorage.
   */
  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage getCloudStorage() {
    if (sourceCase_ == 2) {
      return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) source_;
    }
    return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Cloud Storage.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorageOrBuilder
      getCloudStorageOrBuilder() {
    if (sourceCase_ == 2) {
      return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) source_;
    }
    return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.getDefaultInstance();
  }

  public static final int PLATFORM_LOGS_SETTINGS_FIELD_NUMBER = 4;
  private com.google.pubsub.v1.PlatformLogsSettings platformLogsSettings_;
  /**
   *
   *
   * <pre>
   * Optional. Platform Logs settings. If unset, no Platform Logs will be
   * generated.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the platformLogsSettings field is set.
   */
  @java.lang.Override
  public boolean hasPlatformLogsSettings() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Platform Logs settings. If unset, no Platform Logs will be
   * generated.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The platformLogsSettings.
   */
  @java.lang.Override
  public com.google.pubsub.v1.PlatformLogsSettings getPlatformLogsSettings() {
    return platformLogsSettings_ == null
        ? com.google.pubsub.v1.PlatformLogsSettings.getDefaultInstance()
        : platformLogsSettings_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Platform Logs settings. If unset, no Platform Logs will be
   * generated.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.PlatformLogsSettingsOrBuilder getPlatformLogsSettingsOrBuilder() {
    return platformLogsSettings_ == null
        ? com.google.pubsub.v1.PlatformLogsSettings.getDefaultInstance()
        : platformLogsSettings_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (sourceCase_ == 1) {
      output.writeMessage(1, (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_);
    }
    if (sourceCase_ == 2) {
      output.writeMessage(
          2, (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) source_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getPlatformLogsSettings());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (sourceCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_);
    }
    if (sourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) source_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPlatformLogsSettings());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.pubsub.v1.IngestionDataSourceSettings)) {
      return super.equals(obj);
    }
    com.google.pubsub.v1.IngestionDataSourceSettings other =
        (com.google.pubsub.v1.IngestionDataSourceSettings) obj;

    if (hasPlatformLogsSettings() != other.hasPlatformLogsSettings()) return false;
    if (hasPlatformLogsSettings()) {
      if (!getPlatformLogsSettings().equals(other.getPlatformLogsSettings())) return false;
    }
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 1:
        if (!getAwsKinesis().equals(other.getAwsKinesis())) return false;
        break;
      case 2:
        if (!getCloudStorage().equals(other.getCloudStorage())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasPlatformLogsSettings()) {
      hash = (37 * hash) + PLATFORM_LOGS_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getPlatformLogsSettings().hashCode();
    }
    switch (sourceCase_) {
      case 1:
        hash = (37 * hash) + AWS_KINESIS_FIELD_NUMBER;
        hash = (53 * hash) + getAwsKinesis().hashCode();
        break;
      case 2:
        hash = (37 * hash) + CLOUD_STORAGE_FIELD_NUMBER;
        hash = (53 * hash) + getCloudStorage().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.pubsub.v1.IngestionDataSourceSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Settings for an ingestion data source on a topic.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionDataSourceSettings)
      com.google.pubsub.v1.IngestionDataSourceSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.IngestionDataSourceSettings.class,
              com.google.pubsub.v1.IngestionDataSourceSettings.Builder.class);
    }

    // Construct using com.google.pubsub.v1.IngestionDataSourceSettings.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPlatformLogsSettingsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (awsKinesisBuilder_ != null) {
        awsKinesisBuilder_.clear();
      }
      if (cloudStorageBuilder_ != null) {
        cloudStorageBuilder_.clear();
      }
      platformLogsSettings_ = null;
      if (platformLogsSettingsBuilder_ != null) {
        platformLogsSettingsBuilder_.dispose();
        platformLogsSettingsBuilder_ = null;
      }
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_descriptor;
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings getDefaultInstanceForType() {
      return com.google.pubsub.v1.IngestionDataSourceSettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings build() {
      com.google.pubsub.v1.IngestionDataSourceSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings buildPartial() {
      com.google.pubsub.v1.IngestionDataSourceSettings result =
          new com.google.pubsub.v1.IngestionDataSourceSettings(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.pubsub.v1.IngestionDataSourceSettings result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.platformLogsSettings_ =
            platformLogsSettingsBuilder_ == null
                ? platformLogsSettings_
                : platformLogsSettingsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.pubsub.v1.IngestionDataSourceSettings result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 1 && awsKinesisBuilder_ != null) {
        result.source_ = awsKinesisBuilder_.build();
      }
      if (sourceCase_ == 2 && cloudStorageBuilder_ != null) {
        result.source_ = cloudStorageBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.pubsub.v1.IngestionDataSourceSettings) {
        return mergeFrom((com.google.pubsub.v1.IngestionDataSourceSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.pubsub.v1.IngestionDataSourceSettings other) {
      if (other == com.google.pubsub.v1.IngestionDataSourceSettings.getDefaultInstance())
        return this;
      if (other.hasPlatformLogsSettings()) {
        mergePlatformLogsSettings(other.getPlatformLogsSettings());
      }
      switch (other.getSourceCase()) {
        case AWS_KINESIS:
          {
            mergeAwsKinesis(other.getAwsKinesis());
            break;
          }
        case CLOUD_STORAGE:
          {
            mergeCloudStorage(other.getCloudStorage());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getAwsKinesisFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCloudStorageFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 2;
                break;
              } // case 18
            case 34:
              {
                input.readMessage(
                    getPlatformLogsSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis,
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder,
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesisOrBuilder>
        awsKinesisBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the awsKinesis field is set.
     */
    @java.lang.Override
    public boolean hasAwsKinesis() {
      return sourceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The awsKinesis.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis getAwsKinesis() {
      if (awsKinesisBuilder_ == null) {
        if (sourceCase_ == 1) {
          return (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_;
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
      } else {
        if (sourceCase_ == 1) {
          return awsKinesisBuilder_.getMessage();
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAwsKinesis(
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis value) {
      if (awsKinesisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        awsKinesisBuilder_.setMessage(value);
      }
      sourceCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAwsKinesis(
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder builderForValue) {
      if (awsKinesisBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        awsKinesisBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAwsKinesis(
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis value) {
      if (awsKinesisBuilder_ == null) {
        if (sourceCase_ == 1
            && source_
                != com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
                    .getDefaultInstance()) {
          source_ =
              com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.newBuilder(
                      (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 1) {
          awsKinesisBuilder_.mergeFrom(value);
        } else {
          awsKinesisBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAwsKinesis() {
      if (awsKinesisBuilder_ == null) {
        if (sourceCase_ == 1) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 1) {
          sourceCase_ = 0;
          source_ = null;
        }
        awsKinesisBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder
        getAwsKinesisBuilder() {
      return getAwsKinesisFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesisOrBuilder
        getAwsKinesisOrBuilder() {
      if ((sourceCase_ == 1) && (awsKinesisBuilder_ != null)) {
        return awsKinesisBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 1) {
          return (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_;
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis,
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder,
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesisOrBuilder>
        getAwsKinesisFieldBuilder() {
      if (awsKinesisBuilder_ == null) {
        if (!(sourceCase_ == 1)) {
          source_ =
              com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
        }
        awsKinesisBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis,
                com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder,
                com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesisOrBuilder>(
                (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 1;
      onChanged();
      return awsKinesisBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage,
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.Builder,
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorageOrBuilder>
        cloudStorageBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the cloudStorage field is set.
     */
    @java.lang.Override
    public boolean hasCloudStorage() {
      return sourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The cloudStorage.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage getCloudStorage() {
      if (cloudStorageBuilder_ == null) {
        if (sourceCase_ == 2) {
          return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) source_;
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.getDefaultInstance();
      } else {
        if (sourceCase_ == 2) {
          return cloudStorageBuilder_.getMessage();
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCloudStorage(
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage value) {
      if (cloudStorageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        cloudStorageBuilder_.setMessage(value);
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCloudStorage(
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.Builder builderForValue) {
      if (cloudStorageBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        cloudStorageBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCloudStorage(
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage value) {
      if (cloudStorageBuilder_ == null) {
        if (sourceCase_ == 2
            && source_
                != com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                    .getDefaultInstance()) {
          source_ =
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.newBuilder(
                      (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 2) {
          cloudStorageBuilder_.mergeFrom(value);
        } else {
          cloudStorageBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCloudStorage() {
      if (cloudStorageBuilder_ == null) {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
        }
        cloudStorageBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.Builder
        getCloudStorageBuilder() {
      return getCloudStorageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorageOrBuilder
        getCloudStorageOrBuilder() {
      if ((sourceCase_ == 2) && (cloudStorageBuilder_ != null)) {
        return cloudStorageBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 2) {
          return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) source_;
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage,
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.Builder,
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorageOrBuilder>
        getCloudStorageFieldBuilder() {
      if (cloudStorageBuilder_ == null) {
        if (!(sourceCase_ == 2)) {
          source_ =
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.getDefaultInstance();
        }
        cloudStorageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage,
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.Builder,
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorageOrBuilder>(
                (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 2;
      onChanged();
      return cloudStorageBuilder_;
    }

    private com.google.pubsub.v1.PlatformLogsSettings platformLogsSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.PlatformLogsSettings,
            com.google.pubsub.v1.PlatformLogsSettings.Builder,
            com.google.pubsub.v1.PlatformLogsSettingsOrBuilder>
        platformLogsSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Platform Logs settings. If unset, no Platform Logs will be
     * generated.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the platformLogsSettings field is set.
     */
    public boolean hasPlatformLogsSettings() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Platform Logs settings. If unset, no Platform Logs will be
     * generated.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The platformLogsSettings.
     */
    public com.google.pubsub.v1.PlatformLogsSettings getPlatformLogsSettings() {
      if (platformLogsSettingsBuilder_ == null) {
        return platformLogsSettings_ == null
            ? com.google.pubsub.v1.PlatformLogsSettings.getDefaultInstance()
            : platformLogsSettings_;
      } else {
        return platformLogsSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Platform Logs settings. If unset, no Platform Logs will be
     * generated.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPlatformLogsSettings(com.google.pubsub.v1.PlatformLogsSettings value) {
      if (platformLogsSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        platformLogsSettings_ = value;
      } else {
        platformLogsSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Platform Logs settings. If unset, no Platform Logs will be
     * generated.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPlatformLogsSettings(
        com.google.pubsub.v1.PlatformLogsSettings.Builder builderForValue) {
      if (platformLogsSettingsBuilder_ == null) {
        platformLogsSettings_ = builderForValue.build();
      } else {
        platformLogsSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Platform Logs settings. If unset, no Platform Logs will be
     * generated.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePlatformLogsSettings(com.google.pubsub.v1.PlatformLogsSettings value) {
      if (platformLogsSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && platformLogsSettings_ != null
            && platformLogsSettings_
                != com.google.pubsub.v1.PlatformLogsSettings.getDefaultInstance()) {
          getPlatformLogsSettingsBuilder().mergeFrom(value);
        } else {
          platformLogsSettings_ = value;
        }
      } else {
        platformLogsSettingsBuilder_.mergeFrom(value);
      }
      if (platformLogsSettings_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Platform Logs settings. If unset, no Platform Logs will be
     * generated.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPlatformLogsSettings() {
      bitField0_ = (bitField0_ & ~0x00000004);
      platformLogsSettings_ = null;
      if (platformLogsSettingsBuilder_ != null) {
        platformLogsSettingsBuilder_.dispose();
        platformLogsSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Platform Logs settings. If unset, no Platform Logs will be
     * generated.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.PlatformLogsSettings.Builder getPlatformLogsSettingsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getPlatformLogsSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Platform Logs settings. If unset, no Platform Logs will be
     * generated.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.PlatformLogsSettingsOrBuilder getPlatformLogsSettingsOrBuilder() {
      if (platformLogsSettingsBuilder_ != null) {
        return platformLogsSettingsBuilder_.getMessageOrBuilder();
      } else {
        return platformLogsSettings_ == null
            ? com.google.pubsub.v1.PlatformLogsSettings.getDefaultInstance()
            : platformLogsSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Platform Logs settings. If unset, no Platform Logs will be
     * generated.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.PlatformLogsSettings,
            com.google.pubsub.v1.PlatformLogsSettings.Builder,
            com.google.pubsub.v1.PlatformLogsSettingsOrBuilder>
        getPlatformLogsSettingsFieldBuilder() {
      if (platformLogsSettingsBuilder_ == null) {
        platformLogsSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.PlatformLogsSettings,
                com.google.pubsub.v1.PlatformLogsSettings.Builder,
                com.google.pubsub.v1.PlatformLogsSettingsOrBuilder>(
                getPlatformLogsSettings(), getParentForChildren(), isClean());
        platformLogsSettings_ = null;
      }
      return platformLogsSettingsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionDataSourceSettings)
  }

  // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionDataSourceSettings)
  private static final com.google.pubsub.v1.IngestionDataSourceSettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.pubsub.v1.IngestionDataSourceSettings();
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IngestionDataSourceSettings> PARSER =
      new com.google.protobuf.AbstractParser<IngestionDataSourceSettings>() {
        @java.lang.Override
        public IngestionDataSourceSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<IngestionDataSourceSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IngestionDataSourceSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
