/*
 * Decompiled with CFR 0.152.
 */
package com.google.pubsub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.pubsub.v1.TopicName;
import java.util.Map;

public class ProjectTopicName
extends TopicName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/topics/{topic}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String topic;

    @Override
    public String getProject() {
        return this.project;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectTopicName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.topic = (String)Preconditions.checkNotNull((Object)builder.getTopic());
    }

    public static ProjectTopicName of(String project, String topic) {
        return ProjectTopicName.newBuilder().setProject(project).setTopic(topic).build();
    }

    public static String format(String project, String topic) {
        return ProjectTopicName.newBuilder().setProject(project).setTopic(topic).build().toString();
    }

    public static ProjectTopicName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectTopicName.parse: formattedString not in valid format");
        return ProjectTopicName.of((String)matchMap.get("project"), (String)matchMap.get("topic"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectTopicName projectTopicName = this;
            synchronized (projectTopicName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"topic", (Object)this.topic);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    @Override
    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "topic", this.topic});
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectTopicName) {
            ProjectTopicName that = (ProjectTopicName)o;
            return this.project.equals(that.project) && this.topic.equals(that.topic);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.topic.hashCode();
    }

    public static class Builder
    extends TopicName.Builder {
        private String project;
        private String topic;

        @Override
        public String getProject() {
            return this.project;
        }

        @Override
        public String getTopic() {
            return this.topic;
        }

        @Override
        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        @Override
        public Builder setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        private Builder() {
        }

        private Builder(ProjectTopicName projectTopicName) {
            this.project = projectTopicName.project;
            this.topic = projectTopicName.topic;
        }

        @Override
        public ProjectTopicName build() {
            return new ProjectTopicName(this);
        }
    }
}

