/*
 * Decompiled with CFR 0.152.
 */
package com.google.pubsub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProjectSnapshotName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/snapshots/{snapshot}");
    private final String project;
    private final String snapshot;

    public String getProject() {
        return this.project;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectSnapshotName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.snapshot = (String)Preconditions.checkNotNull((Object)builder.getSnapshot());
    }

    public static ProjectSnapshotName of(String project, String snapshot) {
        return ProjectSnapshotName.newBuilder().setProject(project).setSnapshot(snapshot).build();
    }

    public static String format(String project, String snapshot) {
        return ProjectSnapshotName.newBuilder().setProject(project).setSnapshot(snapshot).build().toString();
    }

    public static ProjectSnapshotName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectSnapshotName.parse: formattedString not in valid format");
        return ProjectSnapshotName.of((String)matchMap.get("project"), (String)matchMap.get("snapshot"));
    }

    public static List<ProjectSnapshotName> parseList(List<String> formattedStrings) {
        ArrayList<ProjectSnapshotName> list = new ArrayList<ProjectSnapshotName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProjectSnapshotName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProjectSnapshotName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProjectSnapshotName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("ProjectSnapshotName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "snapshot", this.snapshot});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectSnapshotName) {
            ProjectSnapshotName that = (ProjectSnapshotName)o;
            return this.project.equals(that.project) && this.snapshot.equals(that.snapshot);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.snapshot.hashCode();
    }

    public static class Builder {
        private String project;
        private String snapshot;

        public String getProject() {
            return this.project;
        }

        public String getSnapshot() {
            return this.snapshot;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSnapshot(String snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        private Builder() {
        }

        private Builder(ProjectSnapshotName projectSnapshotName) {
            this.project = projectSnapshotName.project;
            this.snapshot = projectSnapshotName.snapshot;
        }

        public ProjectSnapshotName build() {
            return new ProjectSnapshotName(this);
        }
    }
}

