/*
 * Decompiled with CFR 0.152.
 */
package com.google.pubsub.v1;

import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.api.resourcenames.UntypedResourceName;
import com.google.common.base.Preconditions;
import com.google.pubsub.v1.DeletedTopic;
import com.google.pubsub.v1.TopicName;

public class TopicNameOneof
implements ResourceName {
    private final ResourceName resourceName;

    public TopicName getTopicName() {
        if (this.resourceName instanceof TopicName) {
            return (TopicName)this.resourceName;
        }
        return null;
    }

    public DeletedTopic getDeletedTopic() {
        if (this.resourceName instanceof DeletedTopic) {
            return (DeletedTopic)this.resourceName;
        }
        return null;
    }

    public UntypedResourceName getUntypedResourceName() {
        if (this.resourceName instanceof UntypedResourceName) {
            return (UntypedResourceName)this.resourceName;
        }
        return null;
    }

    public ResourceName getResourceName() {
        return this.resourceName;
    }

    public ResourceNameType getType() {
        return this.getResourceName().getType();
    }

    private TopicNameOneof(ResourceName resourceName) {
        this.resourceName = (ResourceName)Preconditions.checkNotNull((Object)resourceName);
    }

    public static TopicNameOneof parse(String resourceNameString) {
        if (TopicName.isParsableFrom(resourceNameString)) {
            return new TopicNameOneof(TopicName.parse(resourceNameString));
        }
        if (DeletedTopic.matches(resourceNameString)) {
            return new TopicNameOneof(DeletedTopic.instance());
        }
        return new TopicNameOneof((ResourceName)UntypedResourceName.parse((String)resourceNameString));
    }

    public static TopicNameOneof from(TopicName topicName) {
        return new TopicNameOneof(topicName);
    }

    public static TopicNameOneof from(DeletedTopic deletedTopic) {
        return new TopicNameOneof(deletedTopic);
    }

    public static TopicNameOneof fromUntyped(UntypedResourceName untypedResourceName) {
        return new TopicNameOneof((ResourceName)untypedResourceName);
    }

    public String toString() {
        return this.getResourceName().toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TopicNameOneof) {
            TopicNameOneof that = (TopicNameOneof)o;
            return this.resourceName.equals(that.resourceName);
        }
        return false;
    }

    public int hashCode() {
        return this.resourceName.hashCode();
    }
}

