/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.privilegedaccessmanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EntitlementName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ENTITLEMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/entitlements/{entitlement}");
    private static final PathTemplate FOLDER_LOCATION_ENTITLEMENT = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}/entitlements/{entitlement}");
    private static final PathTemplate ORGANIZATION_LOCATION_ENTITLEMENT = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/entitlements/{entitlement}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String entitlement;
    private final String folder;
    private final String organization;

    @Deprecated
    protected EntitlementName() {
        this.project = null;
        this.location = null;
        this.entitlement = null;
        this.folder = null;
        this.organization = null;
    }

    private EntitlementName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.entitlement = (String)Preconditions.checkNotNull((Object)builder.getEntitlement());
        this.folder = null;
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_ENTITLEMENT;
    }

    private EntitlementName(FolderLocationEntitlementBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.entitlement = (String)Preconditions.checkNotNull((Object)builder.getEntitlement());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_LOCATION_ENTITLEMENT;
    }

    private EntitlementName(OrganizationLocationEntitlementBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.entitlement = (String)Preconditions.checkNotNull((Object)builder.getEntitlement());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_LOCATION_ENTITLEMENT;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEntitlement() {
        return this.entitlement;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationEntitlementBuilder() {
        return new Builder();
    }

    public static FolderLocationEntitlementBuilder newFolderLocationEntitlementBuilder() {
        return new FolderLocationEntitlementBuilder();
    }

    public static OrganizationLocationEntitlementBuilder newOrganizationLocationEntitlementBuilder() {
        return new OrganizationLocationEntitlementBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EntitlementName of(String project, String location, String entitlement) {
        return EntitlementName.newBuilder().setProject(project).setLocation(location).setEntitlement(entitlement).build();
    }

    public static EntitlementName ofProjectLocationEntitlementName(String project, String location, String entitlement) {
        return EntitlementName.newBuilder().setProject(project).setLocation(location).setEntitlement(entitlement).build();
    }

    public static EntitlementName ofFolderLocationEntitlementName(String folder, String location, String entitlement) {
        return EntitlementName.newFolderLocationEntitlementBuilder().setFolder(folder).setLocation(location).setEntitlement(entitlement).build();
    }

    public static EntitlementName ofOrganizationLocationEntitlementName(String organization, String location, String entitlement) {
        return EntitlementName.newOrganizationLocationEntitlementBuilder().setOrganization(organization).setLocation(location).setEntitlement(entitlement).build();
    }

    public static String format(String project, String location, String entitlement) {
        return EntitlementName.newBuilder().setProject(project).setLocation(location).setEntitlement(entitlement).build().toString();
    }

    public static String formatProjectLocationEntitlementName(String project, String location, String entitlement) {
        return EntitlementName.newBuilder().setProject(project).setLocation(location).setEntitlement(entitlement).build().toString();
    }

    public static String formatFolderLocationEntitlementName(String folder, String location, String entitlement) {
        return EntitlementName.newFolderLocationEntitlementBuilder().setFolder(folder).setLocation(location).setEntitlement(entitlement).build().toString();
    }

    public static String formatOrganizationLocationEntitlementName(String organization, String location, String entitlement) {
        return EntitlementName.newOrganizationLocationEntitlementBuilder().setOrganization(organization).setLocation(location).setEntitlement(entitlement).build().toString();
    }

    public static EntitlementName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_ENTITLEMENT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_ENTITLEMENT.match(formattedString);
            return EntitlementName.ofProjectLocationEntitlementName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("entitlement"));
        }
        if (FOLDER_LOCATION_ENTITLEMENT.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION_ENTITLEMENT.match(formattedString);
            return EntitlementName.ofFolderLocationEntitlementName((String)matchMap.get("folder"), (String)matchMap.get("location"), (String)matchMap.get("entitlement"));
        }
        if (ORGANIZATION_LOCATION_ENTITLEMENT.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_ENTITLEMENT.match(formattedString);
            return EntitlementName.ofOrganizationLocationEntitlementName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("entitlement"));
        }
        throw new ValidationException("EntitlementName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<EntitlementName> parseList(List<String> formattedStrings) {
        ArrayList<EntitlementName> list = new ArrayList<EntitlementName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EntitlementName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EntitlementName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EntitlementName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ENTITLEMENT.matches(formattedString) || FOLDER_LOCATION_ENTITLEMENT.matches(formattedString) || ORGANIZATION_LOCATION_ENTITLEMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EntitlementName entitlementName = this;
            synchronized (entitlementName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.entitlement != null) {
                        fieldMapBuilder.put((Object)"entitlement", (Object)this.entitlement);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EntitlementName that = (EntitlementName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.entitlement, that.entitlement) && Objects.equals(this.folder, that.folder) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.entitlement);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    public static class OrganizationLocationEntitlementBuilder {
        private String organization;
        private String location;
        private String entitlement;

        protected OrganizationLocationEntitlementBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEntitlement() {
            return this.entitlement;
        }

        public OrganizationLocationEntitlementBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationEntitlementBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationEntitlementBuilder setEntitlement(String entitlement) {
            this.entitlement = entitlement;
            return this;
        }

        public EntitlementName build() {
            return new EntitlementName(this);
        }
    }

    public static class FolderLocationEntitlementBuilder {
        private String folder;
        private String location;
        private String entitlement;

        protected FolderLocationEntitlementBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEntitlement() {
            return this.entitlement;
        }

        public FolderLocationEntitlementBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationEntitlementBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationEntitlementBuilder setEntitlement(String entitlement) {
            this.entitlement = entitlement;
            return this;
        }

        public EntitlementName build() {
            return new EntitlementName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String entitlement;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEntitlement() {
            return this.entitlement;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEntitlement(String entitlement) {
            this.entitlement = entitlement;
            return this;
        }

        private Builder(EntitlementName entitlementName) {
            Preconditions.checkArgument((boolean)Objects.equals(entitlementName.pathTemplate, PROJECT_LOCATION_ENTITLEMENT), (Object)"toBuilder is only supported when EntitlementName has the pattern of projects/{project}/locations/{location}/entitlements/{entitlement}");
            this.project = entitlementName.project;
            this.location = entitlementName.location;
            this.entitlement = entitlementName.entitlement;
        }

        public EntitlementName build() {
            return new EntitlementName(this);
        }
    }
}

