/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.osconfig.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OSPolicyAssignmentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_OS_POLICY_ASSIGNMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/osPolicyAssignments/{os_policy_assignment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String osPolicyAssignment;

    @Deprecated
    protected OSPolicyAssignmentName() {
        this.project = null;
        this.location = null;
        this.osPolicyAssignment = null;
    }

    private OSPolicyAssignmentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.osPolicyAssignment = (String)Preconditions.checkNotNull((Object)builder.getOsPolicyAssignment());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getOsPolicyAssignment() {
        return this.osPolicyAssignment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static OSPolicyAssignmentName of(String project, String location, String osPolicyAssignment) {
        return OSPolicyAssignmentName.newBuilder().setProject(project).setLocation(location).setOsPolicyAssignment(osPolicyAssignment).build();
    }

    public static String format(String project, String location, String osPolicyAssignment) {
        return OSPolicyAssignmentName.newBuilder().setProject(project).setLocation(location).setOsPolicyAssignment(osPolicyAssignment).build().toString();
    }

    public static OSPolicyAssignmentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_OS_POLICY_ASSIGNMENT.validatedMatch(formattedString, "OSPolicyAssignmentName.parse: formattedString not in valid format");
        return OSPolicyAssignmentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("os_policy_assignment"));
    }

    public static List<OSPolicyAssignmentName> parseList(List<String> formattedStrings) {
        ArrayList<OSPolicyAssignmentName> list = new ArrayList<OSPolicyAssignmentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OSPolicyAssignmentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OSPolicyAssignmentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OSPolicyAssignmentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_OS_POLICY_ASSIGNMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OSPolicyAssignmentName oSPolicyAssignmentName = this;
            synchronized (oSPolicyAssignmentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.osPolicyAssignment != null) {
                        fieldMapBuilder.put((Object)"os_policy_assignment", (Object)this.osPolicyAssignment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_OS_POLICY_ASSIGNMENT.instantiate(new String[]{"project", this.project, "location", this.location, "os_policy_assignment", this.osPolicyAssignment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            OSPolicyAssignmentName that = (OSPolicyAssignmentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.osPolicyAssignment, that.osPolicyAssignment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.osPolicyAssignment);
    }

    public static class Builder {
        private String project;
        private String location;
        private String osPolicyAssignment;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getOsPolicyAssignment() {
            return this.osPolicyAssignment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setOsPolicyAssignment(String osPolicyAssignment) {
            this.osPolicyAssignment = osPolicyAssignment;
            return this;
        }

        private Builder(OSPolicyAssignmentName oSPolicyAssignmentName) {
            this.project = oSPolicyAssignmentName.project;
            this.location = oSPolicyAssignmentName.location;
            this.osPolicyAssignment = oSPolicyAssignmentName.osPolicyAssignment;
        }

        public OSPolicyAssignmentName build() {
            return new OSPolicyAssignmentName(this);
        }
    }
}

