/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.orgpolicy.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomConstraintName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_CUSTOM_CONSTRAINT = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/customConstraints/{custom_constraint}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String customConstraint;

    @Deprecated
    protected CustomConstraintName() {
        this.organization = null;
        this.customConstraint = null;
    }

    private CustomConstraintName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.customConstraint = (String)Preconditions.checkNotNull((Object)builder.getCustomConstraint());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getCustomConstraint() {
        return this.customConstraint;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomConstraintName of(String organization, String customConstraint) {
        return CustomConstraintName.newBuilder().setOrganization(organization).setCustomConstraint(customConstraint).build();
    }

    public static String format(String organization, String customConstraint) {
        return CustomConstraintName.newBuilder().setOrganization(organization).setCustomConstraint(customConstraint).build().toString();
    }

    public static CustomConstraintName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_CUSTOM_CONSTRAINT.validatedMatch(formattedString, "CustomConstraintName.parse: formattedString not in valid format");
        return CustomConstraintName.of((String)matchMap.get("organization"), (String)matchMap.get("custom_constraint"));
    }

    public static List<CustomConstraintName> parseList(List<String> formattedStrings) {
        ArrayList<CustomConstraintName> list = new ArrayList<CustomConstraintName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomConstraintName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomConstraintName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomConstraintName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_CUSTOM_CONSTRAINT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomConstraintName customConstraintName = this;
            synchronized (customConstraintName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.customConstraint != null) {
                        fieldMapBuilder.put((Object)"custom_constraint", (Object)this.customConstraint);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_CUSTOM_CONSTRAINT.instantiate(new String[]{"organization", this.organization, "custom_constraint", this.customConstraint});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CustomConstraintName that = (CustomConstraintName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.customConstraint, that.customConstraint);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        return h ^= Objects.hashCode(this.customConstraint);
    }

    public static class Builder {
        private String organization;
        private String customConstraint;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getCustomConstraint() {
            return this.customConstraint;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setCustomConstraint(String customConstraint) {
            this.customConstraint = customConstraint;
            return this;
        }

        private Builder(CustomConstraintName customConstraintName) {
            this.organization = customConstraintName.organization;
            this.customConstraint = customConstraintName.customConstraint;
        }

        public CustomConstraintName build() {
            return new CustomConstraintName(this);
        }
    }
}

