/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.notebooks.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RuntimeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RUNTIME = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/runtimes/{runtime}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String runtime;

    @Deprecated
    protected RuntimeName() {
        this.project = null;
        this.location = null;
        this.runtime = null;
    }

    private RuntimeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.runtime = (String)Preconditions.checkNotNull((Object)builder.getRuntime());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RuntimeName of(String project, String location, String runtime) {
        return RuntimeName.newBuilder().setProject(project).setLocation(location).setRuntime(runtime).build();
    }

    public static String format(String project, String location, String runtime) {
        return RuntimeName.newBuilder().setProject(project).setLocation(location).setRuntime(runtime).build().toString();
    }

    public static RuntimeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RUNTIME.validatedMatch(formattedString, "RuntimeName.parse: formattedString not in valid format");
        return RuntimeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("runtime"));
    }

    public static List<RuntimeName> parseList(List<String> formattedStrings) {
        ArrayList<RuntimeName> list = new ArrayList<RuntimeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RuntimeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RuntimeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RuntimeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RUNTIME.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RuntimeName runtimeName = this;
            synchronized (runtimeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.runtime != null) {
                        fieldMapBuilder.put((Object)"runtime", (Object)this.runtime);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RUNTIME.instantiate(new String[]{"project", this.project, "location", this.location, "runtime", this.runtime});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RuntimeName that = (RuntimeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.runtime, that.runtime);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.runtime);
    }

    public static class Builder {
        private String project;
        private String location;
        private String runtime;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRuntime() {
            return this.runtime;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRuntime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        private Builder(RuntimeName runtimeName) {
            this.project = runtimeName.project;
            this.location = runtimeName.location;
            this.runtime = runtimeName.runtime;
        }

        public RuntimeName build() {
            return new RuntimeName(this);
        }
    }
}

