/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1alpha1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VpnTunnelName
implements ResourceName {
    private static final PathTemplate PROJECT_REGION_RESOURCE_ID = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/regions/{region}/vpnTunnels/{resource_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String region;
    private final String resourceId;

    @Deprecated
    protected VpnTunnelName() {
        this.project = null;
        this.region = null;
        this.resourceId = null;
    }

    private VpnTunnelName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.resourceId = (String)Preconditions.checkNotNull((Object)builder.getResourceId());
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static VpnTunnelName of(String project, String region, String resourceId) {
        return VpnTunnelName.newBuilder().setProject(project).setRegion(region).setResourceId(resourceId).build();
    }

    public static String format(String project, String region, String resourceId) {
        return VpnTunnelName.newBuilder().setProject(project).setRegion(region).setResourceId(resourceId).build().toString();
    }

    public static VpnTunnelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_REGION_RESOURCE_ID.validatedMatch(formattedString, "VpnTunnelName.parse: formattedString not in valid format");
        return VpnTunnelName.of((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("resource_id"));
    }

    public static List<VpnTunnelName> parseList(List<String> formattedStrings) {
        ArrayList<VpnTunnelName> list = new ArrayList<VpnTunnelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(VpnTunnelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<VpnTunnelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (VpnTunnelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_REGION_RESOURCE_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            VpnTunnelName vpnTunnelName = this;
            synchronized (vpnTunnelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.region != null) {
                        fieldMapBuilder.put((Object)"region", (Object)this.region);
                    }
                    if (this.resourceId != null) {
                        fieldMapBuilder.put((Object)"resource_id", (Object)this.resourceId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_REGION_RESOURCE_ID.instantiate(new String[]{"project", this.project, "region", this.region, "resource_id", this.resourceId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            VpnTunnelName that = (VpnTunnelName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.region, that.region) && Objects.equals(this.resourceId, that.resourceId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.region);
        h *= 1000003;
        return h ^= Objects.hashCode(this.resourceId);
    }

    public static class Builder {
        private String project;
        private String region;
        private String resourceId;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setResourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        private Builder(VpnTunnelName vpnTunnelName) {
            this.project = vpnTunnelName.project;
            this.region = vpnTunnelName.region;
            this.resourceId = vpnTunnelName.resourceId;
        }

        public VpnTunnelName build() {
            return new VpnTunnelName(this);
        }
    }
}

