/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1alpha1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SpokeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SPOKE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/spokes/{spoke}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String spoke;

    @Deprecated
    protected SpokeName() {
        this.project = null;
        this.location = null;
        this.spoke = null;
    }

    private SpokeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.spoke = (String)Preconditions.checkNotNull((Object)builder.getSpoke());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSpoke() {
        return this.spoke;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SpokeName of(String project, String location, String spoke) {
        return SpokeName.newBuilder().setProject(project).setLocation(location).setSpoke(spoke).build();
    }

    public static String format(String project, String location, String spoke) {
        return SpokeName.newBuilder().setProject(project).setLocation(location).setSpoke(spoke).build().toString();
    }

    public static SpokeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SPOKE.validatedMatch(formattedString, "SpokeName.parse: formattedString not in valid format");
        return SpokeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("spoke"));
    }

    public static List<SpokeName> parseList(List<String> formattedStrings) {
        ArrayList<SpokeName> list = new ArrayList<SpokeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SpokeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SpokeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SpokeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SPOKE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SpokeName spokeName = this;
            synchronized (spokeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.spoke != null) {
                        fieldMapBuilder.put((Object)"spoke", (Object)this.spoke);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SPOKE.instantiate(new String[]{"project", this.project, "location", this.location, "spoke", this.spoke});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SpokeName that = (SpokeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.spoke, that.spoke);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.spoke);
    }

    public static class Builder {
        private String project;
        private String location;
        private String spoke;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSpoke() {
            return this.spoke;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSpoke(String spoke) {
            this.spoke = spoke;
            return this;
        }

        private Builder(SpokeName spokeName) {
            this.project = spokeName.project;
            this.location = spokeName.location;
            this.spoke = spokeName.spoke;
        }

        public SpokeName build() {
            return new SpokeName(this);
        }
    }
}

