/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MulticloudDataTransferSupportedServiceName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_MULTICLOUD_DATA_TRANSFER_SUPPORTED_SERVICE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/multicloudDataTransferSupportedServices/{multicloud_data_transfer_supported_service}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String multicloudDataTransferSupportedService;

    @Deprecated
    protected MulticloudDataTransferSupportedServiceName() {
        this.project = null;
        this.location = null;
        this.multicloudDataTransferSupportedService = null;
    }

    private MulticloudDataTransferSupportedServiceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.multicloudDataTransferSupportedService = (String)Preconditions.checkNotNull((Object)builder.getMulticloudDataTransferSupportedService());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMulticloudDataTransferSupportedService() {
        return this.multicloudDataTransferSupportedService;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MulticloudDataTransferSupportedServiceName of(String project, String location, String multicloudDataTransferSupportedService) {
        return MulticloudDataTransferSupportedServiceName.newBuilder().setProject(project).setLocation(location).setMulticloudDataTransferSupportedService(multicloudDataTransferSupportedService).build();
    }

    public static String format(String project, String location, String multicloudDataTransferSupportedService) {
        return MulticloudDataTransferSupportedServiceName.newBuilder().setProject(project).setLocation(location).setMulticloudDataTransferSupportedService(multicloudDataTransferSupportedService).build().toString();
    }

    public static MulticloudDataTransferSupportedServiceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_MULTICLOUD_DATA_TRANSFER_SUPPORTED_SERVICE.validatedMatch(formattedString, "MulticloudDataTransferSupportedServiceName.parse: formattedString not in valid format");
        return MulticloudDataTransferSupportedServiceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("multicloud_data_transfer_supported_service"));
    }

    public static List<MulticloudDataTransferSupportedServiceName> parseList(List<String> formattedStrings) {
        ArrayList<MulticloudDataTransferSupportedServiceName> list = new ArrayList<MulticloudDataTransferSupportedServiceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MulticloudDataTransferSupportedServiceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MulticloudDataTransferSupportedServiceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MulticloudDataTransferSupportedServiceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_MULTICLOUD_DATA_TRANSFER_SUPPORTED_SERVICE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MulticloudDataTransferSupportedServiceName multicloudDataTransferSupportedServiceName = this;
            synchronized (multicloudDataTransferSupportedServiceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.multicloudDataTransferSupportedService != null) {
                        fieldMapBuilder.put((Object)"multicloud_data_transfer_supported_service", (Object)this.multicloudDataTransferSupportedService);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_MULTICLOUD_DATA_TRANSFER_SUPPORTED_SERVICE.instantiate(new String[]{"project", this.project, "location", this.location, "multicloud_data_transfer_supported_service", this.multicloudDataTransferSupportedService});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MulticloudDataTransferSupportedServiceName that = (MulticloudDataTransferSupportedServiceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.multicloudDataTransferSupportedService, that.multicloudDataTransferSupportedService);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.multicloudDataTransferSupportedService);
    }

    public static class Builder {
        private String project;
        private String location;
        private String multicloudDataTransferSupportedService;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getMulticloudDataTransferSupportedService() {
            return this.multicloudDataTransferSupportedService;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setMulticloudDataTransferSupportedService(String multicloudDataTransferSupportedService) {
            this.multicloudDataTransferSupportedService = multicloudDataTransferSupportedService;
            return this;
        }

        private Builder(MulticloudDataTransferSupportedServiceName multicloudDataTransferSupportedServiceName) {
            this.project = multicloudDataTransferSupportedServiceName.project;
            this.location = multicloudDataTransferSupportedServiceName.location;
            this.multicloudDataTransferSupportedService = multicloudDataTransferSupportedServiceName.multicloudDataTransferSupportedService;
        }

        public MulticloudDataTransferSupportedServiceName build() {
            return new MulticloudDataTransferSupportedServiceName(this);
        }
    }
}

