/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DestinationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_MULTICLOUD_DATA_TRANSFER_CONFIG_DESTINATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/multicloudDataTransferConfigs/{multicloud_data_transfer_config}/destinations/{destination}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String multicloudDataTransferConfig;
    private final String destination;

    @Deprecated
    protected DestinationName() {
        this.project = null;
        this.location = null;
        this.multicloudDataTransferConfig = null;
        this.destination = null;
    }

    private DestinationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.multicloudDataTransferConfig = (String)Preconditions.checkNotNull((Object)builder.getMulticloudDataTransferConfig());
        this.destination = (String)Preconditions.checkNotNull((Object)builder.getDestination());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMulticloudDataTransferConfig() {
        return this.multicloudDataTransferConfig;
    }

    public String getDestination() {
        return this.destination;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DestinationName of(String project, String location, String multicloudDataTransferConfig, String destination) {
        return DestinationName.newBuilder().setProject(project).setLocation(location).setMulticloudDataTransferConfig(multicloudDataTransferConfig).setDestination(destination).build();
    }

    public static String format(String project, String location, String multicloudDataTransferConfig, String destination) {
        return DestinationName.newBuilder().setProject(project).setLocation(location).setMulticloudDataTransferConfig(multicloudDataTransferConfig).setDestination(destination).build().toString();
    }

    public static DestinationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_MULTICLOUD_DATA_TRANSFER_CONFIG_DESTINATION.validatedMatch(formattedString, "DestinationName.parse: formattedString not in valid format");
        return DestinationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("multicloud_data_transfer_config"), (String)matchMap.get("destination"));
    }

    public static List<DestinationName> parseList(List<String> formattedStrings) {
        ArrayList<DestinationName> list = new ArrayList<DestinationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DestinationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DestinationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DestinationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_MULTICLOUD_DATA_TRANSFER_CONFIG_DESTINATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DestinationName destinationName = this;
            synchronized (destinationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.multicloudDataTransferConfig != null) {
                        fieldMapBuilder.put((Object)"multicloud_data_transfer_config", (Object)this.multicloudDataTransferConfig);
                    }
                    if (this.destination != null) {
                        fieldMapBuilder.put((Object)"destination", (Object)this.destination);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_MULTICLOUD_DATA_TRANSFER_CONFIG_DESTINATION.instantiate(new String[]{"project", this.project, "location", this.location, "multicloud_data_transfer_config", this.multicloudDataTransferConfig, "destination", this.destination});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DestinationName that = (DestinationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.multicloudDataTransferConfig, that.multicloudDataTransferConfig) && Objects.equals(this.destination, that.destination);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.multicloudDataTransferConfig);
        h *= 1000003;
        return h ^= Objects.hashCode(this.destination);
    }

    public static class Builder {
        private String project;
        private String location;
        private String multicloudDataTransferConfig;
        private String destination;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getMulticloudDataTransferConfig() {
            return this.multicloudDataTransferConfig;
        }

        public String getDestination() {
            return this.destination;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setMulticloudDataTransferConfig(String multicloudDataTransferConfig) {
            this.multicloudDataTransferConfig = multicloudDataTransferConfig;
            return this;
        }

        public Builder setDestination(String destination) {
            this.destination = destination;
            return this;
        }

        private Builder(DestinationName destinationName) {
            this.project = destinationName.project;
            this.location = destinationName.location;
            this.multicloudDataTransferConfig = destinationName.multicloudDataTransferConfig;
            this.destination = destinationName.destination;
        }

        public DestinationName build() {
            return new DestinationName(this);
        }
    }
}

