/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RouteTableName
implements ResourceName {
    private static final PathTemplate PROJECT_HUB_ROUTE_TABLE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/global/hubs/{hub}/routeTables/{route_table}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String hub;
    private final String routeTable;

    @Deprecated
    protected RouteTableName() {
        this.project = null;
        this.hub = null;
        this.routeTable = null;
    }

    private RouteTableName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.hub = (String)Preconditions.checkNotNull((Object)builder.getHub());
        this.routeTable = (String)Preconditions.checkNotNull((Object)builder.getRouteTable());
    }

    public String getProject() {
        return this.project;
    }

    public String getHub() {
        return this.hub;
    }

    public String getRouteTable() {
        return this.routeTable;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RouteTableName of(String project, String hub, String routeTable) {
        return RouteTableName.newBuilder().setProject(project).setHub(hub).setRouteTable(routeTable).build();
    }

    public static String format(String project, String hub, String routeTable) {
        return RouteTableName.newBuilder().setProject(project).setHub(hub).setRouteTable(routeTable).build().toString();
    }

    public static RouteTableName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_HUB_ROUTE_TABLE.validatedMatch(formattedString, "RouteTableName.parse: formattedString not in valid format");
        return RouteTableName.of((String)matchMap.get("project"), (String)matchMap.get("hub"), (String)matchMap.get("route_table"));
    }

    public static List<RouteTableName> parseList(List<String> formattedStrings) {
        ArrayList<RouteTableName> list = new ArrayList<RouteTableName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RouteTableName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RouteTableName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RouteTableName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_HUB_ROUTE_TABLE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RouteTableName routeTableName = this;
            synchronized (routeTableName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.hub != null) {
                        fieldMapBuilder.put((Object)"hub", (Object)this.hub);
                    }
                    if (this.routeTable != null) {
                        fieldMapBuilder.put((Object)"route_table", (Object)this.routeTable);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_HUB_ROUTE_TABLE.instantiate(new String[]{"project", this.project, "hub", this.hub, "route_table", this.routeTable});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RouteTableName that = (RouteTableName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.hub, that.hub) && Objects.equals(this.routeTable, that.routeTable);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.hub);
        h *= 1000003;
        return h ^= Objects.hashCode(this.routeTable);
    }

    public static class Builder {
        private String project;
        private String hub;
        private String routeTable;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getHub() {
            return this.hub;
        }

        public String getRouteTable() {
            return this.routeTable;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setHub(String hub) {
            this.hub = hub;
            return this;
        }

        public Builder setRouteTable(String routeTable) {
            this.routeTable = routeTable;
            return this;
        }

        private Builder(RouteTableName routeTableName) {
            this.project = routeTableName.project;
            this.hub = routeTableName.hub;
            this.routeTable = routeTableName.routeTable;
        }

        public RouteTableName build() {
            return new RouteTableName(this);
        }
    }
}

