/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networksecurity.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DnsThreatDetectorName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DNS_THREAT_DETECTOR = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dnsThreatDetectors/{dns_threat_detector}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dnsThreatDetector;

    @Deprecated
    protected DnsThreatDetectorName() {
        this.project = null;
        this.location = null;
        this.dnsThreatDetector = null;
    }

    private DnsThreatDetectorName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dnsThreatDetector = (String)Preconditions.checkNotNull((Object)builder.getDnsThreatDetector());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDnsThreatDetector() {
        return this.dnsThreatDetector;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DnsThreatDetectorName of(String project, String location, String dnsThreatDetector) {
        return DnsThreatDetectorName.newBuilder().setProject(project).setLocation(location).setDnsThreatDetector(dnsThreatDetector).build();
    }

    public static String format(String project, String location, String dnsThreatDetector) {
        return DnsThreatDetectorName.newBuilder().setProject(project).setLocation(location).setDnsThreatDetector(dnsThreatDetector).build().toString();
    }

    public static DnsThreatDetectorName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DNS_THREAT_DETECTOR.validatedMatch(formattedString, "DnsThreatDetectorName.parse: formattedString not in valid format");
        return DnsThreatDetectorName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("dns_threat_detector"));
    }

    public static List<DnsThreatDetectorName> parseList(List<String> formattedStrings) {
        ArrayList<DnsThreatDetectorName> list = new ArrayList<DnsThreatDetectorName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DnsThreatDetectorName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DnsThreatDetectorName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DnsThreatDetectorName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DNS_THREAT_DETECTOR.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DnsThreatDetectorName dnsThreatDetectorName = this;
            synchronized (dnsThreatDetectorName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dnsThreatDetector != null) {
                        fieldMapBuilder.put((Object)"dns_threat_detector", (Object)this.dnsThreatDetector);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DNS_THREAT_DETECTOR.instantiate(new String[]{"project", this.project, "location", this.location, "dns_threat_detector", this.dnsThreatDetector});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DnsThreatDetectorName that = (DnsThreatDetectorName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dnsThreatDetector, that.dnsThreatDetector);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dnsThreatDetector);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dnsThreatDetector;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDnsThreatDetector() {
            return this.dnsThreatDetector;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDnsThreatDetector(String dnsThreatDetector) {
            this.dnsThreatDetector = dnsThreatDetector;
            return this;
        }

        private Builder(DnsThreatDetectorName dnsThreatDetectorName) {
            this.project = dnsThreatDetectorName.project;
            this.location = dnsThreatDetectorName.location;
            this.dnsThreatDetector = dnsThreatDetectorName.dnsThreatDetector;
        }

        public DnsThreatDetectorName build() {
            return new DnsThreatDetectorName(this);
        }
    }
}

