/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networksecurity.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AddressGroupName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ADDRESS_GROUP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/addressGroups/{address_group}");
    private static final PathTemplate ORGANIZATION_LOCATION_ADDRESS_GROUP = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/addressGroups/{address_group}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String addressGroup;
    private final String organization;

    @Deprecated
    protected AddressGroupName() {
        this.project = null;
        this.location = null;
        this.addressGroup = null;
        this.organization = null;
    }

    private AddressGroupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.addressGroup = (String)Preconditions.checkNotNull((Object)builder.getAddressGroup());
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_ADDRESS_GROUP;
    }

    private AddressGroupName(OrganizationLocationAddressGroupBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.addressGroup = (String)Preconditions.checkNotNull((Object)builder.getAddressGroup());
        this.project = null;
        this.pathTemplate = ORGANIZATION_LOCATION_ADDRESS_GROUP;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAddressGroup() {
        return this.addressGroup;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationAddressGroupBuilder() {
        return new Builder();
    }

    public static OrganizationLocationAddressGroupBuilder newOrganizationLocationAddressGroupBuilder() {
        return new OrganizationLocationAddressGroupBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AddressGroupName of(String project, String location, String addressGroup) {
        return AddressGroupName.newBuilder().setProject(project).setLocation(location).setAddressGroup(addressGroup).build();
    }

    public static AddressGroupName ofProjectLocationAddressGroupName(String project, String location, String addressGroup) {
        return AddressGroupName.newBuilder().setProject(project).setLocation(location).setAddressGroup(addressGroup).build();
    }

    public static AddressGroupName ofOrganizationLocationAddressGroupName(String organization, String location, String addressGroup) {
        return AddressGroupName.newOrganizationLocationAddressGroupBuilder().setOrganization(organization).setLocation(location).setAddressGroup(addressGroup).build();
    }

    public static String format(String project, String location, String addressGroup) {
        return AddressGroupName.newBuilder().setProject(project).setLocation(location).setAddressGroup(addressGroup).build().toString();
    }

    public static String formatProjectLocationAddressGroupName(String project, String location, String addressGroup) {
        return AddressGroupName.newBuilder().setProject(project).setLocation(location).setAddressGroup(addressGroup).build().toString();
    }

    public static String formatOrganizationLocationAddressGroupName(String organization, String location, String addressGroup) {
        return AddressGroupName.newOrganizationLocationAddressGroupBuilder().setOrganization(organization).setLocation(location).setAddressGroup(addressGroup).build().toString();
    }

    public static AddressGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_ADDRESS_GROUP.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_ADDRESS_GROUP.match(formattedString);
            return AddressGroupName.ofProjectLocationAddressGroupName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("address_group"));
        }
        if (ORGANIZATION_LOCATION_ADDRESS_GROUP.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_ADDRESS_GROUP.match(formattedString);
            return AddressGroupName.ofOrganizationLocationAddressGroupName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("address_group"));
        }
        throw new ValidationException("AddressGroupName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<AddressGroupName> parseList(List<String> formattedStrings) {
        ArrayList<AddressGroupName> list = new ArrayList<AddressGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AddressGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AddressGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AddressGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ADDRESS_GROUP.matches(formattedString) || ORGANIZATION_LOCATION_ADDRESS_GROUP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AddressGroupName addressGroupName = this;
            synchronized (addressGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.addressGroup != null) {
                        fieldMapBuilder.put((Object)"address_group", (Object)this.addressGroup);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AddressGroupName that = (AddressGroupName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.addressGroup, that.addressGroup) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.addressGroup);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    public static class OrganizationLocationAddressGroupBuilder {
        private String organization;
        private String location;
        private String addressGroup;

        protected OrganizationLocationAddressGroupBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAddressGroup() {
            return this.addressGroup;
        }

        public OrganizationLocationAddressGroupBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationAddressGroupBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationAddressGroupBuilder setAddressGroup(String addressGroup) {
            this.addressGroup = addressGroup;
            return this;
        }

        public AddressGroupName build() {
            return new AddressGroupName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String addressGroup;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAddressGroup() {
            return this.addressGroup;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAddressGroup(String addressGroup) {
            this.addressGroup = addressGroup;
            return this;
        }

        private Builder(AddressGroupName addressGroupName) {
            Preconditions.checkArgument((boolean)Objects.equals(addressGroupName.pathTemplate, PROJECT_LOCATION_ADDRESS_GROUP), (Object)"toBuilder is only supported when AddressGroupName has the pattern of projects/{project}/locations/{location}/addressGroups/{address_group}");
            this.project = addressGroupName.project;
            this.location = addressGroupName.location;
            this.addressGroup = addressGroupName.addressGroup;
        }

        public AddressGroupName build() {
            return new AddressGroupName(this);
        }
    }
}

