/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.netapp.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QuotaRuleName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_VOLUME_QUOTA_RULE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/volumes/{volume}/quotaRules/{quota_rule}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String volume;
    private final String quotaRule;

    @Deprecated
    protected QuotaRuleName() {
        this.project = null;
        this.location = null;
        this.volume = null;
        this.quotaRule = null;
    }

    private QuotaRuleName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.volume = (String)Preconditions.checkNotNull((Object)builder.getVolume());
        this.quotaRule = (String)Preconditions.checkNotNull((Object)builder.getQuotaRule());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getVolume() {
        return this.volume;
    }

    public String getQuotaRule() {
        return this.quotaRule;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static QuotaRuleName of(String project, String location, String volume, String quotaRule) {
        return QuotaRuleName.newBuilder().setProject(project).setLocation(location).setVolume(volume).setQuotaRule(quotaRule).build();
    }

    public static String format(String project, String location, String volume, String quotaRule) {
        return QuotaRuleName.newBuilder().setProject(project).setLocation(location).setVolume(volume).setQuotaRule(quotaRule).build().toString();
    }

    public static QuotaRuleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_VOLUME_QUOTA_RULE.validatedMatch(formattedString, "QuotaRuleName.parse: formattedString not in valid format");
        return QuotaRuleName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("volume"), (String)matchMap.get("quota_rule"));
    }

    public static List<QuotaRuleName> parseList(List<String> formattedStrings) {
        ArrayList<QuotaRuleName> list = new ArrayList<QuotaRuleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(QuotaRuleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<QuotaRuleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (QuotaRuleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_VOLUME_QUOTA_RULE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            QuotaRuleName quotaRuleName = this;
            synchronized (quotaRuleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.volume != null) {
                        fieldMapBuilder.put((Object)"volume", (Object)this.volume);
                    }
                    if (this.quotaRule != null) {
                        fieldMapBuilder.put((Object)"quota_rule", (Object)this.quotaRule);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_VOLUME_QUOTA_RULE.instantiate(new String[]{"project", this.project, "location", this.location, "volume", this.volume, "quota_rule", this.quotaRule});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            QuotaRuleName that = (QuotaRuleName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.volume, that.volume) && Objects.equals(this.quotaRule, that.quotaRule);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.volume);
        h *= 1000003;
        return h ^= Objects.hashCode(this.quotaRule);
    }

    public static class Builder {
        private String project;
        private String location;
        private String volume;
        private String quotaRule;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getVolume() {
            return this.volume;
        }

        public String getQuotaRule() {
            return this.quotaRule;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setVolume(String volume) {
            this.volume = volume;
            return this;
        }

        public Builder setQuotaRule(String quotaRule) {
            this.quotaRule = quotaRule;
            return this;
        }

        private Builder(QuotaRuleName quotaRuleName) {
            this.project = quotaRuleName.project;
            this.location = quotaRuleName.location;
            this.volume = quotaRuleName.volume;
            this.quotaRule = quotaRuleName.quotaRule;
        }

        public QuotaRuleName build() {
            return new QuotaRuleName(this);
        }
    }
}

