/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.netapp.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BackupPolicyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_BACKUP_POLICY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/backupPolicies/{backup_policy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String backupPolicy;

    @Deprecated
    protected BackupPolicyName() {
        this.project = null;
        this.location = null;
        this.backupPolicy = null;
    }

    private BackupPolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.backupPolicy = (String)Preconditions.checkNotNull((Object)builder.getBackupPolicy());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getBackupPolicy() {
        return this.backupPolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BackupPolicyName of(String project, String location, String backupPolicy) {
        return BackupPolicyName.newBuilder().setProject(project).setLocation(location).setBackupPolicy(backupPolicy).build();
    }

    public static String format(String project, String location, String backupPolicy) {
        return BackupPolicyName.newBuilder().setProject(project).setLocation(location).setBackupPolicy(backupPolicy).build().toString();
    }

    public static BackupPolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_BACKUP_POLICY.validatedMatch(formattedString, "BackupPolicyName.parse: formattedString not in valid format");
        return BackupPolicyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("backup_policy"));
    }

    public static List<BackupPolicyName> parseList(List<String> formattedStrings) {
        ArrayList<BackupPolicyName> list = new ArrayList<BackupPolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BackupPolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BackupPolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BackupPolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_BACKUP_POLICY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BackupPolicyName backupPolicyName = this;
            synchronized (backupPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.backupPolicy != null) {
                        fieldMapBuilder.put((Object)"backup_policy", (Object)this.backupPolicy);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_BACKUP_POLICY.instantiate(new String[]{"project", this.project, "location", this.location, "backup_policy", this.backupPolicy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BackupPolicyName that = (BackupPolicyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.backupPolicy, that.backupPolicy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.backupPolicy);
    }

    public static class Builder {
        private String project;
        private String location;
        private String backupPolicy;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBackupPolicy() {
            return this.backupPolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setBackupPolicy(String backupPolicy) {
            this.backupPolicy = backupPolicy;
            return this;
        }

        private Builder(BackupPolicyName backupPolicyName) {
            this.project = backupPolicyName.project;
            this.location = backupPolicyName.location;
            this.backupPolicy = backupPolicyName.backupPolicy;
        }

        public BackupPolicyName build() {
            return new BackupPolicyName(this);
        }
    }
}

