/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.netapp.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BackupVaultName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_BACKUP_VAULT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/backupVaults/{backup_vault}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String backupVault;

    @Deprecated
    protected BackupVaultName() {
        this.project = null;
        this.location = null;
        this.backupVault = null;
    }

    private BackupVaultName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.backupVault = (String)Preconditions.checkNotNull((Object)builder.getBackupVault());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getBackupVault() {
        return this.backupVault;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BackupVaultName of(String project, String location, String backupVault) {
        return BackupVaultName.newBuilder().setProject(project).setLocation(location).setBackupVault(backupVault).build();
    }

    public static String format(String project, String location, String backupVault) {
        return BackupVaultName.newBuilder().setProject(project).setLocation(location).setBackupVault(backupVault).build().toString();
    }

    public static BackupVaultName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_BACKUP_VAULT.validatedMatch(formattedString, "BackupVaultName.parse: formattedString not in valid format");
        return BackupVaultName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("backup_vault"));
    }

    public static List<BackupVaultName> parseList(List<String> formattedStrings) {
        ArrayList<BackupVaultName> list = new ArrayList<BackupVaultName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BackupVaultName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BackupVaultName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BackupVaultName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_BACKUP_VAULT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BackupVaultName backupVaultName = this;
            synchronized (backupVaultName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.backupVault != null) {
                        fieldMapBuilder.put((Object)"backup_vault", (Object)this.backupVault);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_BACKUP_VAULT.instantiate(new String[]{"project", this.project, "location", this.location, "backup_vault", this.backupVault});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BackupVaultName that = (BackupVaultName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.backupVault, that.backupVault);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.backupVault);
    }

    public static class Builder {
        private String project;
        private String location;
        private String backupVault;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBackupVault() {
            return this.backupVault;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setBackupVault(String backupVault) {
            this.backupVault = backupVault;
            return this;
        }

        private Builder(BackupVaultName backupVaultName) {
            this.project = backupVaultName.project;
            this.location = backupVaultName.location;
            this.backupVault = backupVaultName.backupVault;
        }

        public BackupVaultName build() {
            return new BackupVaultName(this);
        }
    }
}

