/*
 * Decompiled with CFR 0.152.
 */
package com.google.apps.meet.v2beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ParticipantSessionName
implements ResourceName {
    private static final PathTemplate CONFERENCE_RECORD_PARTICIPANT_PARTICIPANT_SESSION = PathTemplate.createWithoutUrlEncoding((String)"conferenceRecords/{conference_record}/participants/{participant}/participantSessions/{participant_session}");
    private volatile Map<String, String> fieldValuesMap;
    private final String conferenceRecord;
    private final String participant;
    private final String participantSession;

    @Deprecated
    protected ParticipantSessionName() {
        this.conferenceRecord = null;
        this.participant = null;
        this.participantSession = null;
    }

    private ParticipantSessionName(Builder builder) {
        this.conferenceRecord = (String)Preconditions.checkNotNull((Object)builder.getConferenceRecord());
        this.participant = (String)Preconditions.checkNotNull((Object)builder.getParticipant());
        this.participantSession = (String)Preconditions.checkNotNull((Object)builder.getParticipantSession());
    }

    public String getConferenceRecord() {
        return this.conferenceRecord;
    }

    public String getParticipant() {
        return this.participant;
    }

    public String getParticipantSession() {
        return this.participantSession;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ParticipantSessionName of(String conferenceRecord, String participant, String participantSession) {
        return ParticipantSessionName.newBuilder().setConferenceRecord(conferenceRecord).setParticipant(participant).setParticipantSession(participantSession).build();
    }

    public static String format(String conferenceRecord, String participant, String participantSession) {
        return ParticipantSessionName.newBuilder().setConferenceRecord(conferenceRecord).setParticipant(participant).setParticipantSession(participantSession).build().toString();
    }

    public static ParticipantSessionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CONFERENCE_RECORD_PARTICIPANT_PARTICIPANT_SESSION.validatedMatch(formattedString, "ParticipantSessionName.parse: formattedString not in valid format");
        return ParticipantSessionName.of((String)matchMap.get("conference_record"), (String)matchMap.get("participant"), (String)matchMap.get("participant_session"));
    }

    public static List<ParticipantSessionName> parseList(List<String> formattedStrings) {
        ArrayList<ParticipantSessionName> list = new ArrayList<ParticipantSessionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ParticipantSessionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ParticipantSessionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ParticipantSessionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CONFERENCE_RECORD_PARTICIPANT_PARTICIPANT_SESSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ParticipantSessionName participantSessionName = this;
            synchronized (participantSessionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.conferenceRecord != null) {
                        fieldMapBuilder.put((Object)"conference_record", (Object)this.conferenceRecord);
                    }
                    if (this.participant != null) {
                        fieldMapBuilder.put((Object)"participant", (Object)this.participant);
                    }
                    if (this.participantSession != null) {
                        fieldMapBuilder.put((Object)"participant_session", (Object)this.participantSession);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CONFERENCE_RECORD_PARTICIPANT_PARTICIPANT_SESSION.instantiate(new String[]{"conference_record", this.conferenceRecord, "participant", this.participant, "participant_session", this.participantSession});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ParticipantSessionName that = (ParticipantSessionName)o;
            return Objects.equals(this.conferenceRecord, that.conferenceRecord) && Objects.equals(this.participant, that.participant) && Objects.equals(this.participantSession, that.participantSession);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.conferenceRecord);
        h *= 1000003;
        h ^= Objects.hashCode(this.participant);
        h *= 1000003;
        return h ^= Objects.hashCode(this.participantSession);
    }

    public static class Builder {
        private String conferenceRecord;
        private String participant;
        private String participantSession;

        protected Builder() {
        }

        public String getConferenceRecord() {
            return this.conferenceRecord;
        }

        public String getParticipant() {
            return this.participant;
        }

        public String getParticipantSession() {
            return this.participantSession;
        }

        public Builder setConferenceRecord(String conferenceRecord) {
            this.conferenceRecord = conferenceRecord;
            return this;
        }

        public Builder setParticipant(String participant) {
            this.participant = participant;
            return this;
        }

        public Builder setParticipantSession(String participantSession) {
            this.participantSession = participantSession;
            return this;
        }

        private Builder(ParticipantSessionName participantSessionName) {
            this.conferenceRecord = participantSessionName.conferenceRecord;
            this.participant = participantSessionName.participant;
            this.participantSession = participantSessionName.participantSession;
        }

        public ParticipantSessionName build() {
            return new ParticipantSessionName(this);
        }
    }
}

