/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CmekSettingsName
implements ResourceName {
    private static final PathTemplate PROJECT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/cmekSettings");
    private static final PathTemplate ORGANIZATION = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/cmekSettings");
    private static final PathTemplate FOLDER = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/cmekSettings");
    private static final PathTemplate BILLING_ACCOUNT = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}/cmekSettings");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String organization;
    private final String folder;
    private final String billingAccount;

    @Deprecated
    protected CmekSettingsName() {
        this.project = null;
        this.organization = null;
        this.folder = null;
        this.billingAccount = null;
    }

    private CmekSettingsName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.organization = null;
        this.folder = null;
        this.billingAccount = null;
        this.pathTemplate = PROJECT;
    }

    private CmekSettingsName(OrganizationCmekSettingsBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.project = null;
        this.folder = null;
        this.billingAccount = null;
        this.pathTemplate = ORGANIZATION;
    }

    private CmekSettingsName(FolderCmekSettingsBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.project = null;
        this.organization = null;
        this.billingAccount = null;
        this.pathTemplate = FOLDER;
    }

    private CmekSettingsName(BillingAccountCmekSettingsBuilder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
        this.project = null;
        this.organization = null;
        this.folder = null;
        this.pathTemplate = BILLING_ACCOUNT;
    }

    public String getProject() {
        return this.project;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectBuilder() {
        return new Builder();
    }

    @Deprecated
    public static Builder newProjectCmekSettingsBuilder() {
        return new Builder();
    }

    public static OrganizationCmekSettingsBuilder newOrganizationCmekSettingsBuilder() {
        return new OrganizationCmekSettingsBuilder();
    }

    public static FolderCmekSettingsBuilder newFolderCmekSettingsBuilder() {
        return new FolderCmekSettingsBuilder();
    }

    public static BillingAccountCmekSettingsBuilder newBillingAccountCmekSettingsBuilder() {
        return new BillingAccountCmekSettingsBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CmekSettingsName of(String project) {
        return CmekSettingsName.newBuilder().setProject(project).build();
    }

    public static CmekSettingsName ofProjectName(String project) {
        return CmekSettingsName.newBuilder().setProject(project).build();
    }

    @Deprecated
    public static CmekSettingsName ofProjectCmekSettingsName(String project) {
        return CmekSettingsName.newBuilder().setProject(project).build();
    }

    public static CmekSettingsName ofOrganizationName(String organization) {
        return CmekSettingsName.newOrganizationCmekSettingsBuilder().setOrganization(organization).build();
    }

    @Deprecated
    public static CmekSettingsName ofOrganizationCmekSettingsName(String organization) {
        return CmekSettingsName.newOrganizationCmekSettingsBuilder().setOrganization(organization).build();
    }

    public static CmekSettingsName ofFolderName(String folder) {
        return CmekSettingsName.newFolderCmekSettingsBuilder().setFolder(folder).build();
    }

    @Deprecated
    public static CmekSettingsName ofFolderCmekSettingsName(String folder) {
        return CmekSettingsName.newFolderCmekSettingsBuilder().setFolder(folder).build();
    }

    public static CmekSettingsName ofBillingAccountName(String billingAccount) {
        return CmekSettingsName.newBillingAccountCmekSettingsBuilder().setBillingAccount(billingAccount).build();
    }

    @Deprecated
    public static CmekSettingsName ofBillingAccountCmekSettingsName(String billingAccount) {
        return CmekSettingsName.newBillingAccountCmekSettingsBuilder().setBillingAccount(billingAccount).build();
    }

    public static String format(String project) {
        return CmekSettingsName.newBuilder().setProject(project).build().toString();
    }

    public static String formatProjectName(String project) {
        return CmekSettingsName.newBuilder().setProject(project).build().toString();
    }

    @Deprecated
    public static String formatProjectCmekSettingsName(String project) {
        return CmekSettingsName.newBuilder().setProject(project).build().toString();
    }

    public static String formatOrganizationName(String organization) {
        return CmekSettingsName.newOrganizationCmekSettingsBuilder().setOrganization(organization).build().toString();
    }

    @Deprecated
    public static String formatOrganizationCmekSettingsName(String organization) {
        return CmekSettingsName.newOrganizationCmekSettingsBuilder().setOrganization(organization).build().toString();
    }

    public static String formatFolderName(String folder) {
        return CmekSettingsName.newFolderCmekSettingsBuilder().setFolder(folder).build().toString();
    }

    @Deprecated
    public static String formatFolderCmekSettingsName(String folder) {
        return CmekSettingsName.newFolderCmekSettingsBuilder().setFolder(folder).build().toString();
    }

    public static String formatBillingAccountName(String billingAccount) {
        return CmekSettingsName.newBillingAccountCmekSettingsBuilder().setBillingAccount(billingAccount).build().toString();
    }

    @Deprecated
    public static String formatBillingAccountCmekSettingsName(String billingAccount) {
        return CmekSettingsName.newBillingAccountCmekSettingsBuilder().setBillingAccount(billingAccount).build().toString();
    }

    public static CmekSettingsName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT.matches(formattedString)) {
            Map matchMap = PROJECT.match(formattedString);
            return CmekSettingsName.ofProjectCmekSettingsName((String)matchMap.get("project"));
        }
        if (ORGANIZATION.matches(formattedString)) {
            Map matchMap = ORGANIZATION.match(formattedString);
            return CmekSettingsName.ofOrganizationCmekSettingsName((String)matchMap.get("organization"));
        }
        if (FOLDER.matches(formattedString)) {
            Map matchMap = FOLDER.match(formattedString);
            return CmekSettingsName.ofFolderCmekSettingsName((String)matchMap.get("folder"));
        }
        if (BILLING_ACCOUNT.matches(formattedString)) {
            Map matchMap = BILLING_ACCOUNT.match(formattedString);
            return CmekSettingsName.ofBillingAccountCmekSettingsName((String)matchMap.get("billing_account"));
        }
        throw new ValidationException("CmekSettingsName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<CmekSettingsName> parseList(List<String> formattedStrings) {
        ArrayList<CmekSettingsName> list = new ArrayList<CmekSettingsName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CmekSettingsName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CmekSettingsName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CmekSettingsName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT.matches(formattedString) || ORGANIZATION.matches(formattedString) || FOLDER.matches(formattedString) || BILLING_ACCOUNT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CmekSettingsName cmekSettingsName = this;
            synchronized (cmekSettingsName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put((Object)"billing_account", (Object)this.billingAccount);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CmekSettingsName that = (CmekSettingsName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder) && Objects.equals(this.billingAccount, that.billingAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.billingAccount);
    }

    public static class BillingAccountCmekSettingsBuilder {
        private String billingAccount;

        protected BillingAccountCmekSettingsBuilder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public BillingAccountCmekSettingsBuilder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public CmekSettingsName build() {
            return new CmekSettingsName(this);
        }
    }

    public static class FolderCmekSettingsBuilder {
        private String folder;

        protected FolderCmekSettingsBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public FolderCmekSettingsBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public CmekSettingsName build() {
            return new CmekSettingsName(this);
        }
    }

    public static class OrganizationCmekSettingsBuilder {
        private String organization;

        protected OrganizationCmekSettingsBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public OrganizationCmekSettingsBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public CmekSettingsName build() {
            return new CmekSettingsName(this);
        }
    }

    public static class Builder {
        private String project;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder(CmekSettingsName cmekSettingsName) {
            Preconditions.checkArgument((boolean)Objects.equals(cmekSettingsName.pathTemplate, PROJECT), (Object)"toBuilder is only supported when CmekSettingsName has the pattern of projects/{project}/cmekSettings");
            this.project = cmekSettingsName.project;
        }

        public CmekSettingsName build() {
            return new CmekSettingsName(this);
        }
    }
}

