/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ImportJobName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/keyRings/{key_ring}/importJobs/{import_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String keyRing;
    private final String importJob;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getKeyRing() {
        return this.keyRing;
    }

    public String getImportJob() {
        return this.importJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ImportJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.keyRing = (String)Preconditions.checkNotNull((Object)builder.getKeyRing());
        this.importJob = (String)Preconditions.checkNotNull((Object)builder.getImportJob());
    }

    public static ImportJobName of(String project, String location, String keyRing, String importJob) {
        return ImportJobName.newBuilder().setProject(project).setLocation(location).setKeyRing(keyRing).setImportJob(importJob).build();
    }

    public static String format(String project, String location, String keyRing, String importJob) {
        return ImportJobName.newBuilder().setProject(project).setLocation(location).setKeyRing(keyRing).setImportJob(importJob).build().toString();
    }

    public static ImportJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ImportJobName.parse: formattedString not in valid format");
        return ImportJobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("key_ring"), (String)matchMap.get("import_job"));
    }

    public static List<ImportJobName> parseList(List<String> formattedStrings) {
        ArrayList<ImportJobName> list = new ArrayList<ImportJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ImportJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ImportJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ImportJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ImportJobName importJobName = this;
            synchronized (importJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"keyRing", (Object)this.keyRing);
                    fieldMapBuilder.put((Object)"importJob", (Object)this.importJob);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "key_ring", this.keyRing, "import_job", this.importJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImportJobName) {
            ImportJobName that = (ImportJobName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.keyRing.equals(that.keyRing) && this.importJob.equals(that.importJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.keyRing.hashCode();
        h *= 1000003;
        return h ^= this.importJob.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String keyRing;
        private String importJob;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getKeyRing() {
            return this.keyRing;
        }

        public String getImportJob() {
            return this.importJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setKeyRing(String keyRing) {
            this.keyRing = keyRing;
            return this;
        }

        public Builder setImportJob(String importJob) {
            this.importJob = importJob;
            return this;
        }

        private Builder() {
        }

        private Builder(ImportJobName importJobName) {
            this.project = importJobName.project;
            this.location = importJobName.location;
            this.keyRing = importJobName.keyRing;
            this.importJob = importJobName.importJob;
        }

        public ImportJobName build() {
            return new ImportJobName(this);
        }
    }
}

