/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkemulticloud.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AttachedClusterName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ATTACHED_CLUSTER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/attachedClusters/{attached_cluster}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String attachedCluster;

    @Deprecated
    protected AttachedClusterName() {
        this.project = null;
        this.location = null;
        this.attachedCluster = null;
    }

    private AttachedClusterName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.attachedCluster = (String)Preconditions.checkNotNull((Object)builder.getAttachedCluster());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAttachedCluster() {
        return this.attachedCluster;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AttachedClusterName of(String project, String location, String attachedCluster) {
        return AttachedClusterName.newBuilder().setProject(project).setLocation(location).setAttachedCluster(attachedCluster).build();
    }

    public static String format(String project, String location, String attachedCluster) {
        return AttachedClusterName.newBuilder().setProject(project).setLocation(location).setAttachedCluster(attachedCluster).build().toString();
    }

    public static AttachedClusterName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ATTACHED_CLUSTER.validatedMatch(formattedString, "AttachedClusterName.parse: formattedString not in valid format");
        return AttachedClusterName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("attached_cluster"));
    }

    public static List<AttachedClusterName> parseList(List<String> formattedStrings) {
        ArrayList<AttachedClusterName> list = new ArrayList<AttachedClusterName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AttachedClusterName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AttachedClusterName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AttachedClusterName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ATTACHED_CLUSTER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AttachedClusterName attachedClusterName = this;
            synchronized (attachedClusterName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.attachedCluster != null) {
                        fieldMapBuilder.put((Object)"attached_cluster", (Object)this.attachedCluster);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ATTACHED_CLUSTER.instantiate(new String[]{"project", this.project, "location", this.location, "attached_cluster", this.attachedCluster});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AttachedClusterName that = (AttachedClusterName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.attachedCluster, that.attachedCluster);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.attachedCluster);
    }

    public static class Builder {
        private String project;
        private String location;
        private String attachedCluster;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAttachedCluster() {
            return this.attachedCluster;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAttachedCluster(String attachedCluster) {
            this.attachedCluster = attachedCluster;
            return this;
        }

        private Builder(AttachedClusterName attachedClusterName) {
            this.project = attachedClusterName.project;
            this.location = attachedClusterName.location;
            this.attachedCluster = attachedClusterName.attachedCluster;
        }

        public AttachedClusterName build() {
            return new AttachedClusterName(this);
        }
    }
}

