/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/admin/v1/operation.proto

// Protobuf Java Version: 3.25.8
package com.google.firestore.admin.v1;

/**
 *
 *
 * <pre>
 * Metadata for [google.longrunning.Operation][google.longrunning.Operation]
 * results from
 * [FirestoreAdmin.CreateIndex][google.firestore.admin.v1.FirestoreAdmin.CreateIndex].
 * </pre>
 *
 * Protobuf type {@code google.firestore.admin.v1.IndexOperationMetadata}
 */
public final class IndexOperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.IndexOperationMetadata)
    IndexOperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use IndexOperationMetadata.newBuilder() to construct.
  private IndexOperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IndexOperationMetadata() {
    index_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IndexOperationMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.admin.v1.OperationProto
        .internal_static_google_firestore_admin_v1_IndexOperationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.admin.v1.OperationProto
        .internal_static_google_firestore_admin_v1_IndexOperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.admin.v1.IndexOperationMetadata.class,
            com.google.firestore.admin.v1.IndexOperationMetadata.Builder.class);
  }

  private int bitField0_;
  public static final int START_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp startTime_;

  /**
   *
   *
   * <pre>
   * The time this operation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The time this operation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  /**
   *
   *
   * <pre>
   * The time this operation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp endTime_;

  /**
   *
   *
   * <pre>
   * The time this operation completed. Will be unset if operation still in
   * progress.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The time this operation completed. Will be unset if operation still in
   * progress.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  /**
   *
   *
   * <pre>
   * The time this operation completed. Will be unset if operation still in
   * progress.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int INDEX_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object index_ = "";

  /**
   *
   *
   * <pre>
   * The index resource that this operation is acting on. For example:
   * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{index_id}`
   * </pre>
   *
   * <code>string index = 3;</code>
   *
   * @return The index.
   */
  @java.lang.Override
  public java.lang.String getIndex() {
    java.lang.Object ref = index_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      index_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The index resource that this operation is acting on. For example:
   * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{index_id}`
   * </pre>
   *
   * <code>string index = 3;</code>
   *
   * @return The bytes for index.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIndexBytes() {
    java.lang.Object ref = index_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      index_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_ = 0;

  /**
   *
   *
   * <pre>
   * The state of the operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.OperationState state = 4;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }

  /**
   *
   *
   * <pre>
   * The state of the operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.OperationState state = 4;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.OperationState getState() {
    com.google.firestore.admin.v1.OperationState result =
        com.google.firestore.admin.v1.OperationState.forNumber(state_);
    return result == null ? com.google.firestore.admin.v1.OperationState.UNRECOGNIZED : result;
  }

  public static final int PROGRESS_DOCUMENTS_FIELD_NUMBER = 5;
  private com.google.firestore.admin.v1.Progress progressDocuments_;

  /**
   *
   *
   * <pre>
   * The progress, in documents, of this operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_documents = 5;</code>
   *
   * @return Whether the progressDocuments field is set.
   */
  @java.lang.Override
  public boolean hasProgressDocuments() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * The progress, in documents, of this operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_documents = 5;</code>
   *
   * @return The progressDocuments.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Progress getProgressDocuments() {
    return progressDocuments_ == null
        ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
        : progressDocuments_;
  }

  /**
   *
   *
   * <pre>
   * The progress, in documents, of this operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_documents = 5;</code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.ProgressOrBuilder getProgressDocumentsOrBuilder() {
    return progressDocuments_ == null
        ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
        : progressDocuments_;
  }

  public static final int PROGRESS_BYTES_FIELD_NUMBER = 6;
  private com.google.firestore.admin.v1.Progress progressBytes_;

  /**
   *
   *
   * <pre>
   * The progress, in bytes, of this operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_bytes = 6;</code>
   *
   * @return Whether the progressBytes field is set.
   */
  @java.lang.Override
  public boolean hasProgressBytes() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * The progress, in bytes, of this operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_bytes = 6;</code>
   *
   * @return The progressBytes.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Progress getProgressBytes() {
    return progressBytes_ == null
        ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
        : progressBytes_;
  }

  /**
   *
   *
   * <pre>
   * The progress, in bytes, of this operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_bytes = 6;</code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.ProgressOrBuilder getProgressBytesOrBuilder() {
    return progressBytes_ == null
        ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
        : progressBytes_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getEndTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(index_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, index_);
    }
    if (state_
        != com.google.firestore.admin.v1.OperationState.OPERATION_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, state_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getProgressDocuments());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(6, getProgressBytes());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEndTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(index_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, index_);
    }
    if (state_
        != com.google.firestore.admin.v1.OperationState.OPERATION_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getProgressDocuments());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getProgressBytes());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.admin.v1.IndexOperationMetadata)) {
      return super.equals(obj);
    }
    com.google.firestore.admin.v1.IndexOperationMetadata other =
        (com.google.firestore.admin.v1.IndexOperationMetadata) obj;

    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getIndex().equals(other.getIndex())) return false;
    if (state_ != other.state_) return false;
    if (hasProgressDocuments() != other.hasProgressDocuments()) return false;
    if (hasProgressDocuments()) {
      if (!getProgressDocuments().equals(other.getProgressDocuments())) return false;
    }
    if (hasProgressBytes() != other.hasProgressBytes()) return false;
    if (hasProgressBytes()) {
      if (!getProgressBytes().equals(other.getProgressBytes())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + INDEX_FIELD_NUMBER;
    hash = (53 * hash) + getIndex().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasProgressDocuments()) {
      hash = (37 * hash) + PROGRESS_DOCUMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getProgressDocuments().hashCode();
    }
    if (hasProgressBytes()) {
      hash = (37 * hash) + PROGRESS_BYTES_FIELD_NUMBER;
      hash = (53 * hash) + getProgressBytes().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.admin.v1.IndexOperationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.IndexOperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.IndexOperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.IndexOperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.IndexOperationMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.IndexOperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.IndexOperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.IndexOperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.IndexOperationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.IndexOperationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.IndexOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.IndexOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.admin.v1.IndexOperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Metadata for [google.longrunning.Operation][google.longrunning.Operation]
   * results from
   * [FirestoreAdmin.CreateIndex][google.firestore.admin.v1.FirestoreAdmin.CreateIndex].
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.IndexOperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.IndexOperationMetadata)
      com.google.firestore.admin.v1.IndexOperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.OperationProto
          .internal_static_google_firestore_admin_v1_IndexOperationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.OperationProto
          .internal_static_google_firestore_admin_v1_IndexOperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.IndexOperationMetadata.class,
              com.google.firestore.admin.v1.IndexOperationMetadata.Builder.class);
    }

    // Construct using com.google.firestore.admin.v1.IndexOperationMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
        getProgressDocumentsFieldBuilder();
        getProgressBytesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      index_ = "";
      state_ = 0;
      progressDocuments_ = null;
      if (progressDocumentsBuilder_ != null) {
        progressDocumentsBuilder_.dispose();
        progressDocumentsBuilder_ = null;
      }
      progressBytes_ = null;
      if (progressBytesBuilder_ != null) {
        progressBytesBuilder_.dispose();
        progressBytesBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.admin.v1.OperationProto
          .internal_static_google_firestore_admin_v1_IndexOperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.IndexOperationMetadata getDefaultInstanceForType() {
      return com.google.firestore.admin.v1.IndexOperationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.IndexOperationMetadata build() {
      com.google.firestore.admin.v1.IndexOperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.IndexOperationMetadata buildPartial() {
      com.google.firestore.admin.v1.IndexOperationMetadata result =
          new com.google.firestore.admin.v1.IndexOperationMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.admin.v1.IndexOperationMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.index_ = index_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.progressDocuments_ =
            progressDocumentsBuilder_ == null
                ? progressDocuments_
                : progressDocumentsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.progressBytes_ =
            progressBytesBuilder_ == null ? progressBytes_ : progressBytesBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.admin.v1.IndexOperationMetadata) {
        return mergeFrom((com.google.firestore.admin.v1.IndexOperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.admin.v1.IndexOperationMetadata other) {
      if (other == com.google.firestore.admin.v1.IndexOperationMetadata.getDefaultInstance())
        return this;
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (!other.getIndex().isEmpty()) {
        index_ = other.index_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasProgressDocuments()) {
        mergeProgressDocuments(other.getProgressDocuments());
      }
      if (other.hasProgressBytes()) {
        mergeProgressBytes(other.getProgressBytes());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                index_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(
                    getProgressDocumentsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getProgressBytesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;

    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;

    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private java.lang.Object index_ = "";

    /**
     *
     *
     * <pre>
     * The index resource that this operation is acting on. For example:
     * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{index_id}`
     * </pre>
     *
     * <code>string index = 3;</code>
     *
     * @return The index.
     */
    public java.lang.String getIndex() {
      java.lang.Object ref = index_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        index_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The index resource that this operation is acting on. For example:
     * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{index_id}`
     * </pre>
     *
     * <code>string index = 3;</code>
     *
     * @return The bytes for index.
     */
    public com.google.protobuf.ByteString getIndexBytes() {
      java.lang.Object ref = index_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        index_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The index resource that this operation is acting on. For example:
     * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{index_id}`
     * </pre>
     *
     * <code>string index = 3;</code>
     *
     * @param value The index to set.
     * @return This builder for chaining.
     */
    public Builder setIndex(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      index_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The index resource that this operation is acting on. For example:
     * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{index_id}`
     * </pre>
     *
     * <code>string index = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndex() {
      index_ = getDefaultInstance().getIndex();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The index resource that this operation is acting on. For example:
     * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{index_id}`
     * </pre>
     *
     * <code>string index = 3;</code>
     *
     * @param value The bytes for index to set.
     * @return This builder for chaining.
     */
    public Builder setIndexBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      index_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * The state of the operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState state = 4;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * The state of the operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState state = 4;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The state of the operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState state = 4;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.OperationState getState() {
      com.google.firestore.admin.v1.OperationState result =
          com.google.firestore.admin.v1.OperationState.forNumber(state_);
      return result == null ? com.google.firestore.admin.v1.OperationState.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * The state of the operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState state = 4;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.firestore.admin.v1.OperationState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      state_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The state of the operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState state = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000008);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.firestore.admin.v1.Progress progressDocuments_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.Progress,
            com.google.firestore.admin.v1.Progress.Builder,
            com.google.firestore.admin.v1.ProgressOrBuilder>
        progressDocumentsBuilder_;

    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 5;</code>
     *
     * @return Whether the progressDocuments field is set.
     */
    public boolean hasProgressDocuments() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 5;</code>
     *
     * @return The progressDocuments.
     */
    public com.google.firestore.admin.v1.Progress getProgressDocuments() {
      if (progressDocumentsBuilder_ == null) {
        return progressDocuments_ == null
            ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
            : progressDocuments_;
      } else {
        return progressDocumentsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 5;</code>
     */
    public Builder setProgressDocuments(com.google.firestore.admin.v1.Progress value) {
      if (progressDocumentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        progressDocuments_ = value;
      } else {
        progressDocumentsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 5;</code>
     */
    public Builder setProgressDocuments(
        com.google.firestore.admin.v1.Progress.Builder builderForValue) {
      if (progressDocumentsBuilder_ == null) {
        progressDocuments_ = builderForValue.build();
      } else {
        progressDocumentsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 5;</code>
     */
    public Builder mergeProgressDocuments(com.google.firestore.admin.v1.Progress value) {
      if (progressDocumentsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && progressDocuments_ != null
            && progressDocuments_ != com.google.firestore.admin.v1.Progress.getDefaultInstance()) {
          getProgressDocumentsBuilder().mergeFrom(value);
        } else {
          progressDocuments_ = value;
        }
      } else {
        progressDocumentsBuilder_.mergeFrom(value);
      }
      if (progressDocuments_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 5;</code>
     */
    public Builder clearProgressDocuments() {
      bitField0_ = (bitField0_ & ~0x00000010);
      progressDocuments_ = null;
      if (progressDocumentsBuilder_ != null) {
        progressDocumentsBuilder_.dispose();
        progressDocumentsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 5;</code>
     */
    public com.google.firestore.admin.v1.Progress.Builder getProgressDocumentsBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getProgressDocumentsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 5;</code>
     */
    public com.google.firestore.admin.v1.ProgressOrBuilder getProgressDocumentsOrBuilder() {
      if (progressDocumentsBuilder_ != null) {
        return progressDocumentsBuilder_.getMessageOrBuilder();
      } else {
        return progressDocuments_ == null
            ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
            : progressDocuments_;
      }
    }

    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.Progress,
            com.google.firestore.admin.v1.Progress.Builder,
            com.google.firestore.admin.v1.ProgressOrBuilder>
        getProgressDocumentsFieldBuilder() {
      if (progressDocumentsBuilder_ == null) {
        progressDocumentsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.admin.v1.Progress,
                com.google.firestore.admin.v1.Progress.Builder,
                com.google.firestore.admin.v1.ProgressOrBuilder>(
                getProgressDocuments(), getParentForChildren(), isClean());
        progressDocuments_ = null;
      }
      return progressDocumentsBuilder_;
    }

    private com.google.firestore.admin.v1.Progress progressBytes_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.Progress,
            com.google.firestore.admin.v1.Progress.Builder,
            com.google.firestore.admin.v1.ProgressOrBuilder>
        progressBytesBuilder_;

    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 6;</code>
     *
     * @return Whether the progressBytes field is set.
     */
    public boolean hasProgressBytes() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 6;</code>
     *
     * @return The progressBytes.
     */
    public com.google.firestore.admin.v1.Progress getProgressBytes() {
      if (progressBytesBuilder_ == null) {
        return progressBytes_ == null
            ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
            : progressBytes_;
      } else {
        return progressBytesBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 6;</code>
     */
    public Builder setProgressBytes(com.google.firestore.admin.v1.Progress value) {
      if (progressBytesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        progressBytes_ = value;
      } else {
        progressBytesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 6;</code>
     */
    public Builder setProgressBytes(
        com.google.firestore.admin.v1.Progress.Builder builderForValue) {
      if (progressBytesBuilder_ == null) {
        progressBytes_ = builderForValue.build();
      } else {
        progressBytesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 6;</code>
     */
    public Builder mergeProgressBytes(com.google.firestore.admin.v1.Progress value) {
      if (progressBytesBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && progressBytes_ != null
            && progressBytes_ != com.google.firestore.admin.v1.Progress.getDefaultInstance()) {
          getProgressBytesBuilder().mergeFrom(value);
        } else {
          progressBytes_ = value;
        }
      } else {
        progressBytesBuilder_.mergeFrom(value);
      }
      if (progressBytes_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 6;</code>
     */
    public Builder clearProgressBytes() {
      bitField0_ = (bitField0_ & ~0x00000020);
      progressBytes_ = null;
      if (progressBytesBuilder_ != null) {
        progressBytesBuilder_.dispose();
        progressBytesBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 6;</code>
     */
    public com.google.firestore.admin.v1.Progress.Builder getProgressBytesBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getProgressBytesFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 6;</code>
     */
    public com.google.firestore.admin.v1.ProgressOrBuilder getProgressBytesOrBuilder() {
      if (progressBytesBuilder_ != null) {
        return progressBytesBuilder_.getMessageOrBuilder();
      } else {
        return progressBytes_ == null
            ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
            : progressBytes_;
      }
    }

    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.Progress,
            com.google.firestore.admin.v1.Progress.Builder,
            com.google.firestore.admin.v1.ProgressOrBuilder>
        getProgressBytesFieldBuilder() {
      if (progressBytesBuilder_ == null) {
        progressBytesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.admin.v1.Progress,
                com.google.firestore.admin.v1.Progress.Builder,
                com.google.firestore.admin.v1.ProgressOrBuilder>(
                getProgressBytes(), getParentForChildren(), isClean());
        progressBytes_ = null;
      }
      return progressBytesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.IndexOperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.IndexOperationMetadata)
  private static final com.google.firestore.admin.v1.IndexOperationMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.admin.v1.IndexOperationMetadata();
  }

  public static com.google.firestore.admin.v1.IndexOperationMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IndexOperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<IndexOperationMetadata>() {
        @java.lang.Override
        public IndexOperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<IndexOperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IndexOperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.admin.v1.IndexOperationMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
