/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/admin/v1/firestore_admin.proto

// Protobuf Java Version: 3.25.8
package com.google.firestore.admin.v1;

/**
 *
 *
 * <pre>
 * The request message for
 * [FirestoreAdmin.CloneDatabase][google.firestore.admin.v1.FirestoreAdmin.CloneDatabase].
 * </pre>
 *
 * Protobuf type {@code google.firestore.admin.v1.CloneDatabaseRequest}
 */
public final class CloneDatabaseRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.CloneDatabaseRequest)
    CloneDatabaseRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CloneDatabaseRequest.newBuilder() to construct.
  private CloneDatabaseRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CloneDatabaseRequest() {
    parent_ = "";
    databaseId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CloneDatabaseRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.admin.v1.FirestoreAdminProto
        .internal_static_google_firestore_admin_v1_CloneDatabaseRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 5:
        return internalGetTags();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.admin.v1.FirestoreAdminProto
        .internal_static_google_firestore_admin_v1_CloneDatabaseRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.admin.v1.CloneDatabaseRequest.class,
            com.google.firestore.admin.v1.CloneDatabaseRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. The project to clone the database in. Format is
   * `projects/{project_id}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The project to clone the database in. Format is
   * `projects/{project_id}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATABASE_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object databaseId_ = "";

  /**
   *
   *
   * <pre>
   * Required. The ID to use for the database, which will become the final
   * component of the database's resource name. This database ID must not be
   * associated with an existing database.
   *
   * This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
   * with first character a letter and the last a letter or a number. Must not
   * be UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
   *
   * "(default)" database ID is also valid.
   * </pre>
   *
   * <code>string database_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The databaseId.
   */
  @java.lang.Override
  public java.lang.String getDatabaseId() {
    java.lang.Object ref = databaseId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      databaseId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The ID to use for the database, which will become the final
   * component of the database's resource name. This database ID must not be
   * associated with an existing database.
   *
   * This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
   * with first character a letter and the last a letter or a number. Must not
   * be UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
   *
   * "(default)" database ID is also valid.
   * </pre>
   *
   * <code>string database_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for databaseId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseIdBytes() {
    java.lang.Object ref = databaseId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      databaseId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PITR_SNAPSHOT_FIELD_NUMBER = 6;
  private com.google.firestore.admin.v1.PitrSnapshot pitrSnapshot_;

  /**
   *
   *
   * <pre>
   * Required. Specification of the PITR data to clone from. The source database
   * must exist.
   *
   * The cloned database will be created in the same location as the source
   * database.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the pitrSnapshot field is set.
   */
  @java.lang.Override
  public boolean hasPitrSnapshot() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. Specification of the PITR data to clone from. The source database
   * must exist.
   *
   * The cloned database will be created in the same location as the source
   * database.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The pitrSnapshot.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.PitrSnapshot getPitrSnapshot() {
    return pitrSnapshot_ == null
        ? com.google.firestore.admin.v1.PitrSnapshot.getDefaultInstance()
        : pitrSnapshot_;
  }

  /**
   *
   *
   * <pre>
   * Required. Specification of the PITR data to clone from. The source database
   * must exist.
   *
   * The cloned database will be created in the same location as the source
   * database.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.PitrSnapshotOrBuilder getPitrSnapshotOrBuilder() {
    return pitrSnapshot_ == null
        ? com.google.firestore.admin.v1.PitrSnapshot.getDefaultInstance()
        : pitrSnapshot_;
  }

  public static final int ENCRYPTION_CONFIG_FIELD_NUMBER = 4;
  private com.google.firestore.admin.v1.Database.EncryptionConfig encryptionConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Encryption configuration for the cloned database.
   *
   * If this field is not specified, the cloned database will use
   * the same encryption configuration as the source database, namely
   * [use_source_encryption][google.firestore.admin.v1.Database.EncryptionConfig.use_source_encryption].
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Database.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the encryptionConfig field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Encryption configuration for the cloned database.
   *
   * If this field is not specified, the cloned database will use
   * the same encryption configuration as the source database, namely
   * [use_source_encryption][google.firestore.admin.v1.Database.EncryptionConfig.use_source_encryption].
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Database.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The encryptionConfig.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Database.EncryptionConfig getEncryptionConfig() {
    return encryptionConfig_ == null
        ? com.google.firestore.admin.v1.Database.EncryptionConfig.getDefaultInstance()
        : encryptionConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Encryption configuration for the cloned database.
   *
   * If this field is not specified, the cloned database will use
   * the same encryption configuration as the source database, namely
   * [use_source_encryption][google.firestore.admin.v1.Database.EncryptionConfig.use_source_encryption].
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Database.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Database.EncryptionConfigOrBuilder
      getEncryptionConfigOrBuilder() {
    return encryptionConfig_ == null
        ? com.google.firestore.admin.v1.Database.EncryptionConfig.getDefaultInstance()
        : encryptionConfig_;
  }

  public static final int TAGS_FIELD_NUMBER = 5;

  private static final class TagsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.firestore.admin.v1.FirestoreAdminProto
                .internal_static_google_firestore_admin_v1_CloneDatabaseRequest_TagsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> tags_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetTags() {
    if (tags_ == null) {
      return com.google.protobuf.MapField.emptyMapField(TagsDefaultEntryHolder.defaultEntry);
    }
    return tags_;
  }

  public int getTagsCount() {
    return internalGetTags().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. Tags to be bound to the cloned database.
   *
   * The tags should be provided in the format of
   * `tagKeys/{tag_key_id} -&gt; tagValues/{tag_value_id}`.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; tags = 5 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsTags(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetTags().getMap().containsKey(key);
  }

  /** Use {@link #getTagsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getTags() {
    return getTagsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. Tags to be bound to the cloned database.
   *
   * The tags should be provided in the format of
   * `tagKeys/{tag_key_id} -&gt; tagValues/{tag_value_id}`.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; tags = 5 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getTagsMap() {
    return internalGetTags().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. Tags to be bound to the cloned database.
   *
   * The tags should be provided in the format of
   * `tagKeys/{tag_key_id} -&gt; tagValues/{tag_value_id}`.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; tags = 5 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getTagsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetTags().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. Tags to be bound to the cloned database.
   *
   * The tags should be provided in the format of
   * `tagKeys/{tag_key_id} -&gt; tagValues/{tag_value_id}`.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; tags = 5 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getTagsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetTags().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(databaseId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, databaseId_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getEncryptionConfig());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetTags(), TagsDefaultEntryHolder.defaultEntry, 5);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getPitrSnapshot());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(databaseId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, databaseId_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getEncryptionConfig());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetTags().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> tags__ =
          TagsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, tags__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getPitrSnapshot());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.admin.v1.CloneDatabaseRequest)) {
      return super.equals(obj);
    }
    com.google.firestore.admin.v1.CloneDatabaseRequest other =
        (com.google.firestore.admin.v1.CloneDatabaseRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getDatabaseId().equals(other.getDatabaseId())) return false;
    if (hasPitrSnapshot() != other.hasPitrSnapshot()) return false;
    if (hasPitrSnapshot()) {
      if (!getPitrSnapshot().equals(other.getPitrSnapshot())) return false;
    }
    if (hasEncryptionConfig() != other.hasEncryptionConfig()) return false;
    if (hasEncryptionConfig()) {
      if (!getEncryptionConfig().equals(other.getEncryptionConfig())) return false;
    }
    if (!internalGetTags().equals(other.internalGetTags())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + DATABASE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDatabaseId().hashCode();
    if (hasPitrSnapshot()) {
      hash = (37 * hash) + PITR_SNAPSHOT_FIELD_NUMBER;
      hash = (53 * hash) + getPitrSnapshot().hashCode();
    }
    if (hasEncryptionConfig()) {
      hash = (37 * hash) + ENCRYPTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionConfig().hashCode();
    }
    if (!internalGetTags().getMap().isEmpty()) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetTags().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.admin.v1.CloneDatabaseRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.admin.v1.CloneDatabaseRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The request message for
   * [FirestoreAdmin.CloneDatabase][google.firestore.admin.v1.FirestoreAdmin.CloneDatabase].
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.CloneDatabaseRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.CloneDatabaseRequest)
      com.google.firestore.admin.v1.CloneDatabaseRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.FirestoreAdminProto
          .internal_static_google_firestore_admin_v1_CloneDatabaseRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetTags();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetMutableTags();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.FirestoreAdminProto
          .internal_static_google_firestore_admin_v1_CloneDatabaseRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.CloneDatabaseRequest.class,
              com.google.firestore.admin.v1.CloneDatabaseRequest.Builder.class);
    }

    // Construct using com.google.firestore.admin.v1.CloneDatabaseRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPitrSnapshotFieldBuilder();
        getEncryptionConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      databaseId_ = "";
      pitrSnapshot_ = null;
      if (pitrSnapshotBuilder_ != null) {
        pitrSnapshotBuilder_.dispose();
        pitrSnapshotBuilder_ = null;
      }
      encryptionConfig_ = null;
      if (encryptionConfigBuilder_ != null) {
        encryptionConfigBuilder_.dispose();
        encryptionConfigBuilder_ = null;
      }
      internalGetMutableTags().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.admin.v1.FirestoreAdminProto
          .internal_static_google_firestore_admin_v1_CloneDatabaseRequest_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.CloneDatabaseRequest getDefaultInstanceForType() {
      return com.google.firestore.admin.v1.CloneDatabaseRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.CloneDatabaseRequest build() {
      com.google.firestore.admin.v1.CloneDatabaseRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.CloneDatabaseRequest buildPartial() {
      com.google.firestore.admin.v1.CloneDatabaseRequest result =
          new com.google.firestore.admin.v1.CloneDatabaseRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.admin.v1.CloneDatabaseRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.databaseId_ = databaseId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pitrSnapshot_ =
            pitrSnapshotBuilder_ == null ? pitrSnapshot_ : pitrSnapshotBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.encryptionConfig_ =
            encryptionConfigBuilder_ == null ? encryptionConfig_ : encryptionConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.tags_ = internalGetTags();
        result.tags_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.admin.v1.CloneDatabaseRequest) {
        return mergeFrom((com.google.firestore.admin.v1.CloneDatabaseRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.admin.v1.CloneDatabaseRequest other) {
      if (other == com.google.firestore.admin.v1.CloneDatabaseRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDatabaseId().isEmpty()) {
        databaseId_ = other.databaseId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasPitrSnapshot()) {
        mergePitrSnapshot(other.getPitrSnapshot());
      }
      if (other.hasEncryptionConfig()) {
        mergeEncryptionConfig(other.getEncryptionConfig());
      }
      internalGetMutableTags().mergeFrom(other.internalGetTags());
      bitField0_ |= 0x00000010;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                databaseId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                input.readMessage(
                    getEncryptionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> tags__ =
                    input.readMessage(
                        TagsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                internalGetMutableTags().getMutableMap().put(tags__.getKey(), tags__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getPitrSnapshotFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. The project to clone the database in. Format is
     * `projects/{project_id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The project to clone the database in. Format is
     * `projects/{project_id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The project to clone the database in. Format is
     * `projects/{project_id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The project to clone the database in. Format is
     * `projects/{project_id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The project to clone the database in. Format is
     * `projects/{project_id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object databaseId_ = "";

    /**
     *
     *
     * <pre>
     * Required. The ID to use for the database, which will become the final
     * component of the database's resource name. This database ID must not be
     * associated with an existing database.
     *
     * This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
     * with first character a letter and the last a letter or a number. Must not
     * be UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
     *
     * "(default)" database ID is also valid.
     * </pre>
     *
     * <code>string database_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The databaseId.
     */
    public java.lang.String getDatabaseId() {
      java.lang.Object ref = databaseId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        databaseId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The ID to use for the database, which will become the final
     * component of the database's resource name. This database ID must not be
     * associated with an existing database.
     *
     * This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
     * with first character a letter and the last a letter or a number. Must not
     * be UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
     *
     * "(default)" database ID is also valid.
     * </pre>
     *
     * <code>string database_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for databaseId.
     */
    public com.google.protobuf.ByteString getDatabaseIdBytes() {
      java.lang.Object ref = databaseId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        databaseId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The ID to use for the database, which will become the final
     * component of the database's resource name. This database ID must not be
     * associated with an existing database.
     *
     * This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
     * with first character a letter and the last a letter or a number. Must not
     * be UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
     *
     * "(default)" database ID is also valid.
     * </pre>
     *
     * <code>string database_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The databaseId to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      databaseId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The ID to use for the database, which will become the final
     * component of the database's resource name. This database ID must not be
     * associated with an existing database.
     *
     * This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
     * with first character a letter and the last a letter or a number. Must not
     * be UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
     *
     * "(default)" database ID is also valid.
     * </pre>
     *
     * <code>string database_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabaseId() {
      databaseId_ = getDefaultInstance().getDatabaseId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The ID to use for the database, which will become the final
     * component of the database's resource name. This database ID must not be
     * associated with an existing database.
     *
     * This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
     * with first character a letter and the last a letter or a number. Must not
     * be UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
     *
     * "(default)" database ID is also valid.
     * </pre>
     *
     * <code>string database_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for databaseId to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      databaseId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.firestore.admin.v1.PitrSnapshot pitrSnapshot_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.PitrSnapshot,
            com.google.firestore.admin.v1.PitrSnapshot.Builder,
            com.google.firestore.admin.v1.PitrSnapshotOrBuilder>
        pitrSnapshotBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Specification of the PITR data to clone from. The source database
     * must exist.
     *
     * The cloned database will be created in the same location as the source
     * database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the pitrSnapshot field is set.
     */
    public boolean hasPitrSnapshot() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Specification of the PITR data to clone from. The source database
     * must exist.
     *
     * The cloned database will be created in the same location as the source
     * database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The pitrSnapshot.
     */
    public com.google.firestore.admin.v1.PitrSnapshot getPitrSnapshot() {
      if (pitrSnapshotBuilder_ == null) {
        return pitrSnapshot_ == null
            ? com.google.firestore.admin.v1.PitrSnapshot.getDefaultInstance()
            : pitrSnapshot_;
      } else {
        return pitrSnapshotBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Specification of the PITR data to clone from. The source database
     * must exist.
     *
     * The cloned database will be created in the same location as the source
     * database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPitrSnapshot(com.google.firestore.admin.v1.PitrSnapshot value) {
      if (pitrSnapshotBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pitrSnapshot_ = value;
      } else {
        pitrSnapshotBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Specification of the PITR data to clone from. The source database
     * must exist.
     *
     * The cloned database will be created in the same location as the source
     * database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPitrSnapshot(
        com.google.firestore.admin.v1.PitrSnapshot.Builder builderForValue) {
      if (pitrSnapshotBuilder_ == null) {
        pitrSnapshot_ = builderForValue.build();
      } else {
        pitrSnapshotBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Specification of the PITR data to clone from. The source database
     * must exist.
     *
     * The cloned database will be created in the same location as the source
     * database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergePitrSnapshot(com.google.firestore.admin.v1.PitrSnapshot value) {
      if (pitrSnapshotBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && pitrSnapshot_ != null
            && pitrSnapshot_ != com.google.firestore.admin.v1.PitrSnapshot.getDefaultInstance()) {
          getPitrSnapshotBuilder().mergeFrom(value);
        } else {
          pitrSnapshot_ = value;
        }
      } else {
        pitrSnapshotBuilder_.mergeFrom(value);
      }
      if (pitrSnapshot_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Specification of the PITR data to clone from. The source database
     * must exist.
     *
     * The cloned database will be created in the same location as the source
     * database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearPitrSnapshot() {
      bitField0_ = (bitField0_ & ~0x00000004);
      pitrSnapshot_ = null;
      if (pitrSnapshotBuilder_ != null) {
        pitrSnapshotBuilder_.dispose();
        pitrSnapshotBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Specification of the PITR data to clone from. The source database
     * must exist.
     *
     * The cloned database will be created in the same location as the source
     * database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.firestore.admin.v1.PitrSnapshot.Builder getPitrSnapshotBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getPitrSnapshotFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. Specification of the PITR data to clone from. The source database
     * must exist.
     *
     * The cloned database will be created in the same location as the source
     * database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.firestore.admin.v1.PitrSnapshotOrBuilder getPitrSnapshotOrBuilder() {
      if (pitrSnapshotBuilder_ != null) {
        return pitrSnapshotBuilder_.getMessageOrBuilder();
      } else {
        return pitrSnapshot_ == null
            ? com.google.firestore.admin.v1.PitrSnapshot.getDefaultInstance()
            : pitrSnapshot_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Specification of the PITR data to clone from. The source database
     * must exist.
     *
     * The cloned database will be created in the same location as the source
     * database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.PitrSnapshot,
            com.google.firestore.admin.v1.PitrSnapshot.Builder,
            com.google.firestore.admin.v1.PitrSnapshotOrBuilder>
        getPitrSnapshotFieldBuilder() {
      if (pitrSnapshotBuilder_ == null) {
        pitrSnapshotBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.admin.v1.PitrSnapshot,
                com.google.firestore.admin.v1.PitrSnapshot.Builder,
                com.google.firestore.admin.v1.PitrSnapshotOrBuilder>(
                getPitrSnapshot(), getParentForChildren(), isClean());
        pitrSnapshot_ = null;
      }
      return pitrSnapshotBuilder_;
    }

    private com.google.firestore.admin.v1.Database.EncryptionConfig encryptionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.Database.EncryptionConfig,
            com.google.firestore.admin.v1.Database.EncryptionConfig.Builder,
            com.google.firestore.admin.v1.Database.EncryptionConfigOrBuilder>
        encryptionConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Encryption configuration for the cloned database.
     *
     * If this field is not specified, the cloned database will use
     * the same encryption configuration as the source database, namely
     * [use_source_encryption][google.firestore.admin.v1.Database.EncryptionConfig.use_source_encryption].
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the encryptionConfig field is set.
     */
    public boolean hasEncryptionConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Encryption configuration for the cloned database.
     *
     * If this field is not specified, the cloned database will use
     * the same encryption configuration as the source database, namely
     * [use_source_encryption][google.firestore.admin.v1.Database.EncryptionConfig.use_source_encryption].
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The encryptionConfig.
     */
    public com.google.firestore.admin.v1.Database.EncryptionConfig getEncryptionConfig() {
      if (encryptionConfigBuilder_ == null) {
        return encryptionConfig_ == null
            ? com.google.firestore.admin.v1.Database.EncryptionConfig.getDefaultInstance()
            : encryptionConfig_;
      } else {
        return encryptionConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Encryption configuration for the cloned database.
     *
     * If this field is not specified, the cloned database will use
     * the same encryption configuration as the source database, namely
     * [use_source_encryption][google.firestore.admin.v1.Database.EncryptionConfig.use_source_encryption].
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.firestore.admin.v1.Database.EncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionConfig_ = value;
      } else {
        encryptionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Encryption configuration for the cloned database.
     *
     * If this field is not specified, the cloned database will use
     * the same encryption configuration as the source database, namely
     * [use_source_encryption][google.firestore.admin.v1.Database.EncryptionConfig.use_source_encryption].
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.firestore.admin.v1.Database.EncryptionConfig.Builder builderForValue) {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfig_ = builderForValue.build();
      } else {
        encryptionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Encryption configuration for the cloned database.
     *
     * If this field is not specified, the cloned database will use
     * the same encryption configuration as the source database, namely
     * [use_source_encryption][google.firestore.admin.v1.Database.EncryptionConfig.use_source_encryption].
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEncryptionConfig(
        com.google.firestore.admin.v1.Database.EncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && encryptionConfig_ != null
            && encryptionConfig_
                != com.google.firestore.admin.v1.Database.EncryptionConfig.getDefaultInstance()) {
          getEncryptionConfigBuilder().mergeFrom(value);
        } else {
          encryptionConfig_ = value;
        }
      } else {
        encryptionConfigBuilder_.mergeFrom(value);
      }
      if (encryptionConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Encryption configuration for the cloned database.
     *
     * If this field is not specified, the cloned database will use
     * the same encryption configuration as the source database, namely
     * [use_source_encryption][google.firestore.admin.v1.Database.EncryptionConfig.use_source_encryption].
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEncryptionConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      encryptionConfig_ = null;
      if (encryptionConfigBuilder_ != null) {
        encryptionConfigBuilder_.dispose();
        encryptionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Encryption configuration for the cloned database.
     *
     * If this field is not specified, the cloned database will use
     * the same encryption configuration as the source database, namely
     * [use_source_encryption][google.firestore.admin.v1.Database.EncryptionConfig.use_source_encryption].
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.firestore.admin.v1.Database.EncryptionConfig.Builder
        getEncryptionConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getEncryptionConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Encryption configuration for the cloned database.
     *
     * If this field is not specified, the cloned database will use
     * the same encryption configuration as the source database, namely
     * [use_source_encryption][google.firestore.admin.v1.Database.EncryptionConfig.use_source_encryption].
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.firestore.admin.v1.Database.EncryptionConfigOrBuilder
        getEncryptionConfigOrBuilder() {
      if (encryptionConfigBuilder_ != null) {
        return encryptionConfigBuilder_.getMessageOrBuilder();
      } else {
        return encryptionConfig_ == null
            ? com.google.firestore.admin.v1.Database.EncryptionConfig.getDefaultInstance()
            : encryptionConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Encryption configuration for the cloned database.
     *
     * If this field is not specified, the cloned database will use
     * the same encryption configuration as the source database, namely
     * [use_source_encryption][google.firestore.admin.v1.Database.EncryptionConfig.use_source_encryption].
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.Database.EncryptionConfig,
            com.google.firestore.admin.v1.Database.EncryptionConfig.Builder,
            com.google.firestore.admin.v1.Database.EncryptionConfigOrBuilder>
        getEncryptionConfigFieldBuilder() {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.admin.v1.Database.EncryptionConfig,
                com.google.firestore.admin.v1.Database.EncryptionConfig.Builder,
                com.google.firestore.admin.v1.Database.EncryptionConfigOrBuilder>(
                getEncryptionConfig(), getParentForChildren(), isClean());
        encryptionConfig_ = null;
      }
      return encryptionConfigBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> tags_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetTags() {
      if (tags_ == null) {
        return com.google.protobuf.MapField.emptyMapField(TagsDefaultEntryHolder.defaultEntry);
      }
      return tags_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableTags() {
      if (tags_ == null) {
        tags_ = com.google.protobuf.MapField.newMapField(TagsDefaultEntryHolder.defaultEntry);
      }
      if (!tags_.isMutable()) {
        tags_ = tags_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return tags_;
    }

    public int getTagsCount() {
      return internalGetTags().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Tags to be bound to the cloned database.
     *
     * The tags should be provided in the format of
     * `tagKeys/{tag_key_id} -&gt; tagValues/{tag_value_id}`.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; tags = 5 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsTags(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetTags().getMap().containsKey(key);
    }

    /** Use {@link #getTagsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getTags() {
      return getTagsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Tags to be bound to the cloned database.
     *
     * The tags should be provided in the format of
     * `tagKeys/{tag_key_id} -&gt; tagValues/{tag_value_id}`.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; tags = 5 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getTagsMap() {
      return internalGetTags().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Tags to be bound to the cloned database.
     *
     * The tags should be provided in the format of
     * `tagKeys/{tag_key_id} -&gt; tagValues/{tag_value_id}`.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; tags = 5 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getTagsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetTags().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Tags to be bound to the cloned database.
     *
     * The tags should be provided in the format of
     * `tagKeys/{tag_key_id} -&gt; tagValues/{tag_value_id}`.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; tags = 5 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getTagsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetTags().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearTags() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableTags().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Tags to be bound to the cloned database.
     *
     * The tags should be provided in the format of
     * `tagKeys/{tag_key_id} -&gt; tagValues/{tag_value_id}`.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; tags = 5 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeTags(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableTags().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableTags() {
      bitField0_ |= 0x00000010;
      return internalGetMutableTags().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Tags to be bound to the cloned database.
     *
     * The tags should be provided in the format of
     * `tagKeys/{tag_key_id} -&gt; tagValues/{tag_value_id}`.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; tags = 5 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putTags(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableTags().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Tags to be bound to the cloned database.
     *
     * The tags should be provided in the format of
     * `tagKeys/{tag_key_id} -&gt; tagValues/{tag_value_id}`.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; tags = 5 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllTags(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableTags().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.CloneDatabaseRequest)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.CloneDatabaseRequest)
  private static final com.google.firestore.admin.v1.CloneDatabaseRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.admin.v1.CloneDatabaseRequest();
  }

  public static com.google.firestore.admin.v1.CloneDatabaseRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloneDatabaseRequest> PARSER =
      new com.google.protobuf.AbstractParser<CloneDatabaseRequest>() {
        @java.lang.Override
        public CloneDatabaseRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CloneDatabaseRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloneDatabaseRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.admin.v1.CloneDatabaseRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
