/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.enterpriseknowledgegraph.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PublicKnowledgeGraphEntityName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PUBLIC_KNOWLEDGE_GRAPH_ENTITY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/publicKnowledgeGraphEntities/{public_knowledge_graph_entity}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String publicKnowledgeGraphEntity;

    @Deprecated
    protected PublicKnowledgeGraphEntityName() {
        this.project = null;
        this.location = null;
        this.publicKnowledgeGraphEntity = null;
    }

    private PublicKnowledgeGraphEntityName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.publicKnowledgeGraphEntity = (String)Preconditions.checkNotNull((Object)builder.getPublicKnowledgeGraphEntity());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPublicKnowledgeGraphEntity() {
        return this.publicKnowledgeGraphEntity;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PublicKnowledgeGraphEntityName of(String project, String location, String publicKnowledgeGraphEntity) {
        return PublicKnowledgeGraphEntityName.newBuilder().setProject(project).setLocation(location).setPublicKnowledgeGraphEntity(publicKnowledgeGraphEntity).build();
    }

    public static String format(String project, String location, String publicKnowledgeGraphEntity) {
        return PublicKnowledgeGraphEntityName.newBuilder().setProject(project).setLocation(location).setPublicKnowledgeGraphEntity(publicKnowledgeGraphEntity).build().toString();
    }

    public static PublicKnowledgeGraphEntityName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PUBLIC_KNOWLEDGE_GRAPH_ENTITY.validatedMatch(formattedString, "PublicKnowledgeGraphEntityName.parse: formattedString not in valid format");
        return PublicKnowledgeGraphEntityName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("public_knowledge_graph_entity"));
    }

    public static List<PublicKnowledgeGraphEntityName> parseList(List<String> formattedStrings) {
        ArrayList<PublicKnowledgeGraphEntityName> list = new ArrayList<PublicKnowledgeGraphEntityName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PublicKnowledgeGraphEntityName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PublicKnowledgeGraphEntityName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PublicKnowledgeGraphEntityName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PUBLIC_KNOWLEDGE_GRAPH_ENTITY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PublicKnowledgeGraphEntityName publicKnowledgeGraphEntityName = this;
            synchronized (publicKnowledgeGraphEntityName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.publicKnowledgeGraphEntity != null) {
                        fieldMapBuilder.put((Object)"public_knowledge_graph_entity", (Object)this.publicKnowledgeGraphEntity);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PUBLIC_KNOWLEDGE_GRAPH_ENTITY.instantiate(new String[]{"project", this.project, "location", this.location, "public_knowledge_graph_entity", this.publicKnowledgeGraphEntity});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            PublicKnowledgeGraphEntityName that = (PublicKnowledgeGraphEntityName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.publicKnowledgeGraphEntity, that.publicKnowledgeGraphEntity);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.publicKnowledgeGraphEntity);
    }

    public static class Builder {
        private String project;
        private String location;
        private String publicKnowledgeGraphEntity;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPublicKnowledgeGraphEntity() {
            return this.publicKnowledgeGraphEntity;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPublicKnowledgeGraphEntity(String publicKnowledgeGraphEntity) {
            this.publicKnowledgeGraphEntity = publicKnowledgeGraphEntity;
            return this;
        }

        private Builder(PublicKnowledgeGraphEntityName publicKnowledgeGraphEntityName) {
            this.project = publicKnowledgeGraphEntityName.project;
            this.location = publicKnowledgeGraphEntityName.location;
            this.publicKnowledgeGraphEntity = publicKnowledgeGraphEntityName.publicKnowledgeGraphEntity;
        }

        public PublicKnowledgeGraphEntityName build() {
            return new PublicKnowledgeGraphEntityName(this);
        }
    }
}

