/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.edgenetwork.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InterconnectName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ZONE_INTERCONNECT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/zones/{zone}/interconnects/{interconnect}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String zone;
    private final String interconnect;

    @Deprecated
    protected InterconnectName() {
        this.project = null;
        this.location = null;
        this.zone = null;
        this.interconnect = null;
    }

    private InterconnectName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
        this.interconnect = (String)Preconditions.checkNotNull((Object)builder.getInterconnect());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getZone() {
        return this.zone;
    }

    public String getInterconnect() {
        return this.interconnect;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InterconnectName of(String project, String location, String zone, String interconnect) {
        return InterconnectName.newBuilder().setProject(project).setLocation(location).setZone(zone).setInterconnect(interconnect).build();
    }

    public static String format(String project, String location, String zone, String interconnect) {
        return InterconnectName.newBuilder().setProject(project).setLocation(location).setZone(zone).setInterconnect(interconnect).build().toString();
    }

    public static InterconnectName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ZONE_INTERCONNECT.validatedMatch(formattedString, "InterconnectName.parse: formattedString not in valid format");
        return InterconnectName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("zone"), (String)matchMap.get("interconnect"));
    }

    public static List<InterconnectName> parseList(List<String> formattedStrings) {
        ArrayList<InterconnectName> list = new ArrayList<InterconnectName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InterconnectName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InterconnectName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InterconnectName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ZONE_INTERCONNECT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InterconnectName interconnectName = this;
            synchronized (interconnectName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.zone != null) {
                        fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    }
                    if (this.interconnect != null) {
                        fieldMapBuilder.put((Object)"interconnect", (Object)this.interconnect);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ZONE_INTERCONNECT.instantiate(new String[]{"project", this.project, "location", this.location, "zone", this.zone, "interconnect", this.interconnect});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            InterconnectName that = (InterconnectName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.zone, that.zone) && Objects.equals(this.interconnect, that.interconnect);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.zone);
        h *= 1000003;
        return h ^= Objects.hashCode(this.interconnect);
    }

    public static class Builder {
        private String project;
        private String location;
        private String zone;
        private String interconnect;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getZone() {
            return this.zone;
        }

        public String getInterconnect() {
            return this.interconnect;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public Builder setInterconnect(String interconnect) {
            this.interconnect = interconnect;
            return this;
        }

        private Builder(InterconnectName interconnectName) {
            this.project = interconnectName.project;
            this.location = interconnectName.location;
            this.zone = interconnectName.zone;
            this.interconnect = interconnectName.interconnect;
        }

        public InterconnectName build() {
            return new InterconnectName(this);
        }
    }
}

